// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type CreateBackupSynchronicityRequest struct {

    core.JDCloudRequest

    /* 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)  */
    RegionId string `json:"regionId"`

    /* 源实例ID  */
    InstanceId string `json:"instanceId"`

    /* 备份同步的目标地域  */
    DestRegion string `json:"destRegion"`
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: 源实例ID (Required)
 * param destRegion: 备份同步的目标地域 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCreateBackupSynchronicityRequest(
    regionId string,
    instanceId string,
    destRegion string,
) *CreateBackupSynchronicityRequest {

	return &CreateBackupSynchronicityRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/backupSynchronicities",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
        DestRegion: destRegion,
	}
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: 源实例ID (Required)
 * param destRegion: 备份同步的目标地域 (Required)
 */
func NewCreateBackupSynchronicityRequestWithAllParams(
    regionId string,
    instanceId string,
    destRegion string,
) *CreateBackupSynchronicityRequest {

    return &CreateBackupSynchronicityRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/backupSynchronicities",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        DestRegion: destRegion,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewCreateBackupSynchronicityRequestWithoutParam() *CreateBackupSynchronicityRequest {

    return &CreateBackupSynchronicityRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/backupSynchronicities",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)(Required) */
func (r *CreateBackupSynchronicityRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: 源实例ID(Required) */
func (r *CreateBackupSynchronicityRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param destRegion: 备份同步的目标地域(Required) */
func (r *CreateBackupSynchronicityRequest) SetDestRegion(destRegion string) {
    r.DestRegion = destRegion
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CreateBackupSynchronicityRequest) GetRegionId() string {
    return r.RegionId
}

type CreateBackupSynchronicityResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result CreateBackupSynchronicityResult `json:"result"`
}

type CreateBackupSynchronicityResult struct {
    ServiceId string `json:"serviceId"`
}