// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    rds "github.com/jdcloud-api/jdcloud-sdk-go/services/rds/models"
)

type CreateInstanceByTimeInCrossRegionRequest struct {

    core.JDCloudRequest

    /* 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)  */
    RegionId string `json:"regionId"`

    /* 根据源实例的哪个时间点创建新实例  */
    RestoreTime string `json:"restoreTime"`

    /* 跨地域备份同步服务ID  */
    ServiceId string `json:"serviceId"`

    /* 新建实例规格  */
    InstanceSpec *rds.RestoredNewDBInstanceSpec `json:"instanceSpec"`
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param restoreTime: 根据源实例的哪个时间点创建新实例 (Required)
 * param serviceId: 跨地域备份同步服务ID (Required)
 * param instanceSpec: 新建实例规格 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCreateInstanceByTimeInCrossRegionRequest(
    regionId string,
    restoreTime string,
    serviceId string,
    instanceSpec *rds.RestoredNewDBInstanceSpec,
) *CreateInstanceByTimeInCrossRegionRequest {

	return &CreateInstanceByTimeInCrossRegionRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/backupSynchronicities:createInstanceByTimeInCrossRegion",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        RestoreTime: restoreTime,
        ServiceId: serviceId,
        InstanceSpec: instanceSpec,
	}
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param restoreTime: 根据源实例的哪个时间点创建新实例 (Required)
 * param serviceId: 跨地域备份同步服务ID (Required)
 * param instanceSpec: 新建实例规格 (Required)
 */
func NewCreateInstanceByTimeInCrossRegionRequestWithAllParams(
    regionId string,
    restoreTime string,
    serviceId string,
    instanceSpec *rds.RestoredNewDBInstanceSpec,
) *CreateInstanceByTimeInCrossRegionRequest {

    return &CreateInstanceByTimeInCrossRegionRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/backupSynchronicities:createInstanceByTimeInCrossRegion",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        RestoreTime: restoreTime,
        ServiceId: serviceId,
        InstanceSpec: instanceSpec,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewCreateInstanceByTimeInCrossRegionRequestWithoutParam() *CreateInstanceByTimeInCrossRegionRequest {

    return &CreateInstanceByTimeInCrossRegionRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/backupSynchronicities:createInstanceByTimeInCrossRegion",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)(Required) */
func (r *CreateInstanceByTimeInCrossRegionRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param restoreTime: 根据源实例的哪个时间点创建新实例(Required) */
func (r *CreateInstanceByTimeInCrossRegionRequest) SetRestoreTime(restoreTime string) {
    r.RestoreTime = restoreTime
}

/* param serviceId: 跨地域备份同步服务ID(Required) */
func (r *CreateInstanceByTimeInCrossRegionRequest) SetServiceId(serviceId string) {
    r.ServiceId = serviceId
}

/* param instanceSpec: 新建实例规格(Required) */
func (r *CreateInstanceByTimeInCrossRegionRequest) SetInstanceSpec(instanceSpec *rds.RestoredNewDBInstanceSpec) {
    r.InstanceSpec = instanceSpec
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CreateInstanceByTimeInCrossRegionRequest) GetRegionId() string {
    return r.RegionId
}

type CreateInstanceByTimeInCrossRegionResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result CreateInstanceByTimeInCrossRegionResult `json:"result"`
}

type CreateInstanceByTimeInCrossRegionResult struct {
    InstanceId string `json:"instanceId"`
    OrderId string `json:"orderId"`
}