// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type CreateParameterGroupRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* 实例引擎类型，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)  */
    Engine string `json:"engine"`

    /* 实例引擎版本，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)  */
    EngineVersion string `json:"engineVersion"`

    /* 参数组的名字  */
    ParameterGroupName string `json:"parameterGroupName"`

    /* 参数组的描述 (Optional) */
    Description *string `json:"description"`
}

/*
 * param regionId: Region ID (Required)
 * param engine: 实例引擎类型，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md) (Required)
 * param engineVersion: 实例引擎版本，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md) (Required)
 * param parameterGroupName: 参数组的名字 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCreateParameterGroupRequest(
    regionId string,
    engine string,
    engineVersion string,
    parameterGroupName string,
) *CreateParameterGroupRequest {

	return &CreateParameterGroupRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/parameterGroups",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        Engine: engine,
        EngineVersion: engineVersion,
        ParameterGroupName: parameterGroupName,
	}
}

/*
 * param regionId: Region ID (Required)
 * param engine: 实例引擎类型，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md) (Required)
 * param engineVersion: 实例引擎版本，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md) (Required)
 * param parameterGroupName: 参数组的名字 (Required)
 * param description: 参数组的描述 (Optional)
 */
func NewCreateParameterGroupRequestWithAllParams(
    regionId string,
    engine string,
    engineVersion string,
    parameterGroupName string,
    description *string,
) *CreateParameterGroupRequest {

    return &CreateParameterGroupRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/parameterGroups",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        Engine: engine,
        EngineVersion: engineVersion,
        ParameterGroupName: parameterGroupName,
        Description: description,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewCreateParameterGroupRequestWithoutParam() *CreateParameterGroupRequest {

    return &CreateParameterGroupRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/parameterGroups",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *CreateParameterGroupRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param engine: 实例引擎类型，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)(Required) */
func (r *CreateParameterGroupRequest) SetEngine(engine string) {
    r.Engine = engine
}

/* param engineVersion: 实例引擎版本，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)(Required) */
func (r *CreateParameterGroupRequest) SetEngineVersion(engineVersion string) {
    r.EngineVersion = engineVersion
}

/* param parameterGroupName: 参数组的名字(Required) */
func (r *CreateParameterGroupRequest) SetParameterGroupName(parameterGroupName string) {
    r.ParameterGroupName = parameterGroupName
}

/* param description: 参数组的描述(Optional) */
func (r *CreateParameterGroupRequest) SetDescription(description string) {
    r.Description = &description
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CreateParameterGroupRequest) GetRegionId() string {
    return r.RegionId
}

type CreateParameterGroupResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result CreateParameterGroupResult `json:"result"`
}

type CreateParameterGroupResult struct {
    ParameterGroupId string `json:"parameterGroupId"`
}