// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type CreateROInstanceRequest struct {

    core.JDCloudRequest

    /* 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)  */
    RegionId string `json:"regionId"`

    /* RDS 实例ID，唯一标识一个RDS实例  */
    InstanceId string `json:"instanceId"`

    /* 实例名称，具体规则可参见帮助中心文档:[名称及密码限制](../../../documentation/Database-and-Cache-Service/RDS/Introduction/Restrictions/SQLServer-Restrictions.md)  */
    InstanceName string `json:"instanceName"`

    /* 只读实例规格FlavorId  */
    InstanceClass string `json:"instanceClass"`

    /* 存储类型，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)，缺省值为：LOCAL_SSD (Optional) */
    InstanceStorageType *string `json:"instanceStorageType"`

    /* 磁盘空间  */
    InstanceStorageGB int `json:"instanceStorageGB"`

    /* 可用区ID  */
    AzId string `json:"azId"`

    /* VPC的ID，如果没有填写就保持和常规实例一样的VPC (Optional) */
    VpcId *string `json:"vpcId"`

    /* 子网ID，如果没有填写就保持和常规实例一样的subnet (Optional) */
    SubnetId *string `json:"subnetId"`

    /* 参数组ID，缺省采用和常规实例一样的参数组 (Optional) */
    ParameterGroup *string `json:"parameterGroup"`

    /* 实例数据加密(存储类型为云硬盘才支持数据加密)。false：不加密；true：加密。缺省为false。 (Optional) */
    StorageEncrypted *bool `json:"storageEncrypted"`

    /* 创建只读实例的数目,缺省为1 (Optional) */
    Count *int `json:"count"`

    /* 只读代理服务的ID，缺省值为 “NULL”，表示不绑定代理服务 (Optional) */
    RoInstanceProxy *string `json:"roInstanceProxy"`
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param instanceName: 实例名称，具体规则可参见帮助中心文档:[名称及密码限制](../../../documentation/Database-and-Cache-Service/RDS/Introduction/Restrictions/SQLServer-Restrictions.md) (Required)
 * param instanceClass: 只读实例规格FlavorId (Required)
 * param instanceStorageGB: 磁盘空间 (Required)
 * param azId: 可用区ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCreateROInstanceRequest(
    regionId string,
    instanceId string,
    instanceName string,
    instanceClass string,
    instanceStorageGB int,
    azId string,
) *CreateROInstanceRequest {

	return &CreateROInstanceRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instances/{instanceId}:createROInstance",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
        InstanceName: instanceName,
        InstanceClass: instanceClass,
        InstanceStorageGB: instanceStorageGB,
        AzId: azId,
	}
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param instanceName: 实例名称，具体规则可参见帮助中心文档:[名称及密码限制](../../../documentation/Database-and-Cache-Service/RDS/Introduction/Restrictions/SQLServer-Restrictions.md) (Required)
 * param instanceClass: 只读实例规格FlavorId (Required)
 * param instanceStorageType: 存储类型，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)，缺省值为：LOCAL_SSD (Optional)
 * param instanceStorageGB: 磁盘空间 (Required)
 * param azId: 可用区ID (Required)
 * param vpcId: VPC的ID，如果没有填写就保持和常规实例一样的VPC (Optional)
 * param subnetId: 子网ID，如果没有填写就保持和常规实例一样的subnet (Optional)
 * param parameterGroup: 参数组ID，缺省采用和常规实例一样的参数组 (Optional)
 * param storageEncrypted: 实例数据加密(存储类型为云硬盘才支持数据加密)。false：不加密；true：加密。缺省为false。 (Optional)
 * param count: 创建只读实例的数目,缺省为1 (Optional)
 * param roInstanceProxy: 只读代理服务的ID，缺省值为 “NULL”，表示不绑定代理服务 (Optional)
 */
func NewCreateROInstanceRequestWithAllParams(
    regionId string,
    instanceId string,
    instanceName string,
    instanceClass string,
    instanceStorageType *string,
    instanceStorageGB int,
    azId string,
    vpcId *string,
    subnetId *string,
    parameterGroup *string,
    storageEncrypted *bool,
    count *int,
    roInstanceProxy *string,
) *CreateROInstanceRequest {

    return &CreateROInstanceRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:createROInstance",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        InstanceName: instanceName,
        InstanceClass: instanceClass,
        InstanceStorageType: instanceStorageType,
        InstanceStorageGB: instanceStorageGB,
        AzId: azId,
        VpcId: vpcId,
        SubnetId: subnetId,
        ParameterGroup: parameterGroup,
        StorageEncrypted: storageEncrypted,
        Count: count,
        RoInstanceProxy: roInstanceProxy,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewCreateROInstanceRequestWithoutParam() *CreateROInstanceRequest {

    return &CreateROInstanceRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:createROInstance",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)(Required) */
func (r *CreateROInstanceRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: RDS 实例ID，唯一标识一个RDS实例(Required) */
func (r *CreateROInstanceRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param instanceName: 实例名称，具体规则可参见帮助中心文档:[名称及密码限制](../../../documentation/Database-and-Cache-Service/RDS/Introduction/Restrictions/SQLServer-Restrictions.md)(Required) */
func (r *CreateROInstanceRequest) SetInstanceName(instanceName string) {
    r.InstanceName = instanceName
}

/* param instanceClass: 只读实例规格FlavorId(Required) */
func (r *CreateROInstanceRequest) SetInstanceClass(instanceClass string) {
    r.InstanceClass = instanceClass
}

/* param instanceStorageType: 存储类型，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)，缺省值为：LOCAL_SSD(Optional) */
func (r *CreateROInstanceRequest) SetInstanceStorageType(instanceStorageType string) {
    r.InstanceStorageType = &instanceStorageType
}

/* param instanceStorageGB: 磁盘空间(Required) */
func (r *CreateROInstanceRequest) SetInstanceStorageGB(instanceStorageGB int) {
    r.InstanceStorageGB = instanceStorageGB
}

/* param azId: 可用区ID(Required) */
func (r *CreateROInstanceRequest) SetAzId(azId string) {
    r.AzId = azId
}

/* param vpcId: VPC的ID，如果没有填写就保持和常规实例一样的VPC(Optional) */
func (r *CreateROInstanceRequest) SetVpcId(vpcId string) {
    r.VpcId = &vpcId
}

/* param subnetId: 子网ID，如果没有填写就保持和常规实例一样的subnet(Optional) */
func (r *CreateROInstanceRequest) SetSubnetId(subnetId string) {
    r.SubnetId = &subnetId
}

/* param parameterGroup: 参数组ID，缺省采用和常规实例一样的参数组(Optional) */
func (r *CreateROInstanceRequest) SetParameterGroup(parameterGroup string) {
    r.ParameterGroup = &parameterGroup
}

/* param storageEncrypted: 实例数据加密(存储类型为云硬盘才支持数据加密)。false：不加密；true：加密。缺省为false。(Optional) */
func (r *CreateROInstanceRequest) SetStorageEncrypted(storageEncrypted bool) {
    r.StorageEncrypted = &storageEncrypted
}

/* param count: 创建只读实例的数目,缺省为1(Optional) */
func (r *CreateROInstanceRequest) SetCount(count int) {
    r.Count = &count
}

/* param roInstanceProxy: 只读代理服务的ID，缺省值为 “NULL”，表示不绑定代理服务(Optional) */
func (r *CreateROInstanceRequest) SetRoInstanceProxy(roInstanceProxy string) {
    r.RoInstanceProxy = &roInstanceProxy
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CreateROInstanceRequest) GetRegionId() string {
    return r.RegionId
}

type CreateROInstanceResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result CreateROInstanceResult `json:"result"`
}

type CreateROInstanceResult struct {
    RoInstanceId []string `json:"roInstanceId"`
    OrderId string `json:"orderId"`
}