// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    rds "github.com/jdcloud-api/jdcloud-sdk-go/services/rds/models"
)

type CreateReadWriteProxyRequest struct {

    core.JDCloudRequest

    /* 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)  */
    RegionId string `json:"regionId"`

    /* RDS 实例ID  */
    InstanceId string `json:"instanceId"`

    /* 延迟阈值，范围是0~1000，单位：秒，默认为100 (Optional) */
    DelayThreshold *int `json:"delayThreshold"`

    /* 读写分离代理后端实例负载均衡策略，默认值为LEAST_CURRENT_OPERATIONS；当前支持的负载均衡策略请查看[枚举参数定义](../Enum-Definitions/Enum-Definitions.md) (Optional) */
    LoadBalancerPolicy *string `json:"loadBalancerPolicy"`

    /* 后端实例健康检查配置 (Optional) */
    HealthCheckSpec *rds.HealthCheckSpec `json:"healthCheckSpec"`
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCreateReadWriteProxyRequest(
    regionId string,
    instanceId string,
) *CreateReadWriteProxyRequest {

	return &CreateReadWriteProxyRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/readWriteProxy",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
	}
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID (Required)
 * param delayThreshold: 延迟阈值，范围是0~1000，单位：秒，默认为100 (Optional)
 * param loadBalancerPolicy: 读写分离代理后端实例负载均衡策略，默认值为LEAST_CURRENT_OPERATIONS；当前支持的负载均衡策略请查看[枚举参数定义](../Enum-Definitions/Enum-Definitions.md) (Optional)
 * param healthCheckSpec: 后端实例健康检查配置 (Optional)
 */
func NewCreateReadWriteProxyRequestWithAllParams(
    regionId string,
    instanceId string,
    delayThreshold *int,
    loadBalancerPolicy *string,
    healthCheckSpec *rds.HealthCheckSpec,
) *CreateReadWriteProxyRequest {

    return &CreateReadWriteProxyRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/readWriteProxy",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        DelayThreshold: delayThreshold,
        LoadBalancerPolicy: loadBalancerPolicy,
        HealthCheckSpec: healthCheckSpec,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewCreateReadWriteProxyRequestWithoutParam() *CreateReadWriteProxyRequest {

    return &CreateReadWriteProxyRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/readWriteProxy",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)(Required) */
func (r *CreateReadWriteProxyRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: RDS 实例ID(Required) */
func (r *CreateReadWriteProxyRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param delayThreshold: 延迟阈值，范围是0~1000，单位：秒，默认为100(Optional) */
func (r *CreateReadWriteProxyRequest) SetDelayThreshold(delayThreshold int) {
    r.DelayThreshold = &delayThreshold
}

/* param loadBalancerPolicy: 读写分离代理后端实例负载均衡策略，默认值为LEAST_CURRENT_OPERATIONS；当前支持的负载均衡策略请查看[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)(Optional) */
func (r *CreateReadWriteProxyRequest) SetLoadBalancerPolicy(loadBalancerPolicy string) {
    r.LoadBalancerPolicy = &loadBalancerPolicy
}

/* param healthCheckSpec: 后端实例健康检查配置(Optional) */
func (r *CreateReadWriteProxyRequest) SetHealthCheckSpec(healthCheckSpec *rds.HealthCheckSpec) {
    r.HealthCheckSpec = healthCheckSpec
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CreateReadWriteProxyRequest) GetRegionId() string {
    return r.RegionId
}

type CreateReadWriteProxyResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result CreateReadWriteProxyResult `json:"result"`
}

type CreateReadWriteProxyResult struct {
    ReadWriteProxyId string `json:"readWriteProxyId"`
}