// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type DeleteBackupRequest struct {

    core.JDCloudRequest

    /* 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)  */
    RegionId string `json:"regionId"`

    /* 备份ID  */
    BackupId string `json:"backupId"`
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param backupId: 备份ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDeleteBackupRequest(
    regionId string,
    backupId string,
) *DeleteBackupRequest {

	return &DeleteBackupRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/backups/{backupId}",
			Method:  "DELETE",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        BackupId: backupId,
	}
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param backupId: 备份ID (Required)
 */
func NewDeleteBackupRequestWithAllParams(
    regionId string,
    backupId string,
) *DeleteBackupRequest {

    return &DeleteBackupRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/backups/{backupId}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        BackupId: backupId,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDeleteBackupRequestWithoutParam() *DeleteBackupRequest {

    return &DeleteBackupRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/backups/{backupId}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)(Required) */
func (r *DeleteBackupRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param backupId: 备份ID(Required) */
func (r *DeleteBackupRequest) SetBackupId(backupId string) {
    r.BackupId = backupId
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DeleteBackupRequest) GetRegionId() string {
    return r.RegionId
}

type DeleteBackupResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DeleteBackupResult `json:"result"`
}

type DeleteBackupResult struct {
}