// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type DeleteImportFileRequest struct {

    core.JDCloudRequest

    /* 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)  */
    RegionId string `json:"regionId"`

    /* RDS 实例ID，唯一标识一个RDS实例  */
    InstanceId string `json:"instanceId"`

    /* 单库上云文件名  */
    FileName string `json:"fileName"`

    /* 共享文件的全局ID，可从上传文件查询接口describeImportFiles中获取；如果该文件不是共享文件，则无须输入该字段 (Optional) */
    SharedFileGid *string `json:"sharedFileGid"`
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param fileName: 单库上云文件名 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDeleteImportFileRequest(
    regionId string,
    instanceId string,
    fileName string,
) *DeleteImportFileRequest {

	return &DeleteImportFileRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instances/{instanceId}/importFiles/{fileName}",
			Method:  "DELETE",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
        FileName: fileName,
	}
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param fileName: 单库上云文件名 (Required)
 * param sharedFileGid: 共享文件的全局ID，可从上传文件查询接口describeImportFiles中获取；如果该文件不是共享文件，则无须输入该字段 (Optional)
 */
func NewDeleteImportFileRequestWithAllParams(
    regionId string,
    instanceId string,
    fileName string,
    sharedFileGid *string,
) *DeleteImportFileRequest {

    return &DeleteImportFileRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}/importFiles/{fileName}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        FileName: fileName,
        SharedFileGid: sharedFileGid,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDeleteImportFileRequestWithoutParam() *DeleteImportFileRequest {

    return &DeleteImportFileRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}/importFiles/{fileName}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)(Required) */
func (r *DeleteImportFileRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: RDS 实例ID，唯一标识一个RDS实例(Required) */
func (r *DeleteImportFileRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param fileName: 单库上云文件名(Required) */
func (r *DeleteImportFileRequest) SetFileName(fileName string) {
    r.FileName = fileName
}

/* param sharedFileGid: 共享文件的全局ID，可从上传文件查询接口describeImportFiles中获取；如果该文件不是共享文件，则无须输入该字段(Optional) */
func (r *DeleteImportFileRequest) SetSharedFileGid(sharedFileGid string) {
    r.SharedFileGid = &sharedFileGid
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DeleteImportFileRequest) GetRegionId() string {
    return r.RegionId
}

type DeleteImportFileResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DeleteImportFileResult `json:"result"`
}

type DeleteImportFileResult struct {
}