// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type DeleteParameterGroupRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* Parameter Group ID  */
    ParameterGroupId string `json:"parameterGroupId"`
}

/*
 * param regionId: Region ID (Required)
 * param parameterGroupId: Parameter Group ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDeleteParameterGroupRequest(
    regionId string,
    parameterGroupId string,
) *DeleteParameterGroupRequest {

	return &DeleteParameterGroupRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/parameterGroups/{parameterGroupId}",
			Method:  "DELETE",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        ParameterGroupId: parameterGroupId,
	}
}

/*
 * param regionId: Region ID (Required)
 * param parameterGroupId: Parameter Group ID (Required)
 */
func NewDeleteParameterGroupRequestWithAllParams(
    regionId string,
    parameterGroupId string,
) *DeleteParameterGroupRequest {

    return &DeleteParameterGroupRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/parameterGroups/{parameterGroupId}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        ParameterGroupId: parameterGroupId,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDeleteParameterGroupRequestWithoutParam() *DeleteParameterGroupRequest {

    return &DeleteParameterGroupRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/parameterGroups/{parameterGroupId}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *DeleteParameterGroupRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param parameterGroupId: Parameter Group ID(Required) */
func (r *DeleteParameterGroupRequest) SetParameterGroupId(parameterGroupId string) {
    r.ParameterGroupId = parameterGroupId
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DeleteParameterGroupRequest) GetRegionId() string {
    return r.RegionId
}

type DeleteParameterGroupResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DeleteParameterGroupResult `json:"result"`
}

type DeleteParameterGroupResult struct {
}