// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type DescribeAuditDownloadURLRequest struct {

    core.JDCloudRequest

    /* 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)  */
    RegionId string `json:"regionId"`

    /* RDS 实例ID，唯一标识一个RDS实例  */
    InstanceId string `json:"instanceId"`

    /* 审计文件名  */
    FileName string `json:"fileName"`
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param fileName: 审计文件名 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeAuditDownloadURLRequest(
    regionId string,
    instanceId string,
    fileName string,
) *DescribeAuditDownloadURLRequest {

	return &DescribeAuditDownloadURLRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instances/{instanceId}/audit:describeAuditDownloadURL",
			Method:  "GET",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
        FileName: fileName,
	}
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param fileName: 审计文件名 (Required)
 */
func NewDescribeAuditDownloadURLRequestWithAllParams(
    regionId string,
    instanceId string,
    fileName string,
) *DescribeAuditDownloadURLRequest {

    return &DescribeAuditDownloadURLRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}/audit:describeAuditDownloadURL",
            Method:  "GET",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        FileName: fileName,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeAuditDownloadURLRequestWithoutParam() *DescribeAuditDownloadURLRequest {

    return &DescribeAuditDownloadURLRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}/audit:describeAuditDownloadURL",
            Method:  "GET",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)(Required) */
func (r *DescribeAuditDownloadURLRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: RDS 实例ID，唯一标识一个RDS实例(Required) */
func (r *DescribeAuditDownloadURLRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param fileName: 审计文件名(Required) */
func (r *DescribeAuditDownloadURLRequest) SetFileName(fileName string) {
    r.FileName = fileName
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeAuditDownloadURLRequest) GetRegionId() string {
    return r.RegionId
}

type DescribeAuditDownloadURLResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DescribeAuditDownloadURLResult `json:"result"`
}

type DescribeAuditDownloadURLResult struct {
    PublicURL string `json:"publicURL"`
    InternalURL string `json:"internalURL"`
}