// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type DescribeLogDownloadURLRequest struct {

    core.JDCloudRequest

    /* 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)  */
    RegionId string `json:"regionId"`

    /* RDS 实例ID，唯一标识一个RDS实例  */
    InstanceId string `json:"instanceId"`

    /* 日志文件ID  */
    LogId string `json:"logId"`

    /* 设置链接地址的过期时间，单位是秒，默认值是 300 秒，最长不能超过取值范围为 1 ~ 86400 秒 (Optional) */
    Seconds *int `json:"seconds"`
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param logId: 日志文件ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeLogDownloadURLRequest(
    regionId string,
    instanceId string,
    logId string,
) *DescribeLogDownloadURLRequest {

	return &DescribeLogDownloadURLRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instances/{instanceId}/log/{logId}:describeLogDownloadURL",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
        LogId: logId,
	}
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param logId: 日志文件ID (Required)
 * param seconds: 设置链接地址的过期时间，单位是秒，默认值是 300 秒，最长不能超过取值范围为 1 ~ 86400 秒 (Optional)
 */
func NewDescribeLogDownloadURLRequestWithAllParams(
    regionId string,
    instanceId string,
    logId string,
    seconds *int,
) *DescribeLogDownloadURLRequest {

    return &DescribeLogDownloadURLRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}/log/{logId}:describeLogDownloadURL",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        LogId: logId,
        Seconds: seconds,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeLogDownloadURLRequestWithoutParam() *DescribeLogDownloadURLRequest {

    return &DescribeLogDownloadURLRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}/log/{logId}:describeLogDownloadURL",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)(Required) */
func (r *DescribeLogDownloadURLRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: RDS 实例ID，唯一标识一个RDS实例(Required) */
func (r *DescribeLogDownloadURLRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param logId: 日志文件ID(Required) */
func (r *DescribeLogDownloadURLRequest) SetLogId(logId string) {
    r.LogId = logId
}

/* param seconds: 设置链接地址的过期时间，单位是秒，默认值是 300 秒，最长不能超过取值范围为 1 ~ 86400 秒(Optional) */
func (r *DescribeLogDownloadURLRequest) SetSeconds(seconds int) {
    r.Seconds = &seconds
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeLogDownloadURLRequest) GetRegionId() string {
    return r.RegionId
}

type DescribeLogDownloadURLResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DescribeLogDownloadURLResult `json:"result"`
}

type DescribeLogDownloadURLResult struct {
    PublicURL string `json:"publicURL"`
    InternalURL string `json:"internalURL"`
}