// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    rds "github.com/jdcloud-api/jdcloud-sdk-go/services/rds/models"
)

type DescribeParameterGroupAttachedInstancesRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* Parameter Group ID  */
    ParameterGroupId string `json:"parameterGroupId"`

    /* 显示数据的页码，默认为1，取值范围：[-1,∞)。pageNumber为-1时，返回所有数据页码；超过总页数时，显示最后一页 (Optional) */
    PageNumber *int `json:"pageNumber"`

    /* 每页显示的数据条数，默认为10，取值范围：[10,100]，且为10的整数倍 (Optional) */
    PageSize *int `json:"pageSize"`
}

/*
 * param regionId: Region ID (Required)
 * param parameterGroupId: Parameter Group ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeParameterGroupAttachedInstancesRequest(
    regionId string,
    parameterGroupId string,
) *DescribeParameterGroupAttachedInstancesRequest {

	return &DescribeParameterGroupAttachedInstancesRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/parameterGroups/{parameterGroupId}/instances",
			Method:  "GET",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        ParameterGroupId: parameterGroupId,
	}
}

/*
 * param regionId: Region ID (Required)
 * param parameterGroupId: Parameter Group ID (Required)
 * param pageNumber: 显示数据的页码，默认为1，取值范围：[-1,∞)。pageNumber为-1时，返回所有数据页码；超过总页数时，显示最后一页 (Optional)
 * param pageSize: 每页显示的数据条数，默认为10，取值范围：[10,100]，且为10的整数倍 (Optional)
 */
func NewDescribeParameterGroupAttachedInstancesRequestWithAllParams(
    regionId string,
    parameterGroupId string,
    pageNumber *int,
    pageSize *int,
) *DescribeParameterGroupAttachedInstancesRequest {

    return &DescribeParameterGroupAttachedInstancesRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/parameterGroups/{parameterGroupId}/instances",
            Method:  "GET",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        ParameterGroupId: parameterGroupId,
        PageNumber: pageNumber,
        PageSize: pageSize,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeParameterGroupAttachedInstancesRequestWithoutParam() *DescribeParameterGroupAttachedInstancesRequest {

    return &DescribeParameterGroupAttachedInstancesRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/parameterGroups/{parameterGroupId}/instances",
            Method:  "GET",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *DescribeParameterGroupAttachedInstancesRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param parameterGroupId: Parameter Group ID(Required) */
func (r *DescribeParameterGroupAttachedInstancesRequest) SetParameterGroupId(parameterGroupId string) {
    r.ParameterGroupId = parameterGroupId
}

/* param pageNumber: 显示数据的页码，默认为1，取值范围：[-1,∞)。pageNumber为-1时，返回所有数据页码；超过总页数时，显示最后一页(Optional) */
func (r *DescribeParameterGroupAttachedInstancesRequest) SetPageNumber(pageNumber int) {
    r.PageNumber = &pageNumber
}

/* param pageSize: 每页显示的数据条数，默认为10，取值范围：[10,100]，且为10的整数倍(Optional) */
func (r *DescribeParameterGroupAttachedInstancesRequest) SetPageSize(pageSize int) {
    r.PageSize = &pageSize
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeParameterGroupAttachedInstancesRequest) GetRegionId() string {
    return r.RegionId
}

type DescribeParameterGroupAttachedInstancesResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DescribeParameterGroupAttachedInstancesResult `json:"result"`
}

type DescribeParameterGroupAttachedInstancesResult struct {
    Instances []rds.AttachedDBInstance `json:"instances"`
    TotalCount int `json:"totalCount"`
}