// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    rds "github.com/jdcloud-api/jdcloud-sdk-go/services/rds/models"
)

type DescribeParameterModifyRecordsRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* Parameter Group ID  */
    ParameterGroupId string `json:"parameterGroupId"`

    /* 显示数据的页码，默认为1，取值范围：[-1,∞)。pageNumber为-1时，返回所有数据页码；超过总页数时，显示最后一页; (Optional) */
    PageNumber *int `json:"pageNumber"`

    /* 每页显示的数据条数，默认为10，取值范围：[10,100]，且为10的整数倍 (Optional) */
    PageSize *int `json:"pageSize"`

    /* 查询开始时间，格式为：YYYY-MM-DD HH:mm:ss (Optional) */
    StartTime *string `json:"startTime"`

    /* 查询结束时间，格式为：YYYY-MM-DD HH:mm:ss (Optional) */
    EndTime *string `json:"endTime"`
}

/*
 * param regionId: Region ID (Required)
 * param parameterGroupId: Parameter Group ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeParameterModifyRecordsRequest(
    regionId string,
    parameterGroupId string,
) *DescribeParameterModifyRecordsRequest {

	return &DescribeParameterModifyRecordsRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/parameterGroups/{parameterGroupId}/records",
			Method:  "GET",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        ParameterGroupId: parameterGroupId,
	}
}

/*
 * param regionId: Region ID (Required)
 * param parameterGroupId: Parameter Group ID (Required)
 * param pageNumber: 显示数据的页码，默认为1，取值范围：[-1,∞)。pageNumber为-1时，返回所有数据页码；超过总页数时，显示最后一页; (Optional)
 * param pageSize: 每页显示的数据条数，默认为10，取值范围：[10,100]，且为10的整数倍 (Optional)
 * param startTime: 查询开始时间，格式为：YYYY-MM-DD HH:mm:ss (Optional)
 * param endTime: 查询结束时间，格式为：YYYY-MM-DD HH:mm:ss (Optional)
 */
func NewDescribeParameterModifyRecordsRequestWithAllParams(
    regionId string,
    parameterGroupId string,
    pageNumber *int,
    pageSize *int,
    startTime *string,
    endTime *string,
) *DescribeParameterModifyRecordsRequest {

    return &DescribeParameterModifyRecordsRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/parameterGroups/{parameterGroupId}/records",
            Method:  "GET",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        ParameterGroupId: parameterGroupId,
        PageNumber: pageNumber,
        PageSize: pageSize,
        StartTime: startTime,
        EndTime: endTime,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeParameterModifyRecordsRequestWithoutParam() *DescribeParameterModifyRecordsRequest {

    return &DescribeParameterModifyRecordsRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/parameterGroups/{parameterGroupId}/records",
            Method:  "GET",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *DescribeParameterModifyRecordsRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param parameterGroupId: Parameter Group ID(Required) */
func (r *DescribeParameterModifyRecordsRequest) SetParameterGroupId(parameterGroupId string) {
    r.ParameterGroupId = parameterGroupId
}

/* param pageNumber: 显示数据的页码，默认为1，取值范围：[-1,∞)。pageNumber为-1时，返回所有数据页码；超过总页数时，显示最后一页;(Optional) */
func (r *DescribeParameterModifyRecordsRequest) SetPageNumber(pageNumber int) {
    r.PageNumber = &pageNumber
}

/* param pageSize: 每页显示的数据条数，默认为10，取值范围：[10,100]，且为10的整数倍(Optional) */
func (r *DescribeParameterModifyRecordsRequest) SetPageSize(pageSize int) {
    r.PageSize = &pageSize
}

/* param startTime: 查询开始时间，格式为：YYYY-MM-DD HH:mm:ss(Optional) */
func (r *DescribeParameterModifyRecordsRequest) SetStartTime(startTime string) {
    r.StartTime = &startTime
}

/* param endTime: 查询结束时间，格式为：YYYY-MM-DD HH:mm:ss(Optional) */
func (r *DescribeParameterModifyRecordsRequest) SetEndTime(endTime string) {
    r.EndTime = &endTime
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeParameterModifyRecordsRequest) GetRegionId() string {
    return r.RegionId
}

type DescribeParameterModifyRecordsResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DescribeParameterModifyRecordsResult `json:"result"`
}

type DescribeParameterModifyRecordsResult struct {
    Records []rds.ParameterModifyRecords `json:"records"`
    TotalCount int `json:"totalCount"`
}