// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    rds "github.com/jdcloud-api/jdcloud-sdk-go/services/rds/models"
)

type GrantAccountPrivilegeRequest struct {

    core.JDCloudRequest

    /* 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)  */
    RegionId string `json:"regionId"`

    /* RDS 实例ID，唯一标识一个RDS实例  */
    InstanceId string `json:"instanceId"`

    /* 账号名，在同一个实例中账号名不能重复  */
    AccountName string `json:"accountName"`

    /* 设置数据库细粒度权限内容 (Optional) */
    DatabasePrivileges []rds.DatabasePrivilege `json:"databasePrivileges"`

    /* 设置全局权限，权限的具体定义参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md) (Optional) */
    GlobalPrivileges []string `json:"globalPrivileges"`
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param accountName: 账号名，在同一个实例中账号名不能重复 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewGrantAccountPrivilegeRequest(
    regionId string,
    instanceId string,
    accountName string,
) *GrantAccountPrivilegeRequest {

	return &GrantAccountPrivilegeRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instances/{instanceId}/accounts/{accountName}:grantAccountPrivilege",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
        AccountName: accountName,
	}
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param accountName: 账号名，在同一个实例中账号名不能重复 (Required)
 * param databasePrivileges: 设置数据库细粒度权限内容 (Optional)
 * param globalPrivileges: 设置全局权限，权限的具体定义参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md) (Optional)
 */
func NewGrantAccountPrivilegeRequestWithAllParams(
    regionId string,
    instanceId string,
    accountName string,
    databasePrivileges []rds.DatabasePrivilege,
    globalPrivileges []string,
) *GrantAccountPrivilegeRequest {

    return &GrantAccountPrivilegeRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}/accounts/{accountName}:grantAccountPrivilege",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        AccountName: accountName,
        DatabasePrivileges: databasePrivileges,
        GlobalPrivileges: globalPrivileges,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewGrantAccountPrivilegeRequestWithoutParam() *GrantAccountPrivilegeRequest {

    return &GrantAccountPrivilegeRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}/accounts/{accountName}:grantAccountPrivilege",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)(Required) */
func (r *GrantAccountPrivilegeRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: RDS 实例ID，唯一标识一个RDS实例(Required) */
func (r *GrantAccountPrivilegeRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param accountName: 账号名，在同一个实例中账号名不能重复(Required) */
func (r *GrantAccountPrivilegeRequest) SetAccountName(accountName string) {
    r.AccountName = accountName
}

/* param databasePrivileges: 设置数据库细粒度权限内容(Optional) */
func (r *GrantAccountPrivilegeRequest) SetDatabasePrivileges(databasePrivileges []rds.DatabasePrivilege) {
    r.DatabasePrivileges = databasePrivileges
}

/* param globalPrivileges: 设置全局权限，权限的具体定义参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)(Optional) */
func (r *GrantAccountPrivilegeRequest) SetGlobalPrivileges(globalPrivileges []string) {
    r.GlobalPrivileges = globalPrivileges
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r GrantAccountPrivilegeRequest) GetRegionId() string {
    return r.RegionId
}

type GrantAccountPrivilegeResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result GrantAccountPrivilegeResult `json:"result"`
}

type GrantAccountPrivilegeResult struct {
}