// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type ModifyInstanceSpecRequest struct {

    core.JDCloudRequest

    /* 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)  */
    RegionId string `json:"regionId"`

    /* RDS 实例ID，唯一标识一个RDS实例  */
    InstanceId string `json:"instanceId"`

    /* 扩容后实例规格  */
    NewInstanceClass string `json:"newInstanceClass"`

    /* 扩容后实例磁盘大小  */
    NewInstanceStorageGB int `json:"newInstanceStorageGB"`

    /* 存储类型，如果不指定，默认会采用实例原存储类型. (Optional) */
    NewInstanceStorageType *string `json:"newInstanceStorageType"`

    /* 实例数据加密(存储类型为云硬盘才支持数据加密). false：不加密; true：加密. 如果实例从本地盘变为云硬盘，缺省为false. 如果实例本来就是使用云硬盘的，缺省和源实例保持一致 (Optional) */
    StorageEncrypted *bool `json:"storageEncrypted"`

    /* 变配后的子网ID (Optional) */
    SubnetId *string `json:"subnetId"`
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param newInstanceClass: 扩容后实例规格 (Required)
 * param newInstanceStorageGB: 扩容后实例磁盘大小 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewModifyInstanceSpecRequest(
    regionId string,
    instanceId string,
    newInstanceClass string,
    newInstanceStorageGB int,
) *ModifyInstanceSpecRequest {

	return &ModifyInstanceSpecRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instances/{instanceId}:modifyInstanceSpec",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
        NewInstanceClass: newInstanceClass,
        NewInstanceStorageGB: newInstanceStorageGB,
	}
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param newInstanceClass: 扩容后实例规格 (Required)
 * param newInstanceStorageGB: 扩容后实例磁盘大小 (Required)
 * param newInstanceStorageType: 存储类型，如果不指定，默认会采用实例原存储类型. (Optional)
 * param storageEncrypted: 实例数据加密(存储类型为云硬盘才支持数据加密). false：不加密; true：加密. 如果实例从本地盘变为云硬盘，缺省为false. 如果实例本来就是使用云硬盘的，缺省和源实例保持一致 (Optional)
 * param subnetId: 变配后的子网ID (Optional)
 */
func NewModifyInstanceSpecRequestWithAllParams(
    regionId string,
    instanceId string,
    newInstanceClass string,
    newInstanceStorageGB int,
    newInstanceStorageType *string,
    storageEncrypted *bool,
    subnetId *string,
) *ModifyInstanceSpecRequest {

    return &ModifyInstanceSpecRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:modifyInstanceSpec",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        NewInstanceClass: newInstanceClass,
        NewInstanceStorageGB: newInstanceStorageGB,
        NewInstanceStorageType: newInstanceStorageType,
        StorageEncrypted: storageEncrypted,
        SubnetId: subnetId,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewModifyInstanceSpecRequestWithoutParam() *ModifyInstanceSpecRequest {

    return &ModifyInstanceSpecRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:modifyInstanceSpec",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)(Required) */
func (r *ModifyInstanceSpecRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: RDS 实例ID，唯一标识一个RDS实例(Required) */
func (r *ModifyInstanceSpecRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param newInstanceClass: 扩容后实例规格(Required) */
func (r *ModifyInstanceSpecRequest) SetNewInstanceClass(newInstanceClass string) {
    r.NewInstanceClass = newInstanceClass
}

/* param newInstanceStorageGB: 扩容后实例磁盘大小(Required) */
func (r *ModifyInstanceSpecRequest) SetNewInstanceStorageGB(newInstanceStorageGB int) {
    r.NewInstanceStorageGB = newInstanceStorageGB
}

/* param newInstanceStorageType: 存储类型，如果不指定，默认会采用实例原存储类型.(Optional) */
func (r *ModifyInstanceSpecRequest) SetNewInstanceStorageType(newInstanceStorageType string) {
    r.NewInstanceStorageType = &newInstanceStorageType
}

/* param storageEncrypted: 实例数据加密(存储类型为云硬盘才支持数据加密). false：不加密; true：加密. 如果实例从本地盘变为云硬盘，缺省为false. 如果实例本来就是使用云硬盘的，缺省和源实例保持一致(Optional) */
func (r *ModifyInstanceSpecRequest) SetStorageEncrypted(storageEncrypted bool) {
    r.StorageEncrypted = &storageEncrypted
}

/* param subnetId: 变配后的子网ID(Optional) */
func (r *ModifyInstanceSpecRequest) SetSubnetId(subnetId string) {
    r.SubnetId = &subnetId
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r ModifyInstanceSpecRequest) GetRegionId() string {
    return r.RegionId
}

type ModifyInstanceSpecResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result ModifyInstanceSpecResult `json:"result"`
}

type ModifyInstanceSpecResult struct {
    OrderId string `json:"orderId"`
}