// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type ModifyParameterGroupAttributeRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* Parameter Group ID  */
    ParameterGroupId string `json:"parameterGroupId"`

    /* 参数组名称  */
    ParameterGroupName string `json:"parameterGroupName"`

    /* 参数组描述 (Optional) */
    Description *string `json:"description"`
}

/*
 * param regionId: Region ID (Required)
 * param parameterGroupId: Parameter Group ID (Required)
 * param parameterGroupName: 参数组名称 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewModifyParameterGroupAttributeRequest(
    regionId string,
    parameterGroupId string,
    parameterGroupName string,
) *ModifyParameterGroupAttributeRequest {

	return &ModifyParameterGroupAttributeRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/parameterGroups/{parameterGroupId}:modifyParameterGroupAttribute",
			Method:  "PUT",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        ParameterGroupId: parameterGroupId,
        ParameterGroupName: parameterGroupName,
	}
}

/*
 * param regionId: Region ID (Required)
 * param parameterGroupId: Parameter Group ID (Required)
 * param parameterGroupName: 参数组名称 (Required)
 * param description: 参数组描述 (Optional)
 */
func NewModifyParameterGroupAttributeRequestWithAllParams(
    regionId string,
    parameterGroupId string,
    parameterGroupName string,
    description *string,
) *ModifyParameterGroupAttributeRequest {

    return &ModifyParameterGroupAttributeRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/parameterGroups/{parameterGroupId}:modifyParameterGroupAttribute",
            Method:  "PUT",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        ParameterGroupId: parameterGroupId,
        ParameterGroupName: parameterGroupName,
        Description: description,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewModifyParameterGroupAttributeRequestWithoutParam() *ModifyParameterGroupAttributeRequest {

    return &ModifyParameterGroupAttributeRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/parameterGroups/{parameterGroupId}:modifyParameterGroupAttribute",
            Method:  "PUT",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *ModifyParameterGroupAttributeRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param parameterGroupId: Parameter Group ID(Required) */
func (r *ModifyParameterGroupAttributeRequest) SetParameterGroupId(parameterGroupId string) {
    r.ParameterGroupId = parameterGroupId
}

/* param parameterGroupName: 参数组名称(Required) */
func (r *ModifyParameterGroupAttributeRequest) SetParameterGroupName(parameterGroupName string) {
    r.ParameterGroupName = parameterGroupName
}

/* param description: 参数组描述(Optional) */
func (r *ModifyParameterGroupAttributeRequest) SetDescription(description string) {
    r.Description = &description
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r ModifyParameterGroupAttributeRequest) GetRegionId() string {
    return r.RegionId
}

type ModifyParameterGroupAttributeResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result ModifyParameterGroupAttributeResult `json:"result"`
}

type ModifyParameterGroupAttributeResult struct {
}