// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type RebootInstanceRequest struct {

    core.JDCloudRequest

    /* 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)  */
    RegionId string `json:"regionId"`

    /* RDS 实例ID，唯一标识一个RDS实例  */
    InstanceId string `json:"instanceId"`

    /* 是否重启主节点。<br> - 仅SQL Server 支持该参数 (Optional) */
    RebootMaster *bool `json:"rebootMaster"`

    /* 是否重启备节点。<br> - 仅SQL Server 支持该参数 (Optional) */
    RebootSlave *bool `json:"rebootSlave"`
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewRebootInstanceRequest(
    regionId string,
    instanceId string,
) *RebootInstanceRequest {

	return &RebootInstanceRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instances/{instanceId}:rebootInstance",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
	}
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param rebootMaster: 是否重启主节点。<br> - 仅SQL Server 支持该参数 (Optional)
 * param rebootSlave: 是否重启备节点。<br> - 仅SQL Server 支持该参数 (Optional)
 */
func NewRebootInstanceRequestWithAllParams(
    regionId string,
    instanceId string,
    rebootMaster *bool,
    rebootSlave *bool,
) *RebootInstanceRequest {

    return &RebootInstanceRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:rebootInstance",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        RebootMaster: rebootMaster,
        RebootSlave: rebootSlave,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewRebootInstanceRequestWithoutParam() *RebootInstanceRequest {

    return &RebootInstanceRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:rebootInstance",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)(Required) */
func (r *RebootInstanceRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: RDS 实例ID，唯一标识一个RDS实例(Required) */
func (r *RebootInstanceRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param rebootMaster: 是否重启主节点。<br> - 仅SQL Server 支持该参数(Optional) */
func (r *RebootInstanceRequest) SetRebootMaster(rebootMaster bool) {
    r.RebootMaster = &rebootMaster
}

/* param rebootSlave: 是否重启备节点。<br> - 仅SQL Server 支持该参数(Optional) */
func (r *RebootInstanceRequest) SetRebootSlave(rebootSlave bool) {
    r.RebootSlave = &rebootSlave
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r RebootInstanceRequest) GetRegionId() string {
    return r.RegionId
}

type RebootInstanceResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result RebootInstanceResult `json:"result"`
}

type RebootInstanceResult struct {
}