// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    rds "github.com/jdcloud-api/jdcloud-sdk-go/services/rds/models"
)

type RestoreInstanceByTimeRequest struct {

    core.JDCloudRequest

    /* 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)  */
    RegionId string `json:"regionId"`

    /* RDS 实例ID，唯一标识一个RDS实例  */
    InstanceId string `json:"instanceId"`

    /* 根据源实例的哪个时间点创建新实例  */
    RestoreTime string `json:"restoreTime"`

    /* 需要进行单库，单表恢复的概要信息  */
    RestoreSchema []rds.Schema `json:"restoreSchema"`
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param restoreTime: 根据源实例的哪个时间点创建新实例 (Required)
 * param restoreSchema: 需要进行单库，单表恢复的概要信息 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewRestoreInstanceByTimeRequest(
    regionId string,
    instanceId string,
    restoreTime string,
    restoreSchema []rds.Schema,
) *RestoreInstanceByTimeRequest {

	return &RestoreInstanceByTimeRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instances/{instanceId}:restoreInstanceByTime",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
        RestoreTime: restoreTime,
        RestoreSchema: restoreSchema,
	}
}

/*
 * param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md) (Required)
 * param instanceId: RDS 实例ID，唯一标识一个RDS实例 (Required)
 * param restoreTime: 根据源实例的哪个时间点创建新实例 (Required)
 * param restoreSchema: 需要进行单库，单表恢复的概要信息 (Required)
 */
func NewRestoreInstanceByTimeRequestWithAllParams(
    regionId string,
    instanceId string,
    restoreTime string,
    restoreSchema []rds.Schema,
) *RestoreInstanceByTimeRequest {

    return &RestoreInstanceByTimeRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:restoreInstanceByTime",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        RestoreTime: restoreTime,
        RestoreSchema: restoreSchema,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewRestoreInstanceByTimeRequestWithoutParam() *RestoreInstanceByTimeRequest {

    return &RestoreInstanceByTimeRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:restoreInstanceByTime",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)(Required) */
func (r *RestoreInstanceByTimeRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: RDS 实例ID，唯一标识一个RDS实例(Required) */
func (r *RestoreInstanceByTimeRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param restoreTime: 根据源实例的哪个时间点创建新实例(Required) */
func (r *RestoreInstanceByTimeRequest) SetRestoreTime(restoreTime string) {
    r.RestoreTime = restoreTime
}

/* param restoreSchema: 需要进行单库，单表恢复的概要信息(Required) */
func (r *RestoreInstanceByTimeRequest) SetRestoreSchema(restoreSchema []rds.Schema) {
    r.RestoreSchema = restoreSchema
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r RestoreInstanceByTimeRequest) GetRegionId() string {
    return r.RegionId
}

type RestoreInstanceByTimeResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result RestoreInstanceByTimeResult `json:"result"`
}

type RestoreInstanceByTimeResult struct {
}