// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    vm "github.com/jdcloud-api/jdcloud-sdk-go/services/vm/models"
)

type CreateInstanceTemplateRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 启动模板的数据  */
    InstanceTemplateData *vm.InstanceTemplateSpec `json:"instanceTemplateData"`

    /* 启动模板的名称，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。  */
    Name string `json:"name"`

    /* 启动模板的描述，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。 (Optional) */
    Description *string `json:"description"`
}

/*
 * param regionId: 地域ID (Required)
 * param instanceTemplateData: 启动模板的数据 (Required)
 * param name: 启动模板的名称，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCreateInstanceTemplateRequest(
    regionId string,
    instanceTemplateData *vm.InstanceTemplateSpec,
    name string,
) *CreateInstanceTemplateRequest {

	return &CreateInstanceTemplateRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instanceTemplates",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceTemplateData: instanceTemplateData,
        Name: name,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param instanceTemplateData: 启动模板的数据 (Required)
 * param name: 启动模板的名称，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。 (Required)
 * param description: 启动模板的描述，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。 (Optional)
 */
func NewCreateInstanceTemplateRequestWithAllParams(
    regionId string,
    instanceTemplateData *vm.InstanceTemplateSpec,
    name string,
    description *string,
) *CreateInstanceTemplateRequest {

    return &CreateInstanceTemplateRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instanceTemplates",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceTemplateData: instanceTemplateData,
        Name: name,
        Description: description,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewCreateInstanceTemplateRequestWithoutParam() *CreateInstanceTemplateRequest {

    return &CreateInstanceTemplateRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instanceTemplates",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *CreateInstanceTemplateRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceTemplateData: 启动模板的数据(Required) */
func (r *CreateInstanceTemplateRequest) SetInstanceTemplateData(instanceTemplateData *vm.InstanceTemplateSpec) {
    r.InstanceTemplateData = instanceTemplateData
}

/* param name: 启动模板的名称，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。(Required) */
func (r *CreateInstanceTemplateRequest) SetName(name string) {
    r.Name = name
}

/* param description: 启动模板的描述，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。(Optional) */
func (r *CreateInstanceTemplateRequest) SetDescription(description string) {
    r.Description = &description
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CreateInstanceTemplateRequest) GetRegionId() string {
    return r.RegionId
}

type CreateInstanceTemplateResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result CreateInstanceTemplateResult `json:"result"`
}

type CreateInstanceTemplateResult struct {
    InstanceTemplateId string `json:"instanceTemplateId"`
}