// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type DeleteInstanceTemplateRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 启动模板ID  */
    InstanceTemplateId string `json:"instanceTemplateId"`
}

/*
 * param regionId: 地域ID (Required)
 * param instanceTemplateId: 启动模板ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDeleteInstanceTemplateRequest(
    regionId string,
    instanceTemplateId string,
) *DeleteInstanceTemplateRequest {

	return &DeleteInstanceTemplateRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instanceTemplates/{instanceTemplateId}",
			Method:  "DELETE",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceTemplateId: instanceTemplateId,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param instanceTemplateId: 启动模板ID (Required)
 */
func NewDeleteInstanceTemplateRequestWithAllParams(
    regionId string,
    instanceTemplateId string,
) *DeleteInstanceTemplateRequest {

    return &DeleteInstanceTemplateRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instanceTemplates/{instanceTemplateId}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceTemplateId: instanceTemplateId,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDeleteInstanceTemplateRequestWithoutParam() *DeleteInstanceTemplateRequest {

    return &DeleteInstanceTemplateRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instanceTemplates/{instanceTemplateId}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *DeleteInstanceTemplateRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceTemplateId: 启动模板ID(Required) */
func (r *DeleteInstanceTemplateRequest) SetInstanceTemplateId(instanceTemplateId string) {
    r.InstanceTemplateId = instanceTemplateId
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DeleteInstanceTemplateRequest) GetRegionId() string {
    return r.RegionId
}

type DeleteInstanceTemplateResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DeleteInstanceTemplateResult `json:"result"`
}

type DeleteInstanceTemplateResult struct {
}