// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type DetachKeypairRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 密钥名称  */
    KeyName string `json:"keyName"`

    /* 虚机Id  */
    InstanceIds []string `json:"instanceIds"`
}

/*
 * param regionId: 地域ID (Required)
 * param keyName: 密钥名称 (Required)
 * param instanceIds: 虚机Id (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDetachKeypairRequest(
    regionId string,
    keyName string,
    instanceIds []string,
) *DetachKeypairRequest {

	return &DetachKeypairRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/keypairs/{keyName}:detach",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        KeyName: keyName,
        InstanceIds: instanceIds,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param keyName: 密钥名称 (Required)
 * param instanceIds: 虚机Id (Required)
 */
func NewDetachKeypairRequestWithAllParams(
    regionId string,
    keyName string,
    instanceIds []string,
) *DetachKeypairRequest {

    return &DetachKeypairRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/keypairs/{keyName}:detach",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        KeyName: keyName,
        InstanceIds: instanceIds,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDetachKeypairRequestWithoutParam() *DetachKeypairRequest {

    return &DetachKeypairRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/keypairs/{keyName}:detach",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *DetachKeypairRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param keyName: 密钥名称(Required) */
func (r *DetachKeypairRequest) SetKeyName(keyName string) {
    r.KeyName = keyName
}

/* param instanceIds: 虚机Id(Required) */
func (r *DetachKeypairRequest) SetInstanceIds(instanceIds []string) {
    r.InstanceIds = instanceIds
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DetachKeypairRequest) GetRegionId() string {
    return r.RegionId
}

type DetachKeypairResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DetachKeypairResult `json:"result"`
}

type DetachKeypairResult struct {
    SuccessInstanceId []string `json:"successInstanceId"`
    FailInstanceId []string `json:"failInstanceId"`
}