// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    vm "github.com/jdcloud-api/jdcloud-sdk-go/services/vm/models"
)

type RebuildInstanceRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 云主机ID  */
    InstanceId string `json:"instanceId"`

    /* 云主机密码，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。 (Optional) */
    Password *string `json:"password"`

    /* 镜像ID。可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeimages">DescribeImages</a>接口获得指定地域的镜像信息。 (Optional) */
    ImageId *string `json:"imageId"`

    /* 密钥对名称；当前只支持一个。仅Linux系统支持指定。 (Optional) */
    KeyNames []string `json:"keyNames"`

    /* 云主机hostname，若不指定hostname，则hostname默认使用云主机重置前的hostname
Windows Server系统：长度为2-15个字符，允许大小写字母、数字或连字符（-）。不能以连字符（-）开头或结尾，不能连续使用连字符（-），也不能全部使用数字。不支持点号（.）。
Linux系统：长度为2-64个字符，允许支持多个点号，点之间为一段，每段允许使用大小写字母、数字或连字符（-），但不能连续使用点号（.）或连字符（-），不能以点号（.）或连字符（-）开头或结尾。
 (Optional) */
    Hostname *string `json:"hostname"`

    /* 用户自定义元数据信息，key-value键值对总数量不超过40对，其中有效键值对数量不超过20，无效键值对数量不超过20对。不区分大小写。
若不指定metadata，则metadata默认使用云主机重置前的metadata。
注意：key不要以连字符(-)结尾，否则此key不生效。
 (Optional) */
    Metadata []vm.Metadata `json:"metadata"`

    /* 元数据信息，目前只支持传入一个key为"launch-script"，表示首次启动脚本。value为base64格式。
若不指定userdata，则userdata默认使用云主机重置前的userdata。
launch-script：linux系统支持bash和python，编码前须分别以 #!/bin/bash 和 #!/usr/bin/env python 作为内容首行;
launch-script：windows系统支持bat和powershell，编码前须分别以 <cmd></cmd> 和 <powershell></powershell> 作为内容首、尾行。
 (Optional) */
    Userdata []vm.Userdata `json:"userdata"`
}

/*
 * param regionId: 地域ID (Required)
 * param instanceId: 云主机ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewRebuildInstanceRequest(
    regionId string,
    instanceId string,
) *RebuildInstanceRequest {

	return &RebuildInstanceRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instances/{instanceId}:rebuildInstance",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param instanceId: 云主机ID (Required)
 * param password: 云主机密码，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。 (Optional)
 * param imageId: 镜像ID。可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeimages">DescribeImages</a>接口获得指定地域的镜像信息。 (Optional)
 * param keyNames: 密钥对名称；当前只支持一个。仅Linux系统支持指定。 (Optional)
 * param hostname: 云主机hostname，若不指定hostname，则hostname默认使用云主机重置前的hostname
Windows Server系统：长度为2-15个字符，允许大小写字母、数字或连字符（-）。不能以连字符（-）开头或结尾，不能连续使用连字符（-），也不能全部使用数字。不支持点号（.）。
Linux系统：长度为2-64个字符，允许支持多个点号，点之间为一段，每段允许使用大小写字母、数字或连字符（-），但不能连续使用点号（.）或连字符（-），不能以点号（.）或连字符（-）开头或结尾。
 (Optional)
 * param metadata: 用户自定义元数据信息，key-value键值对总数量不超过40对，其中有效键值对数量不超过20，无效键值对数量不超过20对。不区分大小写。
若不指定metadata，则metadata默认使用云主机重置前的metadata。
注意：key不要以连字符(-)结尾，否则此key不生效。
 (Optional)
 * param userdata: 元数据信息，目前只支持传入一个key为"launch-script"，表示首次启动脚本。value为base64格式。
若不指定userdata，则userdata默认使用云主机重置前的userdata。
launch-script：linux系统支持bash和python，编码前须分别以 #!/bin/bash 和 #!/usr/bin/env python 作为内容首行;
launch-script：windows系统支持bat和powershell，编码前须分别以 <cmd></cmd> 和 <powershell></powershell> 作为内容首、尾行。
 (Optional)
 */
func NewRebuildInstanceRequestWithAllParams(
    regionId string,
    instanceId string,
    password *string,
    imageId *string,
    keyNames []string,
    hostname *string,
    metadata []vm.Metadata,
    userdata []vm.Userdata,
) *RebuildInstanceRequest {

    return &RebuildInstanceRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:rebuildInstance",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        Password: password,
        ImageId: imageId,
        KeyNames: keyNames,
        Hostname: hostname,
        Metadata: metadata,
        Userdata: userdata,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewRebuildInstanceRequestWithoutParam() *RebuildInstanceRequest {

    return &RebuildInstanceRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:rebuildInstance",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *RebuildInstanceRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: 云主机ID(Required) */
func (r *RebuildInstanceRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param password: 云主机密码，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。(Optional) */
func (r *RebuildInstanceRequest) SetPassword(password string) {
    r.Password = &password
}

/* param imageId: 镜像ID。可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeimages">DescribeImages</a>接口获得指定地域的镜像信息。(Optional) */
func (r *RebuildInstanceRequest) SetImageId(imageId string) {
    r.ImageId = &imageId
}

/* param keyNames: 密钥对名称；当前只支持一个。仅Linux系统支持指定。(Optional) */
func (r *RebuildInstanceRequest) SetKeyNames(keyNames []string) {
    r.KeyNames = keyNames
}

/* param hostname: 云主机hostname，若不指定hostname，则hostname默认使用云主机重置前的hostname
Windows Server系统：长度为2-15个字符，允许大小写字母、数字或连字符（-）。不能以连字符（-）开头或结尾，不能连续使用连字符（-），也不能全部使用数字。不支持点号（.）。
Linux系统：长度为2-64个字符，允许支持多个点号，点之间为一段，每段允许使用大小写字母、数字或连字符（-），但不能连续使用点号（.）或连字符（-），不能以点号（.）或连字符（-）开头或结尾。
(Optional) */
func (r *RebuildInstanceRequest) SetHostname(hostname string) {
    r.Hostname = &hostname
}

/* param metadata: 用户自定义元数据信息，key-value键值对总数量不超过40对，其中有效键值对数量不超过20，无效键值对数量不超过20对。不区分大小写。
若不指定metadata，则metadata默认使用云主机重置前的metadata。
注意：key不要以连字符(-)结尾，否则此key不生效。
(Optional) */
func (r *RebuildInstanceRequest) SetMetadata(metadata []vm.Metadata) {
    r.Metadata = metadata
}

/* param userdata: 元数据信息，目前只支持传入一个key为"launch-script"，表示首次启动脚本。value为base64格式。
若不指定userdata，则userdata默认使用云主机重置前的userdata。
launch-script：linux系统支持bash和python，编码前须分别以 #!/bin/bash 和 #!/usr/bin/env python 作为内容首行;
launch-script：windows系统支持bat和powershell，编码前须分别以 <cmd></cmd> 和 <powershell></powershell> 作为内容首、尾行。
(Optional) */
func (r *RebuildInstanceRequest) SetUserdata(userdata []vm.Userdata) {
    r.Userdata = userdata
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r RebuildInstanceRequest) GetRegionId() string {
    return r.RegionId
}

type RebuildInstanceResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result RebuildInstanceResult `json:"result"`
}

type RebuildInstanceResult struct {
}