// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type UnShareImageRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 镜像ID  */
    ImageId string `json:"imageId"`

    /* 需要取消的帐户  */
    Pins []string `json:"pins"`
}

/*
 * param regionId: 地域ID (Required)
 * param imageId: 镜像ID (Required)
 * param pins: 需要取消的帐户 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewUnShareImageRequest(
    regionId string,
    imageId string,
    pins []string,
) *UnShareImageRequest {

	return &UnShareImageRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/images/{imageId}:unshare",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        ImageId: imageId,
        Pins: pins,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param imageId: 镜像ID (Required)
 * param pins: 需要取消的帐户 (Required)
 */
func NewUnShareImageRequestWithAllParams(
    regionId string,
    imageId string,
    pins []string,
) *UnShareImageRequest {

    return &UnShareImageRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/images/{imageId}:unshare",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        ImageId: imageId,
        Pins: pins,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewUnShareImageRequestWithoutParam() *UnShareImageRequest {

    return &UnShareImageRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/images/{imageId}:unshare",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *UnShareImageRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param imageId: 镜像ID(Required) */
func (r *UnShareImageRequest) SetImageId(imageId string) {
    r.ImageId = imageId
}

/* param pins: 需要取消的帐户(Required) */
func (r *UnShareImageRequest) SetPins(pins []string) {
    r.Pins = pins
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r UnShareImageRequest) GetRegionId() string {
    return r.RegionId
}

type UnShareImageResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result UnShareImageResult `json:"result"`
}

type UnShareImageResult struct {
}