// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package models


type InstanceTemplateSpec struct {

    /* 实例规格，可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeinstancetypes">DescribeInstanceTypes</a>接口获得指定地域或可用区的规格信息。  */
    InstanceType string `json:"instanceType"`

    /* 镜像ID，可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeimages">DescribeImages</a>接口获得指定地域的镜像信息。  */
    ImageId string `json:"imageId"`

    /* 密码，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。 (Optional) */
    Password *string `json:"password"`

    /* 密钥对名称；当前只支持一个 (Optional) */
    KeyNames []string `json:"keyNames"`

    /* 用户自定义元数据信息，key-value 键值对数量不超过20。key、value不区分大小写。
注意：key不要以连字符(-)结尾，否则此key不生效。
 (Optional) */
    Metadata []Metadata `json:"metadata"`

    /* 元数据信息，目前只支持传入一个key为"launch-script"，表示首次启动脚本。value为base64格式。
launch-script：linux系统支持bash和python，编码前须分别以 #!/bin/bash 和 #!/usr/bin/env python 作为内容首行;
launch-script：windows系统支持bat和powershell，编码前须分别以 <cmd></cmd> 和 <powershell></powershell> 作为内容首、尾行。
 (Optional) */
    Userdata []Userdata `json:"userdata"`

    /* 主网卡主IP关联的弹性IP规格 (Optional) */
    ElasticIp *InstanceTemplateElasticIpSpec `json:"elasticIp"`

    /* 主网卡配置信息  */
    PrimaryNetworkInterface *InstanceTemplateNetworkInterfaceAttachmentSpec `json:"primaryNetworkInterface"`

    /* 系统盘配置信息 (Optional) */
    SystemDisk *InstanceTemplateDiskAttachmentSpec `json:"systemDisk"`

    /* 数据盘配置信息 (Optional) */
    DataDisks []InstanceTemplateDiskAttachmentSpec `json:"dataDisks"`

    /* 停机不计费的标志， keepCharging(默认)：关机后继续计费；stopCharging：关机后停止计费。 (Optional) */
    ChargeOnStopped *string `json:"chargeOnStopped"`

    /* 自动镜像策略ID。 (Optional) */
    AutoImagePolicyId *string `json:"autoImagePolicyId"`

    /* 当存在密钥时，是否同时使用密码登录，"yes"为使用，"no"为不使用，""默认为"yes" (Optional) */
    PassWordAuth *string `json:"passWordAuth"`

    /* 继承镜像中的登录验证方式，"yes"为使用，"no"为不使用，""默认为"no" (Optional) */
    ImageInherit *string `json:"imageInherit"`
}
