// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    vpc "github.com/jdcloud-api/jdcloud-sdk-go/services/vpc/models"
)

type AddRouteTableRulesRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* RouteTable ID  */
    RouteTableId string `json:"routeTableId"`

    /* 路由表规则信息  */
    RouteTableRuleSpecs []vpc.AddRouteTableRules `json:"routeTableRuleSpecs"`
}

/*
 * param regionId: Region ID (Required)
 * param routeTableId: RouteTable ID (Required)
 * param routeTableRuleSpecs: 路由表规则信息 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewAddRouteTableRulesRequest(
    regionId string,
    routeTableId string,
    routeTableRuleSpecs []vpc.AddRouteTableRules,
) *AddRouteTableRulesRequest {

	return &AddRouteTableRulesRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/routeTables/{routeTableId}:addRouteTableRules",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        RouteTableId: routeTableId,
        RouteTableRuleSpecs: routeTableRuleSpecs,
	}
}

/*
 * param regionId: Region ID (Required)
 * param routeTableId: RouteTable ID (Required)
 * param routeTableRuleSpecs: 路由表规则信息 (Required)
 */
func NewAddRouteTableRulesRequestWithAllParams(
    regionId string,
    routeTableId string,
    routeTableRuleSpecs []vpc.AddRouteTableRules,
) *AddRouteTableRulesRequest {

    return &AddRouteTableRulesRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/routeTables/{routeTableId}:addRouteTableRules",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        RouteTableId: routeTableId,
        RouteTableRuleSpecs: routeTableRuleSpecs,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewAddRouteTableRulesRequestWithoutParam() *AddRouteTableRulesRequest {

    return &AddRouteTableRulesRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/routeTables/{routeTableId}:addRouteTableRules",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *AddRouteTableRulesRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param routeTableId: RouteTable ID(Required) */
func (r *AddRouteTableRulesRequest) SetRouteTableId(routeTableId string) {
    r.RouteTableId = routeTableId
}

/* param routeTableRuleSpecs: 路由表规则信息(Required) */
func (r *AddRouteTableRulesRequest) SetRouteTableRuleSpecs(routeTableRuleSpecs []vpc.AddRouteTableRules) {
    r.RouteTableRuleSpecs = routeTableRuleSpecs
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r AddRouteTableRulesRequest) GetRegionId() string {
    return r.RegionId
}

type AddRouteTableRulesResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result AddRouteTableRulesResult `json:"result"`
}

type AddRouteTableRulesResult struct {
}