// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package models


type SubnetSpec struct {

    /* 子网所属vpc的Id  */
    VpcId string `json:"vpcId"`

    /* 子网名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符。  */
    SubnetName string `json:"subnetName"`

    /* 子网网段，vpc内子网网段不能重叠，cidr的取值范围：10.0.0.0/8、172.16.0.0/12和192.168.0.0/16及它们包含的子网，且子网掩码长度为16-28之间，如果vpc含有cidr，则必须为vpc所在cidr的子网  */
    AddressPrefix string `json:"addressPrefix"`

    /* 子网关联的路由表Id, 默认为vpc的默认路由表,子网关联路由表需检查路由表中已绑定的子网与本子网类型是否一致（一致标准为：或者都为标准子网，或者都为相同边缘可用区的边缘子网） (Optional) */
    RouteTableId string `json:"routeTableId"`

    /* 子网描述信息,允许输入UTF-8编码下的全部字符，不超过256字符。 (Optional) */
    Description string `json:"description"`

    /* 子网类型，取值：standard(标准子网)，edge(边缘子网) (Optional) */
    SubnetType string `json:"subnetType"`

    /* 子网可用区，边缘子网必须指定可用区 (Optional) */
    Az string `json:"az"`
}
