// This file is auto-generated by jwt/internal/cmd/gentoken/main.go. DO NOT EDIT
package openid

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"sort"
	"strconv"
	"time"

	"github.com/lestrrat-go/iter/mapiter"
	"github.com/lestrrat-go/jwx/internal/iter"
	"github.com/lestrrat-go/jwx/jwt/internal/types"
	"github.com/pkg/errors"
)

const (
	AudienceKey            = "aud"
	ExpirationKey          = "exp"
	IssuedAtKey            = "iat"
	IssuerKey              = "iss"
	JwtIDKey               = "jti"
	NotBeforeKey           = "nbf"
	SubjectKey             = "sub"
	NameKey                = "name"
	GivenNameKey           = "given_name"
	MiddleNameKey          = "middle_name"
	FamilyNameKey          = "family_name"
	NicknameKey            = "nickname"
	PreferredUsernameKey   = "preferred_username"
	ProfileKey             = "profile"
	PictureKey             = "picture"
	WebsiteKey             = "website"
	EmailKey               = "email"
	EmailVerifiedKey       = "email_verified"
	GenderKey              = "gender"
	BirthdateKey           = "birthdate"
	ZoneinfoKey            = "zoneinfo"
	LocaleKey              = "locale"
	PhoneNumberKey         = "phone_number"
	PhoneNumberVerifiedKey = "phone_number_verified"
	AddressKey             = "address"
	UpdatedAtKey           = "updated_at"
)

type Token interface {
	Audience() []string
	Expiration() time.Time
	IssuedAt() time.Time
	Issuer() string
	JwtID() string
	NotBefore() time.Time
	Subject() string
	Name() string
	GivenName() string
	MiddleName() string
	FamilyName() string
	Nickname() string
	PreferredUsername() string
	Profile() string
	Picture() string
	Website() string
	Email() string
	EmailVerified() bool
	Gender() string
	Birthdate() *BirthdateClaim
	Zoneinfo() string
	Locale() string
	PhoneNumber() string
	PhoneNumberVerified() bool
	Address() *AddressClaim
	UpdatedAt() time.Time
	PrivateClaims() map[string]interface{}
	Get(string) (interface{}, bool)
	Set(string, interface{}) error
	Iterate(context.Context) Iterator
	Walk(context.Context, Visitor) error
	AsMap(context.Context) (map[string]interface{}, error)
}
type stdToken struct {
	audience            types.StringList       // https://tools.ietf.org/html/rfc7519#section-4.1.3
	expiration          *types.NumericDate     // https://tools.ietf.org/html/rfc7519#section-4.1.4
	issuedAt            *types.NumericDate     // https://tools.ietf.org/html/rfc7519#section-4.1.6
	issuer              *string                // https://tools.ietf.org/html/rfc7519#section-4.1.1
	jwtID               *string                // https://tools.ietf.org/html/rfc7519#section-4.1.7
	notBefore           *types.NumericDate     // https://tools.ietf.org/html/rfc7519#section-4.1.5
	subject             *string                // https://tools.ietf.org/html/rfc7519#section-4.1.2
	name                *string                //
	givenName           *string                //
	middleName          *string                //
	familyName          *string                //
	nickname            *string                //
	preferredUsername   *string                //
	profile             *string                //
	picture             *string                //
	website             *string                //
	email               *string                //
	emailVerified       *bool                  //
	gender              *string                //
	birthdate           *BirthdateClaim        //
	zoneinfo            *string                //
	locale              *string                //
	phoneNumber         *string                //
	phoneNumberVerified *bool                  //
	address             *AddressClaim          //
	updatedAt           *types.NumericDate     //
	privateClaims       map[string]interface{} `json:"-"`
}

type openidTokenMarshalProxy struct {
	Xaudience            types.StringList   `json:"aud,omitempty"`
	Xexpiration          *types.NumericDate `json:"exp,omitempty"`
	XissuedAt            *types.NumericDate `json:"iat,omitempty"`
	Xissuer              *string            `json:"iss,omitempty"`
	XjwtID               *string            `json:"jti,omitempty"`
	XnotBefore           *types.NumericDate `json:"nbf,omitempty"`
	Xsubject             *string            `json:"sub,omitempty"`
	Xname                *string            `json:"name,omitempty"`
	XgivenName           *string            `json:"given_name,omitempty"`
	XmiddleName          *string            `json:"middle_name,omitempty"`
	XfamilyName          *string            `json:"family_name,omitempty"`
	Xnickname            *string            `json:"nickname,omitempty"`
	XpreferredUsername   *string            `json:"preferred_username,omitempty"`
	Xprofile             *string            `json:"profile,omitempty"`
	Xpicture             *string            `json:"picture,omitempty"`
	Xwebsite             *string            `json:"website,omitempty"`
	Xemail               *string            `json:"email,omitempty"`
	XemailVerified       *bool              `json:"email_verified,omitempty"`
	Xgender              *string            `json:"gender,omitempty"`
	Xbirthdate           *BirthdateClaim    `json:"birthdate,omitempty"`
	Xzoneinfo            *string            `json:"zoneinfo,omitempty"`
	Xlocale              *string            `json:"locale,omitempty"`
	XphoneNumber         *string            `json:"phone_number,omitempty"`
	XphoneNumberVerified *bool              `json:"phone_number_verified,omitempty"`
	Xaddress             *AddressClaim      `json:"address,omitempty"`
	XupdatedAt           *types.NumericDate `json:"updated_at,omitempty"`
}

// New creates a standard token, with minimal knowledge of
// possible claims. Standard claims include"aud", "exp", "iat", "iss", "jti", "nbf", "sub", "name", "given_name", "middle_name", "family_name", "nickname", "preferred_username", "profile", "picture", "website", "email", "email_verified", "gender", "birthdate", "zoneinfo", "locale", "phone_number", "phone_number_verified", "address" and "updated_at".
// Convenience accessors are provided for these standard claims
func New() Token {
	return &stdToken{
		privateClaims: make(map[string]interface{}),
	}
}

// Size returns the number of valid claims stored in this token
func (t *stdToken) Size() int {
	var count int
	if len(t.audience) > 0 {
		count++
	}
	if t.birthdate != nil {
		count++
	}
	if t.address != nil {
		count++
	}
	count += len(t.privateClaims)
	return count
}

func (t *stdToken) Get(name string) (interface{}, bool) {
	switch name {
	case AudienceKey:
		if t.audience == nil {
			return nil, false
		}
		v := t.audience.Get()
		return v, true
	case ExpirationKey:
		if t.expiration == nil {
			return nil, false
		}
		v := t.expiration.Get()
		return v, true
	case IssuedAtKey:
		if t.issuedAt == nil {
			return nil, false
		}
		v := t.issuedAt.Get()
		return v, true
	case IssuerKey:
		if t.issuer == nil {
			return nil, false
		}
		v := *(t.issuer)
		return v, true
	case JwtIDKey:
		if t.jwtID == nil {
			return nil, false
		}
		v := *(t.jwtID)
		return v, true
	case NotBeforeKey:
		if t.notBefore == nil {
			return nil, false
		}
		v := t.notBefore.Get()
		return v, true
	case SubjectKey:
		if t.subject == nil {
			return nil, false
		}
		v := *(t.subject)
		return v, true
	case NameKey:
		if t.name == nil {
			return nil, false
		}
		v := *(t.name)
		return v, true
	case GivenNameKey:
		if t.givenName == nil {
			return nil, false
		}
		v := *(t.givenName)
		return v, true
	case MiddleNameKey:
		if t.middleName == nil {
			return nil, false
		}
		v := *(t.middleName)
		return v, true
	case FamilyNameKey:
		if t.familyName == nil {
			return nil, false
		}
		v := *(t.familyName)
		return v, true
	case NicknameKey:
		if t.nickname == nil {
			return nil, false
		}
		v := *(t.nickname)
		return v, true
	case PreferredUsernameKey:
		if t.preferredUsername == nil {
			return nil, false
		}
		v := *(t.preferredUsername)
		return v, true
	case ProfileKey:
		if t.profile == nil {
			return nil, false
		}
		v := *(t.profile)
		return v, true
	case PictureKey:
		if t.picture == nil {
			return nil, false
		}
		v := *(t.picture)
		return v, true
	case WebsiteKey:
		if t.website == nil {
			return nil, false
		}
		v := *(t.website)
		return v, true
	case EmailKey:
		if t.email == nil {
			return nil, false
		}
		v := *(t.email)
		return v, true
	case EmailVerifiedKey:
		if t.emailVerified == nil {
			return nil, false
		}
		v := *(t.emailVerified)
		return v, true
	case GenderKey:
		if t.gender == nil {
			return nil, false
		}
		v := *(t.gender)
		return v, true
	case BirthdateKey:
		if t.birthdate == nil {
			return nil, false
		}
		v := t.birthdate
		return v, true
	case ZoneinfoKey:
		if t.zoneinfo == nil {
			return nil, false
		}
		v := *(t.zoneinfo)
		return v, true
	case LocaleKey:
		if t.locale == nil {
			return nil, false
		}
		v := *(t.locale)
		return v, true
	case PhoneNumberKey:
		if t.phoneNumber == nil {
			return nil, false
		}
		v := *(t.phoneNumber)
		return v, true
	case PhoneNumberVerifiedKey:
		if t.phoneNumberVerified == nil {
			return nil, false
		}
		v := *(t.phoneNumberVerified)
		return v, true
	case AddressKey:
		if t.address == nil {
			return nil, false
		}
		v := t.address
		return v, true
	case UpdatedAtKey:
		if t.updatedAt == nil {
			return nil, false
		}
		v := t.updatedAt.Get()
		return v, true
	default:
		v, ok := t.privateClaims[name]
		return v, ok
	}
}

func (h *stdToken) Set(name string, value interface{}) error {
	switch name {
	case AudienceKey:
		var acceptor types.StringList
		if err := acceptor.Accept(value); err != nil {
			return errors.Wrapf(err, `invalid value for %s key`, AudienceKey)
		}
		h.audience = acceptor
		return nil
	case ExpirationKey:
		var acceptor types.NumericDate
		if err := acceptor.Accept(value); err != nil {
			return errors.Wrapf(err, `invalid value for %s key`, ExpirationKey)
		}
		h.expiration = &acceptor
		return nil
	case IssuedAtKey:
		var acceptor types.NumericDate
		if err := acceptor.Accept(value); err != nil {
			return errors.Wrapf(err, `invalid value for %s key`, IssuedAtKey)
		}
		h.issuedAt = &acceptor
		return nil
	case IssuerKey:
		if v, ok := value.(string); ok {
			h.issuer = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, IssuerKey, value)
	case JwtIDKey:
		if v, ok := value.(string); ok {
			h.jwtID = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, JwtIDKey, value)
	case NotBeforeKey:
		var acceptor types.NumericDate
		if err := acceptor.Accept(value); err != nil {
			return errors.Wrapf(err, `invalid value for %s key`, NotBeforeKey)
		}
		h.notBefore = &acceptor
		return nil
	case SubjectKey:
		if v, ok := value.(string); ok {
			h.subject = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, SubjectKey, value)
	case NameKey:
		if v, ok := value.(string); ok {
			h.name = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, NameKey, value)
	case GivenNameKey:
		if v, ok := value.(string); ok {
			h.givenName = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, GivenNameKey, value)
	case MiddleNameKey:
		if v, ok := value.(string); ok {
			h.middleName = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, MiddleNameKey, value)
	case FamilyNameKey:
		if v, ok := value.(string); ok {
			h.familyName = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, FamilyNameKey, value)
	case NicknameKey:
		if v, ok := value.(string); ok {
			h.nickname = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, NicknameKey, value)
	case PreferredUsernameKey:
		if v, ok := value.(string); ok {
			h.preferredUsername = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, PreferredUsernameKey, value)
	case ProfileKey:
		if v, ok := value.(string); ok {
			h.profile = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, ProfileKey, value)
	case PictureKey:
		if v, ok := value.(string); ok {
			h.picture = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, PictureKey, value)
	case WebsiteKey:
		if v, ok := value.(string); ok {
			h.website = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, WebsiteKey, value)
	case EmailKey:
		if v, ok := value.(string); ok {
			h.email = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, EmailKey, value)
	case EmailVerifiedKey:
		if v, ok := value.(bool); ok {
			h.emailVerified = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, EmailVerifiedKey, value)
	case GenderKey:
		if v, ok := value.(string); ok {
			h.gender = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, GenderKey, value)
	case BirthdateKey:
		var acceptor BirthdateClaim
		if err := acceptor.Accept(value); err != nil {
			return errors.Wrapf(err, `invalid value for %s key`, BirthdateKey)
		}
		h.birthdate = &acceptor
		return nil
	case ZoneinfoKey:
		if v, ok := value.(string); ok {
			h.zoneinfo = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, ZoneinfoKey, value)
	case LocaleKey:
		if v, ok := value.(string); ok {
			h.locale = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, LocaleKey, value)
	case PhoneNumberKey:
		if v, ok := value.(string); ok {
			h.phoneNumber = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, PhoneNumberKey, value)
	case PhoneNumberVerifiedKey:
		if v, ok := value.(bool); ok {
			h.phoneNumberVerified = &v
			return nil
		}
		return errors.Errorf(`invalid value for %s key: %T`, PhoneNumberVerifiedKey, value)
	case AddressKey:
		var acceptor AddressClaim
		if err := acceptor.Accept(value); err != nil {
			return errors.Wrapf(err, `invalid value for %s key`, AddressKey)
		}
		h.address = &acceptor
		return nil
	case UpdatedAtKey:
		var acceptor types.NumericDate
		if err := acceptor.Accept(value); err != nil {
			return errors.Wrapf(err, `invalid value for %s key`, UpdatedAtKey)
		}
		h.updatedAt = &acceptor
		return nil
	default:
		if h.privateClaims == nil {
			h.privateClaims = map[string]interface{}{}
		}
		h.privateClaims[name] = value
	}
	return nil
}

func (h *stdToken) Audience() []string {
	if h.audience != nil {
		return h.audience.Get()
	}
	return nil
}

func (h *stdToken) Expiration() time.Time {
	if h.expiration != nil {
		return h.expiration.Get()
	}
	return time.Time{}
}

func (h *stdToken) IssuedAt() time.Time {
	if h.issuedAt != nil {
		return h.issuedAt.Get()
	}
	return time.Time{}
}

func (h *stdToken) Issuer() string {
	if h.issuer != nil {
		return *(h.issuer)
	}
	return ""
}

func (h *stdToken) JwtID() string {
	if h.jwtID != nil {
		return *(h.jwtID)
	}
	return ""
}

func (h *stdToken) NotBefore() time.Time {
	if h.notBefore != nil {
		return h.notBefore.Get()
	}
	return time.Time{}
}

func (h *stdToken) Subject() string {
	if h.subject != nil {
		return *(h.subject)
	}
	return ""
}

func (h *stdToken) Name() string {
	if h.name != nil {
		return *(h.name)
	}
	return ""
}

func (h *stdToken) GivenName() string {
	if h.givenName != nil {
		return *(h.givenName)
	}
	return ""
}

func (h *stdToken) MiddleName() string {
	if h.middleName != nil {
		return *(h.middleName)
	}
	return ""
}

func (h *stdToken) FamilyName() string {
	if h.familyName != nil {
		return *(h.familyName)
	}
	return ""
}

func (h *stdToken) Nickname() string {
	if h.nickname != nil {
		return *(h.nickname)
	}
	return ""
}

func (h *stdToken) PreferredUsername() string {
	if h.preferredUsername != nil {
		return *(h.preferredUsername)
	}
	return ""
}

func (h *stdToken) Profile() string {
	if h.profile != nil {
		return *(h.profile)
	}
	return ""
}

func (h *stdToken) Picture() string {
	if h.picture != nil {
		return *(h.picture)
	}
	return ""
}

func (h *stdToken) Website() string {
	if h.website != nil {
		return *(h.website)
	}
	return ""
}

func (h *stdToken) Email() string {
	if h.email != nil {
		return *(h.email)
	}
	return ""
}

func (h *stdToken) EmailVerified() bool {
	if h.emailVerified != nil {
		return *(h.emailVerified)
	}
	return false
}

func (h *stdToken) Gender() string {
	if h.gender != nil {
		return *(h.gender)
	}
	return ""
}

func (h *stdToken) Birthdate() *BirthdateClaim {
	return h.birthdate
}

func (h *stdToken) Zoneinfo() string {
	if h.zoneinfo != nil {
		return *(h.zoneinfo)
	}
	return ""
}

func (h *stdToken) Locale() string {
	if h.locale != nil {
		return *(h.locale)
	}
	return ""
}

func (h *stdToken) PhoneNumber() string {
	if h.phoneNumber != nil {
		return *(h.phoneNumber)
	}
	return ""
}

func (h *stdToken) PhoneNumberVerified() bool {
	if h.phoneNumberVerified != nil {
		return *(h.phoneNumberVerified)
	}
	return false
}

func (h *stdToken) Address() *AddressClaim {
	return h.address
}

func (h *stdToken) UpdatedAt() time.Time {
	if h.updatedAt != nil {
		return h.updatedAt.Get()
	}
	return time.Time{}
}

func (t *stdToken) PrivateClaims() map[string]interface{} {
	return t.privateClaims
}

func (h *stdToken) iterate(ctx context.Context, ch chan *ClaimPair) {
	defer close(ch)

	var pairs []*ClaimPair
	if h.audience != nil {
		v := h.audience.Get()
		pairs = append(pairs, &ClaimPair{Key: AudienceKey, Value: v})
	}
	if h.expiration != nil {
		v := h.expiration.Get()
		pairs = append(pairs, &ClaimPair{Key: ExpirationKey, Value: v})
	}
	if h.issuedAt != nil {
		v := h.issuedAt.Get()
		pairs = append(pairs, &ClaimPair{Key: IssuedAtKey, Value: v})
	}
	if h.issuer != nil {
		v := *(h.issuer)
		pairs = append(pairs, &ClaimPair{Key: IssuerKey, Value: v})
	}
	if h.jwtID != nil {
		v := *(h.jwtID)
		pairs = append(pairs, &ClaimPair{Key: JwtIDKey, Value: v})
	}
	if h.notBefore != nil {
		v := h.notBefore.Get()
		pairs = append(pairs, &ClaimPair{Key: NotBeforeKey, Value: v})
	}
	if h.subject != nil {
		v := *(h.subject)
		pairs = append(pairs, &ClaimPair{Key: SubjectKey, Value: v})
	}
	if h.name != nil {
		v := *(h.name)
		pairs = append(pairs, &ClaimPair{Key: NameKey, Value: v})
	}
	if h.givenName != nil {
		v := *(h.givenName)
		pairs = append(pairs, &ClaimPair{Key: GivenNameKey, Value: v})
	}
	if h.middleName != nil {
		v := *(h.middleName)
		pairs = append(pairs, &ClaimPair{Key: MiddleNameKey, Value: v})
	}
	if h.familyName != nil {
		v := *(h.familyName)
		pairs = append(pairs, &ClaimPair{Key: FamilyNameKey, Value: v})
	}
	if h.nickname != nil {
		v := *(h.nickname)
		pairs = append(pairs, &ClaimPair{Key: NicknameKey, Value: v})
	}
	if h.preferredUsername != nil {
		v := *(h.preferredUsername)
		pairs = append(pairs, &ClaimPair{Key: PreferredUsernameKey, Value: v})
	}
	if h.profile != nil {
		v := *(h.profile)
		pairs = append(pairs, &ClaimPair{Key: ProfileKey, Value: v})
	}
	if h.picture != nil {
		v := *(h.picture)
		pairs = append(pairs, &ClaimPair{Key: PictureKey, Value: v})
	}
	if h.website != nil {
		v := *(h.website)
		pairs = append(pairs, &ClaimPair{Key: WebsiteKey, Value: v})
	}
	if h.email != nil {
		v := *(h.email)
		pairs = append(pairs, &ClaimPair{Key: EmailKey, Value: v})
	}
	if h.emailVerified != nil {
		v := *(h.emailVerified)
		pairs = append(pairs, &ClaimPair{Key: EmailVerifiedKey, Value: v})
	}
	if h.gender != nil {
		v := *(h.gender)
		pairs = append(pairs, &ClaimPair{Key: GenderKey, Value: v})
	}
	if h.birthdate != nil {
		v := h.birthdate
		pairs = append(pairs, &ClaimPair{Key: BirthdateKey, Value: v})
	}
	if h.zoneinfo != nil {
		v := *(h.zoneinfo)
		pairs = append(pairs, &ClaimPair{Key: ZoneinfoKey, Value: v})
	}
	if h.locale != nil {
		v := *(h.locale)
		pairs = append(pairs, &ClaimPair{Key: LocaleKey, Value: v})
	}
	if h.phoneNumber != nil {
		v := *(h.phoneNumber)
		pairs = append(pairs, &ClaimPair{Key: PhoneNumberKey, Value: v})
	}
	if h.phoneNumberVerified != nil {
		v := *(h.phoneNumberVerified)
		pairs = append(pairs, &ClaimPair{Key: PhoneNumberVerifiedKey, Value: v})
	}
	if h.address != nil {
		v := h.address
		pairs = append(pairs, &ClaimPair{Key: AddressKey, Value: v})
	}
	if h.updatedAt != nil {
		v := h.updatedAt.Get()
		pairs = append(pairs, &ClaimPair{Key: UpdatedAtKey, Value: v})
	}
	for k, v := range h.privateClaims {
		pairs = append(pairs, &ClaimPair{Key: k, Value: v})
	}
	for _, pair := range pairs {
		select {
		case <-ctx.Done():
			return
		case ch <- pair:
		}
	}
}

// this is almost identical to json.Encoder.Encode(), but we use Marshal
// to avoid having to remove the trailing newline for each successive
// call to Encode()
func writeJSON(buf *bytes.Buffer, v interface{}, keyName string) error {
	if enc, err := json.Marshal(v); err != nil {
		return errors.Wrapf(err, `failed to encode '%s'`, keyName)
	} else {
		buf.Write(enc)
	}
	return nil
}

func (h *stdToken) UnmarshalJSON(buf []byte) error {
	var proxy openidTokenMarshalProxy
	if err := json.Unmarshal(buf, &proxy); err != nil {
		return errors.Wrap(err, `failed to unmarshal stdToken`)
	}
	h.audience = proxy.Xaudience
	h.expiration = proxy.Xexpiration
	h.issuedAt = proxy.XissuedAt
	h.issuer = proxy.Xissuer
	h.jwtID = proxy.XjwtID
	h.notBefore = proxy.XnotBefore
	h.subject = proxy.Xsubject
	h.name = proxy.Xname
	h.givenName = proxy.XgivenName
	h.middleName = proxy.XmiddleName
	h.familyName = proxy.XfamilyName
	h.nickname = proxy.Xnickname
	h.preferredUsername = proxy.XpreferredUsername
	h.profile = proxy.Xprofile
	h.picture = proxy.Xpicture
	h.website = proxy.Xwebsite
	h.email = proxy.Xemail
	h.emailVerified = proxy.XemailVerified
	h.gender = proxy.Xgender
	h.birthdate = proxy.Xbirthdate
	h.zoneinfo = proxy.Xzoneinfo
	h.locale = proxy.Xlocale
	h.phoneNumber = proxy.XphoneNumber
	h.phoneNumberVerified = proxy.XphoneNumberVerified
	h.address = proxy.Xaddress
	h.updatedAt = proxy.XupdatedAt
	var m map[string]interface{}
	if err := json.Unmarshal(buf, &m); err != nil {
		return errors.Wrap(err, `failed to parse privsate parameters`)
	}
	delete(m, AudienceKey)
	delete(m, ExpirationKey)
	delete(m, IssuedAtKey)
	delete(m, IssuerKey)
	delete(m, JwtIDKey)
	delete(m, NotBeforeKey)
	delete(m, SubjectKey)
	delete(m, NameKey)
	delete(m, GivenNameKey)
	delete(m, MiddleNameKey)
	delete(m, FamilyNameKey)
	delete(m, NicknameKey)
	delete(m, PreferredUsernameKey)
	delete(m, ProfileKey)
	delete(m, PictureKey)
	delete(m, WebsiteKey)
	delete(m, EmailKey)
	delete(m, EmailVerifiedKey)
	delete(m, GenderKey)
	delete(m, BirthdateKey)
	delete(m, ZoneinfoKey)
	delete(m, LocaleKey)
	delete(m, PhoneNumberKey)
	delete(m, PhoneNumberVerifiedKey)
	delete(m, AddressKey)
	delete(m, UpdatedAtKey)
	h.privateClaims = m
	return nil
}

func (h stdToken) MarshalJSON() ([]byte, error) {
	var proxy openidTokenMarshalProxy
	proxy.Xaudience = h.audience
	proxy.Xexpiration = h.expiration
	proxy.XissuedAt = h.issuedAt
	proxy.Xissuer = h.issuer
	proxy.XjwtID = h.jwtID
	proxy.XnotBefore = h.notBefore
	proxy.Xsubject = h.subject
	proxy.Xname = h.name
	proxy.XgivenName = h.givenName
	proxy.XmiddleName = h.middleName
	proxy.XfamilyName = h.familyName
	proxy.Xnickname = h.nickname
	proxy.XpreferredUsername = h.preferredUsername
	proxy.Xprofile = h.profile
	proxy.Xpicture = h.picture
	proxy.Xwebsite = h.website
	proxy.Xemail = h.email
	proxy.XemailVerified = h.emailVerified
	proxy.Xgender = h.gender
	proxy.Xbirthdate = h.birthdate
	proxy.Xzoneinfo = h.zoneinfo
	proxy.Xlocale = h.locale
	proxy.XphoneNumber = h.phoneNumber
	proxy.XphoneNumberVerified = h.phoneNumberVerified
	proxy.Xaddress = h.address
	proxy.XupdatedAt = h.updatedAt
	var buf bytes.Buffer
	enc := json.NewEncoder(&buf)
	if err := enc.Encode(proxy); err != nil {
		return nil, errors.Wrap(err, `failed to encode proxy to JSON`)
	}
	hasContent := buf.Len() > 3 // encoding/json always adds a newline, so "{}\n" is the empty hash
	if l := len(h.privateClaims); l > 0 {
		buf.Truncate(buf.Len() - 2)
		keys := make([]string, 0, l)
		for k := range h.privateClaims {
			keys = append(keys, k)
		}
		sort.Strings(keys)
		for i, k := range keys {
			if hasContent || i > 0 {
				fmt.Fprintf(&buf, `,`)
			}
			fmt.Fprintf(&buf, `%s:`, strconv.Quote(k))
			if err := enc.Encode(h.privateClaims[k]); err != nil {
				return nil, errors.Wrapf(err, `failed to encode private param %s`, k)
			}
		}
		fmt.Fprintf(&buf, `}`)
	}
	return buf.Bytes(), nil
}

func (h *stdToken) Iterate(ctx context.Context) Iterator {
	ch := make(chan *ClaimPair)
	go h.iterate(ctx, ch)
	return mapiter.New(ch)
}

func (h *stdToken) Walk(ctx context.Context, visitor Visitor) error {
	return iter.WalkMap(ctx, h, visitor)
}

func (h *stdToken) AsMap(ctx context.Context) (map[string]interface{}, error) {
	return iter.AsMap(ctx, h)
}
