# Generated by gendocs.py

import rethinkdb
rethinkdb.ast.RqlQuery.set_intersection.__func__.__doc__ = u"     Intersect two arrays returning values that occur in both of them\nas a set (an array with distinct values).\n\n *Example:* Check which pieces of equipment Iron Man has from a fixed\nlist.\n>>> r.table('marvel').get('IronMan')['equipment'].set_intersection(['newBoots', 'arc_reactor']).run(conn)"
rethinkdb.db_create.__doc__ = u'    Create a database. A RethinkDB database is a collection of tables,\nsimilar to relational databases.  If successful, the operation returns\nan object: `{"created": 1}`. If a database with the same name already\nexists the operation throws `RqlRuntimeError`. Note: that you can only\nuse alphanumeric characters and underscores for the database name.\n\n *Example:* Create a database named \'superheroes\'.\n>>> r.db_create(\'superheroes\').run(conn)'
rethinkdb.ast.Table.get_all.__func__.__doc__ = u'    Get all documents where the given value matches the value of the\nrequested index.\n\n *Example:* Secondary index keys are not guaranteed to be unique so we\ncannot query via "get" when using a secondary index.\n>>> r.table(\'marvel\').get_all(\'man_of_steel\', index=\'code_name\').run(conn)\n\n *Example:* Without an index argument, we default to the primary\nindex. While `get` will either return the document or `null` when no\ndocument with such a primary key value exists, this will return either\na one or zero length stream.\n>>> r.table(\'dc\').get_all(\'superman\').run(conn)\n\n *Example:* You can get multiple documents in a single call to\n`get_all`.\n>>> r.table(\'dc\').get_all(\'superman\', \'ant man\').run(conn)'
rethinkdb.ast.RqlQuery.skip.__func__.__doc__ = u"    Skip a number of elements from the head of the sequence.\n\n *Example:* Here in conjunction with `order_by` we choose to ignore\nthe most successful heroes.\n>>> r.table('marvel').order_by('successMetric').skip(10).run(conn)"
rethinkdb.ast.RqlQuery.delete_at.__func__.__doc__ = u'    Remove an element from an array at a given index. Returns the\nmodified array.\n\n *Example:* Hulk decides to leave the avengers.\n>>> r.expr(["Iron Man", "Hulk", "Spider-Man"]).delete_at(1).run(conn)\n\n *Example:* Hulk and Thor decide to leave the avengers.\n>>> r.expr(["Iron Man", "Hulk", "Thor", "Spider-Man"]).delete_at(1,3).run(conn)'
rethinkdb.ast.RqlQuery.month.__func__.__doc__ = u'    Return the month of a time object as a number between 1 and 12.\nFor your convenience, the terms r.january, r.february etc. are defined\nand map to the appropriate integer.\n\n *Example:* Retrieve all the users who were born in November.\n>>> r.table("users").filter(\n...     r.row["birthdate"].month() == 11\n... )\n\n *Example:* Retrieve all the users who were born in November.\n>>> r.table("users").filter(\n...     r.row["birthdate"].month() == r.november\n... )'
rethinkdb.net.Connection.reconnect.__func__.__doc__ = u'    Close and reopen a connection. Closing a connection waits until\nall outstanding requests have finished.  If `noreply_wait` is set to\n`false`, all outstanding requests are canceled immediately.\n\n *Example:* Cancel outstanding requests/queries that are no longer\nneeded.\n>>> conn.reconnect(noreply_wait=False)'
rethinkdb.ast.Table.index_drop.__func__.__doc__ = u"    Delete a previously created secondary index of this table.\n\n *Example:* Drop a secondary index named 'code_name'.\n>>> r.table('dc').index_drop('code_name').run(conn)"
rethinkdb.row.__doc__ = u"    Returns the currently visited document.\n\n *Example:* Get all users whose age is greater than 5.\n>>> r.table('users').filter(r.row['age'] > 5).run(conn)\n\n *Example:* Accessing the attribute 'child' of an embedded document.\n>>> r.table('users').filter(r.row['embedded_doc']['child'] > 5).run(conn)\n\n *Example:* Add 1 to every element of an array.\n>>> r.expr([1, 2, 3]).map(r.row + 1).run(conn)\n\n *Example:* For nested queries functions should be used instead of\nr.row.\n>>> r.table('users').filter(\n...     lambda doc: doc['name'] == r.table('prizes').get('winner')\n... ).run(conn)"
rethinkdb.now.__doc__ = u'    Return a time object representing the current time in UTC. The\ncommand now() is computed once when the server receives the query, so\nmultiple instances of r.now() will always return the same time inside\na query.\n\n *Example:* Add a new user with the time at which he subscribed.\n>>> r.table("users").insert({\n...     "name": "John",\n...     "subscription_date": r.now()\n... }).run(conn)'
rethinkdb.ast.RqlQuery.day_of_year.__func__.__doc__ = u'    Return the day of the year of a time object as a number between 1\nand 366 (following ISO 8601 standard).\n\n *Example:* Retrieve all the users who were born the first day of a\nyear.\n>>> r.table("users").filter(\n...     r.row["birthdate"].day_of_year() == 1\n... ).run(conn)'
rethinkdb.ast.RqlQuery.group_by.__func__.__doc__ = u"    Groups elements by the values of the given attributes and then\napplies the given reduction. Though similar to `groupedMapReduce`,\n`groupBy` takes a standardized object for specifying the reduction.\nCan be used with a number of predefined common reductions.\n\n *Example:* Using a predefined reduction we can easily find the\naverage strength of members of each weight class.\n>>> r.table('marvel').group_by('weightClass', r.avg('strength')).run(conn)\n\n *Example:* Groupings can also be specified on nested attributes.\n>>> r.table('marvel').group_by({'abilities' : {'primary' : True}}, r.avg('strength')).run(conn)\n\n *Example:* The nested syntax can quickly become verbose so there's a\nshortcut.\n>>> r.table('marvel').group_by({'abilities' : 'primary'}, r.avg('strength')).run(conn)"
rethinkdb.ast.Table.index_status.__func__.__doc__ = u"    Get the status of the specified indexes on this table, or the\nstatus of all indexes on this table if no indexes are specified.\n\n *Example:* Get the status of all the indexes on `test`:\n>>> r.table('test').index_status().run(conn)\n\n *Example:* Get the status of the `timestamp` index:\n>>> r.table('test').index_status('timestamp').run(conn)"
rethinkdb.ast.RqlQuery.__lt__.__func__.__doc__ = u'    Test if the first value is less than other.\n\n *Example:* Is 2 less than 2?\n>>> (r.expr(2) < 2).run(conn)'
rethinkdb.ast.RqlQuery.match.__func__.__doc__ = u'    Match against a regular expression. Returns a match object\ncontaining the matched string, that string\'s start/end position, and\nthe capture groups. Accepts RE2 syntax ([https://code.google.com/p/re2\n/wiki/Syntax](https://code.google.com/p/re2/wiki/Syntax)). You can\nenable case-insensitive matching by prefixing the regular expression\nwith `(?i)`. (See linked RE2 documentation for more flags.)\n\n *Example:* Get all users whose name starts with A.\n>>> r.table(\'users\').filter(lambda row:row[\'name\'].match("^A")).run(conn)\n\n *Example:* Parse out a name (returns "mlucy").\n>>> r.expr(\'id:0,name:mlucy,foo:bar\').match(\'name:(\\w+)\')[\'groups\'][0][\'str\'].run(conn)\n\n *Example:* Fail to parse out a name (returns null).\n>>> r.expr(\'id:0,foo:bar\').match(\'name:(\\w+)\')[\'groups\'][0][\'str\'].run(conn)'
rethinkdb.ast.RqlQuery.do.__func__.__doc__ = u"    Evaluate the expr in the context of one or more value bindings.\nThe type of the result is the type of the value returned from expr.\n\n *Example:* The object(s) passed to do() can be bound to name(s). The\nlast argument is the expression to evaluate in the context of the\nbindings.\n>>> r.do(r.table('marvel').get('IronMan'),\n...     lambda ironman: ironman['name']).run(conn)"
rethinkdb.ast.Table.get.__func__.__doc__ = u"    Get a document by primary key.\n\n *Example:* Find a document with the primary key 'superman'.\n>>> r.table('marvel').get('superman').run(conn)"
rethinkdb.ast.RqlQuery.__eq__.__func__.__doc__ = u'    Compute the logical and of two values.\n\n *Example:* True and false anded is false?\n>>> (r.expr(True) & False).run(conn)'
rethinkdb.db.__doc__ = u"    Reference a database.\n\n *Example:* Before we can query a table we have to select the correct\ndatabase.\n>>> r.db('heroes').table('marvel').run(conn)"
rethinkdb.ast.Table.index_list.__func__.__doc__ = u"    List all the secondary indexes of this table.\n\n *Example:* List the available secondary indexes for this table.\n>>> r.table('marvel').index_list().run(conn)"
rethinkdb.net.Connection.repl.__func__.__doc__ = u" Set the default connection to make REPL use easier. Allows calling\n`.run()` on queries without specifying a connection.   Connection\nobjects are not thread-safe and REPL connections should not be used in\nmulti-threaded environments.\n\n *Example:* Set the default connection for the REPL, then call `run()`\nwithout specifying the connection.\n>>> r.connect(db='marvel').repl()\n... r.table('heroes').run()"
rethinkdb.ast.Table.insert.__func__.__doc__ = u"     Insert JSON documents into a table. Accepts a single JSON\ndocument or an array of documents.  Insert returns an object that\ncontains the following attributes:  - `inserted`: the number of\ndocuments that were succesfully inserted - `replaced`: the number of\ndocuments that were updated when upsert is used - `unchanged`: the\nnumber of documents that would have been modified, except that the new\nvalue was the same as the old value when doing an upsert - `errors`:\nthe number of errors encountered while inserting; if errors where\nencountered while inserting, `first_error` contains the text of the\nfirst error - `generated_keys`: a list of generated primary key values\n- `deleted` and `skipped`: 0 for an insert operation.\n\n *Example:* Insert a row into a table named 'marvel'.\n>>> r.table('marvel').insert(\n...     { 'superhero': 'Iron Man', 'superpower':'Arc Reactor' }).run(conn)\n\n *Example:* Insert multiple rows into a table named 'marvel'. Also,\nspecify that only soft durability is required.\n>>> r.table('marvel').insert([\n...     { 'superhero': 'Wolverine', 'superpower': 'Adamantium' },\n...     { 'superhero': 'Spiderman', 'superpower': 'spidy sense' }\n...     ], durability='soft'\n... ).run(conn)\n\n *Example:* Insert a row into a table named 'marvel', overwriting if\nthe document already exists.\n>>> r.table('marvel').insert(\n...     { 'superhero': 'Iron Man', 'superpower': 'Arc Reactor' },\n...     upsert=True\n... ).run(conn)\n\n *Example:* Get back a copy of the new row, this is useful if you've\ndone an upsert or generated an ID.\n>>> r.table('marvel').insert(\n...     { 'superhero': 'Iron Man', 'superpower': 'Arc Reactor' },\n...     upsert=True, return_vals=True\n... ).run(conn)"
rethinkdb.ast.RqlQuery.during.__func__.__doc__ = u'    Return if a time is between two other times (by default, inclusive\nfor the start, exclusive for the end).\n\n *Example:* Retrieve all the posts that were posted between December\n1st, 2013 (inclusive) and December 10th, 2013 (exclusive).\n>>> r.table("posts").filter(\n...     r.row[\'date\'].during(r.time(2013, 12, 1, "Z"), r.time(2013, 12, 10, "Z"))\n... ).run(conn)\n\n *Example:* Retrieve all the posts that were posted between December\n1st, 2013 (exclusive) and December 10th, 2013 (inclusive).\n>>> r.table("posts").filter(\n...     r.row[\'date\'].during(r.time(2013, 12, 1, "Z"), r.time(2013, 12, 10, "Z"), left_bound="open", right_bound="closed")\n... ).run(conn)'
rethinkdb.ast.RqlQuery.difference.__func__.__doc__ = u"    Remove the elements of one array from another array.\n\n *Example:* Retrieve Iron Man's equipment list without boots.\n>>> r.table('marvel').get('IronMan')['equipment'].difference(['Boots']).run(conn)"
rethinkdb.ast.RqlQuery.day.__func__.__doc__ = u'    Return the day of a time object as a number between 1 and 31.\n\n *Example:* Return the users born on the 24th of any month.\n>>> r.table("users").filter(\n...     r.row["birthdate"].day() == 24\n... )'
rethinkdb.ast.RqlQuery.insert_at.__func__.__doc__ = u'    Insert a value in to an array at a given index. Returns the\nmodified array.\n\n *Example:* Hulk decides to join the avengers.\n>>> r.expr(["Iron Man", "Spider-Man"]).insert_at(1, "Hulk").run(conn)'
rethinkdb.net.Connection.noreply_wait.__func__.__doc__ = u'    `noreply_wait` ensures that previous queries with the `noreply`\nflag have been processed by the server. Note that this guarantee only\napplies to queries run on the given connection.\n\n *Example:* We have previously run queries with the `noreply` argument\nset to `True`. Now wait until the server has processed them.\n>>> conn.noreply_wait()'
rethinkdb.ast.RqlQuery.indexes_of.__func__.__doc__ = u"     Get the indexes of an element in a sequence. If the argument is a\npredicate, get the indexes of all elements matching it.\n\n *Example:* Find the position of the letter 'c'.\n>>> r.expr(['a','b','c']).indexes_of('c').run(conn)\n\n *Example:* Find the popularity ranking of invisible heroes.\n>>> r.table('marvel').union(r.table('dc')).order_by('popularity').indexes_of(\n...     r.row['superpowers'].contains('invisibility')\n... ).run(conn)"
rethinkdb.ast.RqlQuery.merge.__func__.__doc__ = u"    Merge two objects together to construct a new object with\nproperties from both. Gives preference to attributes from other when\nthere is a conflict.\n\n *Example:* Equip IronMan for battle.\n>>> r.table('marvel').get('IronMan').merge(\n...     r.table('loadouts').get('alienInvasionKit')\n... ).run(conn)\n\n *Example:* Merge can be used recursively to modify object within\nobjects.\n>>> r.expr({'weapons' : {'spectacular graviton beam' : {'dmg' : 10, 'cooldown' : 20}}}).merge(\n...     {'weapons' : {'spectacular graviton beam' : {'dmg' : 10}}}\n... ).run(conn)\n\n *Example:* To replace a nested object with another object you can use\nthe literal keyword.\n>>> r.expr({'weapons' : {'spectacular graviton beam' : {'dmg' : 10, 'cooldown' : 20}}}).merge(\n...     {'weapons' : r.literal({'repulsor rays' : {'dmg' : 3, 'cooldown' : 0}})}\n... ).run(conn)\n\n *Example:* Literal can be used to remove keys from an object as well.\n>>> r.expr({'weapons' : {'spectacular graviton beam' : {'dmg' : 10, 'cooldown' : 20}}}).merge(\n...     {'weapons' : {'spectacular graviton beam' : r.literal()}}\n... ).run(conn)"
rethinkdb.ast.RqlQuery.__or__.__func__.__doc__ = u'    Compute the logical and of two values.\n\n *Example:* True and false anded is false?\n>>> (r.expr(True) & False).run(conn)'
rethinkdb.any.__doc__ = u'    Compute the logical and of two values.\n\n *Example:* True and false anded is false?\n>>> (r.expr(True) & False).run(conn)'
rethinkdb.db_drop.__doc__ = u'    Drop a database. The database, all its tables, and corresponding\ndata will be deleted.  If successful, the operation returns the object\n`{"dropped": 1}`. If the specified database doesn\'t exist a\n`RqlRuntimeError` is thrown.\n\n *Example:* Drop a database named \'superheroes\'.\n>>> r.db_drop(\'superheroes\').run(conn)'
rethinkdb.ast.RqlQuery.coerce_to.__func__.__doc__ = u"    Converts a value of one type into another.  You can convert: a\nselection, sequence, or object into an ARRAY, an array of pairs into\nan OBJECT, and any DATUM into a STRING.\n\n *Example:* Convert a table to an array.\n>>> r.table('marvel').coerce_to('array').run(conn)\n\n *Example:* Convert an array of pairs into an object.\n>>> r.expr([['name', 'Ironman'], ['victories', 2000]]).coerce_to('object').run(conn)\n\n *Example:* Convert a number to a string.\n>>> r.expr(1).coerce_to('string').run(conn)"
rethinkdb.ast.RqlQuery.reduce.__func__.__doc__ = u"    Produce a single value from a sequence through repeated\napplication of a reduction function.  The reduce function gets invoked\nrepeatedly not only for the input values but also for results of\nprevious reduce invocations. The type and format of the object that is\npassed in to reduce must be the same with the one returned from\nreduce.\n\n *Example:* How many enemies have our heroes defeated?\n>>> r.table('marvel').map(r.row['monstersKilled']).reduce(\n...     lambda acc, val: acc + val, 0).run(conn)"
rethinkdb.ast.Table.sync.__func__.__doc__ = u'    `sync` ensures that writes on a given table are written to\npermanent storage. Queries that specify soft durability\n(`durability=\'soft\'`) do not give such guarantees, so `sync` can be\nused to ensure the state of these queries. A call to `sync` does not\nreturn until all previous writes to the table are persisted.  If\nsuccessful, the operation returns an object: `{"synced": 1}`.\n\n *Example:* After having updated multiple heroes with soft durability,\nwe now want to wait until these changes are persisted.\n>>> r.table(\'marvel\').sync().run(conn)'
rethinkdb.connect.__doc__ = u"    Create a new connection to the database server. The keyword\narguments are:  - `host`: host of the RethinkDB instance. The default\nvalue is `localhost`. - `port`: the driver port, by default `28015`. -\n`db`: the database used if not explicitly specified in a query, by\ndefault `test`. - `auth_key`: the authentification key, by default the\nempty string. - `timeout`: timeout period for the connection to be\nopened, by default `20` (seconds).   Create a new connection to the\ndatabase server.  If the connection cannot be established, a\n`RqlDriverError` exception will be thrown.\n\n *Example:* Opens a connection using the default host and port but\nspecifying the default database.\n>>> conn = r.connect(db='marvel')"
rethinkdb.ast.RqlQuery.year.__func__.__doc__ = u'    Return the year of a time object.\n\n *Example:* Retrieve all the users born in 1986.\n>>> r.table("users").filter(lambda user:\n...     user["birthdate"].year() == 1986\n... ).run(conn)'
rethinkdb.net.Connection.close.__func__.__doc__ = u'     Close an open connection. Closing a connection waits until all\noutstanding requests have finished and then frees any open resources\nassociated with the connection.  If `noreply_wait` is set to `false`,\nall outstanding requests are canceled immediately.  Closing a\nconnection cancels all outstanding requests and frees the memory\nassociated with any open cursors.\n\n *Example:* Close an open connection, waiting for noreply writes to\nfinish.\n>>> conn.close()\n\n *Example:* Close an open connection immediately.\n>>> conn.close(noreply_wait=False)'
rethinkdb.db_list.__doc__ = u'    List all database names in the system. The result is a list of\nstrings.\n\n *Example:* List all databases.\n>>> r.db_list().run(conn)'
rethinkdb.ast.RqlQuery.append.__func__.__doc__ = u"    Append a value to an array.\n\n *Example:* Retrieve Iron Man's equipment list with the addition of\nsome new boots.\n>>> r.table('marvel').get('IronMan')['equipment'].append('newBoots').run(conn)"
rethinkdb.ast.RqlQuery.outer_join.__func__.__doc__ = u"    Computes a left outer join by retaining each row in the left table\neven if no match was found in the right table.\n\n *Example:* Construct a sequence of documents containing all cross-\nuniverse matchups where a marvel hero would lose, but keep marvel\nheroes who would never lose a matchup in the sequence.\n>>> r.table('marvel').outer_join(r.table('dc'),\n...   lambda marvelRow, dcRow: marvelRow['strength'] < dcRow['strength']).run(conn)"
rethinkdb.epoch_time.__doc__ = u'    Create a time object based on seconds since epoch. The first\nargument is a double and will be rounded to three decimal places\n(millisecond-precision).\n\n *Example:* Update the birthdate of the user "John" to November 3rd,\n1986.\n>>> r.table("user").get("John").update({"birthdate": r.epoch_time(531360000)}).run(conn)'
rethinkdb.ast.RqlQuery.__add__.__func__.__doc__ = u'    Sum two numbers, concatenate two strings, or concatenate 2 arrays.\n\n *Example:* It\'s as easy as 2 + 2 = 4.\n>>> (r.expr(2) + 2).run(conn)\n\n *Example:* Strings can be concatenated too.\n>>> (r.expr("foo") + "bar").run(conn)\n\n *Example:* Arrays can be concatenated too.\n>>> (r.expr(["foo", "bar"]) + ["buzz"]).run(conn)\n\n *Example:* Create a date one year from now.\n>>> r.now() + 365*24*60*60'
rethinkdb.add.__doc__ = u'    Sum two numbers, concatenate two strings, or concatenate 2 arrays.\n\n *Example:* It\'s as easy as 2 + 2 = 4.\n>>> (r.expr(2) + 2).run(conn)\n\n *Example:* Strings can be concatenated too.\n>>> (r.expr("foo") + "bar").run(conn)\n\n *Example:* Arrays can be concatenated too.\n>>> (r.expr(["foo", "bar"]) + ["buzz"]).run(conn)\n\n *Example:* Create a date one year from now.\n>>> r.now() + 365*24*60*60'
rethinkdb.ast.RqlQuery.for_each.__func__.__doc__ = u"    Loop over a sequence, evaluating the given write query for each\nelement.\n\n *Example:* Now that our heroes have defeated their villains, we can\nsafely remove them from the villain table.\n>>> r.table('marvel').for_each(\n...     lambda hero: r.table('villains').get(hero['villainDefeated']).delete()\n... ).run(conn)"
rethinkdb.ast.RqlQuery.__div__.__func__.__doc__ = u"    Divide two numbers.\n\n *Example:* It's as easy as 2 / 2 = 1.\n>>> (r.expr(2) / 2).run(conn)"
rethinkdb.div.__doc__ = u"    Divide two numbers.\n\n *Example:* It's as easy as 2 / 2 = 1.\n>>> (r.expr(2) / 2).run(conn)"
rethinkdb.ast.Table.between.__func__.__doc__ = u'    Get all documents between two keys. Accepts three optional\narguments: `index`, `left_bound`, and `right_bound`. If `index` is set\nto the name of a secondary index, `between` will return all documents\nwhere that index\'s value is in the specified range (it uses the\nprimary key by default). `left_bound` or `right_bound` may be set to\n`open` or `closed` to indicate whether or not to include that endpoint\nof the range (by default, `left_bound` is closed and `right_bound` is\nopen).\n\n *Example:* Find all users with primary key = 10 and  20 (a normal\nhalf-open interval).\n>>> r.table(\'marvel\').between(10, 20).run(conn)\n\n *Example:* Find all users with primary key = 10 and = 20 (an interval\nclosed on both sides).\n>>> r.table(\'marvel\').between(10, 20, right_bound=\'closed\').run(conn)\n\n *Example:* Find all users with primary key  20. (You can use `NULL`\nto mean "unbounded" for either endpoint.)\n>>> r.table(\'marvel\').between(None, 20, right_bound=\'closed\').run(conn)\n\n *Example:* Between can be used on secondary indexes too. Just pass an\noptional index argument giving the secondary index to query.\n>>> r.table(\'dc\').between(\'dark_knight\', \'man_of_steel\', index=\'code_name\').run(conn)'
rethinkdb.ast.RqlQuery.run.__func__.__doc__ = u'    Run a query on a connection, returning either a single JSON result\nor a cursor, depending on the query.\n\n *Example:* Run a query on the connection `conn` and print out every\nrow in the result.\n>>> for doc in r.table(\'marvel\').run(conn):\n...     print doc\n\n *Example:* If you are OK with potentially out of date data from all\nthe tables involved in this query and want potentially faster reads,\npass a flag allowing out of date data in an options object. Settings\nfor individual tables will supercede this global setting for all\ntables in the query.\n>>> r.table(\'marvel\').run(conn, use_outdated=True)\n\n *Example:* If you just want to send a write and forget about it, you\ncan set `noreply` to true in the options. In this case `run` will\nreturn immediately.\n>>> r.table(\'marvel\').run(conn, noreply=True)\n\n *Example:* If you want to specify whether to wait for a write to be\nwritten to disk (overriding the table\'s default settings), you can set\n`durability` to `\'hard\'` or `\'soft\'` in the options.\n>>> r.table(\'marvel\')\n...     .insert({ \'superhero\': \'Iron Man\', \'superpower\': \'Arc Reactor\' })\n...     .run(conn, noreply=True, durability=\'soft\')\n\n *Example:* If you do not want a time object to be converted to a\nnative date object, you can pass a `time_format` flag to prevent it\n(valid flags are "raw" and "native"). This query returns an object\nwith two fields (`epoch_time` and `$reql_type$`) instead of a native\ndate object.\n>>> r.now().run(conn, time_format="raw")'
rethinkdb.ast.Table.index_wait.__func__.__doc__ = u"    Wait for the specified indexes on this table to be ready, or for\nall indexes on this table to be ready if no indexes are specified.\n\n *Example:* Wait for all indexes on the table `test` to be ready:\n>>> r.table('test').index_wait().run(conn)\n\n *Example:* Wait for the index `timestamp` to be ready:\n>>> r.table('test').index_wait('timestamp').run(conn)"
rethinkdb.ast.RqlQuery.seconds.__func__.__doc__ = u'    Return the seconds in a time object as a number between 0 and\n59.999 (double precision).\n\n *Example:* Return the post submitted during the first 30 seconds of\nevery minute.\n>>> r.table("posts").filter(lambda post:\n...     post["date"].seconds() < 30\n... ).run(conn)'
rethinkdb.ast.RqlQuery.pluck.__func__.__doc__ = u"    Plucks out one or more attributes from either an object or a\nsequence of objects (projection).\n\n *Example:* We just need information about IronMan's reactor and not\nthe rest of the document.\n>>> r.table('marvel').get('IronMan').pluck('reactorState', 'reactorPower').run(conn)\n\n *Example:* For the hero beauty contest we only care about certain\nqualities.\n>>> r.table('marvel').pluck('beauty', 'muscleTone', 'charm').run(conn)\n\n *Example:* Pluck can also be used on nested objects.\n>>> r.table('marvel').pluck({'abilities' : {'damage' : True, 'mana_cost' : True}, 'weapons' : True}).run(conn)\n\n *Example:* The nested syntax can quickly become overly verbose so\nthere's a shorthand for it.\n>>> r.table('marvel').pluck({'abilities' : ['damage', 'mana_cost']}, 'weapons').run(conn)"
rethinkdb.js.__doc__ = u'    Create a javascript expression.\n\n *Example:* Concatenate two strings using Javascript\'\n>>> r.js("\'str1\' + \'str2\'").run(conn)\n\n *Example:* Select all documents where the \'magazines\' field is\ngreater than 5 by running Javascript on the server.\n>>> r.table(\'marvel\').filter(\n...     r.js(\'(function (row) { return row.magazines > 5; })\')\n... ).run(conn)\n\n *Example:* You may also specify a timeout in seconds (defaults to 5).\n>>> r.js(\'while(true) {}\', timeout=1.3).run(conn)'
rethinkdb.ast.RqlQuery.hours.__func__.__doc__ = u'    Return the hour in a time object as a number between 0 and 23.\n\n *Example:* Return all the posts submitted after midnight and before\n4am.\n>>> r.table("posts").filter(lambda post:\n...     post["date"].hours() < 4\n... ).run(conn)'
rethinkdb.ast.RqlQuery.set_insert.__func__.__doc__ = u"    Add a value to an array and return it as a set (an array with\ndistinct values).\n\n *Example:* Retrieve Iron Man's equipment list with the addition of\nsome new boots.\n>>> r.table('marvel').get('IronMan')['equipment'].set_insert('newBoots').run(conn)"
rethinkdb.ast.RqlQuery.eq_join.__func__.__doc__ = u"    An efficient join that looks up elements in the right table by\nprimary key.\n\n *Example:* Let our heroes join forces to battle evil!\n>>> r.table('marvel').eq_join('main_dc_collaborator', r.table('dc')).run(conn)\n\n *Example:* The above query is equivalent to this inner join but runs\nin O(n log(m)) time rather than the O(n * m) time the inner join\ntakes.\n>>> r.table('marvel').inner_join(r.table('dc'),\n... lambda left, right: left['main_dc_collaborator'] == right['hero_name']).run(conn)\n\n *Example:* You can take advantage of a secondary index on the second\ntable by giving an optional index parameter.\n>>> r.table('marvel').eq_join('main_weapon_origin',\n... r.table('mythical_weapons'), index='origin').run(conn)\n\n *Example:* You can pass a function instead of an attribute to join on\nmore complicated expressions. Here we join to the DC universe\ncollaborator with whom the hero has the most appearances.\n>>> r.table('marvel').eq_join(lambda doc:\n...     doc['dc_collaborators'].order_by('appearances')[0]['name'],\n...     r.table('dc')).run(conn)"
rethinkdb.ast.RqlQuery.filter.__func__.__doc__ = u'    Get all the documents for which the given predicate is true.\n`filter` can be called on a sequence, selection, or a field containing\nan array of elements. The return type is the same as the type on which\nthe function was called on.  The body of every filter is wrapped in an\nimplicit `.default(False)`, which means that if a non-existence errors\nis thrown (when you try to access a field that does not exist in a\ndocument), RethinkDB will just ignore the document. The `default`\nvalue can be changed by passing the named argument `default`. Setting\nthis optional argument to `r.error()` will cause any non-existence\nerrors to return a `RqlRuntimeError`.    A more general way to write\nthe previous query is to use `r.row`.  ```py r.table(\'users\').filter(\nr.row["age"] == 30 ).run(conn) ```  Here the predicate is\n`r.row["age"] == 30`.  - `r.row` refers to the current document -\n`r.row["age"]` refers to the field `age` of the current document -\n`r.row["age"] == 30` returns `True` if the field `age` is 30   An even\nmore general way to write the same query is to use a lambda function.\nRead the documentation about [r.row](../row/) to know more about the\ndifferences between `r.row` and lambda functions in ReQL.  ```py\nr.table(\'users\').filter( lambda user:     user["age"] == 30\n).run(conn) ```             Retrieve all the users whose field\n`places_visited` contains `France`.  ```py r.table("users").filter(\nlambda user:     user["places_visited"].contains("France") ).run(conn)\n```   Retrieve all users named "William Adama" (first name "William",\nlast name "Adama"), with any middle name.   ```py\nr.table("users").filter({     "name":{         "first": "William",\n"last": "Adama"     } }).run(conn) ```  If you want an exact match for\na field that is an object, you will have to use `r.literal`.  Retrieve\nall users named "William Adama" (first name "William", last name\n"Adama"), and who do not have a middle name.  ```py\nr.table("users").filter(r.literal({     "name":{         "first":\n"William",         "last": "Adama"     } })).run(conn) ```   The\nequivalent queries with a lambda function.  ```py\nr.table("users").filter( lambda user:     (user["name"]["first"] ==\n"William")         & (user["name"]["last"] == "Adama") ).run(conn) ```\n```py r.table("users").filter( lambda user:     user["name"] == {\n"first": "William",         "last": "Adama"     } ).run(conn) ```\n\n *Example:* Get all the users that are 30 years old.\n>>> r.table(\'users\').filter({"age": 30}).run(conn)\n\n *Example:* Get all the users that are more than 18 years old.\n>>> r.table("users").filter( r.row["age"] > 18 ).run(conn)\n\n *Example:* Get all the users that are less than 18 years old or whose\nage is unknown (field `age` missing).\n>>> r.table("users").filter( r.row["age"] < 18, default=True).run(conn)\n\n *Example:* Get all the users that are more than 18 years old. Throw\nan error if a document is missing the field `age`.\n>>> r.table("users").filter( r.row["age"] > 18, default=r.error()).run(conn)\n\n *Example:* Select all users who have given their phone number (all\nthe documents whose field `phone_number` is defined and not `None`).\n>>> r.table(\'users\').filter( lambda user:\n...     user.has_fields(\'phone_number\')\n... ).run(conn)\n\n *Example:* Retrieve all the users who subscribed between January 1st,\n2012 (included) and January 1st, 2013 (excluded).\n>>> r.table("users").filter( lambda user:\n...     user["subscription_date"].during( r.time(2012, 1, 1, \'Z\'), r.time(2013, 1, 1, \'Z\') )\n... ).run(conn)\n\n *Example:* Retrieve all the users who have a gmail account (whose\nfield `email` ends with `@gmail.com`).\n>>> r.table("users").filter( lambda user:\n...     user["email"].match("@gmail.com$")\n... ).run(conn)\n\n *Example:* Filter based on the presence of a value in an array.\nSuppose the table `users` has the following schema\n>>> {\n...     "name": <type \'str\'>\n...     "places_visited": [<type \'str\'>]\n... }\n\n *Example:* Filter based on nested fields.   Suppose we have a table\n`users` containing documents with the following schema.\n>>> {\n...     "id": <type \'str\'>\n...     "name": {\n...         "first": <type \'str\'>,\n...         "middle": <type \'str\'>,\n...         "last": <type \'str\'>\n...     }\n... }'
rethinkdb.ast.RqlQuery.distinct.__func__.__doc__ = u"    Remove duplicate elements from the sequence.\n\n *Example:* Which unique villains have been vanquished by marvel\nheroes?\n>>> r.table('marvel').concat_map(lambda hero: hero['villainList']).distinct().run(conn)"
rethinkdb.ast.RqlQuery.__invert__.__func__.__doc__ = u'   Compute the logical inverse (not).   Note the parentheses around\nthe query. If you execute  ```py ~r.expr(True).run(conn) ```  You will\nget back `-2` because the query executed is `r.expr(True)` which\nreturns `True`, and because `~True` evaluates to `-2` in Python.\n\n *Example:* Not true is false.\n>>> (~r.expr(True)).run(conn)\n\n *Example:* The previous query can be rewritten with `not_`\n>>> r.expr(True).not_().run(conn)'
rethinkdb.ast.RqlQuery.not_.__func__.__doc__ = u'   Compute the logical inverse (not).   Note the parentheses around\nthe query. If you execute  ```py ~r.expr(True).run(conn) ```  You will\nget back `-2` because the query executed is `r.expr(True)` which\nreturns `True`, and because `~True` evaluates to `-2` in Python.\n\n *Example:* Not true is false.\n>>> (~r.expr(True)).run(conn)\n\n *Example:* The previous query can be rewritten with `not_`\n>>> r.expr(True).not_().run(conn)'
rethinkdb.not_.__doc__ = u'   Compute the logical inverse (not).   Note the parentheses around\nthe query. If you execute  ```py ~r.expr(True).run(conn) ```  You will\nget back `-2` because the query executed is `r.expr(True)` which\nreturns `True`, and because `~True` evaluates to `-2` in Python.\n\n *Example:* Not true is false.\n>>> (~r.expr(True)).run(conn)\n\n *Example:* The previous query can be rewritten with `not_`\n>>> r.expr(True).not_().run(conn)'
rethinkdb.ast.RqlQuery.with_fields.__func__.__doc__ = u"    Takes a sequence of objects and a list of fields. If any objects\nin the sequence don't have all of the specified fields, they're\ndropped from the sequence. The remaining objects have the specified\nfields plucked out. (This is identical to `has_fields` followed by\n`pluck` on a sequence.)\n\n *Example:* Get a list of heroes and their nemeses, excluding any\nheroes that lack one.\n>>> r.table('marvel').with_fields('id', 'nemesis')\n\n *Example:* Get a list of heroes and their nemeses, excluding any\nheroes whose nemesis isn't in an evil organization.\n>>> r.table('marvel').with_fields('id', {'nemesis' : {'evil_organization' : True}})\n\n *Example:* The nested syntax can quickly become overly verbose so\nthere's a shorthand.\n>>> r.table('marvel').with_fields('id', {'nemesis' : 'evil_organization'})"
rethinkdb.ast.RqlQuery.__getitem__.__func__.__doc__ = u"    Get a single field from an object. If called on a sequence, gets\nthat field from every object in the sequence, skipping objects that\nlack it.\n\n *Example:* What was Iron Man's first appearance in a comic?\n>>> r.table('marvel').get('IronMan')['firstAppearance'].run(conn)"
rethinkdb.ast.RqlQuery.info.__func__.__doc__ = u"    Get information about a ReQL value.\n\n *Example:* Get information about a table such as primary key, or\ncache size.\n>>> r.table('marvel').info().run(conn)"
rethinkdb.ast.RqlQuery.contains.__func__.__doc__ = u"    Returns whether or not a sequence contains all the specified\nvalues, or if functions are provided instead, returns whether or not a\nsequence contains values matching all the specified functions.\n\n *Example:* Has Iron Man ever fought Superman?\n>>> r.table('marvel').get('ironman')['opponents'].contains('superman').run(conn)\n\n *Example:* Has Iron Man ever defeated Superman in battle?\n>>> r.table('marvel').get('ironman')['battles'].contains(lambda battle:\n...     (battle['winner'] == 'ironman') & (battle['loser'] == 'superman')\n... ).run(conn)"
rethinkdb.ast.RqlQuery.__ge__.__func__.__doc__ = u'    Test if the first value is greater than or equal to other.\n\n *Example:* Is 2 greater than or equal to 2?\n>>> (r.expr(2) >= 2).run(conn)'
rethinkdb.ast.Table.index_create.__func__.__doc__ = u"    Create a new secondary index on this table.\n\n *Example:* To efficiently query our heros by code name we have to\ncreate a secondary index.\n>>> r.table('dc').index_create('code_name').run(conn)\n\n *Example:* You can also create a secondary index based on an\narbitrary function on the document.\n>>> r.table('dc').index_create('power_rating',\n... lambda hero: hero['combat_power'] + (2 * hero['compassion_power'])\n... ).run(conn)\n\n *Example:* A compound index can be created by returning an array of\nvalues to use as the secondary index key.\n>>> r.table('dc').index_create('parental_planets',\n... lambda hero: [hero['mothers_home_planet'], hero['fathers_home_planet']]\n... ).run(conn)\n\n *Example:* A multi index can be created by passing an optional multi\nargument. Multi indexes functions should return arrays and allow you\nto query based on whether a value is present in the returned array.\nThe example would allow us to get heroes who possess a specific\nability (the field 'abilities' is an array).\n>>> r.table('dc').index_create('abilities', multi=True).run(conn)"
rethinkdb.ast.RqlQuery.change_at.__func__.__doc__ = u'    Change a value in an array at a given index. Returns the modified\narray.\n\n *Example:* Bruce Banner hulks out.\n>>> r.expr(["Iron Man", "Bruce", "Spider-Man"]).change_at(1, "Hulk").run(conn)'
rethinkdb.ast.DB.table.__func__.__doc__ = u"    Select all documents in a table. This command can be chained with\nother commands to do further processing on the data.\n\n *Example:* Return all documents in the table 'marvel' of the default\ndatabase.\n>>> r.table('marvel').run(conn)\n\n *Example:* Return all documents in the table 'marvel' of the database\n'heroes'.\n>>> r.db('heroes').table('marvel').run(conn)\n\n *Example:* If you are OK with potentially out of date data from this\ntable and want potentially faster reads, pass a flag allowing out of\ndate data.\n>>> r.db('heroes').table('marvel', True).run(conn)"
rethinkdb.ast.RqlQuery.nth.__func__.__doc__ = u'    Get the nth element of a sequence.\n\n *Example:* Select the second element in the array.\n>>> r.expr([1,2,3])[1].run(conn)'
rethinkdb.ast.RqlQuery.__ne__.__func__.__doc__ = u'    Test if two values are not equal.\n\n *Example:* Does 2 not equal 2?\n>>> (r.expr(2) != 2).run(conn)'
rethinkdb.net.Connection.use.__func__.__doc__ = u"    Change the default database on this connection.\n\n *Example:* Change the default database so that we don't need to\nspecify the database when referencing a table.\n>>> conn.use('marvel')\n... r.table('heroes').run(conn) # refers to r.db('marvel').table('heroes')"
rethinkdb.ast.RqlQuery.order_by.__func__.__doc__ = u"    Sort the sequence by document values of the given key(s).\n`orderBy` defaults to ascending ordering. To explicitly specify the\nordering, wrap the attribute with either `r.asc` or `r.desc`.\n\n *Example:* Order our heroes by a series of performance metrics.\n>>> r.table('marvel').order_by('enemies_vanquished', 'damsels_saved').run(conn)\n\n *Example:* Indexes can be used to perform more efficient orderings.\nNotice that the index ordering always has highes precedence. Thus the\nfollowing example is equivalent to the one above.\n>>> r.table('marvel').order_by('damsels_saved', index='enemies_vanquished').run(conn)\n\n *Example:* You can also specify a descending order when using an\nindex.\n>>> r.table('marvel').order_by(index=r.desc('enemies_vanquished')).run(conn)\n\n *Example:* Let's lead with our best vanquishers by specify descending\nordering.\n>>> r.table('marvel').order_by(\n...     r.desc('enemies_vanquished'),\n...     r.asc('damsels_saved')\n... ).run(conn)\n\n *Example:* You can use a function for ordering instead of just\nselecting an attribute.\n>>> r.table('marvel').order_by(lambda doc: doc['enemiesVanquished'] + doc['damselsSaved']).run(conn)\n\n *Example:* Functions can also be used descendingly.\n>>> r.table('marvel').order_by(r.desc(lambda doc: doc['enemiesVanquished'] + doc['damselsSaved'])).run(conn)"
rethinkdb.ast.RqlQuery.zip.__func__.__doc__ = u"    Used to 'zip' up the result of a join by merging the 'right'\nfields into 'left' fields of each member of the sequence.\n\n *Example:* 'zips up' the sequence by merging the left and right\nfields produced by a join.\n>>> r.table('marvel').eq_join('main_dc_collaborator', r.table('dc')).zip().run(conn)"
rethinkdb.ast.RqlQuery.__and__.__func__.__doc__ = u'    Compute the logical and of two values.\n\n *Example:* True and false anded is false?\n>>> (r.expr(True) & False).run(conn)'
rethinkdb.all.__doc__ = u'    Compute the logical and of two values.\n\n *Example:* True and false anded is false?\n>>> (r.expr(True) & False).run(conn)'
rethinkdb.ast.RqlQuery.union.__func__.__doc__ = u"    Concatenate two sequences.\n\n *Example:* Construct a stream of all heroes.\n>>> r.table('marvel').union(r.table('dc')).run(conn)"
rethinkdb.ast.RqlQuery.__mul__.__func__.__doc__ = u'    Multiply two numbers, or make a periodic array.\n\n *Example:* It\'s as easy as 2 * 2 = 4.\n>>> (r.expr(2) * 2).run(conn)\n\n *Example:* Arrays can be multiplied by numbers as well.\n>>> (r.expr(["This", "is", "the", "song", "that", "never", "ends."]) * 100).run(conn)'
rethinkdb.mul.__doc__ = u'    Multiply two numbers, or make a periodic array.\n\n *Example:* It\'s as easy as 2 * 2 = 4.\n>>> (r.expr(2) * 2).run(conn)\n\n *Example:* Arrays can be multiplied by numbers as well.\n>>> (r.expr(["This", "is", "the", "song", "that", "never", "ends."]) * 100).run(conn)'
rethinkdb.ast.DB.table_drop.__func__.__doc__ = u'    Drop a table. The table and all its data will be deleted.  If\nsuccesful, the operation returns an object: {"dropped": 1}. If the\nspecified table doesn\'t exist a `RqlRuntimeError` is thrown.\n\n *Example:* Drop a table named \'dc_universe\'.\n>>> r.db(\'test\').table_drop(\'dc_universe\').run(conn)'
rethinkdb.ast.RqlQuery.set_difference.__func__.__doc__ = u"    Remove the elements of one array from another and return them as a\nset (an array with distinct values).\n\n *Example:* Check which pieces of equipment Iron Man has, excluding a\nfixed list.\n>>> r.table('marvel').get('IronMan')['equipment'].set_difference(['newBoots', 'arc_reactor']).run(conn)"
rethinkdb.json.__doc__ = u'    Parse a JSON string on the server.\n\n *Example:* Send an array to the server\'\n>>> r.json("[1,2,3]").run(conn)'
rethinkdb.ast.RqlQuery.in_timezone.__func__.__doc__ = u"    Return a new time object with a different timezone. While the time\nstays the same, the results returned by methods such as hours() will\nchange since they take the timezone into account. The timezone\nargument has to be of the ISO 8601 format.\n\n *Example:* Hour of the day in San Francisco (UTC/GMT -8, without\ndaylight saving time).\n>>> r.now().in_timezone('-08:00').hours().run(conn)"
rethinkdb.ast.DB.table_list.__func__.__doc__ = u"    List all table names in a database. The result is a list of\nstrings.\n\n *Example:* List all tables of the 'test' database.\n>>> r.db('test').table_list().run(conn)"
rethinkdb.ast.RqlQuery.grouped_map_reduce.__func__.__doc__ = u"    Partition the sequence into groups based on the `grouping`\nfunction. The elements of each group are then mapped using the\n`mapping` function and reduced using the `reduction` function.\n`grouped_map_reduce` is a generalized form of group by.\n\n *Example:* It's only fair that heroes be compared against their\nweight class.\n>>> r.table('marvel').grouped_map_reduce(\n...     lambda hero: hero['weightClass'],  # grouping\n...     lambda hero: hero.pluck('name', 'strength'),  # mapping\n...     lambda acc, hero: r.branch(acc['strength'] < hero['strength'], hero, acc),\n...     {'name':'none', 'strength':0}  # base\n... ).run(conn)"
rethinkdb.iso8601.__doc__ = u'    Create a time object based on an iso8601 date-time string (e.g.\n\'2013-01-01T01:01:01+00:00\'). We support all valid ISO 8601 formats\nexcept for week dates. If you pass an ISO 8601 date-time without a\ntime zone, you must specify the time zone with the optarg\n`default_timezone`. Read more about the ISO 8601 format on the\nWikipedia page.\n\n *Example:* Update the time of John\'s birth.\n>>> r.table("user").get("John").update({"birth": r.iso8601(\'1986-11-03T08:30:00-07:00\')}).run(conn)'
rethinkdb.ast.RqlQuery.default.__func__.__doc__ = u'    Handle non-existence errors. Tries to evaluate and return its\nfirst argument. If an error related to the absence of a value is\nthrown in the process, or if its first argument returns `None`,\nreturns its second argument. (Alternatively, the second argument may\nbe a function which will be called with either the text of the non-\nexistence error or `None`.)   __Exmple:__ Suppose we want to retrieve\nthe titles and authors of the table `posts`. In the case where the\nauthor field is missing or `None`, we want to retrieve the string\n`Anonymous`.  ```py r.table("posts").map(lambda post:     {\n"title": post["title"],         "author":\npost["author"].default("Anonymous")     } ).run(conn) ```  We can\nrewrite the previous query with `r.branch` too.  ```py\nr.table("posts").map(lambda post:     r.branch(\npost.has_fields("author"),         {             "title":\npost["title"],             "author": post["author"]         },\n{             "title": post["title"],             "author":\n"Anonymous"          }     ) ).run(conn) ```    One more way to write\nthe previous query is to set the age to be `-1` when the field is\nmissing.  ```py r.table("users").filter(lambda user:\nuser["age"].default(-1) < 18 ).run(conn) ```  One last way to do the\nsame query is to use `has_fields`.  ```py\nr.table("users").filter(lambda user:     user.has_fields("age").not_()\n| (user["age"] < 18) ).run(conn) ```  The body of every `filter` is\nwrapped in an implicit `.default(False)`. You can overwrite the value\n`False` by passing an option in filter, so the previous query can also\nbe written like this.  ```py r.table("users").filter(     lambda user:\n(user["age"] < 18).default(True),     default=True ).run(conn) ```\n\n *Example:* The `default` command can be useful to filter documents\ntoo. Suppose we want to retrieve all our users who are not grown-ups\nor whose age is unknown (i.e the field `age` is missing or equals\n`None`). We can do it with this query:\n>>> r.table("users").filter(lambda user:\n...     (user["age"] < 18).default(True)\n... ).run(conn)'
rethinkdb.expr.__doc__ = u"    Construct a ReQL JSON object from a native object.\n\n *Example:* Objects wrapped with expr can then be manipulated by ReQL\nAPI functions.\n>>> r.expr({'a':'b'}).merge({'b':[1,2,3]}).run(conn)"
rethinkdb.ast.RqlQuery.day_of_week.__func__.__doc__ = u'     Return the day of week of a time object as a number between 1 and\n7 (following ISO 8601 standard). For your convenience, the terms\nr.monday, r.tuesday etc. are defined and map to the appropriate\ninteger.\n\n *Example:* Return today\'s day of week.\n>>> r.now().day_of_week().run(conn)\n\n *Example:* Retrieve all the users who were born on a Tuesday.\n>>> r.table("users").filter{ |user|\n...     user["birthdate"].day_of_week().eq(r.tuesday)\n... }'
rethinkdb.__doc__ = u'    The top-level ReQL namespace.\n\n *Example:* Setup your top-level namespace.\n>>> import rethinkdb as r'
rethinkdb.ast.RqlQuery.limit.__func__.__doc__ = u"     End the sequence after the given number of elements.\n\n *Example:* Only so many can fit in our Pantheon of heroes.\n>>> r.table('marvel').order_by('belovedness').limit(10).run(conn)"
rethinkdb.error.__doc__ = u"    Throw a runtime error. If called with no arguments inside the\nsecond argument to `default`, re-throw the current error.\n\n *Example:* Iron Man can't possibly have lost a battle:\n>>> r.table('marvel').get('IronMan').do(\n...     lambda ironman: r.branch(ironman['victories'] < ironman['battles'],\n...                              r.error('impossible code path'),\n...                              ironman)\n... ).run(conn)"
rethinkdb.ast.RqlQuery.to_epoch_time.__func__.__doc__ = u'    Convert a time object to its epoch time.\n\n *Example:* Return the current time in an ISO8601 format.\n>>> r.now().to_epoch_time()'
rethinkdb.ast.RqlQuery.__gt__.__func__.__doc__ = u'    Test if two values are not equal.\n\n *Example:* Does 2 not equal 2?\n>>> (r.expr(2) != 2).run(conn)'
rethinkdb.ast.RqlQuery.minutes.__func__.__doc__ = u'   Return the minute in a time object as a number between 0 and 59.\n\n *Example:* Return all the posts submitted during the first 10 minutes\nof every hour.\n>>> r.table("posts").filter(lambda post:\n...     post["date"].minutes() < 10\n... ).run(conn)'
rethinkdb.ast.Table.delete.__func__.__doc__ = u"    Delete one or more documents from a table. The optional argument\nreturn_vals will return the old value of the row you're deleting when\nset to true (only valid for single-row deletes). The optional argument\ndurability with value 'hard' or 'soft' will override the table or\nquery's default durability setting.  Delete returns an object that\ncontains the following attributes:  - `deleted`: the number of\ndocuments that were deleted - `skipped`: the number of documents from\nthe selection that were left unmodified because there was nothing to\ndo. For example, if you delete a row that has already been deleted,\nthat row will be skipped - `errors`L the number of errors encountered\nwhile deleting if errors occured, first_error contains the text of the\nfirst error - `inserted`, `replaced`, and `unchanged`: all 0 for a\ndelete operation.\n\n *Example:* Delete superman from the database.\n>>> r.table('marvel').get('superman').delete().run(conn)\n\n *Example:* Delete every document from the table 'marvel'. Also, don't\nwait for the operation to be flushed to disk.\n>>> r.table('marvel').delete(durability='soft').run(conn)\n\n *Example:* You can get back a copy of the row you delete from the\ndatabase as well.\n>>> r.table('marvel').delete(return_vals=True).run(conn)"
rethinkdb.ast.RqlQuery.__le__.__func__.__doc__ = u'    Test if the first value is less than or equal to other.\n\n *Example:* Is 2 less than or equal to 2?\n>>> (r.expr(2) <= 2).run(conn)'
rethinkdb.ast.RqlQuery.sample.__func__.__doc__ = u"    Select a given number of elements from a sequence with uniform\nrandom distribution. Selection is done without replacement.\n\n *Example:* Select 3 random heroes.\n>>> r.table('marvel').sample(3).run(conn)"
rethinkdb.ast.RqlQuery.timezone.__func__.__doc__ = u'    Return the timezone of the time object.\n\n *Example:* Return all the users in the "-07:00" timezone.\n>>> r.table("users").filter(lambda user:\n...     user["subscriptionDate"].timezone() == "-07:00"\n... )'
rethinkdb.avg.__doc__ = u"    Compute the average value of the given attribute for the group.\n\n *Example:* What's the average agility of heroes at each strength\nlevel?\n>>> r.table('marvel').group_by('strength', r.avg('agility')).run(conn)"
rethinkdb.ast.RqlQuery.has_fields.__func__.__doc__ = u'    Test if an object has all of the specified fields. An object has a\nfield if it has the specified key and that key maps to a non-null\nvalue. For instance, the object `{\'a\':1,\'b\':2,\'c\': None}` has the\nfields `a` and `b`.\n\n *Example:* Which heroes are married?\n>>> r.table(\'marvel\').has_fields(\'spouse\').run(conn)\n\n *Example:* Test if a single object has a field.\n>>> r.table(\'marvel\').get("IronMan").has_fields(\'spouse\').run(conn)\n\n *Example:* You can also test if nested fields exist to get only\nspouses with powers of their own.\n>>> r.table(\'marvel\').has_fields({\'spouse\' : {\'powers\' : True}}).run(conn)\n\n *Example:* The nested syntax can quickly get verbose so there\'s a\nshorthand.\n>>> r.table(\'marvel\').has_fields({\'spouse\' : \'powers\'}).run(conn)'
rethinkdb.ast.RqlQuery.__mod__.__func__.__doc__ = u"    Find the remainder when dividing two numbers.   `\n\n *Example:* It's as easy as 2 % 2 = 0.\n>>> (r.expr(2) % 2).run(conn)"
rethinkdb.mod.__doc__ = u"    Find the remainder when dividing two numbers.   `\n\n *Example:* It's as easy as 2 % 2 = 0.\n>>> (r.expr(2) % 2).run(conn)"
rethinkdb.ast.RqlQuery.slice.__func__.__doc__ = u"    Trim the sequence to within the bounds provided.\n\n *Example:* For this fight, we need heroes with a good mix of strength\nand agility.\n>>> r.table('marvel').order_by('strength')[5:10].run(conn)"
rethinkdb.ast.RqlQuery.time_of_day.__func__.__doc__ = u'    Return the number of seconds elapsed since the beginning of the\nday stored in the time object.\n\n *Example:* Retrieve posts that were submitted before noon.\n>>> r.table("posts").filter(\n...     r.row["date"].time_of_day() <= 12*60*60\n... ).run(conn)'
rethinkdb.ast.RqlQuery.__sub__.__func__.__doc__ = u"    Subtract two numbers.\n\n *Example:* It's as easy as 2 - 2 = 0.\n>>> (r.expr(2) - 2).run(conn)\n\n *Example:* Create a date one year ago today.\n>>> r.now() - 365*24*60*60\n\n *Example:* Retrieve how many seconds elapsed between today and date\n>>> r.now() - date"
rethinkdb.sub.__doc__ = u"    Subtract two numbers.\n\n *Example:* It's as easy as 2 - 2 = 0.\n>>> (r.expr(2) - 2).run(conn)\n\n *Example:* Create a date one year ago today.\n>>> r.now() - 365*24*60*60\n\n *Example:* Retrieve how many seconds elapsed between today and date\n>>> r.now() - date"
rethinkdb.ast.RqlQuery.prepend.__func__.__doc__ = u"    Prepend a value to an array.\n\n *Example:* Retrieve Iron Man's equipment list with the addition of\nsome new boots.\n>>> r.table('marvel').get('IronMan')['equipment'].prepend('newBoots').run(conn)"
rethinkdb.ast.RqlQuery.inner_join.__func__.__doc__ = u"    Returns the inner product of two sequences (e.g. a table, a filter\nresult) filtered by the predicate. The query compares each row of the\nleft sequence with each row of the right sequence to find all pairs of\nrows which satisfy the predicate. When the predicate is satisfied,\neach matched pair of rows of both sequences are combined into a result\nrow.\n\n *Example:* Construct a sequence of documents containing all cross-\nuniverse matchups where a marvel hero would lose.\n>>> r.table('marvel').inner_join(r.table('dc'), lambda marvelRow, dcRow:\n...     marvelRow['strength'] < dcRow['strength']).run(conn)"
rethinkdb.branch.__doc__ = u"    Evaluate one of two control paths based on the value of an\nexpression. branch is effectively an if renamed due to language\nconstraints.  The type of the result is determined by the type of the\nbranch that gets executed.\n\n *Example:* Return the manlier of two heroes:\n>>> r.table('marvel').map(r.branch(r.row['victories'] > 100,\n...     r.row['name'] + ' is a superhero',\n...     r.row['name'] + ' is a hero')\n... ).run(conn)"
rethinkdb.ast.RqlQuery.type_of.__func__.__doc__ = u'    Gets the type of a value.\n\n *Example:* Get the type of a string.\n>>> r.expr("foo").type_of().run(conn)'
rethinkdb.ast.RqlQuery.map.__func__.__doc__ = u"    Transform each element of the sequence by applying the given\nmapping function.\n\n *Example:* Construct a sequence of hero power ratings.\n>>> r.table('marvel').map(lambda hero:\n...     hero['combatPower'] + hero['compassionPower'] * 2\n... ).run(conn)"
rethinkdb.ast.RqlQuery.keys.__func__.__doc__ = u"    Return an array containing all of the object's keys.\n\n *Example:* Get all the keys of a row.\n>>> r.table('marvel').get('ironman').keys().run(conn)"
rethinkdb.ast.Table.update.__func__.__doc__ = u"    Update JSON documents in a table. Accepts a JSON document, a ReQL\nexpression, or a combination of the two. You can pass options like\n`returnVals` that will return the old and new values of the row you\nhave modified.  Update returns an object that contains the following\nattributes:  - `replaced`: the number of documents that were updated -\n`unchanged`: the number of documents that would have been modified\nexcept the new value was the same as the old value; - `skipped`: the\nnumber of documents that were left unmodified because there was\nnothing to do: either the row didn't exist or the new value is `None`;\n- `errors`: the number of errors encountered while performing the\nupdate; if errors occured, first_error contains the text of the first\nerror; - `deleted` and `inserted`: 0 for an update operation.\n\n *Example:* Update Superman's age to 30. If attribute 'age' doesn't\nexist, adds it to the document.\n>>> r.table('marvel').get('superman').update({ 'age': 30 }).run(conn)\n\n *Example:* Increment every superhero's age. If age doesn't exist,\nthrows an error. Specify soft durability.\n>>> r.table('marvel').update(lambda x: {'age': x['age'] + 1}, durability='soft').run(conn)\n\n *Example:* Allow the server to run non-atomic operations.\n>>> r.table('marvel').update(\n...     lambda x: {'age': x['age'] + r.js('1')}, non_atomic=True\n... ).run(conn)\n\n *Example:* You can get back a copy of the original row and the update\nrow using the return_vals flag.\n>>> r.table('marvel').get('superman').update({ 'age': 30 }, return_vals=True).run(conn)"
rethinkdb.ast.Table.replace.__func__.__doc__ = u"    Replace documents in a table. Accepts a JSON document or a ReQL\nexpression, and replaces the original document with the new one. The\nnew document must have the same primary key as the original document.\nThe optional argument durability with value 'hard' or 'soft' will\noverride the table or query's default durability setting. The optional\nargument return_vals will return the old and new values of the row\nyou're modifying when set to true (only valid for single-row\nreplacements). The optional argument non_atomic lets you permit non-\natomic updates.  Replace returns an object that contains the following\nattributes:  - `replaced`: the number of documents that were replaced\n- `unchanged`: the number of documents that would have been modified,\nexcept that the new value was the same as the old value - `inserted`:\nthe number of new documents added. You can have new documents inserted\nif you do a point-replace on a key that isn't in the table or you do a\nreplace on a selection and one of the documents you are replacing has\nbeen deleted - `deleted`: the number of deleted documents when doing a\nreplace with `None`  - `errors`: the number of errors encountered\nwhile performing the replace; if errors occurred performing the\nreplace, first_error contains the text of the first error encountered\n- `skipped`: 0 for a replace operation\n\n *Example:* Remove all existing attributes from Superman's document,\nand add an attribute 'age'.\n>>> r.table('marvel').get('superman').replace({ 'id': 'superman', 'age': 30 }).run(conn)\n\n *Example:* Allow the server to run non-atomic operations.\n>>> r.table('marvel').get('superman').replace(\n...     { 'id': 'superman', 'age': 30 }, non_atomic=True\n... ).run(conn)\n\n *Example:* Mark all Marvel heroes as favorites, specifying soft\ndurability.\n>>> r.table('heroes').filter(r.row['universe'] == 'marvel').replace(\n...     lambda hero: hero.merge({'is_fav': True}), durability='soft'\n... ).run(conn)\n\n *Example:* You can get a copy of the previous value and the old value\nback using the return_vals flag.\n>>> r.table('heroes').filter(r.row['universe'] == 'marvel').replace(\n...     lambda hero: hero.merge({'is_fav': True}), return_vals=True\n... ).run(conn)"
rethinkdb.ast.RqlQuery.is_empty.__func__.__doc__ = u"    Test if a sequence is empty.\n\n *Example:* Are there any documents in the marvel table?\n>>> r.table('marvel').is_empty().run(conn)"
rethinkdb.ast.DB.table_create.__func__.__doc__ = u"    Create a table. A RethinkDB table is a collection of JSON\ndocuments.  If successful, the operation returns an object: `{created:\n1}`. If a table with the same name already exists, the operation\nthrows `RqlRuntimeError`. Note: that you can only use alphanumeric\ncharacters and underscores for the table name.  When creating a table\nyou can specify the following options:  - `primary_key`: the name of\nthe primary key. The default primary key is id; - `durability`: if set\nto `soft`, this enables _soft durability_ on this table: writes will\nbe acknowledged by the server immediately and flushed to disk in the\nbackground. Default is `hard` (acknowledgement of writes happens after\ndata has been written to disk); - `cache_size`: set the cache size (in\nbytes) to be used by the table. The default is 1073741824 (1024MB); -\n`datacenter`: the name of the datacenter this table should be assigned\nto.\n\n *Example:* Create a table named 'dc_universe' with the default\nsettings.\n>>> r.db('test').table_create('dc_universe').run(conn)\n\n *Example:* Create a table named 'dc_universe' using the field 'name'\nas primary key.\n>>> r.db('test').table_create('dc_universe', primary_key='name').run(conn)\n\n *Example:* Create a table to log the very fast actions of the heroes.\n>>> r.db('test').table_create('hero_actions', durability='soft').run(conn)"
rethinkdb.ast.RqlQuery.date.__func__.__doc__ = u'    Return a new time object only based on the day, month and year\n(ie. the same day at 00:00).\n\n *Example:* Retrieve all the users whose birthday is today\n>>> r.table("users").filter(lambda user:\n...     user["birthdate"].date() == r.now().date()\n... ).run(conn)'
rethinkdb.ast.RqlQuery.to_iso8601.__func__.__doc__ = u'    Convert a time object to its iso 8601 format.\n\n *Example:* Return the current time in an ISO8601 format.\n>>> r.now().to_iso8601()'
rethinkdb.ast.RqlQuery.set_union.__func__.__doc__ = u"    Add a several values to an array and return it as a set (an array\nwith distinct values).\n\n *Example:* Retrieve Iron Man's equipment list with the addition of\nsome new boots and an arc reactor.\n>>> r.table('marvel').get('IronMan')['equipment'].set_union(['newBoots', 'arc_reactor']).run(conn)"
rethinkdb.ast.RqlQuery.concat_map.__func__.__doc__ = u"    Flattens a sequence of arrays returned by the mappingFunction into\na single sequence.\n\n *Example:* Construct a sequence of all monsters defeated by Marvel\nheroes. Here the field 'defeatedMonsters' is a list that is\nconcatenated to the sequence.\n>>> r.table('marvel').concat_map(lambda hero: hero['defeatedMonsters']).run(conn)"
rethinkdb.ast.RqlQuery.without.__func__.__doc__ = u"    The opposite of pluck; takes an object or a sequence of objects,\nand returns them with the specified paths removed.\n\n *Example:* Since we don't need it for this computation we'll save\nbandwidth and leave out the list of IronMan's romantic conquests.\n>>> r.table('marvel').get('IronMan').without('personalVictoriesList').run(conn)\n\n *Example:* Without their prized weapons, our enemies will quickly be\nvanquished.\n>>> r.table('enemies').without('weapons').run(conn)\n\n *Example:* Nested objects can be used to remove the damage subfield\nfrom the weapons and abilities fields.\n>>> r.table('marvel').without({'weapons' : {'damage' : True}, 'abilities' : {'damage' : True}}).run(conn)\n\n *Example:* The nested syntax can quickly become overly verbose so\nthere's a shorthand for it.\n>>> r.table('marvel').without({'weapons' : 'damage', 'abilities' : 'damage'}).run(conn)"
rethinkdb.time.__doc__ = u'    Create a time object for a specific time.  A few restrictions\nexist on the arguments:  - `year` is an integer between 1400 and\n9,999. - `month` is an integer between 1 and 12. - `day` is an integer\nbetween 1 and 31. - `hour` is an integer. - `minutes` is an integer. -\n`seconds` is a double. Its value will be rounded to three decimal\nplaces (millisecond-precision). - `timezone` can be `\'Z\'` (for UTC) or\na string with the format `\xb1[hh]:[mm]`.\n\n *Example:* Update the birthdate of the user "John" to November 3rd,\n1986 UTC.\n>>> r.table("user").get("John").update({"birthdate": r.time(1986, 11, 3, \'Z\')}).run(conn)'
rethinkdb.ast.RqlQuery.splice_at.__func__.__doc__ = u'    Insert several values in to an array at a given index. Returns the\nmodified array.\n\n *Example:* Hulk and Thor decide to join the avengers.\n>>> r.expr(["Iron Man", "Spider-Man"]).splice_at(1, ["Hulk", "Thor"]).run(conn)'
rethinkdb.sum.__doc__ = u"    Compute the sum of the given field in the group.\n\n *Example:* How many enemies have been vanquished by heroes at each\nstrength level?\n>>> r.table('marvel').group_by('strength', r.sum('enemiesVanquished')).run(conn)"
