package types

// ExecConfig is a small subset of the Config struct that holds the configuration
// for the exec feature of docker.
// copy from github.com/docker/docker/api/types
type ExecConfig struct {
	User         string   // User that will run the command
	Privileged   bool     // Is the workload in privileged mode
	Tty          bool     // Attach standard streams to a tty.
	AttachStdin  bool     // Attach the standard input, makes possible user interaction
	AttachStderr bool     // Attach the standard error
	AttachStdout bool     // Attach the standard output
	Detach       bool     // Execute in detach mode
	DetachKeys   string   // Escape keys for detach
	Env          []string // Environment variables
	WorkingDir   string   // Working directory
	Cmd          []string // Execution commands and args
}
