import {Complex} from "src/math/Complex.js"
import {GateBuilder} from "src/circuit/Gate.js"
import {GatePainting} from "src/draw/GatePainting.js"
import {Matrix} from "src/math/Matrix.js"

let PostSelectionGates = {};

let POST_SELECT_DRAWER = args => {
    if (args.isInToolbox  || args.isHighlighted) {
        GatePainting.DEFAULT_DRAWER(args);
    } else {
        args.painter.fillRect(args.rect, 'white');
        GatePainting.paintGateSymbol(args);
    }

    if (!args.isInToolbox) {
        let {x, y, w, h} = args.rect;
        args.painter.print("post-", x + w / 2, y, 'center', 'hanging', 'red', '10px sans-serif', w, h / 2);
        args.painter.print("select", x + w / 2, y + h, 'center', 'bottom', 'red', '10px sans-serif', w, h / 2);
    }
};

/** @type {!Gate} */
PostSelectionGates.PostSelectOff = new GateBuilder().
    setSerializedIdAndSymbol("|0⟩⟨0|").
    setTitle("Postselect Off").
    setBlurb("Keeps OFF states, discards/retries ON states.").
    setDrawer(POST_SELECT_DRAWER).
    setKnownEffectToMatrix(Matrix.square(1, 0, 0, 0)).
    gate;

/** @type {!Gate} */
PostSelectionGates.PostSelectOn = new GateBuilder().
    setSerializedIdAndSymbol("|1⟩⟨1|").
    setTitle("Postselect On").
    setBlurb("Keeps On states, discards/retries Off states.").
    setDrawer(POST_SELECT_DRAWER).
    setKnownEffectToMatrix(Matrix.square(0, 0, 0, 1)).
    gate;

/** @type {!Gate} */
PostSelectionGates.PostSelectAntiX = new GateBuilder().
    setSerializedId("|+⟩⟨+|").  // The +/- drawing convention was switched, but the serialized id must stay the same.
    setSymbol("|-⟩⟨-|").
    setTitle("Postselect X-Off").
    setBlurb("Keeps ON+OFF states, discards/retries ON-OFF states.").
    setDrawer(POST_SELECT_DRAWER).
    setKnownEffectToMatrix(Matrix.square(1, 1, 1, 1).times(0.5)).
    gate;

/** @type {!Gate} */
PostSelectionGates.PostSelectX = new GateBuilder().
    setSerializedId("|-⟩⟨-|").  // The +/- drawing convention was switched, but the serialized id must stay the same.
    setSymbol("|+⟩⟨+|").
    setTitle("Postselect X-On").
    setBlurb("Keeps ON-OFF states, discards/retries ON+OFF states.").
    setDrawer(POST_SELECT_DRAWER).
    setKnownEffectToMatrix(Matrix.square(1, -1, -1, 1).times(0.5)).
    gate;

/** @type {!Gate} */
PostSelectionGates.PostSelectAntiY = new GateBuilder().
    setSerializedId("|X⟩⟨X|").  // The cross/slash convention was switched, but the serialized id must stay the same.
    setSymbol("|/⟩⟨/|").
    setTitle("Postselect Y-Off").
    setBlurb("Keeps ON+iOFF states, discards ON-iOFF states.").
    setDrawer(POST_SELECT_DRAWER).
    setKnownEffectToMatrix(Matrix.square(1, Complex.I.neg(), Complex.I, 1).times(0.5)).
    gate;

/** @type {!Gate} */
PostSelectionGates.PostSelectY = new GateBuilder().
    setSerializedId("|/⟩⟨/|").  // The cross/slash convention was switched, but the serialized id must stay the same.
    setSymbol("|X⟩⟨X|").
    setTitle("Postselect Y-On").
    setBlurb("Keeps ON-iOFF states, discards/retries ON+iOFF states.").
    setDrawer(POST_SELECT_DRAWER).
    setKnownEffectToMatrix(Matrix.square(1, Complex.I, Complex.I.neg(), 1).times(0.5)).
    gate;

PostSelectionGates.all = [
    PostSelectionGates.PostSelectOff,
    PostSelectionGates.PostSelectOn,
    PostSelectionGates.PostSelectAntiX,
    PostSelectionGates.PostSelectX,
    PostSelectionGates.PostSelectAntiY,
    PostSelectionGates.PostSelectY
];

export {PostSelectionGates}
