<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- English Revision: 1827552 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="bind.xml.meta">

  <title>Ecoute sélective</title>

  <summary>
    <p>Configuration du serveur HTTP Apache pour l'écoute
    sur un port et une adresse IP spécifiques.</p>
  </summary>

  <seealso><a href="vhosts/">Serveurs virtuels</a></seealso>
  <seealso><a href="dns-caveats.html">Problèmes liés au DNS</a></seealso>

  <section id="overview">
    <title>Vue d'ensemble</title>

    <related>
      <modulelist>
        <module>core</module>
        <module>mpm_common</module>
      </modulelist>
      <directivelist>
        <directive module="core" type="section">VirtualHost</directive>
        <directive module="mpm_common">Listen</directive>
      </directivelist>
    </related>


    <p>Au démarrage de httpd, un port et une adresse lui sont associés sur
    l'hôte local et le serveur se met en attente de l'arrivée d'une requête.
    Par défaut, le serveur écoute toutes les adresses de l'hôte local.
    Cependant, on peut lui préciser des ports et des adresses spécifiques à
    écouter, ou une combinaison des deux.  Tout ceci est souvent associé avec la
    fonctionnalité des <a href="vhosts/">serveurs virtuels</a> qui détermine la
    manière dont <code>httpd</code> répond aux différents ports, noms d'hôtes et
    adresses IP.</p>

    <p>La directive <directive module="mpm_common">Listen</directive> permet
    d'indiquer au serveur qu'il ne doit accepter des requêtes que sur le(s)
    port(s) spécifiés ou une combinaison adresse/port. Si seul un numéro de port
    est spécifié dans la directive <directive
    module="mpm_common">Listen</directive>, le serveur se met à l'écoute sur ce
    port et sur toutes les interfaces réseau.  Si une adresse IP est spécifiée
    en plus du port, le serveur va écouter sur ce port et uniquement sur
    l'interface réseau correspondante. On peut utiliser plusieurs directives
    <directive module="mpm_common">Listen</directive> pour spécifier plusieurs
    adresses et ports à écouter. Le serveur répondra alors aux requêtes sur tous
    les ports et adresses spécifiés.</p>

    <p>Par exemple, pour faire en sorte que le serveur accepte des connexions
    sur les ports 80 et 8000 et sur toutes les interfaces, utilisez :</p>

    <example>
    <highlight language="config">
Listen 80
Listen 8000
    </highlight>
    </example>

    <p>Pour faire en sorte que le serveur accepte des connexions sur le port 80
    pour une interface, et sur le port 8000 pour une
    autre interface, utilisez :</p>

    <example>
    <highlight language="config">
Listen 192.0.2.1:80
Listen 192.0.2.5:8000
    </highlight>
    </example>

    <p>Les adresses IPv6 doivent être mises entre crochets, comme dans
    l'exemple suivant :</p>

    <example>
    <highlight language="config">
      Listen [2001:db8::a00:20ff:fea7:ccea]:80
    </highlight>
    </example>

    <note type="warning"><p>Des directives <directive
    module="mpm_common">Listen</directive>
    imbriquées provoqueront une erreur fatale qui
    empêchera le serveur de démarrer.</p>

    <example>
      (48)Address already in use: make_sock: could not bind to address [::]:80
    </example>

    <p>Voir <a
    href="http://wiki.apache.org/httpd/CouldNotBindToAddress">cette
    discussion dans le wiki</a> pour plus de détails à propos de la résolution
    de ce problème.</p>

    </note>

  </section>

  <section id="reload">
    <title>Changer la configuration de l'écoute au redémarrage</title>

    <p>Lorsque httpd est redémarré, certaines remarques sont à prendre en compte
    quant aux modifications apportées aux directives <directive
    module="mpm_common">Listen</directive>. Au cours du redémarrage, httpd
    conserve la liaison avec les ports de la configuration précédente afin
    d'éviter l'obtention d'un message d'erreur "Connection refused" lors d'une
    tentative ultérieure de connexion au serveur. Si les modifications apportées au jeu de
    directives <directive module="mpm_common">Listen</directive> utilisé entrent
    en conflit avec ce dernier, le serveur refusera de redémarrer.</p>

    <p>Par exemple, modifier la configuration suivante :</p>
    
    <example>
    <highlight language="config">
      Listen 127.0.0.1:80
    </highlight>
    </example>

    <p>pour utiliser la suivante pourra échouer car écouter le port 80 sur
    toutes les adresses IP entre en conflit avec une écoute sélective du port 80
    sur la seule adresse IP 127.0.0.1.</p>
    
    <example>
    <highlight language="config">
      Listen 80
    </highlight>
    </example>

    <p>Pour qu'une telle modification de configuration soit prise en compte avec
    succès, il est nécessaire d'arrêter, puis de démarrer le serveur.</p>
    
  </section>

    <section id="ipv6">
    <title>Remarques spécifiques à IPv6</title>

    <p>Un nombre croissant de plateformes implémentent IPv6, et
    <glossary>APR</glossary> supporte IPv6 sur la plupart d'entre elles,
    ce qui permet à httpd d'allouer des points de connexion (sockets) IPv6
    et de traiter des requêtes envoyées sur IPv6.</p>

    <p>Les administrateurs de httpd doivent se préoccuper de la possibilité
    pour un point de connexion IPv6 de traiter à la fois des connexions IPv4
    et des connexions IPv6.
    Le traitement de connexions IPv4 avec un point de connexion IPv6 utilise
    des adresses IPv6 traduites en IPv4 qui sont autorisées par défaut sur la
    plupart des plateformes, mais sont interdites par défaut sous FreeBSD, NetBSD,
    et OpenBSD, afin de respecter la politique de sécurité du système sur ces plateformes.
    Sur les systèmes où ces adresses sont interdites par défaut, un
    paramètre spécial du script <program>configure</program> permet de modifier
    ce comportement pour httpd.</p>

    <p>En revanche, sur certaines plateformes comme Linux et Tru64, la
    <strong>seule</strong> manière de gérer à la fois IPv6 et IPv4 passe
    par l'utilisation d'adresses traduites. Si vous voulez que <code>httpd</code> gère
    des connexions IPv4 et IPv6 avec un minimum de points de connexion,
    ce qui nécessite l'utilisation d'adresses IPv6 traduites en IPv4,
    utilisez l'option <code>--enable-v4-mapped</code> du script <program>
    configure</program>.</p>

    <p>L'option <code>--enable-v4-mapped</code> est utilisée par défaut sur
    toutes les plateformes sauf FreeBSD, NetBSD, et OpenBSD;
    votre httpd a donc probablement été construit avec cette option.</p>

    <p>Si vous souhaitez que httpd ne gère que des connexions IPv4, sans se
    soucier de ce que votre plateforme et APR supportent, spécifiez une adresse
    IPv4 dans toutes les directives
    <directive module="mpm_common">Listen</directive>, comme dans l'exemple
    suivant :</p>

    <example>
    <highlight language="config">
Listen 0.0.0.0:80
Listen 192.0.2.1:80
    </highlight>
    </example>

    <p>Si votre plateforme le supporte et si vous souhaitez que httpd gère
    des connexions IPv4 et IPv6 sur des points de connexion séparés
    (c'est à dire désactiver la traduction des adresses IPv6 au format IPv4),
    utilisez l'option <code>--disable-v4-mapped</code> du script
    <program> configure</program>. <code>--disable-v4-mapped</code> est
    utilisé par défaut sur FreeBSD, NetBSD, et OpenBSD.</p>
  </section>

  <section id="protocol">
    <title>Spécification du protocole avec Listen</title>
    <p>Dans la plupart des configurations, le second paramètre optionnel
    <var>protocol</var> de la directive <directive
    module="mpm_common">Listen</directive> n'est pas obligatoire. S'il
    n'est pas spécifié, les protocoles par défaut
    sont <code>https</code> pour le port 443, et <code>http</code> pour
    tous les autres ports. Le protocole sert à déterminer quel module
    doit traiter une requête, et à appliquer les optimisations
    spécifiques au protocole via la directive <directive
    module="core">AcceptFilter</directive>.</p>

    <p>Vous ne devez définir le protocole que si vous travaillez avec
    des ports non standards. Par exemple, pour travailler en
    <code>https</code> sur le port 8443 :</p>

    <example>
    <highlight language="config">
      Listen 192.170.2.1:8443 https
    </highlight>
    </example>
  </section>

  <section id="virtualhost">
    <title>Qu'en est-il avec les serveurs virtuels</title>

    <p> La directive <directive
    module="mpm_common">Listen</directive> n'implémente pas les serveurs virtuels.
    Elle indique simplement au serveur principal sur quels adresses et ports
    il doit écouter. Si aucune directive
    <directive module="core" type="section">VirtualHost</directive>
    n'est présente, le serveur se comportera de la même façon pour toutes
    les requêtes acceptées. En revanche, la directive
    <directive module="core" type="section">VirtualHost</directive>
    peut être utilisée pour provoquer une réaction différente du serveur
    pour un ou plusieurs adresses ou ports. Pour implémenter un serveur virtuel,
    on doit d'abord indiquer au serveur sur quels adresses et ports il doit écouter.
    Ensuite, une section
    <directive module="core" type="section">VirtualHost</directive>
    doit être créée pour le couple adresse+port spécifié afin de définir le
    comportement de cet hôte virtuel. Notez que si la directive
    <directive module="core" type="section">VirtualHost</directive>
    est définie pour une adresse et un port sur lesquels le serveur n'est pas censé
    écouter, cet hôte virtuel ne sera pas accessible.</p>
  </section>
</manualpage>

