<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- English Revision : 1662015 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="configuring.xml.meta">

  <title>Fichiers de configuration</title>

<summary>
<p>Ce document décrit les fichiers utilisés pour configurer
le Serveur HTTP Apache.</p>
</summary>

  <section id="main">
    <title>Fichiers de configuration principaux</title>
    <related>
      <modulelist>
        <module>mod_mime</module>
      </modulelist>
      <directivelist>
        <directive module="core" type="section">IfDefine</directive>
        <directive module="core">Include</directive>
        <directive module="mod_mime">TypesConfig</directive>
      </directivelist>
    </related>

    <p>La configuration du serveur HTTP Apache est effectuée en plaçant des <a
    href="mod/directives.html">directives</a> dans des fichiers de
    configuration au format texte. Le fichier de configuration principal se nomme
    en général
    <code>httpd.conf</code>. La localisation de ce fichier est définie
    à la compilation, mais peut être redéfinie à l'aide de l'option
    de ligne de commande <code>-f</code>. En outre, d'autres fichiers de
    configuration peuvent être ajoutés à l'aide de la directive
    <directive module="core">Include</directive>, et des caractères de
    remplacement
    peuvent être utilisés pour inclure de nombreux fichiers de configuration.
    Des directives de tous types peuvent être placées dans chacun de ces fichiers
    de configuration.  Les modifications dans les fichiers de configuration
    principaux ne sont prises en compte par httpd que lorsque le serveur
    est démarré ou redémarré.</p>

    <p>Le serveur lit aussi un fichier contenant les types de document mime;
    ce fichier est défini par la directive <directive
    module="mod_mime">TypesConfig</directive>,
    et se nomme <code>mime.types</code> par défaut.</p>
  </section>

  <section id="syntax">
    <title>Syntaxe des fichiers de configuration</title>

    <p>Les fichiers de configuration de httpd contiennent une directive
    par ligne.
    On peut utiliser l'anti-slash "\" comme dernier caractère d'une ligne
    pour indiquer que la directive continue à la ligne suivante.
    Il ne doit y avoir aucun caractère ni espace entre l'anti-slash et
    la fin de la ligne.</p>

    <p>Les arguments des directives sont séparés les uns des autres par
    des espaces. Si un argument contient des espaces, il doit être
    entouré de guillemets.</p>

    <p>Les directives dans les fichiers de configuration ne sont pas
    sensibles à la casse, mais leurs arguments le sont souvent. Les lignes
    qui débutent par le caractère "#" sont interprétées comme des
    commentaires, et sont ignorées. Les commentaires ne doivent
    <strong>pas</strong> apparaître sur la même ligne qu'une directive
    de configuration. Les espaces précédant une directive
    sont ignorés; vous pouvez par conséquent indenter les directives
    afin d'améliorer la lisibilité. Les lignes vides sont
    aussi ignorées.</p>

    <p>Les valeurs des variables d'environnement ou des variables
    définies via la directive <directive
    module="core">Define</directive> peuvent être utilisées dans le
    fichier de configuration en utilisant la syntaxe
    <code>${VAR}</code>. Si "VAR" est le nom d'une variable valide, la
    valeur de la variable est alors substituée à la chaîne
    <code>${VAR}</code>, et le processus de lecture du fichier de
    configuration continue comme si la chaîne correspondant à la valeur
    de la variable s'y était trouvée littéralement. Les variables définies
    via la directive <directive module="core">Define</directive>
    l'emportent sur les autres variables d'environnement du shell. Si la
    variable "VAR" n'est pas trouvée, la chaîne <code>${VAR}</code>
    n'est pas modifiée, et un avertissement est enregistré dans le
    journal. Le caractère ":" est interdit dans les noms de variables
    afin d'éviter tout conflit avec la syntaxe de la directive <directive
    module="mod_rewrite">RewriteMap</directive>.</p>

    <p>Seules les variables d'environnement du shell définies avant le démarrage
    du serveur peuvent être utilisées en extension.
    Les variables d'environnement
    définies dans le fichier de configuration lui-même, par exemple avec <directive
    module="mod_env">SetEnv</directive>, prennent effet trop tard pour
    pouvoir être utilisées en extension au sein du fichier de
    configuration.</p>

    <p>La longueur maximale d'une ligne dans un fichier de configuration
    normal, après substitution des variables et fusion des lignes
    interrompues, est approximativement de 16 Mo. Dans les <a
    href="configuring.html#htaccess">fichiers .htaccess</a>, la longueur
    maximale est de 8190 caractères.</p>

    <p>Vous pouvez vérifier l'absence d'erreurs de syntaxe dans vos fichiers
    de configuration sans démarrer le serveur à l'aide de la commande
    <code>apachectl configtest</code> ou de l'option de ligne de commande
    <code>-t</code>.</p>

    <p>Vous pouvez utiliser la définition <code>-DDUMP_CONFIG</code> de
    <module>mod_info</module> pour afficher la configuration avec tous
    les fichiers inclus et les variables d'environnement évaluées, tous
    les commentaires et les sections <directive module="core"
    type="section">IfDefine</directive> et <directive module="core"
    type="section">IfModule</directive> non actives ayant
    été supprimés. Cependant, la sortie ne reflète
    pas les fusions ou écrasements pouvant intervenir en cas de
    définitions multiples de directives.</p>
  </section>

  <section id="modules">
    <title>Modules</title>

    <related>
      <modulelist>
        <module>mod_so</module>
      </modulelist>
      <directivelist>
        <directive module="core" type="section">IfModule</directive>
        <directive module="mod_so">LoadModule</directive>
      </directivelist>
    </related>

    <p>httpd est un serveur modulaire. Ceci implique que seules les
    fonctionnalités les plus courantes sont incluses dans le serveur de base.
    Les fonctionnalités étendues sont fournies à l'aide de <a
    href="mod/">modules</a> qui peuvent être chargés dans httpd.
    Par défaut, un jeu de <a
    href="mod/module-dict.html#Status">modules de base</a> est inclus dans le
    serveur à la compilation. Si le serveur est compilé de façon à utiliser
    les <a href="dso.html">modules chargés dynamiquement</a>,
    alors les modules peuvent être compilés séparément et chargés à
    n'importe quel moment à l'aide de la directive
    <directive module="mod_so">LoadModule</directive>.
    Dans le cas contraire, httpd doit être recompilé pour ajouter ou
    supprimer des modules.
    Les directives de configuration peuvent être incluses de manière
    conditionnelle selon la présence ou l'absence d'un module particulier
    en les plaçant dans un bloc <directive
    module="core" type="section">IfModule</directive>.</p>

    <p>Pour voir quels modules ont été compilés avec le serveur,
    vous pouvez utiliser l'option de ligne de commande <code>-l</code>.</p>
  </section>

  <section id="scope">
    <title>Portée des directives</title>

    <related>
      <directivelist>
        <directive module="core" type="section">Directory</directive>
        <directive module="core" type="section">DirectoryMatch</directive>
        <directive module="core" type="section">Files</directive>
        <directive module="core" type="section">FilesMatch</directive>
        <directive module="core" type="section">Location</directive>
        <directive module="core" type="section">LocationMatch</directive>
        <directive module="core" type="section">VirtualHost</directive>
      </directivelist>
    </related>

    <p>Les directives placées dans les fichiers de configuration principaux
    s'appliquent au serveur dans son ensemble. Si vous souhaitez modifier la
    configuration d'une partie du serveur seulement, vous pouvez limiter la
    portée de vos directives en les plaçant dans une section
    <directive module="core"
    type="section">Directory</directive>, <directive module="core"
    type="section">DirectoryMatch</directive>, <directive module="core"
    type="section">Files</directive>, <directive module="core"
    type="section">FilesMatch</directive>, <directive module="core"
    type="section">Location</directive>, ou <directive module="core"
    type="section">LocationMatch</directive>.
    Ces sections limitent le champ d'application des directives qu'elles
    contiennent à des URls ou des portions du système de fichiers particulières.
    Elles peuvent aussi être imbriquées, ce qui permet
    une configuration très fine.</p>

    <p>httpd peut servir simultanément de nombreux sites web au travers des
    <a href="vhosts/">Hôtes Virtuels</a>. La portée des directives peut ainsi
    être limitée en les plaçant dans des sections
    <directive module="core" type="section">VirtualHost</directive>,
    afin qu'elles ne s'appliquent qu'aux requêtes
    pour un site web particulier.</p>

    <p>Bien que la plupart des directives puissent être placées dans
    chacune de ces sections, certaines d'entre elles n'ont aucun sens
    dans certains contextes.
    Par exemple, les directives qui contrôlent la création des processus
    n'ont de sens que dans le contexte du serveur principal. Pour déterminer
    quelles directives peuvent être placées dans quelles sections, consultez
    le <a href="mod/directive-dict.html#Context">Contexte</a> de la
    directive. Pour plus d'informations, nous fournissons des détails dans
    <a href="sections.html">Comment fonctionnent les sections Directory,
    Location et Files</a>.</p>
  </section>

  <section id="htaccess">
    <title>Fichiers .htaccess</title>

    <related>
      <directivelist>
        <directive module="core">AccessFileName</directive>
        <directive module="core">AllowOverride</directive>
      </directivelist>
    </related>

    <p>httpd permet la gestion décentralisée de la configuration
    via des fichiers spéciaux placés dans l'arborescence du site web.
    Ces fichiers spéciaux se nomment en général <code>.htaccess</code>,
    mais tout autre nom peut être spécifié à l'aide de la directive
    <directive module="core">AccessFileName</directive>.
    Les directives placées dans les fichiers <code>.htaccess</code>
    s'appliquent au répertoire dans lequel vous avez placé le fichier,
    ainsi qu'à tous ses sous-répertoires.
    La syntaxe des fichiers <code>.htaccess</code> est la même que celle
    des fichiers de configuration principaux. Comme les fichiers
    <code>.htaccess</code> sont lus à chaque requête, les modifications de
    ces fichiers prennent effet immédiatement.</p>

    <p>Pour déterminer quelles directives peuvent être placées
    dans les fichiers <code>.htaccess</code>, consultez le
    <a href="mod/directive-dict.html#Context">Contexte</a> de la
    directive. L'administrateur du serveur peut contrôler quelles
    directives peuvent être placées dans les fichiers
    <code>.htaccess</code> en définissant la directive
    <directive module="core">AllowOverride</directive>
    dans les fichiers de configuration principaux.</p>

    <p>Pour plus d'informations sur les fichiers <code>.htaccess</code>,
    se référer au <a href="howto/htaccess.html">tutoriel .htaccess</a>.</p>
  </section>
</manualpage>
