<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision : 1690345 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="getting-started.xml.meta">

  <title>Pour démarrer</title>

<summary>
<p>Si vous ne connaissez rien au serveur HTTP Apache, ou même au
fonctionnement d'un site web, vous vous demandez probablement par où
commencer et quelles questions poser. Ce document vous permettra de
parcourir les bases du sujet.</p>
</summary>

<section id="clientserver">
<title>Clients, serveurs et URLs</title>

<p>
Les adresses des pages web sur la Toile se présentent sous forme d'URLs
- Uniform Resource Locators - qui comportent un protocole (par
  exemple <code>http</code>), un nom de serveur (par exemple
  <code>www.apache.org</code>), un chemin (par exemple
  <code>/docs/current/getting-started.html</code>), et le cas échéant
  une chaîne de paramètres (query string) (par exemple <code>?arg=value</code>)
  permettant de transmettre des informations supplémentaires au serveur.
</p>

<p>Un client (par exemple un navigateur web) se connecte à un serveur
(par exemple votre serveur HTTP Apache) avec un protocole spécifique, et
effectue une <strong>requête</strong> pour une ressource en spécifiant
son chemin.</p>

<p>Un chemin peut représenter plusieurs types de ressources sur le
serveur. Ce peut être un fichier (comme
<code>getting-started.html</code>), un gestionnaire (comme <a
href="mod/mod_status.html">server-status</a>), ou toute sorte de
programme (comme <code>index.php</code>). Nous décrirons tout ceci plus
en détails ci-dessous dans la section <a href="#content">Contenu d'un
site web</a>.</p>

<p>
Le serveur envoie alors une <strong>réponse</strong> comportant un code
d'état, et éventuellement un corps de réponse. Le code d'état indique si
la requête a été traitée avec succès, ou dans la négative quel type
d'erreur a été rencontré. Le client est alors censé savoir quoi faire de
la réponse. Vous pouvez vous familiariser avec les différents codes
d'état en consultant le <a
href="http://wiki.apache.org/httpd/CommonHTTPStatusCodes">Wiki du
serveur HTTP Apache</a>.</p>

<p>Les détails de la transaction, ainsi que les erreurs rencontrées,
sont enregistrés dans des fichiers journaux. Tout ceci est décrit en
détails ci-dessous dans la section <a href="#logs">Débogage et fichiers
journaux</a>.</p>

</section>

<section id="dns">
<title>Noms d'hôte et DNS</title>

<p>Pour se connecter à un serveur, le client doit tout d'abord traduire
le nom du serveur en adresse IP, cette dernière permettant de localiser
le serveur sur Internet. Ainsi, pour que votre serveur web soit
accessible, son nom doit être enregistré dans le DNS.</p>

<p>Si vous ne savez pas comment effectuer cet enregistrement, vous
devez contacter votre administrateur réseau ou votre fournisseur
d'accès à Internet afin qu'il effectue cette opération pour vous.</p>

<p>Plusieurs noms d'hôte peuvent pointer vers la même adresse IP, et
plusieurs adresses IP peuvent être attachées au même serveur physique.
Vous pouvez ainsi héberger plusieurs serveurs web sur le même serveur
physique grâce au mécanisme des <a href="vhosts/">serveurs virtuels</a>.</p>

<p>Pour tester un serveur non encore accessible sur Internet, vous
pouvez renseigner son nom d'hôte dans votre fichier hosts afin
d'effectuer une résolution de nom locale. Par exemple, pour tester le
serveur web <code>www.example.com</code> depuis le serveur physique qui
l'héberge, vous pouvez ajouter la ligne suivante au fichier hosts de ce
dernier : </p>

<example>
127.0.0.1 www.example.com
</example>

<p>En général, le fichier hosts se trouve dans le répertoire
<code>/etc</code> sur les systèmes de style Unix, ou
<code>C:\Windows\system32\drivers\etc</code> sous Windows.</p>

<p>Vous trouverez plus de détails à propos du fichier hosts à <a
href="http://en.wikipedia.org/wiki/Hosts_(file)">Wikipedia.org/wiki/Hosts_(file)</a>,
et à propos du DNS à <a
href="http://en.wikipedia.org/wiki/Domain_Name_System">Wikipedia.org/wiki/Domain_Name_System</a>.</p>
</section>

<section id="configuration">
<title>Fichiers de configuration et directives</title>

<p>La configuration du serveur HTTP Apache s'effectue via de simples
fichiers textes. Ces fichiers peuvent se trouver dans de nombreux
endroits différents en fonction du mode d'installation du serveur. Vous
trouverez les positions courantes de ces fichiers dans le <a
href="http://wiki.apache.org/httpd/DistrosDefaultLayout">wiki httpd</a>.
Si vous installez httpd depuis le code source, le répertoire par défaut
des fichiers de configuration est <code>/usr/local/apache2/conf</code>.
Le nom du fichier de configuration par défaut est en général
<code>httpd.conf</code>, mais peut aussi varier en fonction des
distributions tierces du serveur.</p>

<p>L'ensemble de la configuration est en général divisé en plusieurs
fichiers afin d'en faciliter la gestion. Ces fichiers sont inclus dans
le fichier de configuration principal via la directive <directive
module="core">Include</directive>. Les noms ou positions de ces fichiers
ne sont pas figés et peuvent varier considérablement d'une distribution
à l'autre. N'hésitez pas à les arranger et subdiviser selon
<strong>vos</strong> goûts et besoins, quitte à en modifier
l'organisation par défaut.</p>

<p>La configuration du serveur s'effectue via des <a
href="mod/quickreference.html">directives de configuration</a> que l'on
insère dans les fichiers de configuration. Une directive se compose d'un
mot-clé suivi d'un ou plusieurs arguments qui définissent sa valeur.</p>

<p>La réponse à la question "<em>Où dois-je placer cette directive
?</em>" dépend en général du niveau auquel cette directive doit être
prise en compte. S'il s'agit du niveau global, elle doit être placée
dans le fichier de configuration principal, et en dehors de toute
section  <directive type="section" module="core">Directory</directive>, <directive
type="section" module="core">Location</directive>, <directive
type="section" module="core">VirtualHost</directive>, ou de toute autre section. Si
par exemple elle ne doit s'appliquer qu'à un répertoire particulier,
elle doit être placée dans la section <directive
type="section" module="core">Directory</directive> qui fait référence à ce répertoire.
Voir la documentation sur les <a href="sections.html">Sections de
configuration</a> pour plus de détails.</p>

<p>En complément des fichiers de configuration principaux, certaines
directives peuvent être insérées dans des fichiers
<code>.htaccess</code> que l'on place directement dans le répertoire
concerné. Les fichiers <code>.htaccess</code> sont essentiellement
destinés aux personnes qui n'ont pas accès aux fichiers de configuration
du serveur. Vous trouverez plus de détails à propos des fichiers
<code>.htaccess</code> dans ce <a
href="howto/htaccess.html"><code>.htaccess</code>howto</a>.</p>

</section>

<section id="content">
<title>Contenu du site web</title>

<p>Si le contenu du site web peut se présenter sous de nombreuses
formes, il en existe deux principales : les
contenus statiques et les contenus dynamiques.</p>

<p>Les contenus statiques sont par exemple les fichiers HTML, les
images, les fichiers CSS et tout autre fichier résidant dans le système
de fichiers. La directive <directive
module="core">DocumentRoot</directive> permet de définir la position
dans l'arborescence du site où vous devez placer ces fichiers. Cette
directive peut être définie au niveau global, ou au niveau de chaque
serveur virtuel. Vous pouvez consulter vos fichiers de configuration
pour vérifier la manière dont cette directive est définie pour votre
serveur.</p>

<p>En général, et si aucun nom de fichier n'est spécifié dans la
requête, c'est une page de nom <code>index.html</code> qui sera
renvoyée. Par exemple, si la directive <code>DocumentRoot</code> est
définie à <code>/var/www/html</code>, et si une requête est effectuée
pour l'adresse <code>http://www.example.com/work/</code>, c'est le
fichier <code>/var/www/html/work/index.html</code> qui sera envoyé au
client par le serveur.</p>

<p>Un contenu dynamique est un contenu qui est généré au moment du
traitement de la requête, et qui peut différer d'une requête à l'autre.
Ces contenus dynamiques peuvent être générés de nombreuses manières par
l'intermédiaire de <a href="handler.html">gestionnaires de contenu</a>
ou "handlers". Il est aussi possible de créer des <a
href="howto/cgi.html">programmes CGI</a> pour générer le contenu de
votre site.</p>

<p>Enfin, on peut utiliser des modules tiers comme mod_php pour écrire
du code permettant d'effectuer de nombreuses choses. De nombreuses
applications tierces écrites à partir de divers langages ou outils sont
disponibles en téléchargement et peuvent être installées sur votre
serveur HTTP Apache. Le support de ces applications est en dehors du sujet de
ce document, et nous vous invitons à consulter le site de leur éditeur
pour accéder à leur documentation.</p>
</section>

<section id="logs">
<title>Fichiers journaux et résolution des problèmes</title>
<p>En tant qu'administrateur d'un serveur HTTP Apache, vos sources
d'informations principales sont les fichiers journaux, et en particulier
le journal des erreurs. Toute tentative de résolution d'un problème sans
consulter le journal des erreurs revient à essayer de conduire les yeux
fermés.</p>

<p>La position dans le système de fichiers du journal des erreurs est
spécifiée par la directive <directive module="core">ErrorLog</directive>
qui peut être définie au niveau global, ou au niveau de chaque serveur
virtuel. Chaque entrée du journal des erreurs vous informe sur la nature
des problèmes et le moment de leur survenue. En outre, elle vous indique
souvent comment résoudre le problème. Chaque message d'erreur contient
un code d'erreur que vous pouvez utiliser pour effectuer une recherche
en ligne afin d'obtenir une description plus détaillée de la manière de
résoudre le problème. Vous pouvez aussi configurer votre journal des
erreurs de manière à ce qu'il enregistre un identifiant d'erreur que
vous pourrez ensuite utiliser pour effectuer une corrélation avec le
journal des accès afin de déterminer quelle requête est à l'origine de
l'erreur.</p>

<p>Vous trouverez plus de détails à ce sujet dans la <a
href="logs.html">Documentation sur la journalisation</a>.</p>
</section>

<section id="other">
<title>Et maintenant, comment faire pour aller plus loin ?</title>

<p>La question des prérequis étant réglée, il est temps de passer aux
choses sérieuses.</p>

<p>Ce document ne couvre que les notions de base. Nous espérons qu'il
vous permettra de mettre le pied à l'étrier, mais il y a encore de
nombreuses choses que vous devez savoir.</p>

<ul>
<li><a href="http://httpd.apache.org/download.cgi">Téléchargement</a></li>
<li><a href="install.html">Installation</a></li>
<li><a href="configuring.html">Configuration</a></li>
<li><a href="invoking.html">Démarrage du serveur</a></li>
<li><a href="http://wiki.apache.org/httpd/FAQ">Foire aux questions</a></li>
</ul>

</section>

</manualpage>
