<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1745806 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="public_html.xml.meta">
<parentdocument href="./">Recettes et tutoriels</parentdocument>

  <title>Répertoires web utilisateurs</title>

<summary>
<p>Sur les systèmes multi-utilisateurs, on peut permettre à chaque
utilisateur d'avoir un site web dans son répertoire home à l'aide de la
directive <directive module="mod_userdir">UserDir</directive>. Les
visiteurs de l'URL <code>http://example.com/~nom_utilisateur/</code>
recevront un contenu situé dans le répertoire home de l'utilisateur
"<code>nom_utilisateur</code>", et dans le sous-répertoire spécifié par
la directive <directive module="mod_userdir">UserDir</directive>.</p>
<p>Notez que par défaut, l'accès à ces répertoires n'est
<strong>pas</strong> permis. Vous pouvez en permettre l'accès à l'aide
de la directive <directive module="mod_userdir">UserDir</directive> en
décommentant la ligne :</p>
    <highlight language="config">
      #Include conf/extra/httpd-userdir.conf
    </highlight>
    <p>dans le fichier de configuration par défaut
    <code>conf/httpd.conf</code>, et en adaptant le
    fichier <code>httpd-userdir.conf</code> selon vos besoins, ou en
    incluant les directives appropriées dans une section
    <directive module="core" type="section">Directory</directive> du fichier de
    configuration principal.</p>
</summary>

<seealso><a href="../urlmapping.html">Mise en correspondance des URLs
avec le système de fichiers</a></seealso>

  <section id="related">
    <title>Répertoires web utilisateurs</title>
    <related>
      <modulelist>
        <module>mod_userdir</module>
      </modulelist>
      <directivelist>
        <directive module="mod_userdir">UserDir</directive>
        <directive module="core">DirectoryMatch</directive>
        <directive module="core">AllowOverride</directive>
      </directivelist>
    </related>
    </section>

    <section id="userdir">
    <title>Définition du chemin des fichiers avec UserDir</title>

    <p>La directive <directive module="mod_userdir">UserDir</directive>
    permet de spécifier un répertoire à partir duquel le contenu de
    l'utilisateur pourra être chargé. Elle peut revêtir plusieurs
    formes.</p>

    <p>Si le chemin spécifié ne commence pas par un slash, il sera
    interprété comme chemin relatif au répertoire home de l'utilisateur
    considéré. Par exemple, avec cette configuration :</p>

    <highlight language="config">UserDir public_html</highlight>

    <p>l'URL <code>http://example.com/~rbowen/fichier.html</code>
    correspondra au chemin fichier
    <code>/home/rbowen/public_html/fichier.html</code></p>

    <p>Si le chemin spécifié commence par un slash, le chemin du fichier
    sera construit en utilisant ce chemin, suivi du nom de l'utilisateur
    considéré. Par exemple, avec cette configuration :</p>

    <highlight language="config">UserDir /var/html</highlight>

    <p>l'URL <code>http://example.com/~rbowen/fichier.html</code>
    correspondra au chemin fichier
    <code>/var/html/rbowen/fichier.html</code></p>

    <p>Si le chemin spécifié contient un astérisque (*), ce dernier sera
    remplacé par le nom de l'utilisateur dans le chemin du fichier
    correspondant. Par exemple, avec cette configuration :</p>

    <highlight language="config">UserDir /var/www/*/docs</highlight>

    <p>l'URL <code>http://example.com/~rbowen/fichier.html</code>
    correspondra au chemin fichier
    <code>/var/www/rbowen/docs/fichier.html</code></p>

    <p>On peut aussi définir plusieurs répertoires ou chemins de
    répertoires.</p>

    <highlight language="config">UserDir public_html /var/html</highlight>

    <p>Avec l'URL <code>http://example.com/~rbowen/fichier.html</code>,
    Apache va rechercher <code>~rbowen</code>. S'il ne le trouve pas,
    Apache va rechercher <code>rbowen</code> dans
    <code>/var/html</code>. S'il le trouve, l'URL ci-dessus correspondra
    au chemin fichier <code>/var/html/rbowen/file.html</code></p>

  </section>

  <section id="redirect">
    <title>Redirection vers des URLs externes</title>
    <p>On peut utiliser la directive <directive
    module="mod_userdir">UserDir</directive> pour rediriger les requêtes
    relatives aux répertoires utilisateurs vers des URLs externes.</p>

    <highlight language="config">UserDir http://example.org/users/*/</highlight>

    <p>L'exemple ci-dessus va rediriger une requête pour
    <code>http://example.com/~bob/abc.html</code> vers
    <code>http://exemple.org/users/bob/abc.html</code>.</p>
  </section>

  <section id="enable">
    <title>Définition de la liste des utilisateurs autorisés à utiliser
    cette fonctionnalité</title>

    <p>En suivant la syntaxe décrite dans la documentation de UserDir,
    vous pouvez définir quels utilisateurs sont autorisés à utiliser
    cette fonctionnalité :</p>

    <highlight language="config">UserDir disabled root jro fish</highlight>

    <p>La configuration ci-dessus va autoriser l'utilisation de la
    fonctionnalité pour tous les utilisateurs, à l'exception de ceux
    listés à la suite de l'argument <code>disabled</code>. De même, vous
    pouvez interdire l'utilisation de la fonctionnalité à tous les
    utilisateurs sauf certains d'entre eux en utilisant une
    configuration du style :</p>

    <highlight language="config">
UserDir disabled
UserDir enabled rbowen krietz      
    </highlight>

    <p>Vous trouverez d'autres exemples dans la documentation de
    <directive module="mod_userdir">UserDir</directive>.</p>

  </section>

  <section id="cgi">
  <title>Définition d'un répertoire CGI pour chaque utilisateur</title>

   <p>Afin de réserver un répertoire cgi-bin pour chaque utilisateur,
   vous pouvez utiliser une section <directive module="core"
   type="section">Directory</directive> pour activer CGI dans un
   sous-répertoire particulier d'un répertoire home utilisateur.</p>

    <highlight language="config">
&lt;Directory "/home/*/public_html/cgi-bin/"&gt;
    Options ExecCGI
    SetHandler cgi-script
&lt;/Directory&gt;
    </highlight>

    <p>Avec la configuration ci-dessus, et en supposant que
    <code>UserDir</code> est défini à <code>public_html</code>, un
    programme CGI <code>exemple.cgi</code> pourra être chargé depuis ce
    répertoire en passant par l'URL :</p>

    <example>
    http://example.com/~rbowen/cgi-bin/exemple.cgi
    </example>

    </section>

    <section id="htaccess">
    <title>Permettre aux utilisateurs de modifier la
    configuration</title>

    <p>Si vous voulez que vos utilisateurs puissent modifier la
    configuration du serveur pour ce qui concerne leur espace web, ils
    devront utiliser des fichiers <code>.htaccess</code> pour effectuer
    ces modifications. Assurez-vous d'avoir défini la directive
    <directive module="core">AllowOverride</directive> à une valeur
    appropriée pour les directives dont vous voulez permettre la
    modification aux utilisateurs. Voir le <a
    href="htaccess.html">tutoriel .htaccess</a> pour plus de détails sur
    la manière dont tout ceci fonctionne.</p>

  </section>

</manualpage>
