<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- English Revision: 1741841 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="logs.xml.meta">

  <title>Fichiers journaux</title>

  <summary>
    <p>Pour véritablement gérer un serveur web,
    il est nécessaire de disposer d'un
    retour d'informations à propos de l'activité et des performances du
    serveur, ainsi que de tout problème qui pourrait survenir. Le serveur HTTP
    Apache propose des fonctionnalités de journalisation souples et très
    complètes. Ce document décrit comment configurer ces fonctionnalités de
    journalisation et interpréter le contenu des journaux.</p>
  </summary>

  <section id="overview">
    <title>Vue d'ensemble</title>

  <related>
      <modulelist>
        <module>mod_log_config</module>
        <module>mod_log_forensic</module>
        <module>mod_logio</module>
        <module>mod_cgi</module>
      </modulelist>
  </related>

  <p>
  Le serveur HTTP Apache fournit toute une variété de mécanismes
  différents pour la journalisation de tout ce qui peut se passer au
  sein de votre serveur, depuis la requête initiale, en passant par le
  processus de mise en correspondance des URLs, et jusqu'à la fermeture
  de la connexion, y compris toute erreur pouvant survenir au cours du
  traitement. De plus, certains modules tiers fournissent des
  fonctionnalités de journalisation ou insèrent des entrées dans les
  fichiers journaux existants, et les applications comme les programmes
  CGI, les scripts PHP ou autres gestionnaires peuvent envoyer des
  messages vers le journal des erreurs du serveur.
  </p>

  <p>
  Ce document décrit le fonctionnement des modules de journalisation
  fournis en standard avec le serveur httpd.
  </p>

  </section>

  <section id="security">
    <title>Avertissement à propos de la sécurité</title>

    <p>Tout utilisateur qui a les droits en écriture sur le répertoire dans
    lequel Apache httpd écrit ses journaux pourra quasi
    certainement avoir accès à l'uid sous lequel le serveur est démarré, en
    l'occurrence habituellement root. N'accordez <em>PAS</em> aux utilisateurs
    l'accès en écriture au répertoire dans lequel les journaux sont stockés
    sans savoir exactement quelles en seraient les conséquences ; voir le
    document <a href="misc/security_tips.html">conseils sur la sécurité</a>
    pour plus de détails.</p>

    <p>En outre, les journaux peuvent contenir des informations fournies
    directement par un client, sans caractères d'échappement. Des clients mal
    intentionnés peuvent donc insérer des caractères de contrôle dans les
    journaux, et il convient par conséquent d'être très prudent lors de la
    manipulation des journaux bruts.</p>
  </section>

  <section id="errorlog">
    <title>Journal des erreurs</title>

    <related>
      <modulelist>
        <module>core</module>
      </modulelist>
      <directivelist>
        <directive module="core">ErrorLog</directive>
        <directive module="core">LogLevel</directive>
      </directivelist>
    </related>

    <p>Le journal des erreurs du serveur, dont le nom et la localisation sont
    définis par la directive <directive module="core">ErrorLog</directive>,
    est le journal le plus important. C'est dans celui-ci
    que le démon Apache httpd va envoyer les informations de diagnostic et
    enregistrer toutes les erreurs qui surviennent lors du traitement des
    requêtes. Lorsqu'un problème survient au démarrage du serveur ou pendant
    son fonctionnement, la première chose à faire est de regarder dans ce
    journal, car il vous renseignera souvent sur le problème rencontré et
    la manière d'y remédier.</p>

    <p>Le journal des erreurs est habituellement enregistré dans un fichier
    (en général <code>error_log</code> sur les systèmes de type Unix et
    <code>error.log</code> sur Windows et OS/2). Sur les systèmes de type Unix,
    le serveur peut aussi enregistrer ses erreurs dans
    <code>syslog</code> ou les
    <a href="#piped">rediriger vers un programme</a> par l'intermédiaire d'un
    tube de communication (pipe).</p>

    <p>Le format par défaut du journal des erreurs est descriptif et de forme
    relativement libre. Certaines informations apparaissent cependant dans la
    plupart des entrées du journal. Voici un message typique
    à titre d'exemple : </p>

    <example>
      [Wed Oct 11 14:32:52 2000] [error] [client 127.0.0.1]
      client denied by server configuration:
      /export/home/live/ap/htdocs/test
    </example>

    <p>Le premier champ de l'entrée du journal est la date et l'heure du
    message. Le second champ indique la sévérité de l'erreur rapportée. La
    directive <directive module="core">LogLevel</directive> permet de
    restreindre le type des erreurs qui doivent être enregistrées
    dans le journal des erreurs en définissant leur niveau de sévérité. Le
    troisième champ contient l'adresse IP du client qui a généré l'erreur.
    Vient ensuite le message proprement dit, qui indique dans ce cas que le
    serveur a été configuré pour interdire l'accès au client. Le serveur
    indique le chemin système du document requis (et non
    son chemin web).</p>

    <p>Une grande variété de messages différents peuvent apparaître dans le
    journal des erreurs. La plupart d'entre eux sont similaires à l'exemple
    ci-dessus. Le journal des erreurs peut aussi contenir des informations de
    débogage en provenance de scripts CGI. Toute information qu'un script CGI
    écrit sur la sortie d'erreurs standard <code>stderr</code> sera recopiée
    telle quelle dans le journal des erreurs.</p>

    <p>La directive <directive module="core">ErrorLogFormat</directive>
    vous permet de personnaliser le format du journal des erreurs, et de
    définir les informations à journaliser. Si
    <module>mod_unique_id</module> est présent, vous pouvez utiliser le
    drapeau <code>%L</code> à la fois dans le journal des erreurs et
    dans le
    journal des accès, ce qui aura pour effet de générer un identifiant
    d'entrée qui vous permettra de corréler les entrées du journal des
    erreurs avec celles du journal des accès.</p>

    <p>Pendant la phase de test, il est souvent utile de visualiser en continu
    le journal des erreurs afin de détecter tout problème éventuel. Sur les
    systèmes de type Unix, ceci s'effectue à l'aide de la commande :</p>

    <example>
      tail -f error_log
    </example>
  </section>

  <section id="permodule">
    <title>Journalisation par module</title>

    <p>La directive <directive module="core">LogLevel</directive> permet
    de spécifier un niveau de sévérité de journalisation pour chaque
    module. Vous pouvez ainsi résoudre un problème propre à un module particulier
    en augmentant son volume de journalisation sans augmenter ce volume
    pour les autres modules. Ceci est particulièrement utile lorsque
    vous voulez obtenir des détails sur le fonctionnement de modules
    comme <module>mod_proxy</module> ou <module>mod_rewrite</module>.</p>

    <p>Pour ce faire, vous devez spécifier le nom du module dans votre
    directive <directive>LogLevel</directive> :</p>

    <highlight language="config">
    LogLevel info rewrite:trace5
    </highlight>

    <p>Dans cet exemple, le niveau de journalisation général est défini
    à info, et à <code>trace5</code> pour <module>mod_rewrite</module>.</p>

    <note>Cette directive remplace les directives de journalisation par
    module des versions précédentes du serveur, comme
    <code>RewriteLog</code>.</note>
 </section>


  <section id="accesslog">
    <title>Journal des accès</title>

    <related>
      <modulelist>
        <module>mod_log_config</module>
        <module>mod_setenvif</module>
      </modulelist>
      <directivelist>
        <directive module="mod_log_config">CustomLog</directive>
        <directive module="mod_log_config">LogFormat</directive>
        <directive module="mod_setenvif">SetEnvIf</directive>
      </directivelist>
    </related>

    <p>Le journal des accès au serveur
    enregistre toutes les requêtes que traite
    ce dernier. La localisation et le contenu du journal des accès sont définis
    par la directive <directive module="mod_log_config">CustomLog</directive>.
    La directive <directive module="mod_log_config">LogFormat</directive>
    permet de simplifier la sélection du contenu du journal. Cette section
    décrit comment configurer le serveur pour l'enregistrement des informations
    dans le journal des accès.</p>

    <p>Bien évidemment, le stockage d'informations dans le journal des accès
    n'est que le point de départ de la gestion de la journalisation. L'étape
    suivante consiste à analyser ces informations de façon à pouvoir en
    extraire des statistiques utiles. L'analyse de journaux en général est en
    dehors du sujet de ce document et ne fait pas vraiment partie intégrante
    du travail du serveur web lui-même. Pour plus d'informations à propos de ce
    sujet et des applications dédiées à l'analyse de journaux, vous pouvez vous
    référer à <a href="http://dmoz.org/Computers/Software/Internet/
    Site_Management/Log_Analysis/">Open Directory</a>.</p>

    <p>Différentes versions du démon Apache httpd utilisaient d'autres modules
    et directives pour contrôler la journalisation des accès, à l'instar de
    mod_log_referer, mod_log_agent, et de la directive
    <code>TransferLog</code>. La directive
    <directive	module="mod_log_config">CustomLog</directive> rassemble
    désormais les fonctionnalités de toutes les anciennes directives.</p>

    <p>Le format du journal des accès est hautement configurable. Il est
    défini à l'aide d'une chaîne de format qui ressemble sensiblement à la
    chaîne de format de style langage C de printf(1). Vous trouverez quelques
    exemples dans les sections suivantes. Pour une liste exhaustive de ce que
    peut contenir une chaîne de format, vous pouvez vous référer au chapitre
    <a href="mod/mod_log_config.html#formats">chaînes de format</a> de la
    documentation du module <module>mod_log_config</module>.</p>

    <section id="common">
      <title>Format habituel du journal</title>

      <p>Voici une configuration typique pour le journal des accès :</p>

      <highlight language="config">
LogFormat "%h %l %u %t \"%r\" %&gt;s %b" common
CustomLog logs/access_log common
      </highlight>

      <p>Ici est définie l'<em>identité</em> <code>common</code> qui est
      ensuite associée à une chaîne de format de journalisation particulière.
      La chaîne de format est constituée de directives débutant par le
      caractère %, chacune d'entre elles indiquant au serveur d'enregistrer
      un élément particulier d'information. Des caractères littéraux peuvent
      aussi être insérés dans la chaîne de format ; il seront copiés tels
      quels dans le flux de sortie destiné à la journalisation.
      Les guillemets (<code>"</code>) doivent être échappées en les faisant
      précéder d'un anti-slash (<code>\</code>) afin qu'elles ne soient pas
      interprétées comme la fin de la chaîne de format. La chaîne de format
      peut aussi contenir les caractères de contrôle spéciaux
      "<code>\n</code>" et "<code>\t</code>" pour insérer respectivement
      un passage à la ligne et une tabulation.</p>

      <p>La directive <directive module="mod_log_config">CustomLog</directive>
      définit un nouveau fichier journal en l'associant à l'identité
      précédemment définie. Le chemin du nom de fichier associé au journal
      des accès est relatif au chemin défini par la directive
      <directive module="core">ServerRoot</directive>, sauf s'il
      débute par un slash.</p>

      <p>La configuration ci-dessus va enregistrer les entrées de
      journalisation selon un format connu sous le nom de
      Common Log Format (CLF) pour "Format de journalisation standard".
      Ce format standard peut être produit par de nombreux serveurs web
      différents et lu par de nombreux programmes d'analyse de journaux.
      Les entrées de fichier journal générées selon le format CLF
      ressemblent à ceci :</p>

      <example>
        127.0.0.1 - frank [10/Oct/2000:13:55:36 -0700] "GET
        /apache_pb.gif HTTP/1.0" 200 2326
      </example>

      <p>Chaque partie de cette entrée de journal est décrite
      dans ce qui suit.</p>

      <dl>
        <dt><code>127.0.0.1</code> (<code>%h</code>)</dt>

        <dd>Il s'agit de l'adresse IP du client (l'hôte distant) qui a envoyé
	la requête au serveur. Si la directive
	<directive module="core">HostnameLookups</directive> est positionnée à
	<code>On</code>, le serveur va essayer de déterminer le nom de l'hôte
	et de l'enregistrer à la place de l'adresse IP. Cette configuration
	n'est cependant pas recommandée car elle peut ralentir le serveur de
	manière significative. Il est par conséquent préférable d'utiliser un
	processeur d'analyse de journaux a posteriori
	tel que <program>logresolve</program>
	pour déterminer les noms d'hôte. L'adresse IP indiquée ici n'est pas
	nécessairement l'adresse IP de la machine devant laquelle se trouve
	l'utilisateur. Si un serveur mandataire s'intercale entre le serveur
	et l'utilisateur, l'adresse indiquée sera celle du mandataire et non
	celle de la machine à l'origine de la requête.</dd>

        <dt><code>-</code> (<code>%l</code>)</dt>

        <dd>Le "trait d'union" indique que la portion d'information
	correspondante n'est pas disponible. Dans le cas présent, l'information
	non disponible est l'identité (RFC 1413) du client telle que déterminée
	par <code>identd</code> sur la machine cliente. Cette information est
	très peu fiable et ne devrait jamais être utilisée, sauf dans le cas
	de réseaux internes étroitement contrôlés. Le démon httpd ne cherchera
	d'ailleurs à obtenir cette information que si la directive
	<directive module="mod_ident">IdentityCheck</directive> est positionnée
	à <code>On</code>.</dd>

        <dt><code>frank</code> (<code>%u</code>)</dt>

        <dd>Il s'agit de l'identifiant utilisateur de la personne qui a
	demandé le document, issu d'une authentification HTTP.
	Ce même identifiant est en général fourni aux scripts CGI par
	l'intermédiaire de la valeur de la variable d'environnement
	<code>REMOTE_USER</code>. Si le statut de la requête (voir plus loin)
	est 401, cette identifiant n'est pas fiable car l'utilisateur n'est
	pas encore authentifié. Si le document n'est pas protégé par
	mot de passe, cette partie d'information sera représentée par
	"<code>-</code>", comme la partie précédente.</dd>

        <dt><code>[10/Oct/2000:13:55:36 -0700]</code>
        (<code>%t</code>)</dt>

        <dd>
          L'heure à laquelle la requête a été reçue.
          Le format est le suivant :

          <p class="indent">
            <code>[jour/mois/année:heure:minutes:secondes zone]<br />
             jour = 2*chiffre<br />
             mois = 3*lettre<br />
             année = 4*chiffre<br />
             heure = 2*chiffre<br />
             minutes = 2*chiffre<br />
             secondes = 2*chiffre<br />
             zone = (`+' | `-') 4*chiffre</code>
          </p>Il est possible de modifier le format d'affichage de l'heure
	  en spécifiant <code>%{format}t</code> dans la chaîne de format du
	  journal, où <code>format</code> est une chaîne de format
	  de la forme de celle de la fonction <code>strftime(3)</code>
	  de la bibliothèque C standard, ou choisie parmi les
	  formats spéciaux supportés. Pour plus de détails,
	  reportez-vous aux. <a
	  href="mod/mod_log_config.html#formats">chaînes de format</a>
	  de <module>mod_log_config</module>.
        </dd>

        <dt><code>"GET /apache_pb.gif HTTP/1.0"</code>
        (<code>\"%r\"</code>)</dt>

        <dd>La ligne de la requête du client est placée entre guillemets.
	Elle contient de nombreuses informations utiles. Tout d'abord, la
	méthode utilisée par le client est <code>GET</code>. Ensuite, le
	client a demandé la ressource <code>/apache_pb.gif</code>, et enfin,
	le client a utilisé le protocole <code>HTTP/1.0</code>. Il est aussi
	possible d'enregistrer séparément une ou plusieurs parties de la
	requête. Par exemple, la chaîne de format "<code>%m %U %q %H</code>"
	va enregistrer la méthode, le chemin, la chaîne de la requête et le
	protocole, ce qui donnera le même résultat que
	"<code>%r</code>".</dd>

        <dt><code>200</code> (<code>%&gt;s</code>)</dt>

        <dd>C'est le code de statut que le serveur retourne au client. Cette
	information est très importante car elle indique si la requête a fait
	l'objet d'une réponse positive (codes commençant par 2), une
	redirection (codes commençant par 3), une erreur due au client (codes
	commençant par 4), ou une erreur due au serveur (codes commençant
	par 5). Vous trouverez la liste complète des codes de statut possibles
	dans la <a href="http://www.w3.org/Protocols/rfc2616/
	rfc2616.txt">specification HTTP</a> (RFC2616 section 10).</dd>

        <dt><code>2326</code> (<code>%b</code>)</dt>

        <dd>La dernière partie indique la taille de l'objet retourné au client,
	en-têtes non compris. Si aucun contenu n'a été retourné au client, cette
	partie contiendra "<code>-</code>". Pour indiquer l'absence de contenu
	par "<code>0</code>", utilisez <code>%B</code> au lieu de
	<code>%b</code>.</dd>
      </dl>
    </section>

    <section id="combined">
      <title>Combined Log Format (Format de journalisation combiné)</title>

      <p>Une autre chaîne de format couramment utilisée est le
      "Combined Log Format" (Format de journalisation combiné). Il s'utilise
      comme suit :</p>

      <highlight language="config">
LogFormat "%h %l %u %t \"%r\" %&gt;s %b \"%{Referer}i\" \"%{User-agent}i\"" combined
CustomLog log/access_log combined
      </highlight>

      <p>Ce format est identique au Common Log Format, avec deux champs
      supplémentaires. Chacun de ces deux champs utilise la directive
      commençant par le caractère "%" <code>%{<em>header</em>}i</code>,
      où <em>header</em> peut être n'importe quel en-tête de requête HTTP.
      Avec ce format, le journal des accès se présentera comme suit :</p>

      <example>
        127.0.0.1 - frank [10/Oct/2000:13:55:36 -0700] "GET
        /apache_pb.gif HTTP/1.0" 200 2326
        "http://www.example.com/start.html" "Mozilla/4.08 [en]
        (Win98; I ;Nav)"
      </example>

      <p>Les champs supplémentaires sont :</p>

      <dl>
        <dt><code>"http://www.example.com/start.html"</code>
        (<code>\"%{Referer}i\"</code>)</dt>

        <dd>L'en-tête "Referer" (sic) de la requête HTTP. Il indique le site
	depuis lequel le client prétend avoir lancé sa requête. (Ce doit être
	la page qui contient un lien vers <code>/apache_pb.gif</code> ou
	inclut ce dernier fichier).</dd>

        <dt><code>"Mozilla/4.08 [en] (Win98; I ;Nav)"</code>
        (<code>\"%{User-agent}i\"</code>)</dt>

        <dd>L'en-tête User-Agent de la requête HTTP. C'est une information
	d'identification que le navigateur du client envoie à propos
	de lui-même.</dd>
      </dl>
    </section>

    <section id="multiple">
      <title>Journaux d'accès multiples</title>

      <p>Plusieurs journaux d'accès peuvent être créés en spécifiant tout
      simplement plusieurs directives
      <directive module="mod_log_config">CustomLog</directive> dans le
      fichier de configuration. Par exemple, les directives suivantes vont
      créer trois journaux d'accès. Le premier contiendra les informations
      de base CLF, le second les informations du Referer, et le troisième
      les informations sur le navigateur. Les deux dernières directives
      <directive module="mod_log_config">CustomLog</directive> montrent
      comment simuler les effets des directives <code>ReferLog</code> et
      <code>AgentLog</code>.</p>

      <highlight language="config">
LogFormat "%h %l %u %t \"%r\" %&gt;s %b" common
CustomLog logs/access_log common
CustomLog logs/referer_log "%{Referer}i -&gt; %U"
CustomLog logs/agent_log "%{User-agent}i"
      </highlight>

      <p>Cet exemple montre aussi qu'il n'est pas obligatoire d'associer
      une chaîne de format à un alias au moyen de la directive
      <directive module="mod_log_config">LogFormat</directive>. Elle peut
      être définie directement dans la ligne de la directive
      <directive module="mod_log_config">CustomLog</directive>.</p>
    </section>

    <section id="conditional">
      <title>Journalisation conditionnelle</title>

      <p>Il est parfois souhaitable d'exclure certaines entrées des journaux
      d'accès en fonction des caractéristiques de la requête du client. On
      peut aisément accomplir ceci à l'aide des
      <a href="env.html">variables d'environnement</a>. Tout d'abord, une
      variable d'environnement doit être définie pour indiquer que la
      requête remplit certaines conditions. Pour ceci, on utilise en général
      la directive <directive module="mod_setenvif">SetEnvIf</directive>,
      puis la clause <code>env=</code> de la directive
      <directive module="mod_log_config">CustomLog</directive> pour inclure
      ou exclure les requêtes pour lesquelles
      la variable d'environnement est définie.
      Quelques exemples :</p>

      <highlight language="config">
# Marque les requêtes en provenance de l'interface loop-back
SetEnvIf Remote_Addr "127\.0\.0\.1" dontlog
# Marque les requêtes pour le fichier robots.txt
SetEnvIf Request_URI "^/robots\.txt$" dontlog
# Journalise toutes les autres requêtes
CustomLog logs/access_log common env=!dontlog
      </highlight>

      <p>Autre exemple, imaginons l'enregistrement des requêtes en provenance
      d'utilisateurs de langue anglaise dans un journal, et celles des autres
      utilisateurs dans un autre journal.</p>

      <highlight language="config">
        SetEnvIf Accept-Language "en" english
        CustomLog logs/english_log common env=english
        CustomLog logs/non_english_log common env=!english
      </highlight>

	<p>Dans le contexte d'une mise en cache, il peut être
	intéressant de connaître l'efficacité du cache. Pour y parvenir,
	on pourrait utiliser cette méthode simple :</p>

      <highlight language="config">
SetEnv CACHE_MISS 1
LogFormat "%h %l %u %t "%r " %>s %b %{CACHE_MISS}e" common-cache
CustomLog logs/access_log common-cache
      </highlight>

      <p><module>mod_cache</module> va s'exécuter avant
      <module>mod_env</module>, et si son action est couronnée de
      succès, il délivrera le contenu sans faire appel à ce dernier. Si
      l'URL se trouve dans le cache, la valeur journalisée sera alors
      <code>-</code>, tandis que dans le cas contraire elle sera
      <code>1</code>.</p>

      <p>En plus de la syntaxe <code>env=</code>, la directive <directive
      module="mod_log_config">LogFormat</directive> supporte les
      valeurs de journalisation conditionnelles basées sur le code de la
      réponse HTTP :</p>

      <highlight language="config">
LogFormat "%400,501{User-agent}i" browserlog
LogFormat "%!200,304,302{Referer}i" refererlog
      </highlight>

      <p>Dans le premier exemple, le <code>User-agent</code> sera
      enregistré si le code d'état HTTP est 400 ou 501. Dans le cas
      contraire, c'est un caractère "-" qui sera enregistré à la place.
      Dans le second exemple, le <code>Referer</code> sera enregistré si
      le code d'état HTTP n'est <strong>pas</strong> 200, 204, ou 302
      (remarquez le caractère "!" avant les codes d'état).</p>

      <p>Bien que nous venions de montrer que la journalisation conditionnelle
      est souple et très puissante, cette méthode de contrôle du contenu des
      journaux n'est pas la seule. Les fichiers journaux sont plus utiles
      quand ils contiennent un enregistrement complet de l'activité du serveur,
      et il est souvent plus aisé de simplement traiter à posteriori les fichiers
      journaux pour supprimer les requêtes que vous ne voulez pas y voir
      apparaître.</p>
    </section>
  </section>

  <section id="rotation">
    <title>Rotation des journaux</title>

    <p>Même dans le cas d'un serveur modérément sollicité, la quantité
    d'informations stockées dans les fichiers journaux est très importante.
    Le fichier journal des accès grossit en général d'1 Mo ou plus toutes
    les 10000 requêtes. Il est par conséquent nécessaire d'effectuer
    périodiquement la rotation des journaux en déplaçant ou supprimant les
    fichiers correspondants. On ne peut pas le faire pendant que le serveur
    est en cours d'exécution, car Apache httpd va continuer à écrire dans l'ancien
    fichier journal aussi longtemps qu'il le maintiendra ouvert.
    C'est pourquoi le serveur doit être
    <a href="stopping.html">redémarré</a> après le déplacement ou la
    suppression des fichiers journaux de façon à ce qu'il en ouvre
    de nouveaux.</p>

    <p>Avec un redémarrage <em>graceful</em>, on peut faire en sorte que le
    serveur ouvre de nouveaux fichiers journaux sans perdre de connexions
    existantes ou en cours avec les clients. Cependant, pour que ceci soit
    possible, le serveur doit continuer à écrire dans les anciens fichiers
    journaux pendant qu'il termine le traitement des requêtes en cours.
    Il est donc nécessaire d'attendre un certain temps après le rédémarrage
    avant d'effectuer tout traitement sur les fichiers journaux. Voici un
    scénario typique dans lequel on effectue une simple rotation des
    journaux en compressant les anciens fichiers correspondants afin
    de gagner de l'espace disque :</p>

    <example>
      mv access_log access_log.old<br />
      mv error_log error_log.old<br />
      apachectl graceful<br />
      sleep 600<br />
      gzip access_log.old error_log.old
    </example>

    <p>La section suivante présente une autre méthode de rotation des journaux
    qui consiste à utiliser les
    <a href="#piped">journaux redirigés</a>.</p>
  </section>

  <section id="piped">
    <title>Journaux redirigés</title>

    <p>Nous avons vu que le démon httpd écrivait les informations de
    journalisation des erreurs et des accès dans un fichier journal ;
    il peut aussi
    rediriger ces informations vers un autre processus par l'intermédiaire d'un
    tube de communication (pipe). Cette fonctionnalité améliore
    considérablement la souplesse de la journalisation, sans ajouter de code
    au serveur principal. Pour rediriger les informations de journalisation
    vers un tube de communication, remplacez simplement le nom de fichier
    journal par
    le caractère pipe "<code>|</code>", suivi du nom de l'exécutable qui va
    recueillir les entrées de journal sur son entrée
    standard. Le serveur va
    lancer le processus de redirection des journaux au moment du démarrage du
    serveur, et le relancera s'il cesse de fonctionner
    pendant l'exécution du serveur.
    (Nous dénommons cette technique "journalisation
    redirigée fiable" grâce à cette dernière fonctionnalité.)</p>

    <p>Les processus de journalisation redirigée sont lancés par le processus
    httpd parent, et héritent de l'UID de ce dernier. Cela signifie que les
    programmes de journalisation dirigée s'exécutent généralement en tant que
    root. Il est donc très important que ces programmes soient simples et
    sécurisés.</p>

    <p>Un des grands avantages de la journalisation redirigée est la possibilité
    d'effectuer la rotation des journaux sans avoir à redémarrer le serveur. Pour
    accomplir cette tâche, le serveur HTTP Apache fournit un programme simple
    appelé <program>rotatelogs</program>. Par exemple, pour une rotation des
    journaux toutes les 24 heures, ajoutez ces lignes :</p>

    <highlight language="config">
      CustomLog "|/usr/local/apache/bin/rotatelogs /var/log/access_log 86400" common
    </highlight>

    <p>Notez que l'ensemble de la commande qui sera appelée par le tube de
    communication a été placée entre guillemets. Bien que cet exemple
    concerne le journal des accès, la même technique peut être utilisée
    pour le journal des erreurs.</p>

    <p>Comme la journalisation conditionnelle, la journalisation redirigée est
    un outil très puissant, mais si elle existe, il est préférable d'utiliser
    une solution plus simple comme le traitement à posteriori hors ligne.</p>


  <p>Par défaut, le processus de redirection du journal est lancé sans
  invoquer un shell. Pour invoquer un shell, utilisez "<code>|$</code>"
  au lieu de "<code>|</code>" (en général avec <code>/bin/sh -c</code>)
  :</p>

    <highlight language="config">
# Invocation de "rotatelogs" en utilisant un shell
CustomLog "|$/usr/local/apache/bin/rotatelogs   /var/log/access_log 86400" common
    </highlight>


    <p>Il s'agissait du comportement par défaut sous Apache 2.2. Selon
    les spécificités du shell, ceci peut générer un processus shell
    supplémentaire pour toute la durée du programme de redirection du
    journal, et induire des problèmes de gestion de signaux au cours du
    redémarrage. La notation "<code>||</code>" est aussi supportée pour
    des raisons de compatibilité avec Apache 2.2 et est équivalente à
    "<code>|</code>".</p>

    <note><title>Note à propos de la plateforme Windows</title>
    <p>Notez que sous Windows, la mémoire allouée au bureau (desktop
    heap) peut devenir insuffisante si vous utilisez de nombreux
    processus vers lesquels sont redirigés des journaux via un pipe, et
    ceci particulièrement si httpd s'exécute en tant que service. La
    quantité de mémoire du bureau allouée à chaque service est spécifiée
    dans le troisième argument du paramètre <code>SharedSection</code>
    de la clé de registre
    HKEY_LOCAL_MACHINE\System\CurrentControlSet\Control\SessionManager\SubSystems\Windows.
    <strong>Modifiez cette valeur avec prudence</strong> ; les
    précautions d'usage s'imposent lorsqu'on modifie la base de registre,
    mais vous pouvez aussi saturer la mémoire du bureau si vous
    spécifiez une valeur trop élevée.</p>
    </note>
    </section>

  <section id="virtualhost">
    <title>Hôtes virtuels</title>

    <p>Lorsqu'un serveur possède plusieurs <a href
    ="vhosts/">hôtes virtuels</a>, il existe de nombreuses solutions pour gérer
    les fichiers journaux. Par exemple, on peut utiliser les journaux comme
    s'il s'agissait d'un serveur avec un seul hôte. Il suffit pour cela de
    placer les directives de journalisation en dehors des sections
    <directive module="core" type="section">VirtualHost</directive> au niveau
    du serveur principal, ce qui a pour effet de journaliser toutes les
    requêtes dans le même journal des accès et des erreurs. Cette technique
    est cependant inappropriée pour recueillir des statistiques sur chaque
    hôte virtuel individuellement.</p>

    <p>Si des directives <directive module=
    "mod_log_config">CustomLog</directive> ou
    <directive module="core">ErrorLog</directive> sont placées dans une section
    <directive module="core" type="section">VirtualHost</directive>, toutes les
    requêtes ou erreurs pour cet hôte virtuel ne seront enregistrées que dans
    le fichier spécifié. Tout hôte virtuel qui ne possède pas de directives de
    journalisation verra ses requêtes enregistrées dans le journal du serveur
    principal. Cette technique est appropriée pour un petit nombre d'hôtes
    virtuels, mais si ce nombre est important, elle peut devenir compliquée à
    gérer. En outre, des problèmes de <a
    href="vhosts/fd-limits.html">nombre de descripteurs
    de fichiers insuffisant</a> peuvent rapidement apparaître.</p>

    <p>Il existe un très bon compromis pour le journal des accès. En intégrant
    les informations à propos de l'hôte virtuel à la chaîne de format du
    journal, il est possible de journaliser tous les hôtes dans le même
    journal, puis de séparer ultérieurement le journal en plusieurs journaux
    individuels. Considérons par exemple les directives suivantes :</p>

    <highlight language="config">
LogFormat "%v %l %u %t \"%r\" %&gt;s %b" comonvhost
CustomLog logs/access_log comonvhost
    </highlight>

    <p>Le champ <code>%v</code> sert à enregistrer le nom de l'hôte virtuel qui
    traite la requête. Un programme tel que <a
    href="programs/split-logfile.html">split-logfile</a> peut ensuite être utilisé
    pour générer "à froid" autant de journaux que d'hôtes virtuels.</p>
  </section>

  <section id="other">
    <title>Autres fichiers journaux</title>

    <related>
      <modulelist>
        <module>mod_logio</module>
	<module>mod_log_config</module>
        <module>mod_log_forensic</module>
        <module>mod_cgi</module>
      </modulelist>
      <directivelist>
        <directive module="mod_log_config">LogFormat</directive>
	<directive module="mod_log_config">BufferedLogs</directive>
        <directive module="mod_log_forensic">ForensicLog</directive>
        <directive module="mpm_common">PidFile</directive>
        <directive module="mod_cgi">ScriptLog</directive>
        <directive module="mod_cgi">ScriptLogBuffer</directive>
        <directive module="mod_cgi">ScriptLogLength</directive>
      </directivelist>
    </related>

    <section>
      <title>Enregistrement du nombre réel d'octets envoyés et reçus</title>

      <p>Le module <module>mod_logio</module> fournit deux champs
      <directive module="mod_log_config">LogFormat</directive> supplémentaires
      (%I et %O) qui permettent d'enregistrer le nombre réel d'octets reçus et
      envoyés sur le réseau.</p>
    </section>

    <section>
      <title>Journalisation de style investigation judiciaire (forensic logging)</title>

      <p>Le module <module>mod_log_forensic</module> permet la journalisation
      à des fins d'investigation judiciaire des requêtes des clients. La
      journalisation est effectuée avant et après le traitement de la requête,
      qui fait donc l'objet de deux entrées dans le journal. Le générateur de
      journaux d'investigation est très strict et ne permet aucune
      personnalisation. C'est un inestimable outil de débogage et de sécurité.</p>
    </section>

    <section id="pidfile">
      <title>Fichier PID</title>

      <p>Au démarrage, le démon httpd Apache enregistre l'identifiant du
      processus httpd parent dans le fichier <code>logs/httpd.pid</code>.
      Le nom de ce fichier peut être modifié à l'aide de la directive
      <directive module="mpm_common">PidFile</directive>. Cet identifiant
      permet à l'administrateur de redémarrer et arrêter le démon en
      envoyant des signaux au processus parent ; sous Windows, vous devez
      utiliser l'option de ligne de commande -k. Pour plus de détails,
      consulter la page <a href="stopping.html">Arrêt et redémarrage</a>.</p>
    </section>

    <section id="scriptlog">
      <title>Journal des scripts</title>

      <p>Afin de faciliter le débogage, la directive
      <directive module="mod_cgi">ScriptLog</directive> vous permet
      d'enregistrer les entrées et sorties des scripts CGI. Elle ne doit être
      utilisée que pendant la phase de test, et en aucun cas sur un
      serveur en production. Vous trouverez plus d'informations dans la
      documentation du module <a href="mod/mod_cgi.html">mod_cgi</a>.</p>
    </section>
    
  </section>
</manualpage>




