<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1869063 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="security_tips.xml.meta">
  <parentdocument href="./">Documentations diverses</parentdocument>

  <title>Conseils sur la sécurité</title>

  <summary>
    <p>Ce document propose quelques conseils et astuces concernant les
    problèmes de sécurité liés
    à l'installation d'un serveur web. Certaines suggestions seront à caractère
    général, tandis que d'autres seront spécifiques à Apache.</p>
  </summary>

  <section id="uptodate"><title>Maintenez votre serveur à jour</title>

    <p>Le serveur HTTP Apache a une bonne réputation en matière de sécurité
    et possède une communauté de développeurs très sensibilisés aux problèmes
    de sécurité. Mais il est inévitable de trouver certains problèmes
    -- petits ou grands -- une fois le logiciel mis à disposition. C'est pour
    cette raison qu'il est crucial de se tenir informé des mises à jour. Si
    vous avez obtenu votre version du serveur HTTP directement depuis Apache,
    nous vous conseillons grandement de vous abonner à la <a
    href="http://httpd.apache.org/lists.html#http-announce">Liste de diffusion
    des annonces du serveur HTTP</a> qui vous informera de
    la parution des nouvelles versions et des mises à jour de sécurité. La
    plupart des distributeurs tiers d'Apache fournissent des services
    similaires.</p>

    <p>Gardez cependant à l'esprit que lorsqu'un serveur web est compromis, le
    code du serveur HTTP n'est la plupart du temps pas en cause. Les problèmes
    proviennent plutôt de code ajouté, de scripts CGI, ou du système
    d'exploitation sous-jacent. Vous devez donc vous tenir informé des
    problèmes et mises à jour concernant tous les logiciels présents sur
    votre système.</p>

  </section>

  <section id="dos">

    <title>Attaques de type "Déni de service"
    (Denial of Service - DoS)</title>

    <p>Tous les services réseau peuvent faire l'objet d'attaques de type
    "Déni de service" qui tentent de les empêcher de répondre aux clients en
    saturant leurs ressources. Il est impossible de se prémunir totalement
    contre ce type d'attaques, mais vous pouvez accomplir certaines actions
    afin de minimiser les problèmes qu'elles créent.</p>

    <p>Souvent, l'outil anti-DoS le plus efficace sera constitué par le
    pare-feu ou certaines configurations du système d'exploitation. Par
    exemple, la plupart des pare-feu peuvent être configurés de façon à
    limiter le nombre de connexions simultanées depuis une adresse IP ou un
    réseau, ce qui permet de prévenir toute une gamme d'attaques simples.
    Bien sûr, ceci n'est d'aucun secours contre les attaques de type
    "Déni de service" distribuées (DDoS).</p>

    <p>Certains réglages de la configuration d'Apache peuvent aussi
    minimiser les problèmes :</p>

    <ul>
      <li>La directive <directive
      module="mod_reqtimeout">RequestReadTimeout</directive> permet de
      limiter le temps que met le client pour envoyer sa requête.</li>

      <li>La valeur de la directive
      <directive module="core">TimeOut</directive> doit être diminuée sur les
      sites sujets aux attaques DoS. Une valeur de quelques secondes devrait
      convenir. Cependant, comme <directive module="core">TimeOut</directive>
      est actuellement concerné par de nombreuses opérations différentes, lui
      attribuer une valeur trop faible peut provoquer des problèmes avec les
      scripts CGI qui présentent un long temps de réponse.</li>

      <li>La valeur de la directive
      <directive module="core">KeepAliveTimeout</directive> doit aussi être
      diminuée sur les sites sujets aux attaques DoS. Certains sites
      désactivent même complètement le "maintien en vie" (keepalives)
      à l'aide de la directive
      <directive module="core">KeepAlive</directive>, ce qui bien sûr
      présente des inconvénients en matière de performances.</li>

      <li>Les valeurs des différentes directives fournies par d'autres modules
      et en rapport avec des délais doivent aussi être vérifiées.</li>

      <li>Les directives
      <directive module="core">LimitRequestBody</directive>,
      <directive module="core">LimitRequestFields</directive>,
      <directive module="core">LimitRequestFieldSize</directive>,
      <directive module="core">LimitRequestLine</directive>, et
      <directive module="core">LimitXMLRequestBody</directive> doivent être
      configurées avec prudence afin de limiter la consommation de ressources
      induite par les demandes des clients.
      </li>

      <li>Sur les systèmes d'exploitation qui le supportent, assurez-vous que
      la directive <directive module="core">AcceptFilter</directive> est
      activée afin de déléguer une partie du traitement des requêtes au
      système d'exploitation. Elle est activée par défaut dans le démon httpd
      d'Apache, mais peut nécessiter une reconfiguration de votre noyau.</li>

      <li>Optimisez la directive <directive
      module="mpm_common">MaxRequestWorkers</directive> de façon à définir le nombre
      maximum de connexions simultanées au dessus duquel les ressources
      s'épuisent. Voir aussi la <a
      href="perf-tuning.html">documentation sur l'optimisation des
      performances</a>.</li>

      <li>L'utilisation d'un <a href="../mpm.html">module mpm</a> threadé
      vous permet de traiter d'avantage de connexions simultanées, ce qui
      minimise l'effet des attaques DoS. Dans le futur, le module mpm
      <module>event</module> utilisera un traitement asynchrone afin de ne pas
      dédier un thread à chaque connexion. De par la
      nature de la bibliothèque OpenSSL, le module mpm <module>event</module> est actuellement incompatible
      avec le module <module>mod_ssl</module> ainsi que d'autres filtres
      en entrée. Dans ces cas, son comportement se ramène à celui
      du module mpm <module>worker</module>.</li>

      <li>Il existe de nombreux modules tiers disponibles à <a
      href="http://modules.apache.org/">http://modules.apache.org/</a> qui
      peuvent retreindre les comportements de certains clients et ainsi
      minimiser les problèmes de DoS.</li>

    </ul>

  </section>


  <section id="serverroot">

    <title>Permissions sur les répertoires de la racine du serveur</title>

    <p>Typiquement, Apache est démarré par l'utilisateur root, puis il devient
    la propriété de l'utilisateur défini par la directive <directive
    module="mod_unixd">User</directive> afin de répondre aux demandes. Comme
    pour toutes les commandes exécutées par root, vous devez vous assurer
    qu'elle n'est pas modifiable par les utilisateurs autres que root. Les
    fichiers eux-mêmes, mais aussi les répertoires ainsi que leurs parents ne
    doivent être modifiables que par root. Par exemple, si vous avez choisi de
    placer la racine du serveur dans <code>/usr/local/apache</code>, il est conseillé de
    créer le répertoire en tant que root, avec des commandes du style :</p>

    <example>
      mkdir /usr/local/apache <br />
      cd /usr/local/apache <br />
      mkdir bin conf logs <br />
      chown 0 . bin conf logs <br />
      chgrp 0 . bin conf logs <br />
      chmod 755 . bin conf logs
    </example>

    <p>Nous supposerons que <code>/</code>, <code>/usr</code> et
    <code>/usr/local</code> ne sont modifiables que par
    root. Quand vous installez l'exécutable <program>httpd</program>, vous
    devez vous assurer qu'il possède des protections similaires :</p>

    <example>
      cp httpd /usr/local/apache/bin <br />
      chown 0 /usr/local/apache/bin/httpd <br />
      chgrp 0 /usr/local/apache/bin/httpd <br />
      chmod 511 /usr/local/apache/bin/httpd
    </example>

    <p>Vous pouvez créer un sous-répertoire htdocs modifiable par d'autres
    utilisateurs -- car root ne crée ni exécute aucun fichier dans ce
    sous-répertoire.</p>

    <p>Si vous permettez à des utilisateurs non root de modifier des fichiers
    que root écrit ou exécute, vous exposez votre système à une compromission
    de l'utilisateur root. Par exemple, quelqu'un pourrait remplacer le binaire
    <program>httpd</program> de façon à ce que la prochaine fois que vous le
    redémarrerez, il exécutera un code arbitraire. Si le répertoire des
    journaux a les droits en écriture (pour un utilisateur non root), quelqu'un
    pourrait remplacer un fichier journal par un lien symbolique vers un autre
    fichier système, et root pourrait alors écraser ce fichier avec des données
    arbitraires. Si les fichiers journaux eux-mêmes ont des droits en
    écriture (pour un utilisateur non root), quelqu'un pourrait
    modifier les journaux eux-mêmes avec des données fausses.</p>

  </section>

  <section id="ssi">

    <title>Inclusions côté serveur</title>

    <p>Les inclusions côté serveur (Server Side Includes - SSI) exposent
    l'administrateur du serveur à de nombreux risques potentiels en matière de
    sécurité.</p>

    <p>Le premier risque est l'augmentation de la charge du serveur. Tous les
    fichiers où SSI est activé doivent être analysés par Apache, qu'ils
    contiennent des directives SSI ou non. L'augmentation de la charge induite
    est minime, mais peut devenir significative dans le contexte d'un
    serveur partagé.</p>

    <p>Les fichiers SSI présentent les mêmes risques que les scripts CGI en
    général. Les fichiers où SSI est activé peuvent exécuter tout script CGI
    ou autre programme à l'aide de la commande <code>"exec cmd"</code> avec les permissions
    des utilisateur et groupe sous lesquels Apache s'exécute, comme défini
    dans <code>httpd.conf</code>.</p>

    <p>Des méthodes existent pour améliorer la sécurité des fichiers SSI, tout
    en tirant parti des bénéfices qu'ils apportent.</p>

    <p>Pour limiter les dommages qu'un fichier SSI agressif pourrait causer,
    l'administrateur du serveur peut activer<a href="../suexec.html">suexec</a>
    comme décrit dans la section <a href="#cgi">Les CGI en général</a>.</p>

    <p>L'activation des SSI pour des fichiers possédant des extensions
    <code>.html</code> ou
    <code>.htm</code> peut s'avérer dangereux. Ceci est particulièrement vrai dans un
    environnement de serveur partagé ou étant le siège d'un traffic élevé. Les
    fichiers où SSI est activé doivent posséder une extension spécifique, telle
    que la conventionnelle <code>.shtml</code>. Ceci permet de limiter la charge du serveur
    à un niveau minimum et de simplifier la gestion des risques.</p>

    <p>Une autre solution consiste à interdire l'exécution de scripts et
    programmes à partir de pages SSI. Pour ce faire, remplacez
    <code>Includes</code> par <code>IncludesNOEXEC</code> dans la directive
    <directive module="core">Options</directive>. Notez que les utilisateurs
    pourront encore utiliser <code>&lt;--#include virtual="..." --&gt;</code> pour exécuter
    des scripts CGI si ces scripts sont situés dans des répertoires spécifiés
    par une directive
    <directive module="mod_alias">ScriptAlias</directive>.</p>

  </section>

  <section id="cgi">

    <title>Les CGI en général</title>

    <p>Tout d'abord, vous devez toujours garder à l'esprit que vous devez
    faire confiance aux développeurs de scripts ou programmes CGI ainsi qu'à
    vos compétences pour déceler les trous de sécurité potentiels dans les
    CGI, que ceux-ci soient délibérés ou accidentels. Les scripts CGI peuvent
    essentiellement exécuter des commandes arbitraires sur votre système avec
    les droits de l'utilisateur du serveur web, et peuvent par conséquent être
    extrèmement dangereux s'ils ne sont pas vérifiés avec soin.</p>

    <p>Tous les scripts CGI s'exécutent sous le même utilisateur, il peuvent
    donc entrer en conflit (accidentellement ou délibérément) avec d'autres
    scripts. Par exemple, l'utilisateur A hait l'utilisateur B, il écrit donc
    un script qui efface la base de données CGI de l'utilisateur B. Vous pouvez
    utiliser le programme <a href="../suexec.html">suEXEC</a> pour faire en
    sorte que les scripts s'exécutent sous des utilisateurs différents. Ce
    programme est inclus dans la distribution d'Apache depuis la version 1.2
    et est appelé à partir de certaines portions de code du serveur Apache. Une
    autre méthode plus connue est l'utilisation de
    <a href="http://cgiwrap.sourceforge.net/">CGIWrap</a>.</p>

  </section>

  <section id="nsaliasedcgi">

    <title>CGI sans alias de script</title>

    <p>Vous ne devez permettre aux utilisateurs d'exécuter des scripts CGI
    depuis n'importe quel répertoire que dans l'éventualité où :</p>

    <ul>
      <li>Vous faites confiance à vos utilisateurs pour ne pas écrire de
      scripts qui vont délibérément ou accidentellement exposer votre
      système à une attaque.</li>
      <li>Vous estimez que le niveau de sécurité dans les autres parties de
      votre site est si faible qu'un trou de sécurité de plus ou de moins
      n'est pas très important.</li>
      <li>Votre système ne comporte aucun utilisateur, et personne ne visite
      jamais votre site.</li>
    </ul>

  </section>

  <section id="saliasedcgi">

    <title>CGI avec alias de script</title>

    <p>Le confinement des CGI dans des répertoires spécifiques permet à
    l'administrateur de contrôler ce que l'on met dans ces répertoires. Ceci
    est bien entendu mieux sécurisé que les CGI sans alias de script, mais
    seulement à condition que les utilisateurs avec les droits en écriture sur
    les répertoires soient dignes de confiance, et que l'administrateur ait la
    volonté de tester chaque programme ou script CGI à la recherche d'éventuels
    trous de sécurité.</p>

    <p>La plupart des sites choisissent cette approche au détriment des CGI
    sans alias de script.</p>

  </section>

   <section id="dynamic">

  <title>Autres sources de contenu dynamique</title>

  <p>
  Les options de scripting intégrées qui s'exécutent en tant que partie du
  serveur lui-même, comme <code>mod_php</code>, <code>mod_perl</code>,
  <code>mod_tcl</code>, et <code>mod_python</code>,
  s'exécutent sous le même utilisateur que le serveur (voir la directive
  <directive module="mod_unixd">User</directive>), et par conséquent,
  les scripts que ces moteurs exécutent peuvent accéder aux mêmes ressources
  que le serveur. Certains moteurs de scripting peuvent proposer des
  restrictions, mais pour plus de sûreté, il vaut mieux partir du principe
  que ce n'est pas le cas.</p>

  </section>

  <section id="systemsettings">

    <title>Protection de la configuration du système</title>

    <p>Pour contrôler étroitement votre serveur, vous pouvez interdire
    l'utilisation des fichiers <code>.htaccess</code> qui permettent de
    passer outre les fonctionnalités de sécurité que vous avez configurées.
    Voici un moyen pour y parvenir :</p>

    <p>Ajoutez dans le fichier de configuration du serveur</p>

    <highlight language="config">
&lt;Directory "/"&gt;
    AllowOverride None
&lt;/Directory&gt;
    </highlight>

    <p>Ceci interdit l'utilisation des fichiers <code>.htaccess</code> dans
    tous les répertoires, sauf ceux pour lesquels c'est explicitement
    autorisé.</p>

    <p>Notez que c'est la configuration par défaut depuis Apache 2.3.9.</p>

  </section>

  <section id="protectserverfiles">

    <title>Protection par défaut des fichiers du serveur</title>

    <p>Le concept d'accès par défaut est un aspect d'Apache qui est parfois mal
    compris. C'est à dire que, à moins que vous ne changiez explicitement ce
    comportement, si le serveur trouve son chemin vers un fichier en suivant
    les règles normales de correspondance URL - fichier, il peut le retourner
    aux clients.</p>

    <p>Considérons l'exemple suivant :</p>

    <example>
      # cd /; ln -s / public_html <br />
      puis accès à <code>http://localhost/~root/</code>
    </example>

    <p>Ceci permettrait aux clients de parcourir l'ensemble du système de
    fichiers. Pour l'éviter, ajoutez le bloc suivant à la configuration
    de votre serveur :</p>

    <highlight language="config">
&lt;Directory "/"&gt;
    Require all denied
&lt;/Directory&gt;
    </highlight>

    <p>ceci va interdire l'accès par défaut à tous les fichiers du système de
    fichiers. Vous devrez ensuite ajouter les blocs
    <directive module="core">Directory</directive> appropriés correspondant
    aux répertoires auxquels vous voulez autorisez l'accès. Par exemple,</p>

    <highlight language="config">
&lt;Directory "/usr/users/*/public_html"&gt;
    Require all granted
&lt;/Directory&gt;
&lt;Directory "/usr/local/httpd"&gt;
    Require all granted
&lt;/Directory&gt;
    </highlight>

    <p>Portez une attention particulière aux interactions entre les directives
    <directive module="core">Location</directive> et
    <directive module="core">Directory</directive> ; par exemple, si une
    directive <code>&lt;Directory ""/&gt;</code> interdit un accès, une
    directive <code>&lt;Location "/"&gt;</code> pourra passer outre.</p>

    <p>De même, soyez méfiant en jouant avec la directive
    <directive module="mod_userdir">UserDir</directive> ; la positionner à
    <code>"./"</code> aurait le même effet, pour root, que le premier exemple plus haut.
    Nous vous conseillons
    fortement d'inclure la ligne suivante dans le fichier de configuration de
    votre serveur :</p>

    <highlight language="config">UserDir disabled root</highlight>

  </section>

  <section id="watchyourlogs">

    <title>Surveillez vos journaux</title>

    <p>Pour vous tenir informé de ce qui se passe réellement dans votre
    serveur, vous devez consulter vos
    <a href="../logs.html">fichiers journaux</a>. Même si les fichiers journaux
    ne consignent que des évènements qui se sont déjà produits, ils vous
    informeront sur la nature des attaques qui sont lancées contre le serveur
    et vous permettront de vérifier si le niveau de sécurité nécessaire est
    atteint.</p>

    <p>Quelques exemples :</p>

    <example>
      grep -c "/jsp/source.jsp?/jsp/ /jsp/source.jsp??" access_log <br />
      grep "client denied" error_log | tail -n 10
    </example>

    <p>Le premier exemple listera les attaques essayant d'exploiter la
    <a href="http://online.securityfocus.com/bid/4876/info/">vulnérabilité
    d'Apache Tomcat pouvant provoquer la divulgation d'informations par des
    requêtes Source.JSP mal formées</a>, le second donnera la liste des dix
    dernières interdictions client ; par exemple :</p>

    <example>
      [Thu Jul 11 17:18:39 2002] [error] [client foo.example.com] client denied
      by server configuration: /usr/local/apache/htdocs/.htpasswd
    </example>

    <p>Comme vous le voyez, les fichiers journaux ne consignent que ce qui
    s'est déjà produit ; ainsi, si le client a pu accéder au fichier
    <code>.htpasswd</code>, vous devriez avoir quelque chose du style :</p>

    <example>
      foo.example.com - - [12/Jul/2002:01:59:13 +0200] "GET /.htpasswd HTTP/1.1"
    </example>

    <p>dans votre <a href="../logs.html#accesslog">journal des accès</a> ; ce
    qui signifie que vous avez probablement mis en commentaire ce qui suit dans
    le fichier de configuration de votre serveur :</p>

    <highlight language="config">
&lt;Files ".ht*"&gt;
    Require all denied
&lt;/Files&gt;
    </highlight>

  </section>
  <section id="merging">

    <title>Fusion des sections de configuration</title>

    <p>La fusion des sections de configuration est complexe et dépend
    souvent des directives utilisées. Vous devez systématiquement tester
    vos modifications pour vérifier la manière dont les directives sont
    fusionnées.</p>

    <p>Concernant les modules qui n'implémentent aucune logique de
    fusion, comme <module>mod_access_compat</module>, le
    comportement des sections suivantes est tributaire de la présence
    dans ces dernières de directives appartenant à ces modules. La
    configuration est héritée jusqu'à ce qu'une modification soit
    effectuée ; à ce moment, la configuration est <em>remplacée</em> et
    non fusionnée.</p>
  </section>

</manualpage>
