<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1868823:1880372 (outdated) -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="core.xml.meta">

<name>core</name>
<description>Fonctionnalités de base du serveur HTTP Apache toujours
disponibles</description>
<status>Core</status>

<directivesynopsis>
<name>AcceptFilter</name>
<description>Permet d'optimiser la configuration d'une socket pour
l'écoute d'un protocole</description>
<syntax>AcceptFilter <var>protocole</var> <var>filtre
d'acceptation</var></syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet d'effectuer une optimisation de la socket
    d'écoute d'un type de protocole en fonction du système
    d'exploitation. Le but premier est de faire en sorte que le noyau
    n'envoie pas de socket au processus du serveur jusqu'à ce que
    des données soient reçues, ou qu'une requête HTTP complète soit mise
    en tampon. Seuls les <a
    href="http://www.freebsd.org/cgi/man.cgi?query=accept_filter&amp;
    sektion=9">Filtres d'acceptation de FreeBSD</a>, le filtre plus
    primitif <code>TCP_DEFER_ACCEPT</code> sous Linux, et la version
    optimisée d'AcceptEx() de Windows sont actuellement supportés.</p>

    <p>L'utilisation de l'argument <code>none</code> va désactiver tout
    filtre d'acceptation pour ce protocole. Ceci s'avère utile pour les
    protocoles qui nécessitent l'envoi de données par le serveur en
    premier, comme <code>ftp:</code> ou <code>nntp</code>:</p>
    <highlight language="config">
    AcceptFilter nntp none
    </highlight>

    <p>Les noms de protocoles par défaut sont <code>https</code> pour le
    port 443 et <code>http</code> pour tous les autres ports. Pour
    spécifier un autre protocole à utiliser avec un port en écoute,
    ajoutez l'argument <var>protocol</var> à la directive <directive
    module="mpm_common">Listen</directive>.</p>

    <p>Sous FreeBSD, les valeurs par défaut sont :</p>
    <highlight language="config">
AcceptFilter http httpready
AcceptFilter https dataready
    </highlight>

    <p>Le filtre d'acceptation <code>httpready</code> met en tampon des
    requêtes HTTP entières au niveau du noyau. Quand une requête
    entière a été reçue, le noyau l'envoie au serveur. Voir la page de
    manuel de <a
    href="http://www.freebsd.org/cgi/man.cgi?query=accf_http&amp;
    sektion=9">accf_http(9)</a> pour plus de détails. Comme les requêtes
    HTTPS sont chiffrées, celles-ci n'autorisent que le filtre <a
    href="http://www.freebsd.org/cgi/man.cgi?query=accf_data&amp;
    sektion=9">accf_data(9)</a>.</p>

    <p>Sous Linux, les valeurs par défaut sont :</p>
    <highlight language="config">
AcceptFilter http data
AcceptFilter https data
    </highlight>

    <p>Le filtre <code>TCP_DEFER_ACCEPT</code> de Linux ne supporte pas
    la mise en tampon des requêtes http. Toute valeur autre que
    <code>none</code> active le filtre <code>TCP_DEFER_ACCEPT</code>
    pour ce protocole. Pour plus de détails, voir la page de
    manuel Linux de <a
    href="http://man7.org/linux/man-pages/man7/tcp.7.html">tcp(7)</a>.</p>

    <p>Sous Windows, les valeurs par défaut sont :</p>
    <highlight language="config">
AcceptFilter http connect
AcceptFilter https connect
    </highlight>

    <p>Le module MPM pour Windows mpm_winnt utilise la directive
    AcceptFilter comme commutateur de l'API AcceptEx(), et ne supporte
    pas la mise en tampon du protocole http. <code>connect</code>
    utilise l'API AcceptEx(), extrait aussi les adresses réseau finales,
    mais à l'instar de <code>none</code>, la valeur <code>connect</code>
    n'attend pas la transmission des données initiales.</p>

    <p>Sous Windows, <code>none</code> utilise accept() au lieu
    d'AcceptEx(), et ne recycle pas les sockets entre les connexions.
    Ceci s'avère utile pour les interfaces réseau dont le pilote est
    défectueux, ainsi que pour certains fournisseurs de réseau comme les
    pilotes vpn, ou les filtres anti-spam, anti-virus ou
    anti-spyware.</p>

    <note type="warning">
      <title>L'AcceptFilter <code>data</code> (Windows)</title>

      <p>Jusqu'à la version 2.4.23, le filtre d'acceptation <code>data</code>
      attendait que des données aient été transmises et que le tampon de données
      initial et l'adresse réseau finale aient été déterminés par l'invocation
      AcceptEx(). Cette implémentation étant vulnérable à une attaque de type
      denial of service, elle a été désactivée.</p>

      <p>La version actuelle de httpd prend par défaut le filtre
      <code>connect</code> sous Windows, et reprendra la valeur
      <code>data</code> si <code>data</code> est spécifié. Il est fortement
      conseillé aux utilisateurs des versions plus anciennes de définir
      explicitement le filtre <code>connect</code> pour leurs AcceptFilter
      comme indiqué plus haut.</p>
    </note>

</usage>
<seealso><directive module="core">Protocol</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AcceptPathInfo</name>
<description>Les ressources acceptent des informations sous forme d'un
nom de chemin en fin de requête.</description>
<syntax>AcceptPathInfo On|Off|Default</syntax>
<default>AcceptPathInfo Default</default>
<contextlist><context>server config</context>
<context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>

    <p>Cette directive permet de définir si les requêtes contenant des
    informations sous forme d'un nom de chemin suivant le nom d'un
    fichier réel (ou un fichier qui n'existe pas dans un répertoire qui
    existe) doivent être acceptées ou rejetées. Les scripts peuvent
    accéder à cette information via la variable d'environnement
    <code>PATH_INFO</code>.</p>

    <p>Supposons par exemple que <code>/test/</code> pointe vers un
    répertoire qui ne contient que le fichier <code>here.html</code>.
    Les requêtes pour <code>/test/here.html/more</code> et
    <code>/test/nothere.html/more</code> vont affecter la valeur
    <code>/more</code> à la variable d'environnement
    <code>PATH_INFO</code>.</p>

    <p>L'argument de la directive <directive>AcceptPathInfo</directive>
    possède trois valeurs possibles :</p>
    <dl>
    <dt><code>Off</code></dt><dd>Une requête ne sera acceptée que si
    elle correspond à un chemin qui existe. Par conséquent, une requête
    contenant une information de chemin après le nom de fichier réel
    comme <code>/test/here.html/more</code> dans l'exemple ci-dessus
    renverra une erreur "404 NOT FOUND".</dd>

    <dt><code>On</code></dt><dd>Une requête sera acceptée si la partie
    principale du chemin correspond à un fichier existant. Dans
    l'exemple ci-dessus <code>/test/here.html/more</code>, la requête
    sera acceptée si <code>/test/here.html</code> correspond à un nom de
    fichier valide.</dd>

    <dt><code>Default</code></dt><dd>Le traitement des requêtes est
    déterminé par le <a
    href="../handler.html">gestionnaire</a> responsable de la requête.
    Le gestionnaire de base pour les fichiers normaux rejette par défaut
    les requêtes avec <code>PATH_INFO</code>. Les gestionnaires qui
    servent des scripts, comme<a
    href="mod_cgi.html">cgi-script</a> et <a
    href="mod_isapi.html">isapi-handler</a>, acceptent en général par
    défaut les requêtes avec <code>PATH_INFO</code>.</dd>
    </dl>

    <p>Le but premier de la directive <code>AcceptPathInfo</code> est de
    vous permettre de remplacer le choix du gestionnaire d'accepter ou
    de rejeter <code>PATH_INFO</code>. Ce remplacement est nécessaire
    par exemple, lorsque vous utilisez un <a
    href="../filter.html">filtre</a>, comme <a
    href="mod_include.html">INCLUDES</a>, pour générer un contenu basé
    sur <code>PATH_INFO</code>. Le gestionnaire de base va en général
    rejeter la requête, et vous pouvez utiliser la configuration
    suivante pour utiliser un tel script :</p>
<highlight language="config">
&lt;Files "mypaths.shtml"&gt;
  Options +Includes
  SetOutputFilter INCLUDES
  AcceptPathInfo On
&lt;/Files&gt;
    </highlight>
    

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AccessFileName</name>
<description>Nom du fichier de configuration distribué</description>
<syntax>AccessFileName <var>nom-du-fichier</var>
[<var>nom-du-fichier</var>] ...</syntax>
<default>AccessFileName .htaccess</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>Au cours du traitement d'une requête, le serveur recherche le
    premier fichier de configuration existant à partir de la liste
    de noms dans chaque répertoire composant le chemin du document, à
    partir du moment où les fichiers de configuration distribués sont <a
    href="#allowoverride">activés pour ce répertoire</a>. Par exemple
    :</p>

    <highlight language="config">AccessFileName .acl</highlight>

    <p>avant de renvoyer le document
    <code>/usr/local/web/index.html</code>, le serveur va rechercher les
    fichiers <code>/.acl</code>, <code>/usr/.acl</code>,
    <code>/usr/local/.acl</code> et <code>/usr/local/web/.acl</code>
    pour y lire d'éventuelles directives, à moins quelles n'aient été
    désactivées avec</p>

    <highlight language="config">
&lt;Directory "/"&gt;
    AllowOverride None
&lt;/Directory&gt;
    </highlight>
</usage>
<seealso><directive module="core">AllowOverride</directive></seealso>
<seealso><a href="../configuring.html">Fichiers de configuration</a></seealso>
<seealso><a href="../howto/htaccess.html">Fichiers .htaccess</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AddDefaultCharset</name>
<description>Paramètre jeu de caractères par défaut à ajouter quand le
type de contenu d'une réponse est <code>text/plain</code> ou
<code>text/html</code></description>
<syntax>AddDefaultCharset On|Off|<var>jeu de caractères</var></syntax>
<default>AddDefaultCharset Off</default>
<contextlist><context>server config</context>
<context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>Cette directive spécifie une valeur par défaut pour le paramètre
    jeu de caractères du type de média (le nom d'un codage de
    caractères) à ajouter à une réponse, si et seulement si le type de
    contenu de la réponse est soit <code>text/plain</code>, soit
    <code>text/html</code>. Ceci va remplacer
    tout jeu de caractères spécifié dans le corps de la réponse via un
    élément <code>META</code>, bien que cet effet dépende en fait
    souvent de la configuration du client de l'utilisateur. La
    définition de <code>AddDefaultCharset Off</code> désactive cette
    fonctionnalité. <code>AddDefaultCharset On</code> ajoute un jeu de
    caractères par défaut de <code>iso-8859-1</code>. Toute autre valeur
    peut être définie via le paramètre <var>jeu de caractères</var>, qui
    doit appartenir à la liste des <a
    href="http://www.iana.org/assignments/character-sets">valeurs de
    jeux de caractères enregistrés par l'IANA</a> à utiliser dans les
    types de média Internet (types MIME).
    Par exemple :</p>

    <highlight language="config">AddDefaultCharset utf-8</highlight>

    <p>La directive <directive>AddDefaultCharset</directive> ne doit
    être utilisée que lorsque toutes les ressources textes auxquelles
    elle s'applique possèdent le jeu de caractère spécifié, et qu'il est
    trop contraignant de définir leur jeu de caractères
    individuellement. Un exemple de ce type est l'ajout du paramètre jeu
    de caractères aux ressources comportant un contenu généré, comme les
    scripts CGI hérités qui peuvent être vulnérables à des attaques de
    type cross-site scripting à cause des données utilisateurs incluses
    dans leur sortie. Notez cependant qu'une meilleur solution consiste
    à corriger (ou supprimer) ces scripts, car la définition d'un jeu de
    caractères par défaut ne protège pas les utilisateurs qui ont activé
    la fonctionnalité "Détection automatique de l'encodage des
    caractères" dans leur navigateur.</p>
</usage>
<seealso><directive module="mod_mime">AddCharset</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AllowEncodedSlashes</name>
<description>Détermine si les séparateurs de chemin encodés sont
autorisés à transiter dans les URLs tels quels</description>
<syntax>AllowEncodedSlashes On|Off|NoDecode</syntax>
<default>AllowEncodedSlashes Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>
<compatibility>L'option NoDecode est disponible depuis la version
2.3.12.</compatibility>

<usage>
    <p>La directive <directive>AllowEncodedSlashes</directive> permet
    l'utilisation des URLs contenant des séparateurs de chemin
    encodés dans la partie chemin
    (<code>%2F</code> pour <code>/</code> et même <code>%5C</code> pour
    <code>\</code> sur les systèmes concernés).</p>

    <p>Avec la valeur par défaut, <code>Off</code>, de telles URLs sont
    refusées et provoquent le renvoi d'une erreur 404 (Not found).</p>

    <p>Avec la valeur <code>On</code>, ces URLs sont acceptées, et les
    slashes encodés sont décodés comme tout autre caractère codé.</p>

    <p>Avec la valeur <code>NoDecode</code>, ces URLs sont acceptées,
    mais les slashes codés ne sont pas décodés et laissés dans leur état
    codé.</p>

    <p>Définir <directive>AllowEncodedSlashes</directive> à
    <code>On</code> est surtout utile en association avec
    <code>PATH_INFO</code>.</p>

    <note><title>Note</title>
      <p>Si le codage des slashes dans la partie chemin est nécessaire,
      l'utilisation de l'option <code>NoDecode</code> est fortement
      recommandée par mesure de sécurité. Permettre le décodage des
      slashes pourrait éventuellement induire l'autorisation de chemins
      non sûrs.</p>
    </note>
</usage>
<seealso><directive module="core">AcceptPathInfo</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AllowOverride</name>
<description>Types de directives autorisées dans les fichiers
<code>.htaccess</code></description>
<syntax>AllowOverride All|None|<var>type directive</var>
[<var>type directive</var>] ...</syntax>
<default>AllowOverride None à partir de la version 2.3.9, AllowOverride
All pour les versions antérieures</default>
<contextlist><context>directory</context></contextlist>

<usage>
    <p>Lorsque le serveur trouve un fichier <code>.htaccess</code> (dont
    le nom est défini par la directive <directive
    module="core">AccessFileName</directive>), il doit savoir lesquelles
    des directives placées dans ce fichier sont autorisées à modifier la
    configuration préexistante.</p>

    <note><title>Valable seulement dans les sections
    &lt;Directory&gt;</title>
    La directive <directive>AllowOverride</directive> ne peut être
    utilisée que dans les sections <directive type="section"
    module="core">Directory</directive> définies sans expressions
    rationnelles, et non dans les sections <directive
    type="section" module="core">Location</directive>, <directive
    module="core" type="section">DirectoryMatch</directive> ou
    <directive type="section" module="core">Files</directive>.
    </note>

    <p>Lorsque cette directive et la directive <directive
    module="core">AllowOverrideList</directive> sont définies à <code>None</code>, les
    fichiers <a href="#accessfilename">.htaccess</a> sont totalement
    ignorés. Dans ce cas, le serveur n'essaiera même pas de lire les
    fichiers <code>.htaccess</code> du système de fichiers.</p>

    <p>Lorsque cette directive est définie à <code>All</code>, toute
    directive valable dans le <a
    href="directive-dict.html#Context">Contexte</a> .htaccess sera
    autorisée dans les fichiers <code>.htaccess</code>.</p>

    <p>L'argument <var>type directive</var> peut contenir les
    groupements de directives suivants (voir <a href="overrides.html">ce
    document</a> pour obtenir la liste à jour des directives activées pour
    chaque type de directive) :</p>

    <dl>
      <dt><a href="overrides.html#override-authconfig">AuthConfig</a></dt>

      <dd>

      Permet l'utilisation des directives d'autorisation (<directive
      module="mod_authz_dbm">AuthDBMGroupFile</directive>,
      <directive module="mod_authn_dbm">AuthDBMUserFile</directive>,
      <directive module="mod_authz_groupfile">AuthGroupFile</directive>,
      <directive module="mod_authn_core">AuthName</directive>,
      <directive module="mod_authn_core">AuthType</directive>, <directive
      module="mod_authn_file">AuthUserFile</directive>, <directive
      module="mod_authz_core">Require</directive>, <em>etc...</em>).</dd>

      <dt><a href="overrides.html#override-fileinfo">FileInfo</a></dt>

      <dd>
      Permet l'utilisation des directives qui contrôlent les types de
      documents (directives  <directive
      module="core">ErrorDocument</directive>, <directive
      module="core">ForceType</directive>, <directive
      module="mod_negotiation">LanguagePriority</directive>,
      <directive module="core">SetHandler</directive>, <directive
      module="core">SetInputFilter</directive>, <directive
      module="core">SetOutputFilter</directive>, et directives du
      module <module>mod_mime</module> Add* et Remove*), des metadonnées
      des documents (<directive
      module="mod_headers">Header</directive>, <directive
      module="mod_headers">RequestHeader</directive>, <directive
      module="mod_setenvif">SetEnvIf</directive>, <directive
      module="mod_setenvif">SetEnvIfNoCase</directive>, <directive
      module="mod_setenvif">BrowserMatch</directive>, <directive
      module="mod_usertrack">CookieExpires</directive>, <directive
      module="mod_usertrack">CookieDomain</directive>, <directive
      module="mod_usertrack">CookieStyle</directive>, <directive
      module="mod_usertrack">CookieTracking</directive>, <directive
      module="mod_usertrack">CookieName</directive>), des directives du
      module <module>mod_rewrite</module> directives (<directive
      module="mod_rewrite">RewriteEngine</directive>, <directive
      module="mod_rewrite">RewriteOptions</directive>, <directive
      module="mod_rewrite">RewriteBase</directive>, <directive
      module="mod_rewrite">RewriteCond</directive>, <directive
      module="mod_rewrite">RewriteRule</directive>), des directives du
      module <module>mod_alias</module> directives (<directive
      module="mod_alias">Redirect</directive>, <directive
      module="mod_alias">RedirectTemp</directive>, <directive
      module="mod_alias">RedirectPermanent</directive>, <directive
      module="mod_alias">RedirectMatch</directive>), et de la directive
      <directive module="mod_actions">Action</directive> du module
      <module>mod_actions</module>.
      </dd>

      <dt><a href="overrides.html#override-indexes">Indexes</a></dt>

      <dd>
      Permet l'utilisation des directives qui contrôlent l'indexation
      des répertoires (<directive
      module="mod_autoindex">AddDescription</directive>,
      <directive module="mod_autoindex">AddIcon</directive>, <directive
      module="mod_autoindex">AddIconByEncoding</directive>,
      <directive module="mod_autoindex">AddIconByType</directive>,
      <directive module="mod_autoindex">DefaultIcon</directive>, <directive
      module="mod_dir">DirectoryIndex</directive>, <a
      href="mod_autoindex.html#indexoptions.fancyindexing"><code>FancyIndexing</code></a>,
      <directive
      module="mod_autoindex">HeaderName</directive>, <directive
      module="mod_autoindex">IndexIgnore</directive>, <directive
      module="mod_autoindex">IndexOptions</directive>, <directive
      module="mod_autoindex">ReadmeName</directive>,
      <em>etc...</em>).</dd>

      <dt><a href="overrides.html#override-limit">Limit</a></dt>

      <dd>
      Permet l'utilisation des directives contrôlant l'accès au serveur
      (<directive
      module="mod_access_compat">Allow</directive>, <directive
      module="mod_access_compat">Deny</directive> et <directive
      module="mod_access_compat">Order</directive>).</dd>

      <dt>Nonfatal=[Override|Unknown|All]</dt>

      <dd>
      Permet d'utiliser l'option AllowOverride pour rendre les erreurs
      de syntaxe non fatales dans les fichiers .htaccess : au lieu de
      causer une Internal Server Error, les directives non autorisées ou
      non reconnues seront ignorées et un avertissement enregistré dans
      le journal :
      <ul>
          <li><strong>Nonfatal=Override</strong> rend les directives
	  interdite par AllowOverride non fatales.</li>
          <li><strong>Nonfatal=Unknown</strong> rend les directives
	  inconnues non fatales. Sont concernées les erreurs de frappe
	  et les directives implémentées par un module non chargé.</li>
          <li><strong>Nonfatal=All</strong> rend toutes les directives
	  précédentes non fatales.</li>
      </ul>
      <p>Notez qu'une erreur de syntaxe dans une directive valide
      causera toujours une internal server error.</p>
      <note type="warning"><title>Sécurité</title>
          Les erreurs non fatales peuvent être à l'origine de problèmes
	  de sécurité pour les utilisateurs de fichiers .htaccess. Par
	  exemple, si AllowOverride interdit AuthConfig, toute
	  configuration utilisateur destinée à restreindre l'accès à un
	  site ne sera pas prise en compte.
      </note>
      </dd>

      <dt><a href="overrides.html#override-options">Options</a>[=<var>Option</var>,...]</dt>

      <dd>
      Permet l'utilisation des directives contrôlant les fonctionnalités
      spécifiques d'un répertoire (<directive
      module="core">Options</directive> et <directive
      module="mod_include">XBitHack</directive>). "Options" doit être
      suivi d'un signe "égal", puis d'une liste d'options séparées par des
      virgules (pas d'espaces) ; ces options doivent être définies à
      l'aide de la commande <directive
      module="core">Options</directive>.

      <note><title>Désactivation implicite des options</title>
      <p>Bien que la liste des options disponibles dans les fichiers
      .htaccess puisse être limitée par cette directive, tant qu'un
      directive <directive module="core">Options</directive> est
      autorisée, toute autre option héritée peut être désactivée en
      utilisant la syntaxe non-relative. En d'autres termes, ce
      mécanisme ne peut pas forcer une option spécifique à rester
      <em>activée</em> tout en permettant à toute autre option d'être
      activée.
      </p></note>

      <example>
      AllowOverride Options=Indexes,MultiViews
      </example>
      
      </dd>
    </dl>

    <p>Exemple :</p>

    <highlight language="config">AllowOverride AuthConfig Indexes</highlight>

    <p>Dans l'exemple ci-dessus, toutes les directives qui ne font
    partie ni du groupe <code>AuthConfig</code>, ni du groupe
    <code>Indexes</code>, provoquent une erreur "internal
    server error".</p>

    <note><p>Pour des raisons de sécurité et de performance, ne
    définissez pas <code>AllowOverride</code> à autre chose que
    <code>None</code> dans votre bloc <code>&lt;Directory "/"&gt;</code>.
    Recherchez plutôt (ou créez) le bloc <code>&lt;Directory&gt;</code>
    qui se réfère au répertoire où vous allez précisément placer un
    fichier <code>.htaccess</code>.</p>
    </note>
</usage>
<seealso><directive module="core">AccessFileName</directive></seealso>
<seealso><directive module="core">AllowOverrideList</directive></seealso>
<seealso><a href="../configuring.html">Fichiers de configuration</a></seealso>
<seealso><a href="../howto/htaccess.html">Fichiers .htaccess</a></seealso>
<seealso><a href="overrides.html">Override Class Index for .htaccess</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AllowOverrideList</name>
<description>Directives autorisées dans les fichiers <code>.htaccess</code></description>
<syntax>AllowOverrideList None|<var>directive</var>
[<var>directive-type</var>] ...</syntax>
<default>AllowOverrideList None</default>
<contextlist><context>directory</context></contextlist>

<usage>
    <p>Lorsque le serveur trouve un fichier <code>.htaccess</code>
    (comme spécifié par la directive <directive
    module="core">AccessFileName</directive>), il doit savoir lesquelles
    des directives déclarées dans ce fichier peuvent remplacer des
    directives des fichiers de configuration du serveur.</p>

    <note><title>Seulement disponible dans les sections &lt;Directory&gt;</title>
    La directive <directive>AllowOverrideList</directive> n'est
    disponible que dans les sections <directive type="section"
    module="core">Directory</directive> spécifiées sans expressions
    rationnelles.
    </note>

    <p>Lorsque cette directive et la directive <directive
    module="core">AllowOverride</directive> sont définies à
    <code>None</code>, les fichiers <a
    href="#accessfilename">.htaccess</a> sont totalement ignorés. Dans
    ce cas, le serveur ne cherchera même pas à lire des fichiers
    <code>.htaccess</code> dans le système de fichiers.</p>

    <p>Example:</p>

    <highlight language="config">
AllowOverride None
AllowOverrideList Redirect RedirectMatch
    </highlight>

    <p>Dans l'exemple ci-dessus, seules les directives
    <code>Redirect</code> et <code>RedirectMatch</code> sont autorisées.
    Toutes les autres provoqueront une erreur interne du serveur.</p>

    <p>Example:</p>

    <highlight language="config">
AllowOverride AuthConfig
AllowOverrideList CookieTracking CookieName
    </highlight>

    <p>Dans l'exemple ci-dessus, la directive <directive
    module="core">AllowOverride</directive> autorise les directives du
    groupement <code>AuthConfig</code>, et
    <directive>AllowOverrideList</directive> n'autorise que deux
    directives du groupement <code>FileInfo</code>. Toutes les autres
    provoqueront une erreur interne du serveur.</p>
</usage>

<seealso><directive module="core">AccessFileName</directive></seealso>
<seealso><directive module="core">AllowOverride</directive></seealso>
<seealso><a href="../configuring.html">Fichiers de configuration</a></seealso>
<seealso><a href="../howto/htaccess.html">Fichiers .htaccess</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>CGIMapExtension</name>
<description>Technique permettant de localiser l'interpréteur des
scripts CGI</description>
<syntax>CGIMapExtension <var>chemin CGI</var> <var>.extension</var></syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>
<compatibility>NetWare uniquement</compatibility>

<usage>
    <p>Cette directive permet de contrôler la manière dont Apache httpd trouve
    l'interpréteur servant à exécuter les scripts CGI. Par exemple, avec
    la définition <code>CGIMapExtension sys:\foo.nlm .foo</code>, tous
    les fichiers scripts CGI possédant une extension <code>.foo</code>
    seront passés à l'interpréteur FOO.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CGIPassAuth</name>
<description>Active la transmission d'en-têtes d'autorisation HTTP aux scripts en
tant que variables CGI</description>
<syntax>CGIPassAuth On|Off</syntax>
<default>CGIPassAuth Off</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>
<compatibility>Disponible à partir de la version 2.4.13 du serveur HTTP
Apache</compatibility>

<usage>
    <p>La directive <directive>CGIPassAuth</directive> permet aux
    scripts d'accéder aux en-têtes d'autorisation HTTP tels que
    <code>Authorization</code>, en-tête nécessaire aux scripts qui
    implémente une authentification HTTP de base. Normalement, ces
    en-têtes HTTP sont invisibles pour les scripts car ils leurs
    permettraient de voir les identifiants et mots de passe
    utilisés pour accéder au serveur lorsque l'authentification HTTP de
    base est activée au niveau du serveur web. Cette directive doit être
    définie à "On" lorsque des scripts sont autorisés à implémenter une
    authentification HTTP de base.</p>

    <p>Cette directive constitue une alternative à l'option de
    compilation <code>SECURITY_HOLE_PASS_AUTHORIZATION</code> qui était
    déjà disponible dans les versions précédentes du serveur HTTP
    Apache.</p>

    <p>Cette option est prise en compte par tout module qui utilise
    <code>ap_add_common_vars()</code>, comme <module>mod_cgi</module>,
    <module>mod_cgid</module>, <module>mod_proxy_fcgi</module>,
    <module>mod_proxy_scgi</module>, etc... En particulier, elle affecte
    les modules qui ne traitent pas à proprement parler les requêtes,
    mais utilisent quand-même cette API, comme
    <module>mod_include</module> ou <module>mod_ext_filter</module>. Les
    modules tiers qui n'utilisent pas <code>ap_add_common_vars()</code>
    peuvent aussi choisir de prendre en compte cette option.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CGIVar</name>
<description>Contrôle la manière dont certaines variables CGI sont définies</description>
<syntax>CGIVar <var>variable</var> <var>rule</var></syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>
<compatibility>Disponible à partir de la version 2.4.21 du serveur HTTP Apache</compatibility>

<usage>
  <p>Cette directive permet de contrôler la manière dont certaines variables CGI
  sont définies.</p>

  <p>règles <strong>REQUEST_URI</strong> :</p>
  <dl>
    <dt><code>original-uri</code> (valeur par défaut)</dt>
    <dd>La valeur est extraite de la requête originale, et ne tient pas compte
    des redirections internes ou des sous-requêtes qui pourraient modifier la
    ressource demandée.</dd>
    <dt><code>current-uri</code></dt>
    <dd>La valeur reflète la ressource en cours de traitement ; elle peut être
    différente de la ressource demandée dans la requête initiale du client suite à
    d'éventuelles redirections internes ou sous-requêtes.</dd>
  </dl>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ContentDigest</name>
<description>Active la génération d'un en-tête <code>Content-MD5</code>
dans la réponse HTTP</description>
<syntax>ContentDigest On|Off</syntax>
<default>ContentDigest Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>Options</override>
<status>Expérimental</status>

<usage>
    <p>Cette directive active la génération d'un en-tête
    <code>Content-MD5</code> selon les définitions des RFC 1864 et
    2616.</p>

    <p>MD5 est un algorithme permettant de générer un condensé (parfois
    appelé "empreinte") à partir de données d'une taille aléatoire ; le
    degré de précision est tel que la moindre altération des données
    d'origine entraîne une altération de l'empreinte.</p>

    <p>L'en-tête <code>Content-MD5</code> permet de vérifier
    l'intégrité de la réponse HTTP dans son ensemble. Un serveur mandataire
    ou un client peut utiliser cet en-tête pour rechercher une
    éventuelle modification accidentelle de la réponse au cours de sa
    transmission. Exemple d'en-tête :</p>

    <example>
      Content-MD5: AuLb7Dp1rqtRtxz2m9kRpA==
    </example>

    <p>Notez que des problèmes de performances peuvent affecter votre
    serveur, car l'empreinte est générée pour chaque requête (il n'y a
    pas de mise en cache).</p>

    <p>L'en-tête <code>Content-MD5</code> n'est envoyé qu'avec les
    documents servis par le module <module>core</module>, à l'exclusion
    de tout autre module. Ainsi, les documents SSI, les sorties de
    scripts CGI, et les réponses à des requêtes partielles (byte range)
    ne comportent pas cet en-tête.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>DefaultRuntimeDir</name>
<description>Répertoire de base des fichiers créés au cours de l'exécution du serveur</description>
<syntax>DefaultRuntimeDir <var>chemin-répertoire</var></syntax>
<default>DefaultRuntimeDir DEFAULT_REL_RUNTIMEDIR (logs/)</default>
<contextlist><context>server config</context></contextlist>
<compatibility>Disponible depuis la version 2.4.2 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive>DefaultRuntimeDir</directive> permet de
    définir le répertoire dans lequel le serveur va créer les différents
    fichiers relatifs à son exécution (mémoire partagée, verrous,
    etc...). Si le chemin spécifié est relatif, le chemin absolu sera
    généré relativement à la valeur de la directive
    <directive>ServerRoot</directive></p>

    <p><strong>Example</strong></p>
   <highlight language="config">
DefaultRuntimeDir scratch/
    </highlight>

    <p>La valeur par défaut de la directive
    <directive>DefaultRuntimeDir</directive> peut être modifiée en
    changeant la valeur de la macro <code>DEFAULT_REL_RUNTIMEDIR</code>
    définie à la compilation.</p>

   <p>Note: si la valeur de <directive>ServerRoot</directive> n'a pas
   été spécifiée avant d'utiliser cette directive, c'est la valeur par
   défaut de <directive>ServerRoot</directive> qui sera utilisée pour
   définir la base du répertoire.</p>

</usage>
<seealso>Voir les <a
href="../misc/security_tips.html#serverroot">conseils à propos de
sésurité</a> pour plus d'informations en vue de définir correctement les
permissions sur la racine du serveur <directive>ServerRoot</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>DefaultType</name>
<description>Les seuls effets de cette directive sont des émissions
d'avertissements si sa valeur est différente de <code>none</code>. Dans
les versions précédentes, DefaultType permettait de spécifier un type de
média à assigner par défaut au contenu d'une réponse pour lequel aucun
autre type de média n'avait été trouvé.
</description>
<syntax>DefaultType <var>type média|none</var></syntax>
<default>DefaultType none</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>
<compatibility>L'argument <code>none</code> est disponible dans les
versions d'Apache httpd 2.2.7 et supérieures. Tous les autres choix sont
DESACTIVÉS à partir des version 2.3.x.</compatibility>

<usage>
    <p>Cette directive a été désactivée. Pour la compatibilité
    ascendante avec les anciens fichiers de configuration, elle peut
    être spécifiée avec la valeur <code>none</code>, c'est à dire sans
    type de médium par défaut. Par exemple :</p>

    <highlight language="config">DefaultType None</highlight>

    <p><code>DefaultType None</code> n'est disponible que dans les
    versions d'Apache 2.2.7 et supérieures.</p>

    <p>Utilisez le fichier de configuration mime.types et la directive
    <directive module="mod_mime">AddType</directive> pour configurer
    l'assignement d'un type de médium via les extensions de fichiers, ou
    la directive <directive module="core">ForceType</directive> pour
    attribuer un type de médium à des ressources spécifiques. Dans le
    cas contraire, le serveur enverra sa réponse sans champ d'en-tête
    Content-Type, et le destinataire devra déterminer lui-même le type
    de médium.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Define</name>
<description>Permet de définir une variable</description>
<syntax>Define <var>nom-paramètre</var> [<var>valeur-paramètre</var>]</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context></contextlist>

<usage>
    <p>Avec un seul paramètre, l'effet de la directive
    <directive>Define</directive> est identique à celui de l'argument
    <code>-D</code> du programme <program>httpd</program>. Il permet de
    modifier le comportement des sections <directive module="core"
    type="section">IfDefine</directive> sans avoir à ajouter d'argument
    <code>-D</code> au sein des scripts de démarrage.</p>

    <p>De plus, le second paramètre permet d'affecter une valeur à la
    variable définie par le premier. Cette variable peut être référencée
    dans le fichier de configuration via la syntaxe <code>${VAR}</code>.
    La portée de la variable est toujours globale, et n'est jamais
    limitée à la section de configuration courante.</p>

    <highlight language="config">
&lt;IfDefine TEST&gt;
  Define servername test.example.com
&lt;/IfDefine&gt;
&lt;IfDefine !TEST&gt;
  Define servername www.example.com
  Define SSL
&lt;/IfDefine&gt;

DocumentRoot "/var/www/${servername}/htdocs"
    </highlight>

    <p>Le caractère ":" est interdit dans les noms de variables afin
    d'éviter les conflits avec la syntaxe de la directive <directive
    module="mod_rewrite">RewriteMap</directive>.</p>

    <note><title>Portée de la directive et pièges à éviter</title>
    <p>Si cette directive est définie au sein d'un bloc VirtualHost, les
    changements qu'elle induit sont visibles de toute directive
    ultérieure, au delà de tout bloc VirtualHost.</p>
    </note>
</usage>
<seealso><directive module="core">UnDefine</directive></seealso>
<seealso><directive module="core">IfDefine</directive></seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>Directory</name>
<description>Regroupe un ensemble de directives qui ne s'appliquent
qu'au répertoire concerné du système de fichiers, à ses
sous-répertoires, et à leur contenu.</description>
<syntax>&lt;Directory <var>chemin répertoire</var>&gt;
... &lt;/Directory&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>Les balises <directive type="section">Directory</directive> et
    <code>&lt;/Directory&gt;</code> permettent de regrouper un ensemble
    de directives qui ne s'appliquent qu'au répertoire précisé,
    à ses sous-répertoires, et aux fichiers situés dans ces
    sous-répertoires. Toute directive
    autorisée dans un contexte de répertoire peut être utilisée.
    <var>chemin répertoire</var> est soit le chemin absolu d'un
    répertoire, soit une chaîne de caractères avec caractères génériques
    utilisant la comparaison Unix de style shell. Dans une chaîne de
    caractères avec caractères génériques, <code>?</code> correspond à
    un caractère quelconque, et <code>*</code> à toute chaîne de
    caractères. Les intervalles de caractères <code>[]</code> sont aussi
    autorisés. Aucun caractère générique ne peut remplacer le caractère
    `/', si bien que l'expression <code>&lt;Directory
    "/*/public_html"&gt;</code> ne conviendra pas pour le chemin
     * <code>/home/user/public_html</code>, alors que <code>&lt;Directory
    "/home/*/public_html"&gt;</code> conviendra. Exemple :</p>

    <highlight language="config">
&lt;Directory "/usr/local/httpd/htdocs"&gt;
  Options Indexes FollowSymLinks
&lt;/Directory&gt;
    </highlight>

    <p>Les chemins de répertoires contenant des espaces <em>doivent</em> être
    entourés de guillemets afin d'empêcher l'interprétation de ces
    espaces comme fins d'arguments.</p>

    <note>
      <p>Soyez prudent avec l'argument <var>chemin répertoire</var> : il
      doit correspondre exactement au chemin du système de fichier
      qu'Apache httpd utilise pour accéder aux fichiers. Les directives
      comprises dans une section <code>&lt;Directory&gt;</code> ne
      s'appliqueront pas aux fichiers du même répertoire auxquels on
      aura accédé via un chemin différent, per exemple via un lien
      symbolique.</p>
    </note>

    <p> Les <glossary ref="regex">Expressions rationnelles</glossary>
    peuvent aussi être utilisées en ajoutant le caractère
    <code>~</code>. Par exemple :</p>

    <highlight language="config">
&lt;Directory ~ "^/www/[0-9]{3}"&gt;

&lt;/Directory&gt;
</highlight>

    <p>pourra correspondre à tout répertoire situé dans /www/ et dont le
    nom se compose de trois chiffres.</p>

    <p>Si plusieurs sections <directive
    type="section">Directory</directive> (sans expression rationnelle)
    correspondent au répertoire (ou à un de ses parents) qui contient le
    document, les directives de la section <directive
    type="section">Directory</directive> dont le chemin est le plus
    court sont appliquées en premier, en s'intercalant avec les
    directives des fichiers <a href="#accessfilename">.htaccess</a>. Par
    exemple, avec</p>

    <highlight language="config">
&lt;Directory "/"&gt;
  AllowOverride None
&lt;/Directory&gt;

&lt;Directory "/home"&gt;
  AllowOverride FileInfo
&lt;/Directory&gt;
    </highlight>

    <p>l'accès au document <code>/home/web/dir/doc.html</code> emprunte
    le chemin suivant :</p>

    <ul>
      <li>Aplication de la directive <code>AllowOverride None</code>
      (qui désactive les fichiers <code>.htaccess</code>).</li>

      <li>Application de la directive <code>AllowOverride
      FileInfo</code> (pour le répertoire <code>/home</code>).</li>

      <li>Application de toute directive <code>FileInfo</code> qui se
      trouverait dans d'éventuels fichiers <code>/home/.htaccess</code>,
      <code>/home/web/.htaccess</code> ou
      <code>/home/web/dir/.htaccess</code>, dans cet ordre.</li>
    </ul>

    <p>Les directives associées aux répertoires sous forme d'expressions
    rationnelles ne sont prises en compte qu'une fois toutes les
    directives des sections sans expressions rationnelles appliquées.
    Alors, tous les répertoires avec expressions rationnelles sont
    testés selon l'ordre dans lequel ils apparaissent dans le fichier de
    configuration. Par exemple, avec</p>

    <highlight language="config">
&lt;Directory ~ "abc$"&gt;
  # ... directives ici ...
&lt;/Directory&gt;
    </highlight>

    <p>la section avec expression rationnelle ne sera prise en compte
    qu'après les sections <directive
    type="section">Directory</directive> sans expression rationnelle
    et les fichiers <code>.htaccess</code>. Alors, l'expression
    rationnelle conviendra pour <code>/home/abc/public_html/abc</code>
    et la section <directive type="section">Directory</directive>
    correspondante s'appliquera.</p>

   <p><strong>Notez que la politique d'accès par défaut
   dans les sections <code>&lt;Directory "/"&gt;</code> consiste à
   autoriser tout accès sans restriction. Ceci signifie qu'Apache httpd va servir tout fichier
   correspondant à une URL. Il est recommandé de modifier cette
   situation à l'aide d'un bloc du style</strong></p>

    <highlight language="config">
&lt;Directory "/"&gt;
  Require all denied
&lt;/Directory&gt;
    </highlight>

    <p><strong>puis d'affiner la configuration pour les répertoires que vous
    voulez rendre accessibles. Voir la page <a
    href="../misc/security_tips.html">Conseils à propos de sécurité</a>
    pour plus de détails.</strong></p>

    <p>Les sections <directive type="section">Directory</directive> se situent
    dans le fichier <code>httpd.conf</code>. Les directives <directive
    type="section">Directory</directive> ne peuvent pas être imbriquées
    et ne sont pas autorisées dans les sections <directive module="core"
    type="section">Limit</directive> ou <directive module="core"
    type="section">LimitExcept</directive>.</p>
</usage>
<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour des
explications à propos de la manière dont ces différentes sections se
combinent entre elles à la réception d'une requête</seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>DirectoryMatch</name>
<description>Regroupe des directives qui s'appliquent au contenu de répertoires
du système de fichiers correspondant à une expression rationnelle</description>
<syntax>&lt;DirectoryMatch <var>regex</var>&gt;
... &lt;/DirectoryMatch&gt;</syntax>
<contextlist><context>server config
</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Les balises <directive type="section">DirectoryMatch</directive>
    et <code>&lt;/DirectoryMatch&gt;</code> permettent de regrouper un
    ensemble de directives qui ne s'appliqueront qu'au répertoire
    précisé (et aux fichiers qu'il contient), comme pour la section <directive
    module="core" type="section">Directory</directive>. Cependant, le
    répertoire est précisé sous la forme d'une <glossary
    ref="regex">expression rationnelle</glossary>. Par exemple :</p>

    <highlight language="config">
&lt;DirectoryMatch "^/www/(.+/)?[0-9]{3}/"&gt;
    # ...
&lt;/DirectoryMatch&gt;
</highlight>

    <p>convient pour les sous-répertoires de <code>/www/</code> dont
    le nom se compose de trois chiffres.</p>

    <note><title>Compatibilité</title>
      Avant la version 2.3.9, cette directive s'appliquait aussi aux
      sous-répertoires (comme la directive <directive module="core"
      type="section">Directory</directive>), et ne tenait pas compte du
      symbole de fin de ligne ($). Depuis la version 2.3.9, seuls les
      répertoires qui correspondent à l'expression sont affectés par les
      directives contenues dans la section.
    </note>

    <note><title>slash de fin</title>
      Cette directive s'applique aux requêtes pour des répertoires avec
      ou sans slash de fin ; les expressions contenant un symbole de fin
      de ligne ($) doivent donc faire l'objet d'une attention
      particulière.
    </note>
    
    <p>A partir de la version 2.4.8, les groupes nommés et les
    références arrières sont extraits et enregistrés dans
    l'environnement avec leur nom en majuscules et préfixé
    par "MATCH_". Ceci permet
    de référencer des URLs dans des <a href="../expr.html">expressions</a>
    ou au sein de modules comme <module>mod_rewrite</module>. Pour
    éviter toute confusion, les références arrières numérotées (non
    nommées) sont ignorées. Vous devez utiliser à la place des groupes
    nommés.</p>

<highlight language="config">
&lt;DirectoryMatch "^/var/www/combined/(?&lt;sitename&gt;[^/]+)"&gt;
    Require ldap-group cn=%{env:MATCH_SITENAME},ou=combined,o=Example
&lt;/DirectoryMatch&gt;
</highlight>    

</usage>
<seealso><directive type="section" module="core">Directory</directive>
pour une description de la manière dont les expressions rationnelles
sont traitées en présence d'autres sections <directive
type="section">Directory</directive> sans expressions rationnelles</seealso>
<seealso><a
href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication à propos de la manière dont ces différentes sections se
combinent entre elles à la réception d'une requête</seealso>
</directivesynopsis>

<directivesynopsis>
<name>DocumentRoot</name>
<description>Racine principale de l'arborescence des documents visible
depuis Internet</description>
<syntax>DocumentRoot <var>chemin répertoire</var></syntax>
<default>DocumentRoot "/usr/local/apache/htdocs"</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>Cette directive permet de définir le répertoire à partir duquel
    <program>httpd</program> va servir les fichiers. S'il ne correspond
    pas à un <directive module="mod_alias">Alias</directive>, le chemin
    de l'URL sera ajouté par le serveur à la racine des documents afin
    de construire le chemin du document recherché. Exemple :</p>

    <highlight language="config">DocumentRoot "/usr/web"</highlight>

    <p>un accès à <code>http://my.example.com/index.html</code> se
    réfère alors à <code>/usr/web/index.html</code>. Si <var>chemin
    répertoire</var> n'est pas un chemin absolu, il est considéré comme
    relatif au chemin défini par la directive <directive
    module="core">ServerRoot</directive>.</p>

    <p>Le répertoire défini par la directive
    <directive>DocumentRoot</directive> ne doit pas comporter de slash
    final.</p>
</usage>
<seealso><a href="../urlmapping.html#documentroot">Mise en
correspondance des URLs avec le système de fichiers</a></seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>Else</name>
<description>Contient des directives qui ne s'appliquent que si la
condition correspondant à la section <directive type="section"
module="core">If</directive> ou <directive type="section"
module="core">ElseIf</directive> précédente n'est pas satisfaite par la
requête à l'exécution</description>
<syntax>&lt;Else&gt; ... &lt;/Else&gt;</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>
<compatibility>Les conditions imbriquées sont supportées à partir de la version
2.4.26 du serveur HTTP Apache</compatibility>

<usage>
    <p>La section <directive type="section">Else</directive> applique
    les directives qu'elle contient si et seulement si les conditions
    correspondant à la section <directive type="section">If</directive>
    ou <directive type="section">ElseIf</directive> immédiatement
    supérieure et dans la même portée n'ont pas été satisfaites. Par
    exemple, dans :</p>

    <highlight language="config">
&lt;If "-z req('Host')"&gt;
  # ...
&lt;/If&gt;
&lt;Else&gt;
  # ...
&lt;/Else&gt;
    </highlight>

    <p>La condition de la section <directive
    type="section">If</directive> serait satisfaite pour les requêtes
    HTTP/1.0 sans en-tête <var>Host:</var>, alors que celle de la section
    <directive type="section">Else</directive> le serait pour les
    requêtes comportant un en-tête <var>Host:</var>.</p>

</usage>
<seealso><directive type="section" module="core">If</directive></seealso>
<seealso><directive type="section" module="core">ElseIf</directive></seealso>
<seealso><a href="../sections.html">Fonctionnement des sections &lt;Directory&gt;, &lt;Location&gt;,
    &lt;Files&gt;</a> pour une explication de la manière dont ces
    différentes section se combinent entre elles lorsqu'une requête est
    reçue. Les directives <directive type="section">If</directive>,
    <directive type="section">ElseIf</directive>, et <directive
    type="section">Else</directive> s'appliquent en dernier.</seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>ElseIf</name>
<description>Contient des directives qui ne s'appliquent que si la
condition correspondante est satisfaite par une requête à l'exécution,
alors que la condition correspondant à la section <directive
type="section" module="core">If</directive> ou <directive
type="section">ElseIf</directive> précédente ne l'était pas.</description>
<syntax>&lt;ElseIf <var>expression</var>&gt; ... &lt;/ElseIf&gt;</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>
<compatibility>Les conditions imbriquées sont supportées à partir de la version
2.4.26 du serveur HTTP Apache</compatibility>

<usage>
    <p>La section <directive type="section">ElseIf</directive> applique
    les directives qu'elle contient si et seulement si d'une part la
    condition correspondante est satisfaite, et d'autre part la condition
    correspondant à la section <directive type="section">If</directive>
    ou <directive type="section">ElseIf</directive> de la même portée ne
    l'est pas. Par exemple, dans :</p>

    <highlight language="config">
&lt;If "-R '10.1.0.0/16'"&gt;
  #...
&lt;/If&gt;
&lt;ElseIf "-R '10.0.0.0/8'"&gt;
  #...
&lt;/ElseIf&gt;
&lt;Else&gt;
  #...
&lt;/Else&gt;
    </highlight>

    <p>La condition correspondant à la section <directive
    type="section">ElseIf</directive> est satisfaite si l'adresse
    distante de la requête appartient au sous-réseau 10.0.0.0/8, mais
    pas si elle appartient au sous-réseau 10.1.0.0/16.</p>

</usage>
<seealso><a href="../expr.html">Les expressions dans le serveur HTTP
Apache</a>, pour une référence complète et d'autres exemples.</seealso>
<seealso><directive type="section" module="core">If</directive></seealso>
<seealso><directive type="section" module="core">Else</directive></seealso>
<seealso><a href="../sections.html">Fonctionnement des sections &lt;Directory&gt;, &lt;Location&gt;,
    &lt;Files&gt;</a> pour une explication de la manière dont ces
    différentes section se combinent entre elles lorsqu'une requête est
    reçue. Les directives <directive type="section">If</directive>,
    <directive type="section">ElseIf</directive>, et <directive
    type="section">Else</directive> s'appliquent en dernier.</seealso>
</directivesynopsis>

<directivesynopsis>
<name>EnableMMAP</name>
<description>Utilise la projection en mémoire (Memory-Mapping) pour
lire les fichiers pendant qu'ils sont servis</description>
<syntax>EnableMMAP On|Off</syntax>
<default>EnableMMAP On</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>Cette directive définit si <program>httpd</program> peut utiliser
    la projection en mémoire (Memory-Mapping) quand il doit lire le contenu
    d'un fichier pendant qu'il est servi. Par défaut, lorsque le
    traitement d'une requête requiert l'accès aux données contenues dans
    un fichier -- par exemple, pour servir un fichier interprété par le
    serveur à l'aide de <module>mod_include</module> -- Apache httpd projette
    le fichier en mémoire si le système d'exploitation le permet.</p>

    <p>Cette projection en mémoire induit parfois une amélioration des
    performances. Sur certains systèmes cependant, il est préférable de
    désactiver la projection en mémoire afin d'éviter certains problèmes
    opérationnels :</p>

    <ul>
    <li>Sur certains systèmes multi-processeurs, la projection en
    mémoire peut dégrader les performances du programme
    <program>httpd</program>.</li>
    <li>S'il fait l'objet d'une projection en mémoire par
    <program>httpd</program>, la suppression ou la troncature d'un
    fichier peut provoquer un crash de <program>httpd</program> avec une
    erreur de segmentation.</li>
    </ul>

    <p>Pour les configurations de serveur sujettes à ce genre de
    problème, il est préférable de désactiver la projection en mémoire
    des fichiers servis en spécifiant :</p>
    
    <highlight language="config">EnableMMAP Off</highlight>

    <p>Pour les montages NFS, cette fonctionnalité peut être
    explicitement désactivée pour les fichiers concernés en spécifiant
    :</p>

    <highlight language="config">
&lt;Directory "/path-to-nfs-files"&gt;
  EnableMMAP Off
&lt;/Directory&gt;
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>EnableSendfile</name>
<description>Utilise le support sendfile du noyau pour servir les
fichiers aux clients</description>
<syntax>EnableSendfile On|Off</syntax>
<default>EnableSendfile Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>
<compatibility>Par défaut à Off depuis la version 2.3.9.</compatibility>

<usage>
    <p>Cette directive définit si le programme <program>httpd</program>
    peut utiliser le support sendfile du noyau pour transmettre le
    contenu des fichiers aux clients. Par défaut, lorsque le traitement
    d'une requête ne requiert pas l'accès aux données contenues dans un
    fichier -- par exemple, pour la transmission d'un fichier statique
    -- Apache httpd utilise sendfile pour transmettre le contenu du fichier
    sans même lire ce dernier, si le système d'exploitation le
    permet.</p>

    <p>Ce mécanisme sendfile évite la séparation des opérations de
    lecture et d'envoi, ainsi que les réservations de tampons. sur
    certains systèmes cependant, ou sous certains systèmes de fichiers,
    il est préférable de désactiver cette fonctionnalité afin d'éviter
    certains problèmes opérationnels :</p>

    <ul>
    <li>Certains systèmes peuvent présenter un support sendfile
    défectueux que le système de compilation n'a pas détecté, en
    particulier si les exécutables ont été compilés sur une autre
    machine, puis copiés sur la première avec un support sendfile
    défectueux.</li>
    <li>Sous Linux, l'utilisation de sendfile induit des bogues lors de
    la récupération des paquets de vérification TCP (TCP-checksum) avec
    certaines cartes réseau lorsqu'on utilise IPv6.</li>
    <li>Sous Linux sur Itanium, <code>sendfile</code> peut s'avérer incapable de
    traiter les fichiers de plus de 2 Go.</li>
    <li>Avec un montage réseau de <directive
    module="core">DocumentRoot</directive> (par exemple NFS, SMB, CIFS,
    FUSE), le
    noyau peut s'avérer incapable de servir un fichier de ce montage
    réseau en passant par son propre cache.</li>
    </ul>

    <p>Pour les configurations de serveur non sujettes à ce genre de
    problème, vous pouvez activer cette fonctionnalité en
    spécifiant :</p>

    <highlight language="config">EnableSendfile On</highlight>

    <p>Pour les montages réseau, cette fonctionnalité peut être
    explicitement désactivée pour les fichiers concernés en spécifiant
    :</p>

    <highlight language="config">
&lt;Directory "/path-to-nfs-files"&gt;
  EnableSendfile Off
&lt;/Directory&gt;
    </highlight>
    <p>Veuillez noter que la configuration de la directive
    <directive>EnableSendfile</directive> dans un contexte de répertoire
    ou de fichier .htaccess n'est pas supportée par
    <module>mod_cache_disk</module>. Le module ne prend en compte la
    définition de <directive>EnableSendfile</directive> que dans un
    contexte global.
    </p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>HttpProtocolOptions</name>
<description>Modifie les contraintes sur les messages des requêtes HTTP</description>
<syntax>HttpProtocolOptions [Strict|Unsafe] [RegisteredMethods|LenientMethods]
 [Allow0.9|Require1.0]</syntax>
<default>HttpProtocolOptions Strict LenientMethods Allow0.9</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible à partir des versions 2.2.32 et 2.4.24 du serveur HTTP
Apache</compatibility>

<usage>
    <p>Cette directive permet de modifier les règles qui s'appliquent à la ligne
    de requête HTTP (<a
    href="https://tools.ietf.org/html/rfc7230#section-3.1.1">RFC 7230
    &sect;3.1.1</a>) et aux champs des en-têtes des requêtes HTTP (<a
    href="https://tools.ietf.org/html/rfc7230#section-3.2">RFC 7230
    &sect;3.2</a>), qui s'appliquent maintenant par défaut ou en utilisant
    l'option <code>Strict</code>. L'option <code>Unsafe</code>
    a été ajoutée pour pouvoir restaurer les anciens
    comportements nécessaires aux anciens modules et applications et aux agents
    utilisateurs personnalisés considérés comme obsolètes.</p>

    <p>Ces règles
    s'appliquant avant le traitement de la requête, elles doivent, pour être prises en
    compte, être définies
    au niveau global ou dans la première section par défaut du serveur virtuel
    qui correspond à la requête considérée, par interface IP/port et non par
    nom.</p>

    <p>Cette directive accepte trois paramètres issus de la liste suivante, ceux
    qui ne sont pas spécifiés prenant leur valeur par défaut :</p>

    <dl>
    <dt>Strict|Unsafe</dt>
    <dd>
    <p>Avant l'introduction de cette directive, les interpréteurs de requêtes du
    serveur HTTP Apache toléraient un grand nombre de formats en entrée qui
    n'étaient pas forcément conformes au protocole. <a
    href="https://tools.ietf.org/html/rfc7230#section-9.4">RFC 7230 &sect;9.4
    Request Splitting</a> et <a
    href="https://tools.ietf.org/html/rfc7230#section-9.5">&sect;9.5 Response
    Smuggling</a> ne rappellent que deux des risques potentiels induits par des
    requêtes non conformes, alors que <a
    href="https://tools.ietf.org/html/rfc7230#section-3.5">RFC 7230
    &sect;3.5</a> signale les risques encourus par l'acceptation de blancs non
    conformes dans les lignes de requête. Avec l'introduction de cette
    directive, toutes les règles de grammaire de la spécification doivent être
    respectées dans le mode d'opérations par défaut <code>Strict</code>.</p>

    <note type="warning"><title>Risques de sécurité liés au mode Unsafe</title>
    <p>Il est fortement déconseillé aux utilisateurs d'utiliser le mode
    d'opération <code>Unsafe</code>, ou
    <code>UnsafeWhitespace</code>, en particulier pour les déploiements de
    serveurs ouverts sur l'extérieur et/ou accessibles au public. Si un moniteur
    défectueux ou autre logiciel spécialisé ne s'exécutant que sur un intranet
    nécessite une interface, les utilisateurs ne doivent utiliser les options de
    type UnSafe qu'en cas de nécessité et uniquement au sein d'un serveur
    virtuel bien spécifique et sur un réseau privé.</p>
    </note>

    <example>
        <title>Exemple de requête provoquant l'envoi d'un message HTTP 400 en
	mode Strict</title>
        # Missing CRLF<br />
        GET / HTTP/1.0\n\n
      </example>
      <note type="warning"><title>Utilitaires en ligne de commande et CRLF</title>
        <p>Il peut s'avérer nécessaire de forcer certains utilitaires à utiliser
	CRLF ; si ce n'est pas le cas, httpd reverra une réponse HTTP 400 comme
	dans le cas précédent. Par exemple, le <strong>client OpenSSL s_client
	doit utiliser le paramètre -crlf pour fonctionner correctement</strong>.</p>
        <p>Pour détecter des problèmes tels que l'absence de CRLF, vous pouvez
	utiliser la directive <directive
	module="mod_dumpio">DumpIOInput</directive> qui permet de décortiquer
	les requêtes HTTP.</p>
      </note>
    </dd>
    <dt>RegisteredMethods|LenientMethods</dt>
    <dd>
    <p>La section de la <a
    href="https://tools.ietf.org/html/rfc7231#section-4.1">RFC 7231
    &sect;4.1</a> "Request Methods" "Overview" indique que les serveurs doivent
    renvoyer un message d'erreur lorsque la ligne de requête comporte une
    méthode non supportée. C'est déjà le cas lorsque l'option
    <code>LenientMethods</code> est utilisée, mais les administrateurs ont la
    possibilité de limiter les méthodes utilisées via l'option
    <code>RegisteredMethods</code> en enregistrant toute méthode non standard
    via la directive <directive>RegisterHttpMethod</directive>, en particulier
    si l'option <code>Unsafe</code> est utilisée.</p>

    <note type="warning"><title>Compatibilité avec le mandat direct</title>
    <p>L'option
    <code>RegisteredMethods</code> <strong>ne doit pas</strong> être utilisée
    pour les serveurs mandataires car ces derniers ne connaissent pas les
    méthodes supportées par les serveurs originaux.</p>
    </note>

    <example>
        <title>Exemple de requête provoquant l'envoi d'un message HTTP 501 en
	mode LenientMethods</title>
        # Méthode HTTP inconnue<br />
        WOW / HTTP/1.0\r\n\r\n<br /><br />
        # Méthode HTTP spécifiée en minuscules<br />
        get / HTTP/1.0\r\n\r\n<br />
      </example>
      </dd>
      <dt>Allow0.9|Require1.0</dt>
      <dd>
    <p>La section de la <a
    href="https://tools.ietf.org/html/rfc2616#section-19.6">RFC 2616
    &sect;19.6</a> "Compatibility With Previous Versions" encouragait les
    serveurs HTTP à supporter les anciennes requêtes HTTP/0.9. La RFC 7230 va
    cependant à son encontre via sa préconisation "Le souhait de supporter les
    requêtes HTTP/0.9 a été supprimé" et y adjoint des commentaires dans <a
    href="https://tools.ietf.org/html/rfc7230#appendix-A">RFC 7230 Appendix
    A</a>. A ce titre, l'option <code>Require1.0</code> permet à l'utilisateur
    d'inhiber le comportement induit par l'option par défaut
    <code>Allow0.9</code>.</p>

    <example>
        <title>Exemple de requête provoquant l'envoi d'un message HTTP 400 en
	mode Require1.0</title>
        # Version HTTP non supportée<br />
        GET /\r\n\r\n
      </example>
    </dd>
    </dl>

    <p>La consultation des messages enregistrés dans le journal
    <directive>ErrorLog</directive>, configuré via la directive
    <directive>LogLevel</directive> avec un niveau <code>info</code>, pourra
    vous aider à identifier de telles requêtes non conformes ainsi que leur
    provenance. Les utilisateurs devront accorder une attention particulière aux
    messages d'erreur de type 400 dans le journal access pour détecter les
    requêtes apparemment valides mais rejetées.</p>    
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Error</name>
<description>Interrompt la lecture de la configuration avec un message
d'erreur personnalisé</description>
<syntax>Error <var>message</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<compatibility>à partir de la version 2.3.9</compatibility>

<usage>
    <p>Si une erreur peut être détectée dans la configuration, souvent
    un module manquant, cette
    directive peut être utilisée pour générer un message d'erreur
    personnalisé, et interrompre la lecture de la configuration. </p>

    <highlight language="config">
# Exemple
# vérification du chargement de mod_include
&lt;IfModule !include_module&gt;
  Error "mod_include is required by mod_foo.  Load it with LoadModule."
&lt;/IfModule&gt;

# vérification de la définition de SSL ou (exclusif) NOSSL
&lt;IfDefine SSL&gt;
&lt;IfDefine NOSSL&gt;
  Error "Both SSL and NOSSL are defined.  Define only one of them."
&lt;/IfDefine&gt;
&lt;/IfDefine&gt;
&lt;IfDefine !SSL&gt;
&lt;IfDefine !NOSSL&gt;
  Error "Either SSL or NOSSL must be defined."
&lt;/IfDefine&gt;
&lt;/IfDefine&gt;
    </highlight>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>ErrorDocument</name>
<description>Document que le serveur renvoie au client en cas
d'erreur</description>
<syntax>ErrorDocument <var>code erreur</var> <var>document</var></syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>Apache httpd peut traiter les problèmes et les erreurs de quatre
    manières,</p>

    <ol>
      <li>afficher un simple message d'erreur au contenu fixe</li>

      <li>afficher un message personnalisé</li>

      <li>rediriger en interne vers un <var>chemin d'URL</var> local pour traiter
      le problème ou l'erreur</li>

      <li>rediriger vers une <var>URL</var> externe pour traiter
      le problème ou l'erreur</li>
    </ol>

    <p>La première option constitue le comportement par défaut; pour
    choisir une des trois autres options, il faut configurer Apache à
    l'aide de la directive <directive>ErrorDocument</directive>, suivie
    du code de la réponse HTTP et d'une URL ou d'un message. Apache
    httpd fournit parfois des informations supplémentaires à propos du
    problème ou de l'erreur.</p>

    <p>A partir de la version 2.4.13, il est possible d'utiliser la <a
    href="../expr.html">syntaxe des expressions</a> dans cette directive
    afin de générer des chaînes et URLs dynamiques.</p>

    <p>Les URLs peuvent commencer par un slash (/) pour les chemins web
    locaux (relatifs au répertoire défini par la directive <directive
    module="core">DocumentRoot</directive>), ou se présenter sous la
    forme d'une URL complète que le client pourra résoudre.
    Alternativement, un message à afficher par le navigateur pourra être
    fourni. Notez que la décision de considérer le paramètre comme URL,
    chemin ou message intervient avant toute interprètation
    d'expression. Exemples :</p>

    <highlight language="config">
ErrorDocument 500 http://example.com/cgi-bin/server-error.cgi
ErrorDocument 404 /errors/bad_urls.php
ErrorDocument 401 /subscription_info.html
ErrorDocument 403 "Sorry can't allow you access today"
ErrorDocument 403 Forbidden!
ErrorDocument 403 /errors/forbidden.py?referrer=%{escape:%{HTTP_REFERER}}
    </highlight>

    <p>De plus, on peut spécifier la valeur spéciale <code>default</code>
    pour indiquer l'utilisation d'un simple message d'Apache httpd codé en
    dur. Bien que non nécessaire dans des circonstances normales, la
    spécification de la valeur <code>default</code> va permettre de
    rétablir l'utilisation du simple message d'Apache httpd codé en dur pour
    les configurations qui sans cela, hériteraient d'une directive
    <directive>ErrorDocument</directive> existante.</p>

    <highlight language="config">
ErrorDocument 404 /cgi-bin/bad_urls.pl

&lt;Directory "/web/docs"&gt;
  ErrorDocument 404 default
&lt;/Directory&gt;
    </highlight>

    <p>Notez que lorsque vous spécifiez une directive
    <directive>ErrorDocument</directive> pointant vers une URL distante
    (c'est à dire tout ce qui commence par le préfixe http), le serveur
    HTTP Apache va
    envoyer une redirection au client afin de lui indiquer où trouver le
    document, même dans le cas où ce document se trouve sur le serveur
    local. Ceci a de nombreuses conséquences dont la plus importante
    réside dans le fait que le client ne recevra pas le code d'erreur
    original, mais au contraire un code de statut de redirection. Ceci
    peut en retour semer la confusion chez les robots web et divers
    clients qui tentent de déterminer la validité d'une URL en examinant
    le code de statut. De plus, si vous utilisez une URL distante avec
    <code>ErrorDocument 401</code>, le client ne saura pas qu'il doit
    demander un mot de passe à l'utilisateur car il ne recevra pas le
    code de statut 401. C'est pourquoi, <strong>si vous utilisez une
    directive <code>ErrorDocument 401</code>, elle devra faire référence
    à un document par le biais d'un chemin local.</strong></p>

    <p>Microsoft Internet Explorer (MSIE) ignore par défaut les messages
    d'erreur générés par le serveur lorsqu'ils sont trop courts et
    remplacent ses propres messages d'erreur "amicaux". Le seuil de
    taille varie en fonction du type d'erreur, mais en général, si la
    taille de votre message d'erreur est supérieure à 512 octets, il y a
    peu de chances pour que MSIE l'occulte, et il sera affiché par ce
    dernier. Vous trouverez d'avantage d'informations dans l'article de
    la base de connaissances Microsoft <a
    href="http://support.microsoft.com/default.aspx?scid=kb;en-us;Q294807"
    >Q294807</a>.</p>

    <p>Bien que la plupart des messages d'erreur internes originaux
    puissent être remplacés, ceux-ci sont cependant conservés dans
    certaines circonstances sans tenir compte de la définition de la
    directive <directive module="core">ErrorDocument</directive>. En
    particulier, en cas de détection d'une requête mal formée, le
    processus de traitement normal des requêtes est immédiatement
    interrompu, et un message d'erreur interne est renvoyé, ceci afin de
    se prémunir contre les problèmes de sécurité liés aux requêtes mal
    formées.</p>

    <p>Si vous utilisez mod_proxy, il est en général préférable
    d'activer <directive
    module="mod_proxy">ProxyErrorOverride</directive> afin d'être en
    mesure de produire des messages d'erreur personnalisés pour le
    compte de votre serveur d'origine. Si vous n'activez pas
    ProxyErrorOverride, Apache httpd ne générera pas de messages d'erreur
    personnalisés pour le contenu mandaté.</p>

</usage>

<seealso><a href="../custom-error.html">documentation sur la
personnalisation des réponses</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ErrorLog</name>
<description>Définition du chemin du journal des erreurs</description>
<syntax> ErrorLog <var>file-path</var>|syslog[:[<var>facility</var>][:<var>tag</var>]]</syntax>
<default>ErrorLog logs/error_log (Unix) ErrorLog logs/error.log (Windows and OS/2)</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>La directive <directive>ErrorLog</directive> permet de définir le
    nom du fichier dans lequel le serveur va journaliser toutes les
    erreurs qu'il rencontre. Si le <var>file-path</var> n'est pas
    absolu, il est considéré comme relatif au chemin défini par la
    directive <directive module="core">ServerRoot</directive>.</p>

    <highlight language="config">ErrorLog "/var/log/httpd/error_log"</highlight>

    <p>Si le <var>file-path</var> commence par une barre verticale
    "<code>(|)</code>", il est considéré comme une commande à lancer pour traiter la
    journalisation de l'erreur.</p>

    <highlight language="config">ErrorLog "|/usr/local/bin/httpd_errors"</highlight>

    <p>Voir les notes à propos des <a href="../logs.html#piped">journaux
    redirigés</a> pour plus d'informations.</p>

    <p>L'utilisation de <code>syslog</code> à la place d'un nom de
    fichier active la journalisation via syslogd(8) si le système le
    supporte. Le dispositif syslog par défaut est <code>local7</code>,
    mais vous pouvez le modifier à l'aide de la syntaxe
    <code>syslog:<var>facility</var></code>, où <var>facility</var> peut
    être remplacé par un des noms habituellement documentés dans la page
    de man syslog(1). Le dispositif syslog <code>local7</code> est
    global, et si il est modifié dans un serveur virtuel, le dispositif
    final spécifié affecte l'ensemble du serveur. La même règle s'applique au
    tag syslog qui utilise par défaut le nom du binaire du serveur HTTP Apache
    <code>httpd</code> dans la plupart des cas. Vous pouvez aussi modifier cette
    valeur en utilisant la syntaxe <code>syslog::<var>tag</var></code>.</p>

    <highlight language="config">
ErrorLog syslog:user
ErrorLog syslog:user:httpd.srv1
ErrorLog syslog::httpd.srv2  
    </highlight>

    <p>Des modules supplémentaires peuvent fournir leurs propres
    fournisseurs ErrorLog. La syntaxe est similaire à celle de
    l'exemple <code>syslog</code> ci-dessus.</p>

    <p>SECURITE : Voir le document <a
    href="../misc/security_tips.html#serverroot">conseils à propos de
    sécurité</a> pour des détails sur les raisons pour lesquelles votre
    sécurité peut être compromise si le répertoire contenant les
    fichiers journaux présente des droits en écriture pour tout autre
    utilisateur que celui sous lequel le serveur est démarré.</p>
    <note type="warning"><title>Note</title>
      <p>Lors de la spécification d'un chemin de fichier sur les
      plates-formes non-Unix, on doit veiller à n'utiliser que des
      slashes (/), même si la plate-forme autorise l'utilisation des
      anti-slashes (\). Et d'une manière générale, il est recommandé de
      n'utiliser que des slashes (/) dans les fichiers de
      configuration.</p>
    </note>
</usage>
<seealso><directive module="core">LogLevel</directive></seealso>
<seealso><a href="../logs.html">Fichiers journaux du serveur HTTP Apache</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ErrorLogFormat</name>
<description>Spécification du format des entrées du journal des erreurs</description>
<syntax> ErrorLogFormat [connection|request] <var>format</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>ErrorLogFormat</directive> permet de
    spécifier quelles informations supplémentaires vont être enregistrées
    dans le journal des erreurs en plus du message habituel.</p>

    <highlight language="config">
# Exemple simple
ErrorLogFormat "[%t] [%l] [pid %P] %F: %E: [client %a] %M"
    </highlight>

    <p>La spécification de <code>connection</code> ou
    <code>request</code> comme premier paramètre permet de définir des
    formats supplémentaires, ce qui a pour effet de journaliser des
    informations additionnelles lorsque le premier message est
    enregistré respectivement pour une connexion ou une requête
    spécifique. Ces informations additionnelles ne sont enregistrées
    qu'une seule fois par connexion/requête. Si le traitement d'une
    connexion ou d'une requête ne génère aucun message dans le journal,
    alors aucune information additionnelle n'est enregistrée.</p>

    <p>Il peut arriver que certains items de la chaîne de format ne
    produisent aucune sortie. Par exemple, l'en-tête Referer n'est
    présent que si le message du journal est associé à une requête et s'il
    est généré à un moment où l'en-tête Referer a déjà été lu par le
    client. Si aucune sortie n'est générée, le comportement par défaut
    consiste à supprimer tout ce qui se trouve entre l'espace précédent
    et le suivant. Ceci implique que la ligne de journalisation est
    divisée en champs ne contenant pas d'espace séparés par des espaces.
    Si un item de la chaîne de format ne génère aucune sortie,
    l'ensemble du champ est omis. Par exemple, si l'adresse distante
    <code>%a</code> du format <code>[%t] [%l] [%a] %M&nbsp;</code> n'est
    pas disponible, les crochets qui l'entourent ne seront eux-mêmes pas
    enregistrés. Il est possible d'échapper les espaces par un anti-slash
    afin qu'ils ne soient pas considérés comme séparateurs de champs.
    La combinaison '%&nbsp;' (pourcentage espace) est un délimiteur de
    champ de taille nulle qui ne génère aucune sortie.</p>

    <p>Ce comportement peut être changé en ajoutant des modificateurs à
    l'item de la chaîne de format. Le modificateur <code>-</code>
    (moins) provoque l'enregistrement d'un signe moins si l'item
    considéré ne génère aucune sortie. Pour les formats à enregistrement
    unique par connexion/requête, il est aussi possible d'utiliser le
    modificateur <code>+</code> (plus). Si un item ne générant aucune
    sortie possède le modificateur plus, la ligne dans son ensemble est
    omise.</p>

    <p>Un modificateur de type entier permet d'assigner un niveau de
    sévérité à un item de format. L'item considéré ne
    sera journalisé que si la sévérité du message n'est pas
    plus haute que le niveau de sévérité spécifié. Les
    valeurs possibles vont de 1 (alert) à 15 (trace8), en passant par 4
    (warn) ou 7 (debug).</p>

    <p>Par exemple, voici ce qui arriverait si vous ajoutiez des
    modificateurs à l'item <code>%{Referer}i</code> qui enregistre le
    contenu de l'en-tête <code>Referer</code>.</p>

    <table border="1" style="zebra">
    <columnspec><column width=".3"/><column width=".7"/></columnspec>

    <tr><th>Item modifié</th><th>Signification</th></tr>

    <tr>
    <td><code>%-{Referer}i</code></td>
    <td>Enregistre le caractère <code>-</code> si l'en-tête
    <code>Referer</code> n'est pas défini.</td>
    </tr>

    <tr>
    <td><code>%+{Referer}i</code></td>
    <td>N'enregistre rien si l'en-tête
    <code>Referer</code> n'est pas défini.</td>
    </tr>

    <tr>
    <td><code>%4{Referer}i</code></td>
    <td>N'enregistre le contenu de l'en-tête <code>Referer</code> que si
    la sévérité du message de journalisation est supérieure à 4.</td>
    </tr>

    </table>

    <p>Certains items de format acceptent des paramètres supplémentaires
    entre accolades.</p>

    <table border="1" style="zebra">
    <columnspec><column width=".2"/><column width=".8"/></columnspec>

    <tr><th>Chaîne&nbsp;de&nbsp;format</th> <th>Description</th></tr>

    <tr><td><code>%%</code></td>
        <td>Le signe pourcentage</td></tr>

    <tr><td><code>%a</code></td>
        <td>Adresse IP et port clients</td></tr>

    <tr><td><code>%{c}a</code></td>
        <td>Port et adresse IP sous-jacents du correspondant pour la
	connexion (voir le module
	<module>mod_remoteip</module>)</td></tr>

    <tr><td><code>%A</code></td>
        <td>Adresse IP et port locaux</td></tr>

    <tr><td><code>%{<em>name</em>}e</code></td>
        <td>Variable d'environnement de requête <em>name</em></td></tr>

    <tr><td><code>%E</code></td>
        <td>Etat d'erreur APR/OS et chaîne</td></tr>

    <tr><td><code>%F</code></td>
        <td>Nom du fichier source et numéro de ligne de l'appel du
	journal</td></tr>

    <tr><td><code>%{<em>name</em>}i</code></td>
        <td>En-tête de requête <em>name</em></td></tr>

    <tr><td><code>%k</code></td>
        <td>Nombre de requêtes persistantes pour cette connexion</td></tr>

    <tr><td><code>%l</code></td>
        <td>Sévérité du message</td></tr>

    <tr><td><code>%L</code></td>
        <td>Identifiant journal de la requête</td></tr>

    <tr><td><code>%{c}L</code></td>
        <td>Identifiant journal de la connexion</td></tr>

    <tr><td><code>%{C}L</code></td>
        <td>Identifiant journal de la connexion si utilisé dans la
	portée de la connexion, vide sinon</td></tr>

    <tr><td><code>%m</code></td>
        <td>Nom du module qui effectue la journalisation du message</td></tr>

    <tr><td><code>%M</code></td>
        <td>Le message effectif</td></tr>

    <tr><td><code>%{<em>name</em>}n</code></td>
        <td>Note de requête <em>name</em></td></tr>

    <tr><td><code>%P</code></td>
        <td>Identifiant du processus courant</td></tr>

    <tr><td><code>%T</code></td>
        <td>Identifiant du thread courant</td></tr>

    <tr><td><code>%{g}T</code></td>
        <td>Identifiant unique de thread système du thread courant
	(l'identifiant affiché par la commande <code>top</code> par
	exemple ; seulement sous Linux pour l'instant)</td></tr>

    <tr><td><code>%t</code></td>
        <td>L'heure courante</td></tr>

    <tr><td><code>%{u}t</code></td>
        <td>L'heure courante avec les microsecondes</td></tr>

    <tr><td><code>%{cu}t</code></td>
        <td>L'heure courante au format compact ISO 8601, avec les
	microsecondes</td></tr>

    <tr><td><code>%v</code></td>
        <td>Le nom de serveur canonique <directive
	module="core">ServerName</directive> du serveur courant.</td></tr>

    <tr><td><code>%V</code></td>
        <td>Le nom de serveur du serveur qui sert la requête en accord
	avec la définition de la directive <directive module="core"
	>UseCanonicalName</directive>.</td></tr>

    <tr><td><code>\&nbsp;</code> (anti-slash espace)</td>
        <td>Espace non délimiteur</td></tr>

    <tr><td><code>%&nbsp;</code> (pourcentage espace)</td>
        <td>Délimiteur de champ (aucune sortie)</td></tr>
    </table>

    <p>L'item de format identifiant journal <code>%L</code> génère un
    identifiant unique pour une connexion ou une requête. Il peut servir
    à déterminer quelles lignes correspondent à la même connexion ou
    requête ou quelle requête est associée à tel connexion. Un item de
    format <code>%L</code> est aussi disponible dans le module
    <module>mod_log_config</module>, mais il permet dans ce contexte de
    corréler les entrées du journal des accès avec celles du journal des
    erreurs. Si le module <module>mod_unique_id</module> est chargé,
    c'est son identifiant unique qui sera utilisé comme identifiant de
    journal pour les requêtes.</p>

    <highlight language="config">
# Exemple (format par défaut pour les MPMs threadés)
ErrorLogFormat "[%{u}t] [%-m:%l] [pid %P:tid %T] %7F: %E: [client\ %a] %M%&nbsp;,\&nbsp;referer\&nbsp;%{Referer}i"
    </highlight>

    <p>Cet exemple renverrait un message d'erreur du style :</p>

    <example>
    [Thu May 12 08:28:57.652118 2011] [core:error] [pid 8777:tid 4326490112] [client ::1:58619] File does not exist: /usr/local/apache2/htdocs/favicon.ico
    </example>

    <p>Notez que, comme indiqué plus haut, certains champs sont
    totalement supprimés s'ils n'ont pas été définis.</p>

    <highlight language="config">
# Exemple (similaire au format 2.2.x)
ErrorLogFormat "[%t] [%l] %7F: %E: [client\ %a] %M%&nbsp;,\&nbsp;referer\&nbsp;%{Referer}i"
    </highlight>

    <highlight language="config">
# Exemple avancé avec identifiants journal de requête/connexion
ErrorLogFormat "[%{uc}t] [%-m:%-l] [R:%L] [C:%{C}L] %7F: %E: %M"
ErrorLogFormat request "[%{uc}t] [R:%L] Request %k on C:%{c}L pid:%P tid:%T"
ErrorLogFormat request "[%{uc}t] [R:%L] UA:'%+{User-Agent}i'"
ErrorLogFormat request "[%{uc}t] [R:%L] Referer:'%+{Referer}i'"
ErrorLogFormat connection "[%{uc}t] [C:%{c}L] local\ %a remote\ %A"
    </highlight>

</usage>
<seealso><directive module="core">ErrorLog</directive></seealso>
<seealso><directive module="core">LogLevel</directive></seealso>
<seealso><a href="../logs.html">Fichiers journaux du serveur HTTP Apache</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ExtendedStatus</name>
<description>Extrait des informations d'état étendues pour chaque
requête</description>
<syntax>ExtendedStatus On|Off</syntax>
<default>ExtendedStatus Off</default>
<contextlist><context>server config</context></contextlist>

<usage>

	<p>Cette option permet d'extraire des données supplémentaires
	concernant la requête en cours de traitement pour un processus
	donné, et crée un résumé d'utilisation ; vous pouvez accéder à
	ces variables pendant l'exécution en configurant
	<module>mod_status</module>. Notez que d'autres modules sont
	susceptibles de s'appuyer sur ce tableau de bord.</p>

    <p>Cette directive s'applique au serveur dans son ensemble, et ne
    peut pas être activée/désactivée pour un serveur virtuel
    particulier. Notez que l'extraction des informations d'état étendues
    peut ralentir le serveur. Notez aussi que cette définition ne peut
    pas être modifiée au cours d'un redémarrage graceful.</p>

    <note>
    <p>Notez que le chargement de <module>mod_status</module> définit
    automatiquement ExtendedStatus à On, et que d'autres modules tiers
    sont susceptibles d'en faire de même. De tels modules ont besoin
    d'informations détaillées à propos de l'état de tous les processus.
    Depuis la version 2.3.6, <module>mod_status</module> a définit la
    valeur par défaut à On, alors qu'elle était à Off dans les versions
    antérieures.</p>
    </note>

</usage>

</directivesynopsis>

<directivesynopsis>
<name>FileETag</name>
<description>Caractéristiques de fichier utilisées lors de la génération
de l'en-tête de réponse HTTP ETag pour les fichiers statiques</description>
<syntax>FileETag <var>composant</var> ...</syntax>
<default>FileETag MTime Size</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>
<compatibility>La valeur par défaut était "INode&nbsp;MTime&nbsp;Size"
dans les versions 2.3.14 et antérieures.</compatibility>

<usage>
    <p>
    La directive <directive>FileETag</directive> définit les
    caractéristiques de fichier utilisées lors de la génération de
    l'en-tête de réponse HTTP <code>ETag</code> (entity tag) quand le
    document est contenu dans un fichier statique(la valeur de
    <code>ETag</code>
    est utilisée dans le cadre de la gestion du cache pour préserver la
    bande passante réseau). La directive
    <directive>FileETag</directive> vous permet maintenant de choisir
    quelles caractéristiques du fichier vont être utilisées, le cas
    échéant. Les mots-clés reconnus sont :
    </p>

    <dl>
     <dt><strong>INode</strong></dt>
     <dd>Le numéro d'i-node du fichier sera inclus dans le processus de
     génération</dd>
     <dt><strong>MTime</strong></dt>
     <dd>La date et l'heure auxquelles le fichier a été modifié la
     dernière fois seront incluses</dd>
     <dt><strong>Size</strong></dt>
     <dd>La taille du fichier en octets sera incluse</dd>
     <dt><strong>All</strong></dt>
     <dd>Tous les champs disponibles seront utilisés. Cette définition
     est équivalente à : 
     <highlight language="config">FileETag INode MTime Size</highlight></dd>
     <dt><strong>None</strong></dt>
     <dd>Si le document se compose d'un fichier, aucun champ
     <code>ETag</code> ne sera inclus dans la réponse</dd>
    </dl>

    <p>Les mots-clés <code>INode</code>, <code>MTime</code>, et
    <code>Size</code> peuvent être préfixés par <code>+</code> ou
    <code>-</code>, ce qui permet de modifier les valeurs par défaut
    héritées d'un niveau de configuration plus général. Tout mot-clé
    apparaissant sans aucun préfixe annule entièrement et immédiatement
    les configurations héritées.</p>

    <p>Si la configuration d'un répertoire contient
    <code>FileETag&nbsp;INode&nbsp;MTime&nbsp;Size</code>, et si un de
    ses sous-répertoires contient <code>FileETag&nbsp;-INode</code>, la
    configuration de ce sous-répertoire (qui sera propagée vers tout
    sous-répertoire qui ne la supplante pas), sera équivalente à
    <code>FileETag&nbsp;MTime&nbsp;Size</code>.</p>
    <note type="warning"><title>Avertissement</title>
    Ne modifiez pas les valeurs par défaut pour les répertoires ou
    localisations où WebDAV est activé et qui utilisent
    <module>mod_dav_fs</module> comme fournisseur de stockage.
    <module>mod_dav_fs</module> utilise
    <code>MTime&nbsp;Size</code> comme format fixe pour les
    comparaisons de champs <code>ETag</code> dans les requêtes
    conditionnelles. Ces requêtes conditionnelles échoueront si le
    format <code>ETag</code> est modifié via la directive
    <directive>FileETag</directive>.
    </note>
    <note><title>Inclusions côté serveur</title>
    Aucun champ ETag n'est généré pour les réponses interprétées par
    <module>mod_include</module>, car l'entité de la réponse peut
    changer sans modification de l'INode, du MTime, ou de la taille du
    fichier statique contenant les directives SSI.
    </note>


</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>Files</name>
<description>Contient des directives qui s'appliquent aux fichiers
précisés</description>
<syntax>&lt;Files <var>nom fichier</var>&gt; ... &lt;/Files&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>

<usage>
    <p>La directive <directive type="section">Files</directive> limite
    la portée des directives qu'elle contient aux fichiers précisés.
    Elle est comparable aux directives <directive module="core"
    type="section">Directory</directive> et <directive module="core"
    type="section">Location</directive>. Elle doit se terminer par une
    balise <code>&lt;/Files&gt;</code>. Les directives contenues dans
    cette section s'appliqueront à tout objet dont le nom de base (la
    dernière partie du nom de fichier) correspond au fichier spécifié.
    Les sections <directive type="section">Files</directive> sont
    traitées selon l'ordre dans lequel elles apparaissent dans le
    fichier de configuration, après les sections <directive module="core"
    type="section">Directory</directive> et la lecture des fichiers
    <code>.htaccess</code>, mais avant les sections <directive
    type="section" module="core">Location</directive>. Notez que les
    sections <directive type="section">Files</directive> peuvent être
    imbriquées dans les sections <directive type="section"
    module="core">Directory</directive> afin de restreindre la portion
    du système de fichiers à laquelle ces dernières vont
    s'appliquer.</p>

    <p>L'argument <var>filename</var> peut contenir un nom de fichier
    ou une chaîne de caractères avec caractères génériques, où
    <code>?</code> remplace un caractère, et <code>*</code> toute chaîne
    de caractères.</p>
    <highlight language="config">
&lt;Files "cat.html"&gt;
    # Insérer ici des directives qui s'appliquent au fichier cat.html
&lt;/Files&gt;

&lt;Files "?at.*"&gt;
    # Les directives insérées ici s'appliqueront aux fichiers
    # cat.html, bat.html, hat.php, et ainsi de suite.
&lt;/Files&gt;
</highlight>
    
    <p>On peut aussi utiliser les <glossary
    ref="regex">Expressions rationnelles</glossary> en ajoutant la
    caractère <code>~</code>. Par exemple :</p>

    <highlight language="config">
&lt;Files ~ "\.(gif|jpe?g|png)$"&gt;
    #...
&lt;/Files&gt;
</highlight>

    <p>correspondrait à la plupart des formats graphiques de l'Internet.
    Il est cependant préférable d'utiliser la directive <directive
    module="core" type="section">FilesMatch</directive>.</p>

    <p>Notez qu'à la différence des sections <directive type="section"
    module="core">Directory</directive> et <directive type="section"
    module="core">Location</directive>, les sections <directive
    type="section">Files</directive> peuvent être utilisées dans les
    fichiers <code>.htaccess</code>. Ceci permet aux utilisateurs de
    contrôler l'accès à leurs propres ressources, fichier par
    fichier.</p>

</usage>
<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manière dont ces différentes sections se combinent
entre elles à la réception d'une requête</seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>FilesMatch</name>
<description>Contient des directives qui s'appliquent à des fichiers
spécifiés sous la forme d'expressions rationnelles</description>
<syntax>&lt;FilesMatch <var>expression rationnelle</var>&gt; ...
&lt;/FilesMatch&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>

<usage>
    <p>La section <directive type="section">FilesMatch</directive>
    limite la portée des directives qu'elle contient aux fichiers
    spécifiés, tout comme le ferait une section <directive module="core"
    type="section">Files</directive>. Mais elle accepte aussi les
    <glossary ref="regex">expressions rationnelles</glossary>. Par
    exemple :</p>

    <highlight language="config">
&lt;FilesMatch ".+\.(gif|jpe?g|png)$"&gt;
    # ...
&lt;/FilesMatch&gt;
</highlight>

    <p>correspondrait à la plupart des formats graphiques de
    l'Internet.</p>

    <note>Les caractères <code>.+</code> au début de l'expression
    rationnelle permettent de s'assurer que les fichiers de nom
    <code>.png</code>, ou <code>.gif</code>, par exemple, ne seront pas
    pris en compte.</note>

    <p>A partir de la version 2.4.8, les groupes nommés et les
    références arrières sont extraits et enregistrés dans
    l'environnement avec leur nom en majuscules et préfixé
    par "MATCH_". Ceci permet
    de référencer des URLs dans des <a href="../expr.html">expressions</a>
    ou au sein de modules comme <module>mod_rewrite</module>. Pour
    éviter toute confusion, les références arrières numérotées (non
    nommées) sont ignorées. Vous devez utiliser à la place des groupes
    nommés.</p>

<highlight language="config">
&lt;FilesMatch "^(?&lt;sitename&gt;[^/]+)"&gt;
    Require ldap-group cn=%{env:MATCH_SITENAME},ou=combined,o=Example
&lt;/FilesMatch&gt;
</highlight>

</usage>

<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manière dont ces différentes sections se combinent
entre elles à la réception d'une requête</seealso>
</directivesynopsis>

<directivesynopsis>
<name>ForceType</name>
<description>Force le type de médium spécifié dans le champ d'en-tête
HTTP Content-Type pour les fichiers correspondants</description>
<syntax>ForceType <var>type médium</var>|None</syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>Lorsqu'elle est placée dans un fichier <code>.htaccess</code> ou
    une section <directive type="section"
    module="core">Directory</directive>, <directive type="section"
    module="core">Location</directive>, ou <directive type="section"
    module="core">Files</directive>, cette directive force
    l'identification du type MIME des fichiers spécifiés à la valeur de
    l'argument <var>type médium</var>. Par exemple, si vous possédez un
    répertoire ne contenant que des fichiers GIF, et si vous ne voulez
    pas leur ajouter l'extension <code>.gif</code>, vous pouvez utiliser
    :</p>

    <highlight language="config">ForceType image/gif</highlight>

    <p>Notez que cette directive l'emporte sur d'autres associations de
    type de médium indirectes définies dans mime.types ou via la
    directive <directive module="mod_mime">AddType</directive>.</p>

    <p>Vous pouvez aussi annuler toute définition plus générale de
    <directive>ForceType</directive> en affectant la valeur
    <code>None</code> à l'argument <var>type médium</var> :</p>

    <highlight language="config">
# force le type MIME de tous les fichiers à image/gif:
&lt;Location "/images"&gt;
  ForceType image/gif
&lt;/Location&gt;

# mais utilise les méthodes classiques d'attribution du type MIME
# dans le sous-répertoire suivant :
&lt;Location "/images/mixed"&gt;
  ForceType None
&lt;/Location&gt;
    </highlight>
    
    <p>A la base, cette directive écrase le type de contenu généré pour
    les fichiers statiques servis à partir du sytème de fichiers. Pour
    les ressources autres que les fichiers statiques pour lesquels le
    générateur de réponse spécifie en général un type de contenu, cette
    directive est ignorée.</p>

    <note><title>Note</title>
    <p>Lorsque des directives explicites comme <directive
    module="core">SetHandler</directive> ou
    <directive>module="mod_mime">AddHandler</directive> ne s'appliquent
    pas à la requête courante, le nom du gestionnaire interne
    normalement défini par ces directives correspondra alors au type de
    contenu spécifié par cette directive. Il s'agit d'un
    comportement historique que certains modules
    tiers, comme mod_php, peuvent interpréter comme un type de contenu
    artificiel ne servant qu'à indiquer le module qui doit prendre en
    compte la requête considérée. Dans la mesure du
    possible, il est conseillé d'éviter les
    configurations qui comportent de tels types artificiels en utilisant
    les directives <directive module="core" >SetHandler</directive> ou
    <directive module="mod_mime">AddHandler</directive>.</p>
    </note>

</usage>
</directivesynopsis>
<directivesynopsis>
<name>GprofDir</name>
<description>Répertoire dans lequel écrire les données de profiling
gmon.out.</description>
<syntax>GprofDir <var>/tmp/gprof/</var>|<var>/tmp/gprof/</var>%</syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Lorsque le serveur a été compilé avec le support du profiling
    gprof, la directive <directive>GprofDir</directive> permet de
    spécifier dans quel répertoire les fichiers <code>gmon.out</code>
    doivent être écrits lorsque le processus s'arrête. Si l'argument se
    termine par un caractère pourcentage ('%'), des sous-répertoires
    sont créés pour chaque identifiant de processus.</p>

    <p>Cette directive ne fonctionne actuellement qu'avec le MPM
    <module>prefork</module>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>HostnameLookups</name>
<description>Active la recherche DNS sur les adresses IP des
clients</description>
<syntax>HostnameLookups On|Off|Double</syntax>
<default>HostnameLookups Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context></contextlist>

<usage>
    <p>Cette directive active la recherche DNS afin de pouvoir
    journaliser les nom d'hôtes (et les passer aux programmes CGI et aux
    inclusions SSI via la variable <code>REMOTE_HOST</code>). La valeur
    <code>Double</code> déclenche une double recherche DNS inverse. En
    d'autres termes, une fois la recherche inverse effectuée, on lance
    une recherche directe sur le résultat de cette dernière. Au moins
    une des adresses IP fournies par la recherche directe doit
    correspondre à l'adresse originale (ce que l'on nomme
    <code>PARANOID</code> dans la terminologie "tcpwrappers").</p>

    <p>Quelle que soit la configuration, lorsqu'on utilise
    <module>mod_authz_host</module> pour contrôler l'accès en fonction
    du nom d'hôte, une double recherche DNS inverse est effectuée,
    sécurité oblige. Notez cependant que le résultat de cette double
    recherche n'est en général pas accessible, à moins que vous n'ayez
    spécifié <code>HostnameLookups Double</code>. Par exemple, si vous
    n'avez spécifié que <code>HostnameLookups On</code>, et si une
    requête concerne un objet protégé par des restrictions en fonction
    du nom d'hôte, quel que soit le résultat de la double recherche
    inverse, les programmes CGI ne recevront que le résultat de la
    recherche inverse simple dans la variable
    <code>REMOTE_HOST</code>.</p>

    <p>La valeur par défaut est <code>Off</code> afin de préserver le
    traffic réseau des sites pour lesquels la recherche inverse n'est
    pas vraiment nécessaire. Cette valeur par défaut est aussi bénéfique
    pour les utilisateurs finaux car il n'ont ainsi pas à subir de temps
    d'attente supplémentaires dus aux recherches DNS. Les sites
    fortement chargés devraient laisser cette directive à
    <code>Off</code>, car les recherches DNS peuvent prendre des temps
    très longs. Vous pouvez éventuellement utiliser hors ligne
    l'utilitaire <program>logresolve</program>, compilé par défaut dans
    le sous-répertoire <code>bin</code> de votre répertoire
    d'installation, afin de déterminer les noms d'hôtes associés aux
    adresses IP journalisées.</p>

    <p>Enfin, si vous avez des <a
    href="mod_authz_host.html#reqhost">directives Require à base de
    nom</a>, une recherche de nom d'hôte sera effectuée quelle que soit
    la définition de la directive <code>HostnameLookups</code>.</p>
</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>If</name>
<description>Contient des directives qui ne s'appliquent que si une
condition est satisfaite au cours du traitement d'une
requête</description>
<syntax>&lt;If <var>expression</var>&gt; ... &lt;/If&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>
<compatibility>Les conditions imbriquées sont supportées à partir de la version
2.4.26 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive type="section">If</directive> évalue une
    expression à la volée, et applique les directives qu'elle contient
    si et seulement si l'expression renvoie la valeur "vrai". Par
    exemple :</p>

    <highlight language="config">&lt;If "-z req('Host')"&gt;</highlight>

    <p>serait satisfaite pour les requêtes HTTP/1.0 sans en-tête
    <var>Host:</var>. Les expressions peuvent contenir différents
    opérateurs de type shell pour la comparaison de chaînes
    (<code>==</code>, <code>!=</code>, <code>&lt;</code>, ...), la
    comparaison d'entiers (<code>-eq</code>, <code>-ne</code>, ...), ou
    à usages divers (<code>-n</code>, <code>-z</code>, <code>-f</code>,
    ...). Les expressions rationnelles sont aussi supportées,</p>

    <highlight language="config">&lt;If "%{QUERY_STRING} =~ /(delete|commit)=.*?elem/"&gt;</highlight>

    <p>ainsi que les comparaison de modèles de type shell et de
    nombreuses autres opérations. Ces opérations peuvent être effectuées
    sur les en-têtes de requêtes (<code>req</code>), les variables
    d'environnement (<code>env</code>), et un grand nombre d'autres
    propriétés. La documentation complète est disponible dans <a
    href="../expr.html">Les expressions dans le serveur HTTP Apache</a>.</p>

    <p>Cette section de configuration ne peut contenir que des
    directives qui supportent le <a
    href="directive-dict.html#Context">contexte de répertoire</a>.</p>

    <note type="warning">
    Certain variables, such as <code>CONTENT_TYPE</code> and other
    response headers, are set after &lt;If&gt; conditions have already
    been evaluated, and so will not be available to use in this
    directive.
    </note>

</usage>

<seealso><a href="../expr.html">Les expressions dans le serveur HTTP
Apache</a>, pour une référence complète et d'autres exemples.</seealso>
<seealso><directive type="section" module="core">ElseIf</directive></seealso>
<seealso><directive type="section" module="core">Else</directive></seealso>
<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manière dont ces différentes sections se combinent
entre elles à la réception d'une requête. Les
directives <directive type="section">If</directive>, <directive
type="section">ElseIf</directive>, et <directive
type="section">Else</directive> s'appliquent en dernier.</seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>IfDefine</name>
<description>Contient des directives qui ne s'appliqueront que si un
test retourne "vrai" au démarrage du serveur</description>
<syntax>&lt;IfDefine [!]<var>paramètre</var>&gt; ...
    &lt;/IfDefine&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>

<usage>
    <p>La section <code>&lt;IfDefine
    <var>test</var>&gt;...&lt;/IfDefine&gt;</code> permet de
    conférer un caractère conditionnel à un ensemble de directives. Les
    directives situées à l'intérieur d'une section <directive
    type="section">IfDefine</directive> ne s'appliquent que si
    <var>test</var> est vrai. Si <var>test</var> est faux, tout ce qui
    se trouve entre les balises de début et de fin est ignoré.</p>

    <p><var>test</var> peut se présenter sous deux formes :</p>

    <ul>
      <li><var>nom paramètre</var></li>

      <li><code>!</code><var>nom paramètre</var></li>
    </ul>

    <p>Dans le premier cas, les directives situées entre les balises de
    début et de fin ne s'appliqueront que si le paramètre nommé <var>nom
    paramètre</var> est défini. Le second format inverse le test, et
    dans ce cas, les directives ne s'appliqueront que si <var>nom
    paramètre</var> n'est <strong>pas</strong> défini.</p>

    <p>L'argument <var>nom paramètre</var> est une définition qui peut
    être effectuée par la ligne de commande
    <program>httpd</program> via le paramètre
    <code>-D<var>paramètre</var></code> au démarrage du serveur, ou via la
    directive <directive module="core">Define</directive>.</p>

    <p>Les sections <directive type="section">IfDefine</directive>
    peuvent être imbriquées, ce qui permet d'implémenter un test
    multi-paramètres simple. Exemple :</p>

    <example>httpd -DReverseProxy -DUseCache -DMemCache ...</example>
    <highlight language="config">
&lt;IfDefine ReverseProxy&gt;
  LoadModule proxy_module   modules/mod_proxy.so
  LoadModule proxy_http_module   modules/mod_proxy_http.so
  &lt;IfDefine UseCache&gt;
    LoadModule cache_module   modules/mod_cache.so
    &lt;IfDefine MemCache&gt;
      LoadModule mem_cache_module   modules/mod_mem_cache.so
    &lt;/IfDefine&gt;
    &lt;IfDefine !MemCache&gt;
      LoadModule cache_disk_module   modules/mod_cache_disk.so
    &lt;/IfDefine&gt;
  &lt;/IfDefine&gt;
&lt;/IfDefine&gt;
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>IfFile</name>
<description>Regroupe des directives qui ne seront traitées que si un fichier
existe au démarrage</description>
<syntax>&lt;IfFile [!]<var>filename</var>&gt; ...
    &lt;/IfFile&gt;</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>
<compatibility>Disponible à partir de la version 2.4.34 du serveur HTTP Apache</compatibility>

<usage>
    <p>La section <code>&lt;IfFile <var>filename</var>&gt;...&lt;/IfFile&gt;</code>
    permet de conditionner le traitement de directives à
    l'existence d'un fichier sur disque. Ainsi, les directives définies au sein
    d'une section <directive type="section">IfFile</directive> ne seront
    traitées que si le fichier <var>filename</var> existe. Si le fichier
    <var>filename</var> n'existe pas, tout ce qui se trouve entre les marqueurs
    start et end sera ignoré. <var>filename</var> peut être un chemin absolu ou
    relatif au chemin défini par la directive ServerRoot.</p>

    <p>Le paramètre <var>filename</var> de l'en-tête d'une section <directive
    type="section">IfFile</directive> peut prendre la même forme que la variable
    <var>test</var> de la section <directive type="section"
    module="core">IfDefine</directive> ; à ce titre, le résultat du test peut
    être inversé en plaçant le caractère <code>!</code> juste avant
    <var>filename</var>.
    </p>
   
    <p>Si <var>filename</var> est un chemin relatif, il sera généré par rapport
    au chemin défini par la directive <directive
    module="core">ServerRoot</directive>. Lorsque la directive <directive
    type="section">IfFile</directive> intervient avant la définition de la
    directive <directive module="core">ServerRoot</directive>,
    <var>filename</var> sera relatif au répertoire racine par défaut du serveur
    ou au répertoire racine passé dans la ligne de commande via l'option
    <code>-d</code>.</p>
    
</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>IfModule</name>
<description>Contient des directives qui ne s'appliquent qu'en fonction
de la présence ou de l'absence d'un module spécifique</description>
<syntax>&lt;IfModule [!]<var>fichier module</var>|<var>identificateur
module</var>&gt; ... &lt;/IfModule&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>
<compatibility>Les identificateurs de modules sont disponibles dans les
versions 2.1 et supérieures.</compatibility>

<usage>
    <p>La section <code>&lt;IfModule
    <var>test</var>&gt;...&lt;/IfModule&gt;</code> permet de conférer à
    des directives un caractère conditionnel basé sur la présence d'un
    module spécifique. Les directives situées dans une section
    <directive type="section">IfModule</directive> ne s'appliquent que
    si <var>test</var> est vrai. Si <var>test</var> est faux, tout ce
    qui se trouve entre les balises de début et de fin est ignoré.</p>

    <p><var>test</var> peut se présenter sous deux formes :</p>

    <ul>
      <li><var>module</var></li>

      <li>!<var>module</var></li>
    </ul>

    <p>Dans le premier cas, les directives situées entre les balises de
    début et de fin ne s'appliquent que si le module <var>module</var>
    est présent -- soit compilé avec le binaire Apache httpd, soit chargé
    dynamiquement via la directive <directive module="mod_so"
    >LoadModule</directive>. Le second format inverse le test, et dans
    ce cas, les directives ne s'appliquent que si <var>module</var>
    n'est <strong>pas</strong> présent.</p>

    <p>L'argument <var>module</var> peut contenir soit l'identificateur
    du module, soit le nom du fichier source du module. Par exemple,
    <code>rewrite_module</code> est un identificateur et
    <code>mod_rewrite.c</code> le nom du fichier source
    correspondant. Si un module comporte plusieurs fichiers sources,
    utilisez le nom du fichier qui contient la chaîne de caractères
    <code>STANDARD20_MODULE_STUFF</code>.</p>

    <p>Les sections <directive type="section">IfModule</directive>
    peuvent être imbriquées, ce qui permet d'implémenter des tests
    multi-modules simples.</p>

    <note>Cette section ne doit être utilisée que si votre fichier de
    configuration ne fonctionne qu'en fonction de la présence ou de
    l'absence d'un module spécifique. D'une manière générale, il n'est
    pas nécessaire de placer les directives à l'intérieur de sections
    <directive type="section">IfModule</directive>.</note>
</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>IfDirective</name>
<description>Regroupe des directives dont le traitement est conditionné par la
présence ou l'absence d'une directive particulière</description>
<syntax>&lt;IfDirective [!]<var>directive-name</var>&gt; ...
    &lt;/IfDirective&gt;</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>
<compatibility>Disponible à partir de la version 2.4.34 du serveur HTTP Apache</compatibility>

<usage>
    <p>La section <code>&lt;IfDirective
    <var>test</var>&gt;...&lt;/IfDirective&gt;</code> permet de regrouper des
    directives dont le traitement n'est effectué que si une directive
    particulière est présente, autrement dit si l'expression <var>test</var> est
    évaluée à true. Si l'expression <var>test</var> est évaluée à false, toutes
    les lignes qui se trouvent entre les balises de début et de fin de la
    section sont ignorées.</p>

    <p>L'expression <var>test</var> de la section <directive
    type="section">IfDirective</directive> peut prendre les deux formes
    suivantes :</p>

    <ul>
      <li><var>directive-name</var></li>

      <li>!<var>directive-name</var></li>
    </ul>

    <p>Dans le premier cas, les directives qui se situent entre les balises de
    début et de fin de la section ne sont traitées que si une directive de nom
    directive-name est disponible à cet instant. Dans le second cas, la condition est
    inversée, et les directives ne sont traitées que si
    <var>directive-name</var> n'est <strong>pas</strong> disponible.</p>

    <note>Cette section ne doit être utilisée que si vous devez partager le même
    fichier de configuration entre plusieurs versions de
    <program>httpd</program>, sans tenir compte de la disponibilité de telle ou
    telle directive. Dans une configuration standard, il est inutile de placer
    les directives dans des sections <directive
    type="section">IfDirective</directive>.</note>
</usage>
<seealso><directive module="core" type="section">IfSection</directive></seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>IfSection</name>
<description>Regroupe des directives dont le traitement est conditionné par la
présence ou l'absence d'une section particulière</description>
<syntax>&lt;IfSection [!]<var>section-name</var>&gt; ...
    &lt;/IfSection&gt;</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>
<compatibility>Disponible à partir de la version 2.4.34 du serveur HTTP Apache</compatibility>

<usage>
    <p>La section <code>&lt;IfSection
    <var>test</var>&gt;...&lt;/IfSection&gt;</code> permet de regrouper des
    directives dont le traitement n'est effectué que si une section de
    configuration particulière est présente. Une section, par exemple <directive
    type="section">VirtualHost</directive>, permet de regrouper des directives
    et possède un nom précédé du caractère "&lt;".</p>

    <p>Les directives situées à l'intérieur d'une section <directive
    type="section">IfSection</directive> ne sont traitées que si l'expression
    <var>test</var> est évaluée à true. Si l'expression <var>test</var> est
    évaluée à false, toutes les lignes situées entre les balises de début et de
    fin de la section sont ignorées.</p>

    <p><var>section-name</var> doit être spécifié sans les caractères de début
    "&lt;" ou fin "&gt;". L'expression <var>test</var> de la section <directive
    type="section">IfSection</directive> peut prendre deux formes :</p>

    <ul>
      <li><var>section-name</var></li>
      <li>!<var>section-name</var></li>
    </ul>

    <p>Dans le premier cas, les directives qui se situent entre les balises de
    début et de fin de la section ne sont traitées que si une section de nom
    section-name est disponible à cet instant. Dans le second cas, la condition est
    inversée, et les directives ne sont traitées que si
    <var>section-name</var> n'est <strong>pas</strong> disponible.</p>

    <p>Par exemple :</p>

    <highlight language="config">
&lt;IfSection VirtualHost&gt;
   ...
&lt;/IfSection&gt;
    </highlight>
    
    <note>Cette section ne doit être utilisée que si vous devez partager le même
    fichier de configuration entre plusieurs versions de
    <program>httpd</program>, sans tenir compte de la disponibilité de telle ou
    telle section. Dans une configuration standard, il est inutile de placer
    les directives dans des sections <directive
    type="section">IfSection</directive>.</note>
</usage>
<seealso><directive module="core" type="section">IfDirective</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>Include</name>
<description>Inclut d'autres fichiers de configuration dans un des
fichiers de configuration du serveur</description>
<syntax>Include <var>chemin-fichier</var>|<var>chemin-répertoire</var>|<var>wildcard</var></syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context>
</contextlist>
<compatibility>Utilisation des caractères génériques dans la partie chemin depuis la
version 2.3.6</compatibility>

<usage>
    <p>Cette directive permet l'inclusion d'autres fichiers de
    configuration dans un des fichiers de configuration du serveur.</p>

    <p>On peut utiliser des caractères génériques de style Shell
    (<code>fnmatch()</code>) aussi bien dans la partie nom de fichier du
    chemin que dans la partie répertoires pour inclure plusieurs
    fichiers en une
    seule fois, selon leur ordre alphabétique. De plus, si la directive
    <directive>Include</directive> pointe vers un répertoire, Apache
    httpd inclura tous les fichiers de ce répertoire et de tous ces
    sous-répertoires. L'inclusion de répertoires entiers est cependant
    déconseillée, car il est fréquent d'oublier des fichiers
    temporaires dans un répertoire, ce qui causerait une erreur
    <program>httpd</program> en cas d'inclusion. Pour inclure des
    fichiers qui correspondent à un certain modèle, comme *.conf par
    exemple, nous vous recommandons d'utiliser plutôt la syntaxe avec
    caractères génériques comme ci-dessous.</p>

    <p>La directive <directive module="core">Include</directive>
    <strong>échouera avec un code d'erreur</strong> si une expression
   contenant des caractères génériques ne correspond à aucun fichier.
   Pour ignorer les expressions contenant des caractères génériques ne
   correspondant à aucun fichier, utilisez la directive <directive
   module="core">IncludeOptional</directive>.</p>

    <p>Le chemin fichier spécifié peut être soit un chemin absolu, soit
    un chemin relatif au répertoire défini par la directive <directive
    module="core">ServerRoot</directive>.</p>

    <p>Exemples :</p>

    <highlight language="config">
Include /usr/local/apache2/conf/ssl.conf
Include /usr/local/apache2/conf/vhosts/*.conf
    </highlight>

    <p>ou encore, avec des chemins relatifs au répertoire défini par la
    directive <directive module="core">ServerRoot</directive> :</p>

    <highlight language="config">
Include conf/ssl.conf
Include conf/vhosts/*.conf
    </highlight>

    <p>On peut aussi insérer des caractères génériques dans la partie
    répertoires du chemin. Dans l'exemple suivant, la directive
    échouera si aucun sous-répertoire de conf/vhosts ne contient au
    moins un fichier *.conf :</p>
  
    <highlight language="config">Include conf/vhosts/*/*.conf</highlight>

    <p>Par contre, dans l'exemple suivant, la directive sera simplement
    ignorée si aucun sous-répertoire de conf/vhosts ne contient au
    moins un fichier *.conf :</p>

    <highlight language="config">IncludeOptional conf/vhosts/*/*.conf</highlight>
  
</usage>    

<seealso><directive module="core">IncludeOptional</directive></seealso>
<seealso><program>apachectl</program></seealso>
</directivesynopsis>

<directivesynopsis>
<name>IncludeOptional</name>
<description>Inclusion de fichiers dans le fichier de configuration</description>
<syntax>IncludeOptional
<var>file-path</var>|<var>directory-path</var>|<var>wildcard</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>
<compatibility>Disponible à partir de la version 2.3.6 du serveur HTTP
Apache. Après la version 2.4.30, les chemins de fichiers non existants et
ne comportant pas de caractères génériques ne génèrent plus d'erreurs de syntaxe</compatibility>
 
<usage>
    <p>Cette directive permet d'inclure des fichiers dans les fichiers
    de configuration du serveur. Elle fonctionne de manière identique à
    la directive <directive module="core">Include</directive>, mais au lieu de
    générer une erreur, elle sera ignorée silensieusement si malgré
    l'utilisation de caractères génériques, le chemin de fichier ou de
    répertoire spécifié n'existe pas dans le système de fichiers.</p>    
    
</usage>

<seealso><directive module="core">Include</directive></seealso>
<seealso><program>apachectl</program></seealso>
</directivesynopsis>

<directivesynopsis>
<name>KeepAlive</name>
<description>Active les connexions HTTP persistantes</description>
<syntax>KeepAlive On|Off</syntax>
<default>KeepAlive On</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>L'extension Keep-Alive de HTTP/1.0 et l'implémentation des
    connexions persistantes dans HTTP/1.1 ont rendu possibles des
    sessions HTTP de longue durée, ce qui permet de transmettre
    plusieurs requêtes via la même connexion TCP. Dans certains cas, le
    gain en rapidité pour des documents comportant de nombreuses images
    peut atteindre 50%. Pour activer les connexions persistantes,
    définissez <code>KeepAlive On</code>.</p>

    <p>Pour les clients HTTP/1.0, les connexions persistantes ne seront
    mises en oeuvre que si elles ont été spécialement demandées par un
    client. De plus, une connexion persistante avec un client HTTP/1.0
    ne peut être utilisée que si la taille du contenu est connue
    d'avance. Ceci implique que les contenus dynamiques comme les
    sorties CGI, les pages SSI, et les listings de répertoires générés
    par le serveur n'utiliseront en général pas les connexions
    persistantes avec les clients HTTP/1.0. Avec les clients HTTP/1.1,
    les connexions persistantes sont utilisées par défaut, sauf
    instructions contraires. Si le client le demande, le transfert par
    tronçons de taille fixe (chunked encoding) sera utilisé afin de
    transmettre un contenu de longueur inconnue via une connexion
    persistante.</p>

    <p>Lorsqu'un client utilise une connexion persistante, elle comptera
    pour une seule requête pour la directive <directive
    module="mpm_common">MaxConnectionsPerChild</directive>, quel
    que soit le nombre de requêtes transmises via cette connexion.</p>
</usage>

<seealso><directive module="core">MaxKeepAliveRequests</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>KeepAliveTimeout</name>
<description>Durée pendant laquelle le serveur va attendre une requête
avant de fermer une connexion persistante</description>
<syntax>KeepAliveTimeout <var>nombre</var>[ms]</syntax>
<default>KeepAliveTimeout 5</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>Le nombre de secondes pendant lesquelles Apache httpd va attendre une
    requête avant de fermer la connexion. Le délai peut être défini en
    millisecondes en suffixant sa valeur par ms. La valeur du délai
    spécifiée par la directive <directive
    module="core">Timeout</directive> s'applique dès qu'une requête a
    été reçue.</p>

    <p>Donner une valeur trop élévée à
    <directive>KeepAliveTimeout</directive> peut induire des problèmes
    de performances sur les serveurs fortement chargés. Plus le délai
    est élévé, plus nombreux seront les processus serveur en attente de
    requêtes de la part de clients inactifs.</p>

    <p>Si la directive <directive>KeepAliveTimeout</directive> n'est
    <strong>pas</strong> définie pour un serveur virtuel à base de nom, c'est
    la valeur de la paire adresse IP/port du serveur virtuel qui
    correspond le mieux qui sera utilisée.</p>
</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>Limit</name>
<description>Limite les contrôles d'accès que la section contient à
certaines méthodes HTTP</description>
<syntax>&lt;Limit <var>méthode</var> [<var>méthode</var>] ... &gt; ...
    &lt;/Limit&gt;</syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig, Limit</override>

<usage>
    <p>Les contrôles d'accès s'appliquent normalement à
    <strong>toutes</strong> les méthodes d'accès, et c'est en général le
    comportement souhaité. <strong>Dans le cas général, les directives
    de contrôle d'accès n'ont pas à être placées dans une section
    <directive type="section">Limit</directive>.</strong></p>

    <p>La directive <directive type="section">Limit</directive> a pour
    but de limiter les effets des contrôles d'accès aux méthodes HTTP
    spécifiées. Pour toutes les autres méthodes, les restrictions
    d'accès contenues dans la section <directive
    type="section">Limit</directive> <strong>n'auront aucun
    effet</strong>. L'exemple suivant n'applique les contrôles d'accès
    qu'aux méthodes <code>POST</code>, <code>PUT</code>, et
    <code>DELETE</code>, en laissant les autres méthodes sans protection
    :</p>

    <highlight language="config">
&lt;Limit POST PUT DELETE&gt;
  Require valid-user
&lt;/Limit&gt;
    </highlight>

    <p>La liste des noms de méthodes peut contenir une ou plusieurs
    valeurs parmi les suivantes : <code>GET</code>, <code>POST</code>,
    <code>PUT</code>, <code>DELETE</code>, <code>CONNECT</code>,
    <code>OPTIONS</code>, <code>PATCH</code>, <code>PROPFIND</code>,
    <code>PROPPATCH</code>, <code>MKCOL</code>, <code>COPY</code>,
    <code>MOVE</code>, <code>LOCK</code>, et <code>UNLOCK</code>.
    <strong>Le nom de méthode est sensible à la casse.</strong> Si la
    valeur <code>GET</code> est présente, les requêtes <code>HEAD</code>
    seront aussi concernées. La méthode <code>TRACE</code> ne peut pas
    être limitée (voir la directive <directive
    module="core">TraceEnable</directive>).</p>

    <note type="warning">Une section <directive
    type="section">LimitExcept</directive> doit toujours être préférée à
    une section <directive type="section">Limit</directive> pour la
    restriction d'accès, car une section <directive type="section"
    module="core">LimitExcept</directive> fournit une protection contre
    les méthodes arbitraires.</note>

    <p>Les directives <directive type="section">Limit</directive> et
    <directive type="section" module="core">LimitExcept</directive>
    peuvent être imbriquées. Dans ce cas, pour chaque niveau des
    directives <directive type="section">Limit</directive> ou  <directive
    type="section" module="core">LimitExcept</directive>, ces dernières
    doivent restreindre l'accès pour les méthodes auxquelles les
    contrôles d'accès s'appliquent.</p>

    <note type="warning">Lorsqu'on utilise les directives <directive
    type="section">Limit</directive> ou <directive
    type="section">LimitExcept</directive> avec la directive <directive
    module="mod_authz_core">Require</directive>, la première directive
    <directive module="mod_authz_core">Require</directive> dont la
    condition est satisfaite autorise la requête, sans tenir compte de
    la présence d'autres directives <directive
    module="mod_authz_core">Require</directive>.</note>

    <p>Par exemple, avec la configuration suivante, tous les
    utilisateurs seront autorisés à effectuer des requêtes
    <code>POST</code>, et la directive <code>Require group
    editors</code> sera ignorée dans tous les cas :</p>

    <highlight language="config">
&lt;LimitExcept GET&gt;
  Require valid-user
&lt;/LimitExcept&gt;
&lt;Limit POST&gt;
  Require group editors
&lt;/Limit&gt;
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>LimitExcept</name>
<description>Applique les contrôles d'accès à toutes les méthodes HTTP,
sauf celles qui sont spécifiées</description>
<syntax>&lt;LimitExcept <var>méthode</var> [<var>méthode</var>] ... &gt; ...
    &lt;/LimitExcept&gt;</syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig, Limit</override>

<usage>
    <p><directive type="section">LimitExcept</directive> et
    <code>&lt;/LimitExcept&gt;</code> permettent de regrouper des
    directives de contrôle d'accès qui s'appliqueront à toutes les
    méthodes d'accès HTTP qui ne font <strong>pas</strong> partie de la
    liste des arguments ; en d'autres termes, elles ont un comportement
    opposé à celui de la section <directive type="section"
    module="core">Limit</directive>, et on peut les utiliser pour
    contrôler aussi bien les méthodes standards que les méthodes non
    standards ou non reconnues. Voir la documentation de la section
    <directive module="core" type="section">Limit</directive> pour plus
    de détails.</p>

    <p>Par exemple :</p>

    <highlight language="config">
&lt;LimitExcept POST GET&gt;
  Require valid-user
&lt;/LimitExcept&gt;
    </highlight>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>LimitInternalRecursion</name>
<description>Détermine le nombre maximal de redirections internes et de
sous-requêtes imbriquées</description>
<syntax>LimitInternalRecursion <var>nombre</var> [<var>nombre</var>]</syntax>
<default>LimitInternalRecursion 10</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>Une redirection interne survient, par exemple, quand on utilise
    la directive <directive module="mod_actions">Action</directive> qui
    redirige en interne la requête d'origine vers un script CGI. Une
    sous-requête est le mécanisme qu'utilise Apache httpd pour déterminer ce
    qui se passerait pour un URI s'il faisait l'objet d'une requête. Par
    exemple, <module>mod_dir</module> utilise les sous-requêtes pour
    rechercher les fichiers listés dans la directive <directive
    module="mod_dir">DirectoryIndex</directive>.</p>

    <p>La directive <directive>LimitInternalRecursion</directive> permet
    d'éviter un crash du serveur dû à un bouclage infini de redirections
    internes ou de sous-requêtes. De tels bouclages sont dus en général
    à des erreurs de configuration.</p>

    <p>La directive accepte, comme arguments, deux limites qui sont
    évaluées à chaque requête. Le premier <var>nombre</var> est le
    nombre maximum de redirections internes qui peuvent se succéder. Le
    second <var>nombre</var> détermine la profondeur d'imbrication
    maximum des sous-requêtes. Si vous ne spécifiez qu'un seul
    <var>nombre</var>, il sera affecté aux deux limites.</p>

    <highlight language="config">LimitInternalRecursion 5</highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LimitRequestBody</name>
<description>limite la taille maximale du corps de la requête HTTP
envoyée par le client</description>
<syntax>LimitRequestBody <var>octets</var></syntax>
<default>LimitRequestBody 0</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>

<usage>
    <p>Cette directive spécifie la taille maximale autorisée pour le
    corps d'une requête ; la valeur de l'argument <var>octets</var> va
    de 0 (pour une taille illimitée), à 2147483647 (2Go). Voir la note
    ci-dessous pour la limite d'applicabilité aux requêtes mandatées.</p>

    <p>La directive <directive>LimitRequestBody</directive> permet de
    définir une limite pour la taille maximale autorisée du corps d'une
    requête HTTP en tenant compte du contexte dans lequel la directive
    a été placée (c'est à dire au niveau du serveur, d'un répertoire,
    d'un fichier ou d'une localisation). Si la requête du client dépasse
    cette limite, le serveur répondra par un message d'erreur et ne
    traitera pas la requête. La taille du corps d'une requête normale va
    varier de manière importante en fonction de la nature de la
    ressource et des méthodes autorisées pour cette dernière. Les
    scripts CGI utilisent souvent le corps du message pour extraire les
    informations d'un formulaire. Les implémentations de la méthode
    <code>PUT</code> nécessitent une valeur au moins aussi élevée que la
    taille maximale des représentations que le serveur désire accepter
    pour cette ressource.</p>

    <p>L'administrateur du serveur peut utiliser cette directive pour
    contrôler plus efficacement les comportements anormaux des requêtes
    des clients, ce qui lui permettra de prévenir certaines formes
    d'attaques par déni de service.</p>

    <p>Si par exemple, vous autorisez le chargement de fichiers vers une
    localisation particulière, et souhaitez limiter la taille des
    fichiers chargés à 100Ko, vous pouvez utiliser la directive suivante
    :</p>

    <highlight language="config">LimitRequestBody 102400</highlight>

    <note><p>Pour une description détaillée de la manière dont cette
    directive est interprétée par les requêtes mandatées, voir la
    documentation du module <module>mod_proxy</module>.</p>
    </note>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>LimitRequestFields</name>
<description>Limite le nombre de champs d'en-tête autorisés dans une
requête HTTP</description>
<syntax>LimitRequestFields <var>nombre</var></syntax>
<default>LimitRequestFields 100</default>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p><var>nombre</var> est un entier de 0 (nombre de champs illimité)
    à 32767. La valeur par défaut est définie à la compilation par la
    constante <code>DEFAULT_LIMIT_REQUEST_FIELDS</code> (100 selon la
    distribution).</p>

    <p>La directive <directive>LimitRequestFields</directive> permet à
    l'administrateur du serveur de modifier le nombre maximum de champs
    d'en-tête autorisés dans une requête HTTP. Pour un serveur, cette
    valeur doit être supérieure au nombre de champs qu'une requête
    client normale peut contenir. Le nombre de champs d'en-tête d'une
    requête qu'un client utilise dépasse rarement 20, mais ce nombre
    peut varier selon les implémentations des clients, et souvent en
    fonction des extensions que les utilisateurs configurent dans leurs
    navigateurs pour supporter la négociation de contenu détaillée. Les
    extensions HTTP optionnelles utilisent souvent les
    champs d'en-tête des requêtes.</p>

    <p>L'administrateur du serveur peut utiliser cette directive pour
    contrôler plus efficacement les comportements anormaux des requêtes
    des clients, ce qui lui permettra de prévenir certaines formes
    d'attaques par déni de service. La valeur spécifiée doit être
    augmentée si les clients standards reçoivent une erreur du serveur
    indiquant que la requête comportait un nombre d'en-têtes trop
    important.</p>

    <p>Par exemple :</p>

    <highlight language="config">LimitRequestFields 50</highlight>

    <note type="warning"><title>Avertissement</title>
     <p>Dans le cas des serveurs virtuels à base de noms, la valeur de
     cette directive est extraite du serveur virtuel par défaut (le
     premier de la liste) pour la paire adresse IP/port.</p>
    </note>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>LimitRequestFieldSize</name>
<description>Dédinit la taille maximale autorisée d'un en-tête de
requête HTTP</description>
<syntax>LimitRequestFieldSize <var>octets</var></syntax>
<default>LimitRequestFieldSize 8190</default>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p>Cette directive permet de définir le nombre maximum
    d'<var>octets</var> autorisés dans un en-tête de requête HTTP.</p>

    <p>La directive <directive>LimitRequestFieldSize</directive> permet
    à l'administrateur du serveur de définir la taille
    maximale autorisée d'un en-tête de requête HTTP. Pour un serveur,
    cette valeur doit être suffisamment grande pour contenir tout
    en-tête d'une requête client normale. La taille d'un champ d'en-tête
    de requête normal va varier selon les implémentations des clients,
    et en fonction des extensions que les utilisateurs
    configurent dans leurs navigateurs pour supporter la négociation de
    contenu détaillée. Les en-têtes d'authentification SPNEGO peuvent
    atteindre une taille de 12392 octets.</p>

    <p>>L'administrateur du serveur peut utiliser cette directive pour
    contrôler plus efficacement les comportements anormaux des requêtes
    des clients, ce qui lui permettra de prévenir certaines formes
    d'attaques par déni de service.</p>

    <p>Par exemple ::</p>

    <highlight language="config">LimitRequestFieldSize 4094</highlight>

    <note>Dans des conditions normales, la valeur par défaut de cette
    directive ne doit pas être modifiée.</note>

    <note type="warning"><title>Avertissement</title>
     <p>Dans le cas des serveurs virtuels à base de noms, la valeur de
     cette directive est extraite du serveur virtuel par défaut (le
     premier de la liste) pour lequel la paire adresse IP/port
     correspond le mieux.</p>
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LimitRequestLine</name>
<description>Définit la taille maximale d'une ligne de requête
HTTP</description>
<syntax>LimitRequestLine <var>octets</var></syntax>
<default>LimitRequestLine 8190</default>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p>Cette directive permet de définir la taille maximale autorisée
    pour une ligne de requête HTTP en <var>octets</var>.</p>

    <p>La directive <directive>LimitRequestLine</directive> permet à
    l'administrateur du serveur de définir la taille
    maximale autorisée d'une ligne de requête HTTP client. Comme une
    requête comporte une méthode HTTP, un URI, et une version de
    protocole, la directive <directive>LimitRequestLine</directive>
    impose une restriction sur la longueur maximale autorisée pour un
    URI dans une requête au niveau du serveur. Pour un serveur, cette
    valeur doit être suffisamment grande pour référencer les noms de
    toutes ses ressources, y compris toutes informations pouvant être
    ajoutées dans la partie requête d'une méthode <code>GET</code>.</p>

    <p>L'administrateur du serveur peut utiliser cette directive pour
    contrôler plus efficacement les comportements anormaux des requêtes
    des clients, ce qui lui permettra de prévenir certaines formes
    d'attaques par déni de service.</p>

    <p>Par exemple :</p>

    <highlight language="config">LimitRequestLine 4094</highlight>

    <note>Dans des conditions normales, cette directive doit conserver
    sa valeur par défaut.</note>

    <note type="warning"><title>Avertissement</title>
     <p>Dans le cas des serveurs virtuels à base de noms, la valeur de
     cette directive est extraite du serveur virtuel par défaut (le
     premier de la liste) pour lequel la paire adresse IP/port
     correspond le mieux.</p>
    </note>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>LimitXMLRequestBody</name>
<description>Définit la taille maximale du corps d'une requête au format
XML</description>
<syntax>LimitXMLRequestBody <var>octets</var></syntax>
<default>LimitXMLRequestBody 1000000</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>All</override>

<usage>
    <p>Taille maximale (en octets) du corps d'une requête au format XML.
    Une valeur de <code>0</code> signifie qu'aucune limite n'est
    imposée.</p>

    <p>Exemple :</p>

    <highlight language="config">LimitXMLRequestBody 0</highlight>

</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>Location</name>
<description>N'applique les directives contenues qu'aux URLs
spécifiées</description>
<syntax>&lt;Location
    <var>chemin URL</var>|<var>URL</var>&gt; ... &lt;/Location&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>La directive <directive type="section">Location</directive>
    limite la portée des directives contenues aux URLs définies par
    l'argument URL. Elle est similaire à la directive <directive
    type="section" module="core">Directory</directive>, et marque le
    début d'une section qui se termine par une directive
    <code>&lt;/Location&gt;</code>. Les sections <directive
    type="section">Location</directive> sont traitées selon l'ordre dans
    lequel elles apparaissent dans le fichier de configuration, mais
    après les sections <directive
    type="section" module="core">Directory</directive> et la lecture des
    fichiers <code>.htaccess</code>, et après les sections <directive
    type="section" module="core">Files</directive>.</p>

    <p>Les sections <directive type="section">Location</directive>
    agissent complètement en dehors du système de fichiers. Ceci a de
    nombreuses conséquences. Parmi les plus importantes, on ne doit pas
    utiliser les sections <directive type="section">Location</directive>
    pour contrôler l'accès aux répertoires du système de fichiers. Comme
    plusieurs URLs peuvent correspondre au même répertoire du système de
    fichiers, un tel contrôle d'accès pourrait être contourné.</p>

    <p>Les directives que contient cette section seront appliquées aux
    requêtes si la partie chemin de l'URL satisfait à l'un au moins de
    ces critères :
    </p>
    <ul>
      <li>Le chemin spécifié correspond exactement à la partie chemin de
      l'URL.
      </li>
      <li>Le chemin spécifié, qui se termine par un slash, est un
      préfixe de la partie chemin de l'URL (traité comme une racine du
      contexte).
      </li>
      <li>Le chemin spécifié, si on lui ajoute un slash de fin, est un
      préfixe de la partie chemin de l'URL (aussi traité comme une racine du
      contexte).
      </li>
    </ul>
    <p>
    Dans l'exemple ci-dessous, où aucun slash de fin n'est utilisé, les
    directives contenues dans la section s'appliqueront à /private1,
    /private1/ et /private1/file.txt, mais pas à /private1other. 
    </p>
    <highlight language="config">
&lt;Location "/private1"&gt;
    #  ...
&lt;/Location&gt;
    </highlight>
    <p>
    De même, dans l'exemple ci-dessous, où l'on utilise un slash de fin, les
    directives contenues dans la section s'appliqueront à /private2/ et
    à /private2/file.txt, mais pas à /private2other.
    </p>
    <highlight language="config">
&lt;Location "/private2<em>/</em>"&gt;
    # ...
&lt;/Location&gt;
    </highlight>
    
    <note><title>Quand utiliser la section <directive
    type="section">Location</directive></title>

    <p>Vous pouvez utiliser une section <directive
    type="section">Location</directive> pour appliquer des directives à
    des contenus situés en dehors du système de fichiers. Pour les
    contenus situés à l'intérieur du système de fichiers, utilisez
    plutôt les sections <directive
    type="section" module="core">Directory</directive> et <directive
    type="section" module="core">Files</directive>. <code>&lt;Location
    "/"&gt;</code> constitue une exception et permet d'appliquer aisément
    une configuration à l'ensemble du serveur.</p>
    </note>

    <p>Pour toutes les requêtes originales (non mandatées), l'argument
    URL est un chemin d'URL de la forme
    <code>/chemin/</code>. <em>Aucun protocole, nom d'hôte, port, ou chaîne
    de requête ne doivent apparaître.</em> Pour les requêtes mandatées, l'URL
    spécifiée doit être de la forme
    <code>protocole://nom_serveur/chemin</code>, et vous devez inclure
    le préfixe.</p>

    <p>L'URL peut contenir des caractères génériques. Dans une chaîne
    avec caractères génériques, <code>?</code> correspond à un caractère
    quelconque, et <code>*</code> à toute chaîne de caractères. Les
    caractères génériques ne peuvent pas remplacer un / dans le chemin
    URL.</p>

    <p>On peut aussi utiliser les <glossary ref="regex">Expressions
    rationnelles</glossary>, moyennant l'addition d'un caractère
    <code>~</code>. Par exemple :</p>

    <highlight language="config">
&lt;Location ~ "/(extra|special)/data"&gt;
    #...
&lt;/Location&gt;
</highlight>

    <p>concernerait les URLs contenant les sous-chaîne
    <code>/extra/data</code> ou <code>/special/data</code>. La directive
    <directive type="section" module="core">LocationMatch</directive>
    présente un comportement identique à la version avec expressions
    rationnelles de la directive <directive
    type="section">Location</directive>, et son utilisation est
    préférable à l'utilisation de cette dernière pour la simple raison
    qu'il est difficile de distinguer <code>~</code> de <code>-</code>
    dans la plupart des fontes.</p>

    <p>La directive <directive type="section">Location</directive>
    s'utilise principalement avec la directive <directive
    module="core">SetHandler</directive>. Par exemple, pour activer les
    requêtes d'état, mais ne les autoriser que depuis des navigateurs
    appartenant au domaine <code>example.com</code>, vous pouvez
    utiliser :</p>

    <highlight language="config">
&lt;Location "/status"&gt;
  SetHandler server-status
  Require host example.com
&lt;/Location&gt;
    </highlight>

    <note><title>Note à propos du slash (/)</title>
      <p>La signification du caractère slash dépend de l'endroit où il
      se trouve dans l'URL. Les utilisateurs peuvent être habitués à
      son comportement dans le système de fichiers où plusieurs slashes
      successifs sont souvent réduits à un slash unique (en d'autres
      termes, <code>/home///foo</code> est identique à
      <code>/home/foo</code>). Dans l'espace de nommage des URLs, ce
      n'est cependant pas toujours le cas. Pour la directive <directive
      type="section" module="core">LocationMatch</directive> et la
      version avec expressions rationnelles de la directive <directive
      type="section">Location</directive>, vous devez spécifier
      explicitement les slashes multiples si telle est votre
      intention.</p>

      <p>Par exemple, <code>&lt;LocationMatch "^/abc"&gt;</code> va
      correspondre à l'URL <code>/abc</code> mais pas à l'URL <code>
      //abc</code>. La directive <directive type="section"
      >Location</directive> sans expression rationnelle se comporte de
      la même manière lorsqu'elle est utilisée pour des requêtes
      mandatées. Par contre, lorsque la directive <directive
      type="section">Location</directive> sans expression rationnelle
      est utilisée pour des requêtes non mandatées, elle fera
      correspondre implicitement les slashes multiples à des slashes
      uniques. Par exemple, si vous spécifiez <code>&lt;Location
      "/abc/def"&gt;</code>, une requête de la forme
      <code>/abc//def</code> correspondra.</p>
    </note>
</usage>
<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manière dont ces différentes sections se combinent
entre elles à la réception d'une requête.</seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>LocationMatch</name>
<description>N'applique les directives contenues qu'aux URLs
correspondant à une expression rationnelle</description>
<syntax>&lt;LocationMatch
    <var>regex</var>&gt; ... &lt;/LocationMatch&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>La directive <directive type="section">LocationMatch</directive>
    limite la portée des directives contenues à l'URL spécifiée, de
    manière identique à la directive <directive module="core"
    type="section">Location</directive>. Mais son argument permettant de
    spécifier les URLs concernées est une <glossary
    ref="regex">expression rationnelle</glossary> au lieu d'une simple
    chaîne de caractères. Par exemple :</p>

    <highlight language="config">
&lt;LocationMatch "/(extra|special)/data"&gt;
    # ...
&lt;/LocationMatch&gt;
</highlight>

    <p>correspondrait à toute URL contenant les sous-chaînes
    <code>/extra/data</code> ou <code>/special/data</code>.</p>

    <note><p>Si vous recherchez une URL <strong>commençant par</strong>
    plutôt que seulement contenant <code>/extra/data</code>, préfixez
    l'expression rationnelle avec un <code>^</code>.</p>

    <highlight language="config">
    &lt;LocationMatch "^/(extra|special)/data"&gt;
    </highlight>
    </note>

    <p>A partir de la version 2.4.8, les groupes nommés et les
    références arrières sont extraits et enregistrés dans
    l'environnement avec leur nom en majuscules et préfixé
    par "MATCH_". Ceci permet
    de référencer des URLs dans des <a href="../expr.html">expressions</a>
    ou au sein de modules comme <module>mod_rewrite</module>. Pour
    éviter toute confusion, les références arrières numérotées (non
    nommées) sont ignorées. Vous devez utiliser à la place des groupes
    nommés.</p>

<highlight language="config">
&lt;LocationMatch "^/combined/(?&lt;sitename&gt;[^/]+)"&gt;
    Require ldap-group cn=%{env:MATCH_SITENAME},ou=combined,o=Example
&lt;/LocationMatch&gt;
</highlight>

    <note><title>Note à propos du slash '/'</title>
      <p>La signification du caractère slash '/' dépend de l'endroit où il
      apparaît dans une URL. Les utilisateurs sont habitués à voir de multiples
      slashes adjacents réduits à un seul au sein du système de fichiers (par
      exemple, <code>/home///foo</code> est équivalent à
      <code>/home/foo</code>). Ce n'est n'est cependant pas toujours le cas au
      sein des URLs. En effet, si vous souhaitez spécifier plusieurs slashes,
      vous devez le faire explicitement au sein de la directive <directive
      type="section" module="core">LocationMatch</directive> et de la version
      regex de la directive <directive type="section">Location</directive>.</p>

      <p>Par exemple, <code>&lt;LocationMatch "^/abc"&gt;</code> correspondra à
      l'URL <code>/abc</code>, mais pas à l'URL <code>//abc</code>. La directive
      (non-regex) <directive type="section">Location</directive> se comporte de
      la même manière lorsqu'elle est utilisée dans les requêtes de mandataire.
      Par contre, pour les autres types de requêtes, la directive <directive
      type="section">Location</directive> considérera plusieurs slashes
      adjacents comme équivalents à un seul slash. Par exemple, si vous
      spécifiez <code>&lt;Location "/abc/def"&gt;</code>, une requête pour
      <code>/abc//def</code> correspondra.</p>
    </note>
</usage>
<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manière dont ces différentes sections se combinent
entre elles à la réception d'une requête.</seealso>
</directivesynopsis>

<directivesynopsis>
<name>LogLevel</name>
<description>Contrôle la verbosité du journal des erreurs</description>
<syntax>LogLevel [<var>module</var>:]<var>niveau</var>
    [<var>module</var>:<var>niveau</var>] ...
</syntax>
<default>LogLevel warn</default>
<contextlist><context>server config</context><context>virtual
host</context><context>directory</context>
</contextlist>
<compatibility>La configuration du niveau de journalisation par module
et par répertoire est disponible depuis la version 2.3.6 du serveur HTTP
Apache</compatibility>
<usage>
    <p>La directive <directive>LogLevel</directive> permet d'ajuster la
    verbosité des messages enregistrés dans les journaux d'erreur (voir
    la directive <directive module="core">ErrorLog</directive>
    directive). Les <var>niveau</var>x disponibles sont présentés
    ci-après, par ordre de criticité décroissante :</p>

    <table border="1">
    <columnspec><column width=".2"/><column width=".3"/><column width=".5"/>
    </columnspec>
      <tr>
        <th><strong>Niveau</strong> </th>

        <th><strong>Description</strong> </th>

        <th><strong>Exemple</strong> </th>
      </tr>

      <tr>
        <td><code>emerg</code> </td>

        <td>Urgences - le système est inutilisable.</td>

        <td>"Child cannot open lock file. Exiting"</td>
      </tr>

      <tr>
        <td><code>alert</code> </td>

        <td>Des mesures doivent être prises immédiatement.</td>

        <td>"getpwuid: couldn't determine user name from uid"</td>
      </tr>

      <tr>
        <td><code>crit</code> </td>

        <td>Conditions critiques.</td>

        <td>"socket: Failed to get a socket, exiting child"</td>
      </tr>

      <tr>
        <td><code>error</code> </td>

        <td>Erreurs.</td>

        <td>"Premature end of script headers"</td>
      </tr>

      <tr>
        <td><code>warn</code> </td>

        <td>Avertissements.</td>

        <td>"child process 1234 did not exit, sending another
        SIGHUP"</td>
      </tr>

      <tr>
        <td><code>notice</code> </td>

        <td>Evènement important mais normal.</td>

        <td>"httpd: caught SIGBUS, attempting to dump core in
        ..."</td>
      </tr>

      <tr>
        <td><code>info</code> </td>

        <td>Informations.</td>

        <td>"Server seems busy, (you may need to increase
        StartServers, or Min/MaxSpareServers)..."</td>
      </tr>

      <tr>
        <td><code>debug</code> </td>

        <td>Messages de débogage.</td>

        <td>"Opening config file ..."</td>
      </tr>
      <tr>
        <td><code>trace1</code> </td>

        <td>Messages de traces</td>

        <td>"proxy: FTP: control connection complete"</td>
      </tr>
      <tr>
        <td><code>trace2</code> </td>

        <td>Messages de traces</td>

        <td>"proxy: CONNECT: sending the CONNECT request to the remote proxy"</td>
      </tr>
      <tr>
        <td><code>trace3</code> </td>

        <td>Messages de traces</td>

        <td>"openssl: Handshake: start"</td>
      </tr>
      <tr>
        <td><code>trace4</code> </td>

        <td>Messages de traces</td>

        <td>"read from buffered SSL brigade, mode 0, 17 bytes"</td>
      </tr>
      <tr>
        <td><code>trace5</code> </td>

        <td>Messages de traces</td>

        <td>"map lookup FAILED: map=rewritemap key=keyname"</td>
      </tr>
      <tr>
        <td><code>trace6</code> </td>

        <td>Messages de traces</td>

        <td>"cache lookup FAILED, forcing new map lookup"</td>
      </tr>
      <tr>
        <td><code>trace7</code> </td>

        <td>Messages de traces, enregistrement d'une grande quantité de
	données</td>

        <td>"| 0000: 02 23 44 30 13 40 ac 34 df 3d bf 9a 19 49 39 15 |"</td>
      </tr>
      <tr>
        <td><code>trace8</code> </td>

        <td>Messages de traces, enregistrement d'une grande quantité de
	données</td>

        <td>"| 0000: 02 23 44 30 13 40 ac 34 df 3d bf 9a 19 49 39 15 |"</td>
      </tr>
    </table>

    <p>Lorsqu'un niveau particulier est spécifié, les messages de tous
    les autres niveaux de criticité supérieure seront aussi enregistrés.
    <em>Par exemple</em>, si <code>LogLevel info</code> est spécifié,
    les messages de niveaux <code>notice</code> et <code>warn</code>
    seront aussi émis.</p>

    <p>Il est recommandé d'utiliser un niveau <code>crit</code> ou
    inférieur.</p>

    <p>Par exemple :</p>

    <highlight language="config">LogLevel notice</highlight>

    <note><title>Note</title>
      <p>Si la journalisation s'effectue directement dans un fichier,
      les messages de niveau <code>notice</code> ne peuvent pas être
      supprimés et sont donc toujours journalisés. Cependant, ceci ne
      s'applique pas lorsque la journalisation s'effectue vers
      <code>syslog</code>.</p>
    </note>
    
    <p>Spécifier un niveau sans nom de module va attribuer ce niveau à
    tous les modules. Spécifier un niveau avec nom de module va
    attribuer ce niveau à ce module seulement. Il est possible de
    spécifier un module par le nom de son fichier source ou par son
    identificateur, avec ou sans le suffixe <code>_module</code>. Les
    trois spécifications suivantes sont donc équivalentes :</p>

    <highlight language="config">
LogLevel info ssl:warn
LogLevel info mod_ssl.c:warn
LogLevel info ssl_module:warn
    </highlight>

    <p>Il est aussi possible d'attribuer un niveau de journalisation par
    répertoire :</p>

    <highlight language="config">
LogLevel info
&lt;Directory "/usr/local/apache/htdocs/app"&gt;
  LogLevel debug
&lt;/Directory&gt;
    </highlight>

    <note>
        La configuration du niveau de journalisation par répertoire
	n'affecte que les messages journalisés après l'interprétation de
	la requête et qui sont associés à cette dernière. Les messages
	de journalisation associés à la connexion ou au serveur ne sont
	pas affectés.
    </note>
</usage>
<seealso><directive module="core">ErrorLog</directive></seealso>
<seealso><directive module="core">ErrorLogFormat</directive></seealso>
<seealso><a href="../logs.html">Journaux du serveur HTTP Apache</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>MaxKeepAliveRequests</name>
<description>Nombre de requêtes permises pour une connexion
persistante</description>
<syntax>MaxKeepAliveRequests <var>nombre</var></syntax>
<default>MaxKeepAliveRequests 100</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>La directive <directive>MaxKeepAliveRequests</directive> permet
    de limiter le nombre de requêtes autorisées par connexion lorsque
    <directive module="core" >KeepAlive</directive> est à "on". Si sa
    valeur est <code>0</code>, le nombre de requêtes autorisées est
    illimité. Il est recommandé de définir une valeur assez haute pour
    des performances du serveur maximales.</p>

    <p>Par exemple :</p>

    <highlight language="config">MaxKeepAliveRequests 500</highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>MaxRanges</name>
<description>Nombre de segments de données autorisé avant le renvoi de
l'intégralité de la ressource</description>
<syntax>MaxRanges default | unlimited | none | <var>nombre de segments</var></syntax>
<default>MaxRanges 200</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.15 du serveur HTTP
Apache</compatibility>

<usage>
    <p>La directive <directive>MaxRanges</directive> permet de limiter
    le nombre de segments de données que le serveur va renvoyer au
    client. Si un nombre de segments plus important est demandé, la
    ressource sera renvoyée dans son intégralité.</p>

    <dl>  
      <dt><strong>default</strong></dt>
      <dd>Limite le nombre de segments de données à 200 (valeur par
      défaut définie à la compilation).</dd>
   
      <dt><strong>none</strong></dt>
      <dd>Les en-têtes Range sont ignorés.</dd>
          
      <dt><strong>unlimited</strong></dt>
      <dd>Le nombre de segments de données est illimité.</dd>

      <dt><var>nombre de segments</var></dt>
      <dd>Un nombre positif représentera la nombre de segments de
      données maximal que le serveur renverra au client.</dd>
    </dl>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>MaxRangeOverlaps</name>
    <description>Nombre de chevauchements de segments de données autorisé
    (par exemple <code>100-200,150-300</code>) avant le renvoi de la
    ressource complète</description>
    <syntax>MaxRangeOverlaps default | unlimited | none | <var>nombre de
    chevauchements</var></syntax>
    <default>MaxRangeOverlaps 20</default>
    <contextlist><context>server config</context><context>virtual host</context>
        <context>directory</context>
    </contextlist>
    <compatibility>Disponible depuis la version 2.3.15 du serveur HTTP
    Apache</compatibility>

    <usage>
        <p>La directive <directive>MaxRangeOverlaps</directive> permet
	de limiter le nombre de chevauchements de segments de données HTTP
	autorisé par le serveur. Si le nombre de
	chevauchements de segments demandé est supérieur au nombre maximal
	autorisé, la ressource sera renvoyée dans son intégralité.</p>

        <dl>
            <dt><strong>default</strong></dt>
            <dd>Limite le nombre de chevauchements de segments à la valeur
	    par défaut 20 définie à la compilation.</dd>

            <dt><strong>none</strong></dt>
            <dd>Aucun chevauchement de segment n'est autorisé.</dd>

            <dt><strong>unlimited</strong></dt>
            <dd>Le nombre de chevauchements de segments est illimité.</dd>

            <dt><var>number-of-ranges</var></dt>
            <dd>Un nombre positif représente le nombre maximal de
	    chevauchements de segments autorisé par le serveur.</dd>
        </dl>
    </usage>
</directivesynopsis>

<directivesynopsis>
    <name>MaxRangeReversals</name>
    <description>Nombre d'inversions d'ordre autorisé dans la spécification des
    segments de données (par exemple <code>100-200,50-70</code>) avant le renvoi de la
    ressource complète</description>
    <syntax>MaxRangeReversals default | unlimited | none | <var>nombre
    d'inversions</var></syntax>
    <default>MaxRangeReversals 20</default>
    <contextlist><context>server config</context><context>virtual host</context>
        <context>directory</context>
    </contextlist>
    <compatibility>Disponible depuis la version 2.3.15 du serveur HTTP
    Apache</compatibility>

    <usage>
        <p>La directive <directive>MaxRangeReversals</directive> permet
	de limiter le nombre d'inversions d'ordre dans la spécification
	des segments de données HTTP
	autorisé par le serveur. Si le nombre
	d'inversions demandé est supérieur au nombre maximal
	autorisé, la ressource sera renvoyée dans son intégralité.</p>

        <dl>
            <dt><strong>default</strong></dt>
            <dd>Limite le nombre d'inversions à la valeur
	    par défaut 20 définie à la compilation.</dd>

            <dt><strong>none</strong></dt>
            <dd>Aucune inversion n'est autorisée.</dd>

            <dt><strong>unlimited</strong></dt>
            <dd>Le nombre d'inversions est illimité.</dd>

            <dt><var>number-of-ranges</var></dt>
            <dd>Un nombre positif représente le nombre maximal
	    d'inversions autorisé par le serveur.</dd>
        </dl>
    </usage>
</directivesynopsis>

<directivesynopsis>
<name>Mutex</name>
<description>Définit les mécanismes de mutex et le repertoire du fichier
verrou pour tous les mutex ou seulement les mutex spécifiés</description>
<syntax>Mutex <var>mécanisme</var> [default|<var>nom-mutex</var>] ... [OmitPID]</syntax>
<default>Mutex default</default>
<contextlist><context>server config</context></contextlist>
<compatibility>Disponible depuis la version 2.3.4 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive>Mutex</directive> permet de définir le
    mécanisme de mutex, et éventuellement le répertoire du fichier
    verrou que les modules et httpd utilisent pour sérialiser l'accès aux
    ressources. Spécifiez <code>default</code> comme second argument
    pour modifier la configuration de tous les mutex ; spécifiez un nom
    de mutex (voir la table ci-dessous) comme second argument pour
    ne modifier que la configuration de ce mutex.</p>

    <p>La directive <directive>Mutex</directive> est typiquement
    utilisée dans les situations exceptionnelles suivantes :</p>

    <ul>
        <li>choix d'un autre mécanisme de mutex lorsque le mécanisme par
	défaut sélectionné par <glossary>APR</glossary> présente un
	problème de fonctionnement ou de performances.</li>

        <li>choix d'un autre répertoire utilisé par les mutex à base de
	fichier lorsque le répertoire par défaut ne supporte pas le
	verrouillage</li>
    </ul>

    <note><title>Modules supportés</title>
    <p>Cette directive ne configure que les mutex qui ont été
    enregistrés avec le serveur de base via l'API
    <code>ap_mutex_register()</code>. Tous les modules fournis avec
    httpd supportent la directive <directive>Mutex</directive>, mais il
    n'en sera pas forcément de même pour les modules tiers.
    Reportez-vous à la documentation du module tiers considéré afin de
    déterminer le(s) nom(s) de mutex qui pourront être définis si la
    directive est supportée.</p>
    </note>

    

    <p>Les <em>mécanismes</em> de mutex disponibles sont les suivants :</p>
    <ul>
        <li><code>default | yes</code>
        <p>C'est l'implémentation du verrouillage par défaut, telle
	qu'elle est définie par <glossary>APR</glossary>. On peut
	afficher l'implémentation du verrouillage par défaut via la
	commande <program>httpd</program> avec l'option <code>-V</code>.</p></li>

        <li><code>none | no</code>
        <p>Le mutex est désactivé, et cette valeur n'est permise pour un
	mutex que si le module indique qu'il s'agit d'un choix valide.
	Consultez la documentation du module pour plus d'informations.</p></li>

        <li><code>posixsem</code>
        <p>Une variante de mutex basée sur un sémaphore Posix.</p>

        <note type="warning"><title>Avertissement</title>
        <p>La propriété du sémaphore n'est pas restituée si un thread du
	processus gérant le mutex provoque une erreur de segmentation,
	ce qui provoquera un blocage du serveur web.</p>
        </note>
        </li>

        <li><code>sysvsem</code>
        <p>Une variante de mutex basée sur un sémaphore IPC SystemV.</p>

        <note type="warning"><title>Avertissement</title>
        <p>Il peut arriver que les sémaphores SysV soient conservés si le
	processus se crashe avant que le sémaphore ne soit supprimé.</p>
	</note>

        <note type="warning"><title>Sécurité</title>
        <p>L'API des sémaphores permet les attaques par déni de service
	par tout programme CGI s'exécutant sous le même uid que le
	serveur web (autrement dit tous les programmes CGI, à moins que
	vous n'utilisiez un programme du style <program>suexec</program>
	ou <code>cgiwrapper</code>).</p>
	</note>
        </li>

        <li><code>sem</code>
        <p>Sélection de la "meilleure" implémentation des sémaphores
	disponible ; le choix s'effectue entre les sémaphores posix et
	IPC SystemV, dans cet ordre.</p></li>

        <li><code>pthread</code>
        <p>Une variante de mutex à base de mutex de thread Posix
	inter-processus.</p>

        <note type="warning"><title>Avertissement</title>
        <p>Sur la plupart des systèmes, si un processus enfant se
	termine anormalement alors qu'il détenait un mutex qui utilise
	cette implémentation, le serveur va se bloquer et cesser de
	répondre aux requêtes. Dans ce cas, un redémarrage manuel est
	nécessaire pour récupérer le mutex.</p>
        <p>Solaris et Linux constituent des exceptions notables, en ceci qu'ils	fournissent
	un mécanisme qui permet en général de récupérer le mutex après
	l'arrêt anormal d'un processus enfant qui détenait le mutex.</p>
        <p>Si votre système est compatible POSIX ou implémente la fonction
	<code>pthread_mutexattr_setrobust_np()</code>, vous devriez
	pouvoir utiliser l'option <code>pthread</code> sans problème.</p>
        </note>
        </li>

        <li><code>fcntl:/chemin/vers/mutex</code>
        <p>Une variante de mutex utilisant un fichier verrou physique et
	la fonction <code>fcntl()</code>.</p>

        <note type="warning"><title>Avertissement</title>
        <p>Lorsqu'on utilise plusieurs mutex basés sur ce mécanisme dans
	un environnement multi-processus, multi-thread, des erreurs de
	blocage (EDEADLK) peuvent être rapportées pour des opérations de
	mutex valides si la fonction <code>fcntl()</code> ne gère pas
	les threads, comme sous Solaris.</p>
	</note>
        </li>

        <li><code>flock:/chemin/vers/mutex</code>
        <p>Méthode similaire à <code>fcntl:/chemin/vers/mutex</code>,
	mais c'est la fonction <code>flock()</code> qui est utilisée
	pour gérer le verrouillage par fichier.</p></li>

        <li><code>file:/chemin/vers/mutex</code>
        <p>Sélection de la "meilleure" implémentation de verrouillage
	par fichier disponible ; le choix s'effectue entre
	<code>fcntl</code> et <code>flock</code>, dans cet ordre.</p></li>
    </ul>

    <p>La plupart des mécanismes ne sont disponibles que sur les
    plate-formes où ces dernières et <glossary>APR</glossary> les
    supportent. Les mécanismes qui ne sont pas disponibles sur toutes
    les plate-formes sont <em>posixsem</em>,
    <em>sysvsem</em>, <em>sem</em>, <em>pthread</em>, <em>fcntl</em>, 
    <em>flock</em>, et <em>file</em>.</p>

    <p>Avec les mécanismes à base de fichier <em>fcntl</em> et
    <em>flock</em>, le chemin, s'il est fourni, est un répertoire dans
    lequel le fichier verrou sera créé. Le répertoire par
    défaut est le répertoire d'exécution de httpd relatif à la
    directive <directive module="core">ServerRoot</directive>.
    Utilisez toujours un système
    de fichiers local sur disque pour <code>/chemin/vers/mutex</code> et
    jamais un répertoire se trouvant dans un système de fichiers NFS ou
    AFS. Le nom de base du fichier se composera du type de mutex, d'une
    chaîne optionnelle correspondant à l'instance et fournie par le
    module ; et, sauf si le mot-clé <code>OmitPID</code> a été spécifié,
    l'identificateur du processus parent httpd sera ajouté afin de
    rendre le nom du fichier unique, évitant ainsi tout conflit lorsque
    plusieurs instances d'httpd partagent le même répertoire de
    verrouillage. Par exemple, si le nom de mutex est
    <code>mpm-accept</code>, et si le répertoire de verrouillage est
    <code>/var/httpd/locks</code>, le nom du fichier verrou pour
    l'instance httpd dont le processus parent a pour identifiant 12345
    sera <code>/var/httpd/locks/mpm-accept.12345</code>.</p>

    <note type="warning"><title>Sécurité</title>
    <p>Il est conseillé d'<em>éviter</em> de placer les fichiers mutex
    dans un répertoire où tout le monde peut écrire comme
    <code>/var/tmp</code>, car quelqu'un pourrait initier une attaque
    par déni de service et empêcher le serveur de démarrer en créant un
    fichier verrou possédant un nom identique à celui que le serveur va
    tenter de créer.</p>
    </note>

    <p>La table suivante décrit les noms de mutex utilisés par httpd et
    ses modules associés.</p>

    <table border="1" style="zebra">
        <tr>
            <th>Nom mutex</th>
            <th>Module(s)</th>
            <th>Ressource protégée</th>
	</tr>
        <tr>
            <td><code>mpm-accept</code></td>
            <td>modules MPM <module>prefork</module> et <module>worker</module></td>
            <td>connexions entrantes, afin d'éviter le problème de
	    l'afflux de requêtes ; pour plus d'informations, voir la
	    documentation <a
	    href="../misc/perf-tuning.html">Amélioration des
	    performances</a></td>
	</tr>
	<tr>
            <td><code>authdigest-client</code></td>
            <td><module>mod_auth_digest</module></td>
            <td>liste de clients en mémoire partagée</td>
	</tr>
        <tr>
            <td><code>authdigest-opaque</code></td>
            <td><module>mod_auth_digest</module></td>
            <td>compteur en mémoire partagée</td>
	</tr>
        <tr>
            <td><code>ldap-cache</code></td>
            <td><module>mod_ldap</module></td>
            <td>cache de résultat de recherche LDAP</td>
	</tr>
        <tr>
            <td><code>rewrite-map</code></td>
            <td><module>mod_rewrite</module></td>
            <td>communication avec des programmes externes
	    d'associations de valeurs, afin d'éviter les interférences
	    d'entrées/sorties entre plusieurs requêtes</td>
	</tr>
        <tr>
            <td><code>ssl-cache</code></td>
            <td><module>mod_ssl</module></td>
            <td>cache de session SSL</td>
	</tr>
        <tr>
            <td><code>ssl-stapling</code></td>
            <td><module>mod_ssl</module></td>
            <td>cache de l'étiquetage OCSP ("OCSP stapling")</td>
	</tr>
        <tr>
            <td><code>watchdog-callback</code></td>
            <td><module>mod_watchdog</module></td>
            <td>fonction de rappel d'un module client particulier</td>
	</tr>
    </table>

    <p>Le mot-clé <code>OmitPID</code> permet d'empêcher l'addition de
    l'identifiant du processus httpd parent au nom du fichier verrou.</p>


    <p>Dans l'exemple suivant, le mécanisme de mutex pour le mutex
    mpm-accept est modifié pour passer du mécanisme par défaut au
    mécanisme <code>fcntl</code>, avec le fichier verrou associé créé
    dans le répertoire <code>/var/httpd/locks</code>. Le mécanisme de
    mutex par défaut pour tous les autres mutex deviendra
    <code>sysvsem</code>.</p>

    <highlight language="config">
Mutex sysvsem default
Mutex fcntl:/var/httpd/locks mpm-accept
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>NameVirtualHost</name>
<description>OBSOLETE : Définit une adresse IP pour les serveurs virtuels à base de
nom</description>
<syntax>NameVirtualHost <var>adresse</var>[:<var>port</var>]</syntax>
<contextlist><context>server config</context></contextlist>

<usage>

    <p>Avant la version 2.3.11, il était nécessaire de définir une
    directive <directive>NameVirtualHost</directive> pour indiquer au
    serveur qu'une paire adresse IP/port particulière pouvait être
    utilisée comme serveur virtuel à base de nom. Depuis la version
    2.3.11, chaque fois qu'une paire adresse IP/port est utilisée dans
    plusieurs serveurs virtuels, l'hébergement virtuel à base de nom est
    automatiquement activé pour cette adresse.</p>
    
    <p>Cette directive n'a actuellement plus aucun effet.</p>
</usage>

<seealso><a href="../vhosts/">Documentation sur les serveurs
virtuels</a></seealso>

</directivesynopsis>

<directivesynopsis>
<name>Options</name>
<description>Définit les fonctionnalités disponibles pour un répertoire
particulier</description>
<syntax>Options
    [+|-]<var>option</var> [[+|-]<var>option</var>] ...</syntax>
<default>Options FollowSymlinks</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>Options</override>
<compatibility>Avec la version 2.3.11, la valeur par défaut passe de All
à FollowSymlinks</compatibility>

<usage>
    <p>La directive <directive>Options</directive> permet de définir
    les fonctionnalités de serveur disponibles pour un répertoire
    particulier.</p>

    <p><var>option</var> peut être défini à <code>None</code>, auquel
    cas aucune fonctionnalité spécifique n'est activée, ou comprendre
    une ou plusieurs des options suivantes :</p>

    <dl>
      <dt><code>All</code></dt>

      <dd>Toutes les options excepté <code>MultiViews</code>.</dd>

      <dt><code>ExecCGI</code></dt>

      <dd>L'exécution de scripts CGI à l'aide du module
      <module>mod_cgi</module> est permise.</dd>

      <dt><code>FollowSymLinks</code></dt>

      <dd>

      Le serveur va suivre les liens symboliques dans le répertoire
      concerné. Il s'agit de la valeur par défaut.
      <note>
      <p>Bien que le serveur suive les liens symboliques, il ne modifie
      <em>pas</em> le nom de chemin concerné défini par la section
      <directive type="section"
      module="core">Directory</directive>.</p>
      
      <p>Les options <code>FollowSymLinks</code> et
      <code>SymLinksIfOwnerMatch</code> ne fonctionnent que dans les
      sections <directive type="section"
      module="core">Directory</directive> ou les fichiers
      <code>.htaccess</code>.</p>

      <p>Le fait d'omettre cette option ne doit pas être considéré comme
      une mesure de sécurité efficace, car il existe toujours une
      situation de compétition (race condition) entre l'instant où l'on
      vérifie qu'un chemin n'est pas un lien symbolique, et l'instant où
      l'on utilise effectivement ce chemin.</p>
      </note></dd>

      <dt><code>Includes</code></dt>

      <dd>
      Les inclusions côté serveur (SSI) à l'aide du module
      <module>mod_include</module> sont autorisées.</dd>

      <dt><code>IncludesNOEXEC</code></dt>

      <dd>

      Les inclusions côté serveur (SSI) sont permises, mais <code>#exec
      cmd</code> et <code>#exec cgi</code> sont désactivés.
      L'utilisation de <code>#include virtual</code> pour les scripts
      CGI est cependant toujours possible depuis des répertoires
      définis par <directive
      module="mod_alias">ScriptAlias</directive>.</dd>

      <dt><code>Indexes</code></dt>

      <dd>
      Si une URL requise correspond au répertoire concerné, et si aucun
      <directive module="mod_dir">DirectoryIndex</directive> (<em>par
      exemple</em> <code>index.html</code>) n'est défini pour ce
      répertoire, le module <module>mod_autoindex</module> va renvoyer
      un listing formaté du répertoire.</dd>

      <dt><code>MultiViews</code></dt>

      <dd>
      Les vues multiples ("multiviews") à <a
      href="../content-negotiation.html">contenu négocié</a> à l'aide du
      module <module>mod_negotiation</module> sont autorisées.
      <note><title>Note</title> <p>Cette option est ignorée si elle est
      définie en tout autre endroit qu'une section <directive
      module="core" type="section">Directory</directive>, car
      <module>mod_negotiation</module> a besoin de ressources réelles
      pour effectuer ses comparaisons et ses évaluations.</p></note>
      
      </dd>

      <dt><code>SymLinksIfOwnerMatch</code></dt>

      <dd>Le serveur ne suivra que les liens symboliques qui renvoient
      vers un fichier ou un répertoire dont le propriétaire est le même
      que celui du lien.

      <note><title>Note</title>
      <p>Les options <code>FollowSymLinks</code> et
      <code>SymLinksIfOwnerMatch</code> ne fonctionnent que dans les
      sections <directive type="section"
      module="core">Directory</directive> ou les fichiers
      <code>.htaccess</code>.</p>

      <p>Le fait d'omettre cette option ne doit pas être considéré comme
      une mesure de sécurité efficace, car il existe toujours une
      situation de compétition (race condition) entre l'instant où l'on
      vérifie qu'un chemin n'est pas un lien symbolique, et l'instant où
      l'on utilise effectivement ce chemin.</p>
      </note> </dd>
    </dl>

    <p>Normalement, si plusieurs directives
    <directive>Options</directive> peuvent s'appliquer à un répertoire,
    c'est la plus spécifique qui est utilisée et les autres sont
    ignorées ; les options ne sont pas fusionnées (voir <a
    href="../sections.html#merging">comment les sections sont
    fusionnées</a>). Elles le sont cependant si <em>toutes</em> les
    options de la directive <directive>Options</directive> sont
    précédées d'un symbole <code>+</code> ou <code>-</code>. Toute
    option précédée d'un <code>+</code> est ajoutée à la liste des
    options courantes de manière forcée et toute option précédée d'un
    <code>-</code> est supprimée de la liste des options courantes de la
    même manière.</p>

    <note><title>Note</title>
    <p>Mélanger des <directive>Options</directive> avec <code>+</code>
    ou <code>-</code> avec des <directive>Options</directive> sans
    <code>+</code> ou <code>-</code> constitue une erreur de syntaxe, et
    la vérification de la syntaxe au cours du démarrage du serveur fera
    échouer ce dernier.</p>
    </note>

    <p>Par exemple, sans aucun symbole <code>+</code> et <code>-</code>
    :</p>

    <highlight language="config">
&lt;Directory "/web/docs"&gt;
  Options Indexes FollowSymLinks
&lt;/Directory&gt;

&lt;Directory "/web/docs/spec"&gt;
  Options Includes
&lt;/Directory&gt;
    </highlight>

    <p>ici, seule l'option <code>Includes</code> sera prise en compte
    pour le répertoire <code>/web/docs/spec</code>. Par contre, si la
    seconde directive <directive>Options</directive> utilise les
    symboles <code>+</code> et <code>-</code> :</p>

    <highlight language="config">
&lt;Directory "/web/docs"&gt;
  Options Indexes FollowSymLinks
&lt;/Directory&gt;

&lt;Directory "/web/docs/spec"&gt;
  Options +Includes -Indexes
&lt;/Directory&gt;
    </highlight>

    <p>alors, les options <code>FollowSymLinks</code> et
    <code>Includes</code> seront prises en compte pour le répertoire
    <code>/web/docs/spec</code>.</p>

    <note><title>Note</title>
      <p>L'utilisation de <code>-IncludesNOEXEC</code> ou
      <code>-Includes</code> désactive complètement les inclusions côté
      serveur sans tenir compte des définitions précédentes.</p>
    </note>

    <p>En l'absence de toute définition d'options, la valeur par défaut
    est <code>FollowSymlinks</code>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Protocol</name>
<description>Protocole pour une socket d'écoute</description>
<syntax>Protocol <var>protocole</var></syntax>
<contextlist><context>server config</context><context>virtual host</context></contextlist>
<compatibility>Disponible depuis la version 2.1.5 d'Apache, mais
seulement depuis la version 2.3.3 sous Windows.</compatibility>

<usage>
    <p>Cette directive permet de spécifier le protocole utilisé pour une
    socket d'écoute particulière. Le protocole sert à déterminer quel
    module doit traiter une requête, et d'appliquer les optimisations
    spécifiques au protocole via la directive
    <directive>AcceptFilter</directive>.</p>

    <p>Vous ne devez définir le protocole que si vous travaillez avec
    des ports non standards ; dans le cas général, le protocole
    <code>http</code> est associé au port 80 et le protocole
    <code>https</code> au port 443.</p>

    <p>Par exemple, si vous travaillez avec le protocole
    <code>https</code> sur un port non standard, spécifiez le protocole
    de manière explicite :</p>

    <highlight language="config">Protocol https</highlight>

    <p>Vous pouvez aussi spécifier le protocole via la directive
    <directive module="mpm_common">Listen</directive>.</p>
</usage>
<seealso><directive module="core">AcceptFilter</directive></seealso>
<seealso><directive module="mpm_common">Listen</directive></seealso>
</directivesynopsis>

<directivesynopsis>
    <name>Protocols</name>
    <description>Protocoles disponibles pour un serveur virtuel ou non</description>
    <syntax>Protocols <var>protocole</var> ...</syntax>
    <default>Protocols http/1.1</default>
    <contextlist><context>server config</context><context>virtual host</context></contextlist>
    <compatibility>Disponible à partir de la version 2.4.17 du serveur
    HTTP Apache.</compatibility>
    
    <usage>
        <p>Cette directive permet de spécifier la liste des protocoles
	supportés par un serveur virtuel ou non. Cette liste énumère les
	protocoles qu'un client sera autorisé à négocier avec ce
	serveur.</p>
        
        <p>Par défaut,
	seul le	protocole http/1.1 est disponible (compatible avec les
	clients http/1.0 et http/0.9). Par conséquent, vous devez
	fournir cette liste si vous voulez étendre les protocoles
	disponibles pour le serveur.</p>
        
        <p>Par exemple, si vous voulez autoriser le protocole
	HTTP/2 pour un serveur avec TLS, utilisez
	cette directive comme suit :</p>
        
        <highlight language="config">
            Protocols h2 http/1.1
        </highlight>

        <p>Les protocoles valides sont <code>http/1.1</code> pour les
	connexions http et https, <code>h2</code> pour les connections
	https et <code>h2c</code> pour les connexions http. D'autres
	modules peuvent fournir d'autres protocoles.</p>
        
        <p>Spécifier des protocoles non disponibles ou désactivés n'aura
	aucun effet, et ceux-ci seront simplement ignorés.</p>
        
        <p>Si un serveur virtuel ne possède pas de directive Protocols
	propre, il hérite des protocoles spécifiés pour le serveur
	principal. Autrement dit, les directives Protocols définies au
	niveau d'un serveur virtuel remplacent celles définies au niveau
	du serveur principal.
        </p>

    </usage>
    <seealso><directive module="core">ProtocolsHonorOrder</directive></seealso>
</directivesynopsis>


<directivesynopsis>
    <name>ProtocolsHonorOrder</name>
    <description>Détermine qui du client ou du serveur détermine l'ordre
    des protocoles au cours de la négociation de la connexion</description>
    <syntax>ProtocolsHonorOrder On|Off</syntax>
    <default>ProtocolsHonorOrder On</default>
    <contextlist><context>server config</context><context>virtual host</context></contextlist>
    <compatibility>Disponible à partir de la version 2.4.17 du serveur
    HTTP Apache.</compatibility>
    
    <usage>
        <p>Cette directive permet de définir si le serveur doit tenir
	compte de l'ordre des protocoles définis par la directive
	<directive>Protocols</directive>.</p>
        
        <p>Si cette directive est définie à Off, l'ordre de la liste des
	protocoles fournie par le client l'emporte sur l'ordre défini
	dans la configuration du serveur.</p>
        
        <p>Si la directive <directive>ProtocolsHonorOrder</directive>
	est définie à <code>on</code> (valeur par défaut),
	il n'est pas tenu compte de l'ordre de la liste des protocoles
	fournie par le client, et seul l'ordre de la liste des protocles
	définie au niveau du serveur influera la
	négociation du protocole.</p>
        
    </usage>
    <seealso><directive module="core">Protocols</directive></seealso>
</directivesynopsis>

<directivesynopsis>
    <name>RegexDefaultOptions</name>
    <description>Configuration des options globales par défaut pour les
    expressions rationnelles</description>
    <syntax>RegexDefaultOptions [none] [+|-]<var>option</var> [[+|-]<var>option</var>] ...</syntax>
    <default>RegexDefaultOptions DOTALL DOLLAR_ENDONLY</default>
    <contextlist><context>server config</context></contextlist>
    <compatibility>Disponible à partir de la version 2.4.30 du serveur HTTP
    Apache.</compatibility>
    
    <usage>
        <p>Cette directive permet d'ajouter certains comportements par défaut à
	TOUTES les expressions rationnelles utilisées ultérieurement.</p>

        <p>Toute option précédée d'un '+' est ajoutée aux options déjà définies.<br />
        Toute option précédée d'un '-' est enlevée des options déjà définies.<br />
	Toute option non suffixée par '+' ou '-' sera définie et remplacera
	l'option correspondante éventuellement déjà définie.<br />
        Le mot-clé <code>none</code> annule toutes les options déjà définies.</p>

        <p><var>option</var> peut être :</p>
        <dl>
            <dt><code>ICASE</code></dt>
            <dd>Utilise une recherche de correspondance insensible à la casse.</dd>

	    <dt><code>EXTENDED</code></dt>
            <dd>Le drapeau Perl /x ; ignore les espaces non échappés et les
	    commentaires dans le modèle.</dd>

            <dt><code>DOTALL</code></dt>
            <dd>Le drapeau Perl /s ; '.' correspond aux caractères nouvelle
	    ligne.</dd>

            <dt><code>DOLLAR_ENDONLY</code></dt>
            <dd>'$' n'est actif qu'à la fin de la chaîne de référence.</dd>
            
        </dl>
        <highlight language="config">
# Ajoute l'option ICASE par défaut pour toutes les expressions rationnelles
RegexDefaultOptions +ICASE
...
# Supprime l'option DOLLAR_ENDONLY par défaut et conserve toutes les autres
# options
RegexDefaultOptions -DOLLAR_ENDONLY
...
# Définit l'option DOTALL seule et annule toutes les autres options
RegexDefaultOptions DOTALL
...
# Annule toutes les options définies
RegexDefaultOptions none
...
        </highlight>
    </usage>
</directivesynopsis>

<directivesynopsis>
<name>RLimitCPU</name>
<description>Limite le temps CPU alloué aux processus initiés par les
processus enfants d'Apache httpd</description>
<syntax>RLimitCPU <var>secondes</var>|max [<var>secondes</var>|max]</syntax>
<default>Non défini ; utilise les valeurs par défaut du système
d'exploitation</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>All</override>

<usage>
    <p>Prend 1 ou 2 paramètres. Le premier definit la limite de
    consommation de ressources pour tous les processus, et le second la
    consommation de ressources maximale. Les deux paramètres peuvent
    contenir soit un nombre, soit <code>max</code> pour indiquer au
    serveur que la limite de consommation correspond à la valeur
    maximale autorisée par la configuration du système d'exploitation.
    Pour augmenter la consommation maximale de ressources, le serveur
    doit s'exécuter en tant que <code>root</code>, ou se trouver dans sa
    phase de démarrage.</p>

    <p>Cette directive s'applique aux processus initiés par les
    processus enfants d'Apache httpd qui traitent les requêtes, et non aux
    processus enfants eux-mêmes. Sont concernés les scripts CGI et les
    commandes exec des SSI, mais en aucun cas les processus initiés par
    le processus parent d'Apache httpd comme les journalisations redirigées
    vers un programme.</p>

    <p>Les limites de ressources CPU sont exprimées en secondes par
    processus.</p>
</usage>
<seealso><directive module="core">RLimitMEM</directive></seealso>
<seealso><directive module="core">RLimitNPROC</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>RLimitMEM</name>
<description>Limite la mémoire allouée aux processus initiés par les
processus enfants d'Apache httpd</description>
<syntax>RLimitMEM <var>octets</var>|max [<var>octets</var>|max]</syntax>
<default>Non défini ; utilise les valeurs par défaut du système
d'exploitation</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>All</override>

<usage>
    <p>Prend 1 ou 2 paramètres. Le premier definit la limite de
    consommation de ressources pour tous les processus, et le second la
    consommation de ressources maximale. Les deux paramètres peuvent
    contenir soit un nombre, soit <code>max</code> pour indiquer au
    serveur que la limite de consommation correspond à la valeur
    maximale autorisée par la configuration du système d'exploitation.
    Pour augmenter la consommation maximale de ressources, le serveur
    doit s'exécuter en tant que <code>root</code>, ou se trouver dans sa
    phase de démarrage.</p>

    <p>Cette directive s'applique aux processus initiés par les
    processus enfants d'Apache httpd qui traitent les requêtes, et non aux
    processus enfants eux-mêmes. Sont concernés les scripts CGI et les
    commandes exec des SSI, mais en aucun cas les processus initiés par
    le processus parent d'Apache httpd comme les journalisations redirigées
    vers un programme.</p>

    <p>Les limites de ressources mémoire sont exprimées en octets par
    processus.</p>
</usage>
<seealso><directive module="core">RLimitCPU</directive></seealso>
<seealso><directive module="core">RLimitNPROC</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>RLimitNPROC</name>
<description>Limite le nombre de processus qui peuvent être initiés par
les processus initiés par les processus enfants d'Apache httpd</description>
<syntax>RLimitNPROC <var>nombre</var>|max [<var>nombre</var>|max]</syntax>
<default>Unset; uses operating system defaults</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>All</override>

<usage>
    <p>Prend 1 ou 2 paramètres. Le premier definit la limite de
    consommation de ressources pour tous les processus, et le second la
    consommation de ressources maximale. Les deux paramètres peuvent
    contenir soit un nombre, soit <code>max</code> pour indiquer au
    serveur que la limite de consommation correspond à la valeur
    maximale autorisée par la configuration du système d'exploitation.
    Pour augmenter la consommation maximale de ressources, le serveur
    doit s'exécuter en tant que <code>root</code>, ou se trouver dans sa
    phase de démarrage.</p>

    <p>Cette directive s'applique aux processus initiés par les
    processus enfants d'Apache httpd qui traitent les requêtes, et non aux
    processus enfants eux-mêmes. Sont concernés les scripts CGI et les
    commandes exec des SSI, mais en aucun cas les processus initiés par
    le processus parent d'Apache httpd comme les journalisations redirigées
    vers un programme.</p>

    <p>Les limites des processus contrôlent le nombre de processus par
    utilisateur.</p>

    <note><title>Note</title>
      <p>Si les processus CGI s'exécutent sous le même
      utilisateur que celui du serveur web, cette
      directive va limiter le nombre de processus que le serveur
      pourra lui-même créer. La présence de messages
      <strong><code>cannot fork</code></strong> dans le journal des
      erreurs indiquera que la limite est atteinte.</p>
    </note>
</usage>
<seealso><directive module="core">RLimitMEM</directive></seealso>
<seealso><directive module="core">RLimitCPU</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ScriptInterpreterSource</name>
<description>Permet de localiser l'interpréteur des scripts
CGI</description>
<syntax>ScriptInterpreterSource Registry|Registry-Strict|Script</syntax>
<default>ScriptInterpreterSource Script</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>
<compatibility>Win32 seulement.</compatibility>

<usage>
    <p>Cette directive permet de contrôler la méthode qu'utilise Apache
    httpd pour trouver l'interpréteur destiné à exécuter les scripts CGI. La
    définition par défaut est <code>Script</code> : ceci indique à
    Apache httpd qu'il doit utiliser l'interpréteur précisé dans la ligne
    shebang du script (la première ligne, commençant par
    <code>#!</code>). Sur les systèmes Win32, cette ligne ressemble
    souvent à ceci :</p>

    <highlight language="perl">#!C:/Perl/bin/perl.exe</highlight>

    <p>ou simplement, dans le cas où <code>perl</code> est dans le
    <code>PATH</code> :</p>

    <highlight language="perl">#!perl</highlight>

    <p>Avec <code>ScriptInterpreterSource Registry</code>, Windows va
    effectuer une recherche dans l'arborescence
    <code>HKEY_CLASSES_ROOT</code> de la base de registre avec comme
    mot-clé l'extension du fichier contenant le script (par exemple
    <code>.pl</code>). C'est la commande définie par la sous-clé de
    registre <code>Shell\ExecCGI\Command</code> ou, si elle n'existe
    pas, la sous-clé <code>Shell\Open\Command</code> qui est utilisée
    pour ouvrir le fichier du script. Si ces clés de registre ne sont
    pas trouvées, Apache httpd utilise la méthode de l'option
    <code>Script</code>.</p>

    <note type="warning"><title>Sécurité</title>
    <p>Soyez prudent si vous utilisez <code>ScriptInterpreterSource
    Registry</code> avec des répertoires faisant l'objet d'un <directive
    module="mod_alias">ScriptAlias</directive>, car Apache httpd va essayer
    d'exécuter <strong>tous</strong> les fichiers contenus dans
    celui-ci. L'option <code>Registry</code> peut causer des appels de
    programmes non voulus sur des fichiers non destinés à être exécutés.
    Par exemple, la commande par défaut open sur les fichiers
    <code>.htm</code> sur la plupart des systèmes Windows va lancer
    Microsoft Internet Explorer ; ainsi, toute requête HTTP pour un
    fichier <code>.htm</code> situé dans le répertoire des scripts
    va lancer le navigateur en arrière-plan sur le serveur, ce qui a
    toutes les chances de crasher votre système dans les minutes qui
    suivent.</p>
    </note>

    <p>L'option <code>Registry-Strict</code>
    agit de manière identique à <code>Registry</code>, mais n'utilise
    que la sous-clé <code>Shell\ExecCGI\Command</code>. La présence de
    la clé <code>ExecCGI</code> n'étant pas systématique, Elle doit être
    définie manuellement dans le registre Windows et évite ainsi tout
    appel de programme accidentel sur votre système.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SeeRequestTail</name>
<description>Détermine si mod_status affiche les 63 premiers caractères
d'une requête ou les 63 derniers, en supposant que la requête
elle-même possède plus de 63 caractères.</description>
<syntax>SeeRequestTail On|Off</syntax>
<default>SeeRequestTail Off</default>
<contextlist><context>server config</context></contextlist>
<compatibility>Disponible depuis la version 2.2.7
d'Apache httpd.</compatibility>

<usage>
    <p>Avec <code>ExtendedStatus On</code>, mod_status affiche la
    véritable requête en cours de traitement. Pour des raisons
    historiques, seuls 63 caractères de la requête sont réellement
    stockés à des fins d'affichage. Cette directive permet de déterminer
    si ce sont les 63 premiers caractères qui seront stockés (c'est le
    comportement par défaut),
    ou si ce sont les 63 derniers. Ceci ne s'applique bien entendu que
    si la taille de la requête est de 64 caractères ou plus.</p>

    <p>Si Apache httpd traite la requête <code
    >GET&nbsp;/disque1/stockage/apache/htdocs/images/rep-images1/nourriture/pommes.jpg&nbsp;HTTP/1.1</code>
    , l'affichage de la requête par mod_status se présentera comme suit :
    </p>

    <table border="1">
      <tr>
        <th>Off (défaut)</th>
        <td>GET&nbsp;/disque1/stockage/apache/htdocs/images/rep-images1/nourritu</td>
      </tr>
      <tr>
        <th>On</th>
        <td>apache/htdocs/images/rep-images1/nourriture/pommes.jpg&nbsp;HTTP/1.1</td>
      </tr>
    </table>

</usage>

</directivesynopsis>

<directivesynopsis>
<name>ServerAdmin</name>
<description>L'adresse électronique que le serveur inclut dans les
messages d'erreur envoyés au client</description>
<syntax>ServerAdmin <var>adresse électronique</var>|<var>URL</var></syntax>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>La directive <directive>ServerAdmin</directive> permet de définir
    l'adresse de contact que le serveur va inclure dans tout message
    d'erreur qu'il envoie au client. Si le programme <code>httpd</code>
    ne reconnait pas l'argument fourni comme une URL, il suppose que
    c'est une <var>adresse électronique</var>, et lui ajoute le préfixe
    <code>mailto:</code> dans les cibles des hyperliens. Il est
    cependant recommandé d'utiliser exclusivement une adresse
    électronique, car de nombreux scripts CGI considèrent ceci comme
    implicite. Si vous utilisez une URL, elle doit pointer vers un autre
    serveur que vous contrôlez. Dans le cas contraire, les utilisateurs
    seraient dans l'impossibilité de vous contacter en cas de problème.</p>

    <p>Il peut s'avérer utile de définir une adresse dédiée à
    l'administration du serveur, par exemple :</p>

    <highlight language="config">ServerAdmin www-admin@foo.example.com</highlight>
    <p>car les utilisateurs ne mentionnent pas systématiquement le
    serveur dont ils parlent !</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ServerAlias</name>
<description>Autres noms d'un serveur utilisables pour atteindre des
serveurs virtuels à base de nom</description>
<syntax>ServerAlias <var>nom serveur</var> [<var>nom serveur</var>]
...</syntax>
<contextlist><context>virtual host</context></contextlist>

<usage>
    <p>La directive <directive>ServerAlias</directive> permet de définir
    les noms alternatifs d'un serveur utilisables pour atteindre des <a
    href="../vhosts/name-based.html">serveurs virtuels à base de
    nom</a>. La directive <directive>ServerAlias</directive> peut
    contenir des caractères génériques, si nécessaire.</p>

    <highlight language="config">
&lt;VirtualHost *:80&gt;
  ServerName server.example.com
  ServerAlias server server2.example.com server2
  ServerAlias *.example.com
  UseCanonicalName Off
  # ...
&lt;/VirtualHost&gt;
    </highlight>
    <p>La recherche du serveur virtuel à base de nom correspondant au
    plus près à la requête s'effectue selon l'ordre d'apparition des
    directives <directive type="section"
    module="core">virtualhost</directive> dans le fichier de
    configuration. Le premier serveur virtuel dont le <directive
    module="core">ServerName</directive> ou le <directive
    module="core">ServerAlias</directive> correspond est choisi, sans
    priorité particulière si le nom contient des caractères génériques
    (que ce soit pour ServerName ou ServerAlias).</p>

    <p>Tous les noms spécifiés au sein d'une section <directive type="section"
    module="core">VirtualHost</directive> sont traités comme un
    <directive>ServerAlias</directive> (sans caractères génériques).</p>

</usage>
<seealso><directive module="core">UseCanonicalName</directive></seealso>
<seealso><a href="../vhosts/">Documentation sur les serveurs virtuels
du serveur HTTP Apache</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ServerName</name>
<description>Nom d'hôte et port que le serveur utilise pour
s'authentifier lui-même</description>
<syntax>ServerName
[<var>protocole</var>://]<var>nom-de-domaine</var>|<var>adresse-ip</var>[:<var>port</var>]</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>La directive <directive>ServerName</directive> permet de définir
    les protocole, nom d'hôte et port d'une requête que le serveur
    utilise pour s'authentifier lui-même.</p>

    <p>La directive <directive>ServerName</directive> permet (éventuellement en
    conjonction avec la directive <directive
    module="core">ServerAlias</directive>) d'identifier de manière unique un
    serveur virtuel, lorsqu'elle est utilisée dans un contexte de <a
    href="../vhosts/name-based.html">serveurs virtuels à base de noms</a>.</p>

    <p>Cette directive est aussi utilisée lors de la création d'URLs de
    redirection relatives quand la directive <directive
    module="core">UseCanonicalName</directive> est définie à une valeur autre
    que la valeur par défaut.</p>
    
    <p>Par exemple, si le nom de la
    machine hébergeant le serveur web est
    <code>simple.example.com</code>, la machine possède l'alias
    DNS <code>www.example.com</code>, et si vous voulez que le serveur
    web s'identifie avec cet alias, vous devez utilisez la définition
    suivante :</p>

    <highlight language="config">ServerName www.example.com</highlight>

    <p>La directive <directive>ServerName</directive> peut apparaître à
    toutes les étapes de la définition du serveur. Toute occurrence
    annule cependant la précédente (pour ce serveur).</p>

    <p>Si la directive <directive>ServerName</directive> n'est pas
    définie, le serveur tente de déterminer le nom
    d'hôte visible du point de vue du client en demandant tout d'abord au
    système d'exploitation le nom d'hôte système, et en cas d'échec, en effectuant
    une recherche DNS inverse sur une adresse IP présente sur le système.</p>
    
    <p>Si la directive
    <directive>ServerName</directive> ne précise pas de port, le serveur
    utilisera celui de la requête entrante. Il est recommandé de
    spécifier un nom d'hôte et un port spécifiques à l'aide de la
    directive <directive>ServerName</directive> pour une fiabilité
    optimale et à titre préventif.</p>

    <p>Si vous définissez des <a
    href="../vhosts/name-based.html">serveurs virtuels à base de
    nom</a>, une directive <directive>ServerName</directive> située à
    l'intérieur d'une section <directive type="section"
    module="core">VirtualHost</directive> spécifiera quel nom d'hôte
    doit apparaître dans l'en-tête de requête <code>Host:</code> pour
    pouvoir atteindre ce serveur virtuel.</p>


    <p>Parfois, le serveur s'exécute en amont d'un dispositif qui
    implémente SSL, comme un mandataire inverse, un répartiteur de
    charge ou un boîtier dédié SSL. Dans ce cas, spécifiez le protocole
    <code>https://</code> et le port auquel les clients se connectent
    dans la directive <directive>ServerName</directive>, afin de
    s'assurer que le serveur génère correctement ses URLs
    d'auto-identification.
    </p>

    <p>Voir la description des directives <directive
    module="core">UseCanonicalName</directive> et <directive
    module="core">UseCanonicalPhysicalPort</directive> pour les
    définitions qui permettent de déterminer si les URLs
    auto-identifiantes (par exemple via le module
    <module>mod_dir</module>) vont faire référence au port spécifié, ou
    au port indiqué dans la requête du client.
    </p>

    <note type="warning">
    <p>Si la valeur de la directive <directive>ServerName</directive> ne
    peut pas être résolue en adresse IP, le démarrage du serveur
    provoquera un avertissement. <code>httpd</code> va alors utiliser le
    résultat de la commande système <code>hostname</code> pour
    déterminer le nom du serveur, ce qui ne correspondra pratiquement
    jamais au nom de serveur que vous souhaitez réellement.</p>
    <example>
    httpd: Could not reliably determine the server's fully qualified domain name, using rocinante.local for ServerName
    </example>
    </note>

</usage>

<seealso><a href="../dns-caveats.html">Problèmes concernant le DNS et
le serveur HTTP Apache</a></seealso>
<seealso><a href="../vhosts/">Documentation sur les serveurs virtuels
du serveur HTTP Apache</a></seealso>
<seealso><directive module="core">UseCanonicalName</directive></seealso>
<seealso><directive module="core">UseCanonicalPhysicalPort</directive></seealso>
<seealso><directive module="core">ServerAlias</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ServerPath</name>
<description>Nom de chemin d'URL hérité pour un serveur virtuel à base
de nom accédé par un navigateur incompatible</description>
<syntax>ServerPath <var>chemin d'URL</var></syntax>
<contextlist><context>virtual host</context></contextlist>

<usage>
    <p>La directive <directive>ServerPath</directive> permet de définir
    le nom de chemin d'URL hérité d'un hôte, à utiliser avec les <a
    href="../vhosts/">serveurs virtuels à base de nom</a>.</p>
</usage>
<seealso><a href="../vhosts/">Documentation sur les serveurs virtuels
du serveur HTTP Apache</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ServerRoot</name>
<description>Racine du répertoire d'installation du
serveur</description>
<syntax>ServerRoot <var>chemin de répertoire</var></syntax>
<default>ServerRoot /usr/local/apache</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>La directive <directive>ServerRoot</directive> permet de définir
    le répertoire dans lequel le serveur est installé. En particulier,
    il contiendra les sous-répertoires <code>conf/</code> et
    <code>logs/</code>. Les chemins relatifs indiqués dans les autres
    directives (comme <directive
    module="core">Include</directive> ou <directive
    module="mod_so">LoadModule</directive>) seront définis par
    rapport à ce répertoire.</p>

    <highlight language="config">ServerRoot "/home/httpd"</highlight>

    <p>La valeur par défaut de <directive>ServerRoot</directive> peut
    être modifiée via l'argument <code>--prefix</code> de la commande <a
    href="../programs/configure.html"><code>configure</code></a>, et de
    nombreuses distributions tierces du serveur proposent une valeur
    différente de celles listées ci-dessus.</p>

</usage>
<seealso><a href="../invoking.html">the <code>-d</code>
    options de <code>httpd</code></a></seealso>
<seealso><a href="../misc/security_tips.html#serverroot">les conseils à
propos de sécurité</a> pour des informations sur la manière de définir
correctement les permissions sur le répertoire indiqué par la directive
<directive>ServerRoot</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ServerSignature</name>
<description>Définit un pied de page pour les documents générés par le
serveur</description>
<syntax>ServerSignature On|Off|EMail</syntax>
<default>ServerSignature Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>

<usage>
    <p>La directive <directive>ServerSignature</directive> permet de
    définir une ligne de pied de page fixe pour les documents générés
    par le serveur (messages d'erreur, listings de répertoires ftp de
    <module>mod_proxy</module>, sorties de <module>mod_info</module>,
    etc...). Dans le cas d'une chaîne de mandataires, l'utilisateur n'a
    souvent aucun moyen de déterminer lequel des mandataires chaînés a
    généré un message d'erreur, et c'est une des raisons pour lesquelles
    on peut être amené à ajouter un tel pied de page.</p>

    <p>La valeur par défaut <code>Off</code> supprime la ligne de pied
    de page. la valeur <code>On</code>
    ajoute simplement une ligne contenant le numéro de version du
    serveur ainsi que le nom du serveur virtuel issu de la directive
    <directive module="core">ServerName</directive>, alors que la valeur
    <code>EMail</code> ajoute en plus une référence "mailto:" à
    l'administrateur du document référencé issu la directive
    <directive module="core">ServerAdmin</directive>.</p>

    <p>Les détails à propos du numéro de
    version du serveur sont contrôlés à l'aide de la directive
    <directive module="core">ServerTokens</directive>.</p>
</usage>
<seealso><directive module="core">ServerTokens</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ServerTokens</name>
<description>Configure l'en-tête <code>Server</code> de la réponse
HTTP</description>
<syntax>ServerTokens Major|Minor|Min[imal]|Prod[uctOnly]|OS|Full</syntax>
<default>ServerTokens Full</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de contrôler le contenu de l'en-tête
    <code>Server</code> inclus dans la réponse envoyée au client : cet
    en-tête peut contenir le type de système d'exploitation du serveur,
    ainsi que des informations à propos des modules compilés avec le
    serveur.</p>

    <dl>
	<dt><code>ServerTokens Full</code> (ou non spécifié)</dt>

	<dd>Le serveur envoie par exemple : <code>Server: Apache/2.4.2
	(Unix) PHP/4.2.2 MyMod/1.2</code></dd>

    	<dt><code>ServerTokens Prod[uctOnly]</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache</code></dd>

      <dt><code>ServerTokens Major</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2</code></dd>

      <dt><code>ServerTokens Minor</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2.4</code></dd>

      <dt><code>ServerTokens Min[imal]</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2.4.2</code></dd>

      <dt><code>ServerTokens OS</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2.4.2 (Unix)</code></dd>

      
      
    </dl>

    <p>Cette définition s'applique à l'ensemble du serveur et ne peut
    être activée ou désactivée pour tel ou tel serveur virtuel.</p>

    <p>Cette directive contrôle
    aussi les informations fournies par la directive <directive
    module="core">ServerSignature</directive>.</p>

    <note>Définir <directive>ServerTokens</directive> à une
    valeur inférieure à <code>minimal</code> n'est pas
    recommandé car le débogage des problèmes
    interopérationnels n'en sera alors que plus difficile. Notez
    aussi que la désactivation de l'en-tête Server:
    n'améliore en rien la sécurité de votre
    serveur ; le concept de "sécurité par
    l'obscurité" est un mythe et conduit à
    une mauvaise perception de ce qu'est la sécurité.</note>


</usage>
<seealso><directive module="core">ServerSignature</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>SetHandler</name>
<description>Force le traitement des fichiers spécifiés par un
gestionnaire particulier</description>
<syntax>SetHandler <var>handler-name</var>|none|<var>expression</var></syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>
<compatibility>L'argument expression est disponible à partir de la version
2.4.19 su serveur HTTP Apache</compatibility>

<usage>
    <p>Lorsqu'elle se situe à l'intérieur d'un fichier
    <code>.htaccess</code>, ou d'une section <directive type="section"
    module="core">Directory</directive> ou <directive type="section"
    module="core">Location</directive>, cette directive force le
    traitement de tous les fichiers spécifiés par le <a
    href="../handler.html">gestionnaire</a> défini par l'argument
    <var>nom gestionnaire</var>. Par exemple, dans le cas d'un
    répertoire dont vous voulez interpréter le contenu comme des
    fichiers de règles d'images cliquables, sans tenir compte des
    extensions, vous pouvez ajouter la ligne suivante dans un fichier
    <code>.htaccess</code> de ce répertoire :</p>

    <highlight language="config">SetHandler imap-file</highlight>

    <p>Autre exemple : si vous voulez que le serveur affiche un
    compte-rendu d'état chaque fois qu'une URL du type <code>http://nom
    serveur/status</code> est appelée, vous pouvez ajouter ceci dans
    <code>httpd.conf</code> :</p>

    <highlight language="config">
&lt;Location "/status"&gt;
  SetHandler server-status
&lt;/Location&gt;
    </highlight>

    <p>Vous pouvez aussi utiliser cette directive pour associer un
    gestionnaire à des fichiers possèdant une extension de nom de
    fichier particulière. Par exemple :</p>

    <highlight language="config">
&lt;FilesMatch "\.php$"&gt;
    SetHandler application/x-httpd-php
&lt;/FilesMatch&gt;
    </highlight>

    <p>Pour référencer des variables spécifiques à une requête, y compris les
    références arrières vers des expressions rationnelles nommées, vous pouvez
    utiliser des expressions ayant pour valeur une chaîne : </p>

    <highlight language="config">
&lt;LocationMatch ^/app/(?&lt;sub&gt;[^/]+)/&gt;
     SetHandler "proxy:unix:/var/run/app_%{env:MATCH_sub}.sock|fcgi://localhost:8080"
&lt;/LocationMatch&gt;
    </highlight>

    <p>Vous pouvez écraser la définition antérieure d'une directive
    <directive>SetHandler</directive> en utilisant la valeur
    <code>None</code>.</p>

    <note><title>Note</title>
    <p>Comme <directive>SetHandler</directive> l'emporte sur la
    définition des gestionnaires par défaut, le comportement habituel
    consistant à traiter les URLs se terminant par un slash (/) comme
    des répertoires ou des fichiers index est désactivé.</p></note>
</usage>

<seealso><directive module="mod_mime">AddHandler</directive></seealso>

</directivesynopsis>

<directivesynopsis>
<name>SetInputFilter</name>
<description>Définit les filtres par lesquels vont passer les requêtes
client et les données POST</description>
<syntax>SetInputFilter <var>filtre</var>[;<var>filtre</var>...]</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>SetInputFilter</directive> permet de
    définir le ou les filtres par lesquels vont passer les requêtes
    client et les données POST au moment où le serveur les reçoit. Cette
    définition vient en ajout à tout autre filtre défini en
    quelqu'endroit que ce soit, y compris via la directive <directive
    module="mod_mime">AddInputFilter</directive>.</p>

    <p>Si la directive comporte plusieurs filtres, ils doivent être
    séparés par des points-virgules, et spécifiés selon l'ordre dans
    lequel vous souhaitez les voir agir sur les contenus.</p>
</usage>
<seealso>documentation des <a
href="../filter.html">Filtres</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>SetOutputFilter</name>
<description>Définit les filtres par lesquels vont passer les réponses
du serveur</description>
<syntax>SetOutputFilter <var>filtre</var>[;<var>filtre</var>...]</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>SetOutputFilter</directive> permet de
    définir les filtres par lesquels vont passer les réponses du serveur
    avant d'être envoyées au client. Cette définition vient en ajout à
    tout autre filtre défini en quelqu'endroit que ce soit, y compris
    via la directive <directive
    module="mod_mime">AddOutputFilter</directive>.</p>

    <p>Par exemple, la configuration suivante va traiter tous les
    fichiers du répertoire <code>/www/data/</code> comme des inclusions
    côté serveur (SSI) :</p>

    <highlight language="config">
&lt;Directory "/www/data/"&gt;
  SetOutputFilter INCLUDES
&lt;/Directory&gt;
    </highlight>

    <p>Si la directive comporte plusieurs filtres, ils doivent être
    séparés par des points-virgules, et spécifiés selon l'ordre dans
    lequel vous souhaitez les voir agir sur les contenus.</p>
</usage>
<seealso><a href="../filter.html">Filters</a> documentation</seealso>
</directivesynopsis>

<directivesynopsis>
<name>TimeOut</name>
<description>Temps pendant lequel le serveur va attendre certains
évènements avant de considérer qu'une requête a échoué</description>
<syntax>TimeOut <var>secondes</var></syntax>
<default>TimeOut 60</default>
<contextlist><context>server config</context><context>virtual
host</context></contextlist>

<usage>
    <p>La directive <directive>TimeOut</directive> permet de définir le
    temps maximum pendant lequel Apache httpd va attendre des entrées/sorties
    selon les circonstances :</p>

    <ul>
      <li><p>Lors de la lecture de données en provenance du client, le
      temps maximum jusqu'à l'arrivée d'un paquet TCP si le tampon est
      vide.</p>
      <p>Pour les données initiales d'une nouvelle connexion, et tant qu'une
      directive <directive module="core">AcceptFilter</directive> n'aura pas
      transmis cette nouvelle connexion au serveur, cette directive n'aura aucun
      effet.</p>
      </li>

      <li>Lors de l'écriture de données destinées au client, le temps
      maximum jusqu'à l'arrivée de l'accusé-réception d'un paquet si le
      tampon d'envoi est plein.</li>

      <li>Avec <module>mod_cgi</module> et <module>mod_cgid</module>, le temps
      d'attente maximum pour un bloc individuel en sortie d'un script CGI.</li>

      <li>Avec <module>mod_ext_filter</module>, le temps d'attente
      maximum des sorties d'un processus de filtrage.</li>

      <li>Avec <module>mod_proxy</module>, la valeur du délai par défaut
      si <directive module="mod_proxy">ProxyTimeout</directive> n'est
      pas défini.</li>
    </ul>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>TraceEnable</name>
<description>Détermine le comportement des requêtes
<code>TRACE</code></description>
<syntax>TraceEnable <var>[on|off|extended]</var></syntax>
<default>TraceEnable on</default>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p>Cette directive l'emporte sur le comportement de
    <code>TRACE</code> pour le noyau du serveur et
    <module>mod_proxy</module>. La définition par défaut
    <code>TraceEnable on</code> permet des requêtes <code>TRACE</code>
    selon la RFC 2616, qui interdit d'ajouter tout corps à la requête.
    La définition <code>TraceEnable off</code> indique au noyau du
    serveur et à <module>mod_proxy</module> de retourner un code
    d'erreur <code>405</code> (Méthode non autorisée) au client.</p>

    <p>En fait, et à des fins de test et de diagnostic seulement, on
    peut autoriser l'ajout d'un corps de requête à l'aide de la
    définition non standard <code>TraceEnable extended</code>. Le noyau
    du serveur (dans le cas d'un serveur d'origine) va limiter la taille
    du corps de requête à 64Kb (plus 8Kb pour les en-têtes de
    fractionnement si <code>Transfer-Encoding: chunked</code> est
    utilisé). Le noyau du serveur va reproduire l'ensemble des en-têtes,
    y compris les en-têtes de fractionnement avec le corps de la
    réponse. Dans le cas d'un serveur mandataire, la taille du corps de
    requête n'est pas limitée à 64Kb.</p>

    <note><title>Note</title>
    <p>Bien que certains prétendent le contraire, activer la méthode
    <code>TRACE</code> ne constitue pas un problème de sécurité dans Apache
    httpd. La méthode <code>TRACE</code> est définie par la spécification
    HTTP/1.1 et les différentes implémentations sont censées la supporter.</p>
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>UnDefine</name>
<description>Invalide la définition d'une variable</description>
<syntax>UnDefine <var>nom-variable</var></syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Annule l'effet d'une directive <directive
    module="core">Define</directive> ou d'un argument <code>-D</code> de
    <program>httpd</program> en invalidant l'existence de la variable
    correspondante.</p>
    <p>On peut utiliser cette directive pour inverser l'effet d'une
    section <directive module="core" type="section">IfDefine</directive>
    sans avoir à modifier les arguments <code>-D</code> dans les scripts
    de démarrage.</p>
    <p>Si cette directive est définie au sein d'un bloc VirtualHost, les
    changements qu'elle induit sont visibles de toute directive
    ultérieure, au delà de tout bloc VirtualHost.</p>
</usage>
<seealso><directive module="core">Define</directive></seealso>
<seealso><directive module="core">IfDefine</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>UseCanonicalName</name>
<description>Définit la manière dont le serveur détermine son propre nom
et son port</description>
<syntax>UseCanonicalName On|Off|DNS</syntax>
<default>UseCanonicalName Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context></contextlist>

<usage>
    <p>Dans de nombreuses situations, Apache httpd doit construire une URL
    <em>auto-identifiante</em> -- c'est à dire une URL qui fait
    référence au serveur lui-même. Avec <code>UseCanonicalName
    On</code>, Apache httpd va utiliser le nom d'hôte et le port spécifiés par
    la directive <directive module="core">ServerName</directive> pour
    construire le nom canonique du serveur. Ce nom est utilisé dans
    toutes les URLs auto-identifiantes, et affecté aux variables
    <code>SERVER_NAME</code> et <code>SERVER_PORT</code> dans les
    programmes CGI.</p>

    <p>Avec <code>UseCanonicalName Off</code>, Apache httpd va construire ses
    URLs auto-identifiantes à l'aide du nom d'hôte et du port fournis
    par le client, si ce dernier en a fourni un (dans la négative,
    Apache utilisera le nom canonique, de la même manière que
    ci-dessus). Ces valeurs sont les mêmes que celles qui sont utilisées
    pour implémenter les <a
    href="../vhosts/name-based.html">serveurs virtuels à base de
    nom</a>, et sont disponibles avec les mêmes clients. De même, les
    variables CGI <code>SERVER_NAME</code> et <code>SERVER_PORT</code>
    seront affectées des valeurs fournies par le client.</p>

    <p>Cette directive peut s'avérer utile, par exemple, sur un serveur
    intranet auquel les utilisateurs se connectent en utilisant des noms
    courts tels que <code>www</code>. Si les utilisateurs tapent un nom
    court suivi d'une URL qui fait référence à un répertoire, comme
    <code>http://www/splat</code>, <em>sans le slash terminal</em>, vous
    remarquerez qu'Apache httpd va les rediriger vers
    <code>http://www.example.com/splat/</code>. Si vous avez activé
    l'authentification, ceci va obliger l'utilisateur à s'authentifier
    deux fois (une première fois pour <code>www</code> et une seconde
    fois pour <code>www.example.com</code> -- voir <a
    href="http://wiki.apache.org/httpd/FAQ#Why_does_Apache_ask_for_my_password_twice_before_serving_a_file.3F">la
    foire aux questions sur ce sujet pour plus d'informations</a>).
    Par contre, si <directive>UseCanonicalName</directive> est définie à
    <code>Off</code>, Apache httpd redirigera l'utilisateur vers
    <code>http://www/splat/</code>.</p>

    <p>Pour l'hébergement virtuel en masse à base d'adresse IP, on
    utilise une troisième option, <code>UseCanonicalName
    DNS</code>, pour supporter les clients anciens qui ne
    fournissent pas d'en-tête <code>Host:</code>. Apache httpd effectue alors
    une recherche DNS inverse sur l'adresse IP du serveur auquel le
    client s'est connecté afin de construire ses URLs
    auto-identifiantes.</p>

    <note type="warning"><title>Avertissement</title>
    <p>Les programmes CGI risquent d'être perturbés par cette option
    s'ils tiennent compte de la variable <code>SERVER_NAME</code>. Le
    client est pratiquement libre de fournir la valeur qu'il veut comme
    nom d'hôte. Mais si le programme CGI n'utilise
    <code>SERVER_NAME</code> que pour construire des URLs
    auto-identifiantes, il ne devrait pas y avoir de problème.</p>
    </note>
</usage>
<seealso><directive module="core">UseCanonicalPhysicalPort</directive></seealso>
<seealso><directive module="core">ServerName</directive></seealso>
<seealso><directive module="mpm_common">Listen</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>UseCanonicalPhysicalPort</name>
<description>Définit la manière dont le serveur
détermine son propre port</description>
<syntax>UseCanonicalPhysicalPort On|Off</syntax>
<default>UseCanonicalPhysicalPort Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context></contextlist>

<usage>
    <p>Dans de nombreuses situations, Apache httpd doit construire une URL
    <em>auto-identifiante</em> -- c'est à dire une URL qui fait
    référence au serveur lui-même. Avec <code>UseCanonicalPhysicalPort
    On</code>, Apache httpd va fournir le numéro de port physique réel utilisé
    par la requête en tant que port potentiel, pour construire le port
    canonique afin que le serveur puisse alimenter la directive
    <directive module="core">UseCanonicalName</directive>. Avec
    <code>UseCanonicalPhysicalPort Off</code>, Apache httpd n'utilisera pas le
    numéro de port physique réel, mais au contraire se référera aux
    informations de configuration pour construire un numéro de port
    valide.</p>

    <note><title>Note</title>
    <p>L'ordre dans lequel s'effectue la recherche quand on utilise le
    port physique est le suivant :</p>
     <dl>
     <dt><code>UseCanonicalName On</code></dt>
     <dd>
     <ol>
      <li>Port indiqué dans <directive module="core">Servername</directive></li>
      <li>Port physique</li>
      <li>Port par défaut</li>
     </ol>
     </dd>
     <dt><code>UseCanonicalName Off | DNS</code></dt>
     <dd>
     <ol>
      <li>Port spécifié dans l'en-tête <code>Host:</code></li>
      <li>Port physique</li>
      <li>Port spécifié par <directive module="core">Servername</directive></li>
      <li>Port par défaut</li>
     </ol>
     </dd>
     </dl>

    <p>Avec <code>UseCanonicalPhysicalPort Off</code>, on reprend
    l'ordre ci-dessus en supprimant "Port physique".</p>
    </note>

</usage>
<seealso><directive module="core">UseCanonicalName</directive></seealso>
<seealso><directive module="core">ServerName</directive></seealso>
<seealso><directive module="mpm_common">Listen</directive></seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>VirtualHost</name>
<description>Contient des directives qui ne s'appliquent qu'à un nom
d'hôte spécifique ou à une adresse IP</description>
<syntax>&lt;VirtualHost
    <var>adresse IP</var>[:<var>port</var>] [<var>adresse
    IP</var>[:<var>port</var>]] ...&gt; ...
    &lt;/VirtualHost&gt;</syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Les balises <directive type="section">VirtualHost</directive> et
    <code>&lt;/VirtualHost&gt;</code> permettent de rassembler un groupe
    de directives qui ne s'appliquent qu'à un serveur virtuel
    particulier. Toute directive autorisée dans un contexte de serveur
    virtuel peut être utilisée. Lorsque le serveur reçoit un requête
    pour un document hébergé par un serveur virtuel particulier, il
    applique les directives de configuration rassemblées dans la section
    <directive type="section">VirtualHost</directive>. <var>adresse
    IP</var> peut être une des entités suivantes, éventuellement suivies
    d'un caractère ':' et d'un numéro de port (ou *) :</p>

    <ul>
      <li>L'adresse IP du serveur virtuel ;</li>

      <li>Un nom de domaine entièrement qualifié correspondant à
      l'adresse IP du serveur virtuel (non recommandé) ;</li>

      <li>Le caractère <code>*</code>, qui agit comme un
      caractère générique, et correspond à toute adresse IP.</li>

      <li>La chaîne <code>_default_</code>, dont la signification est
      identique à celle du caractère <code>*</code></li>

    </ul>

    <highlight language="config">
&lt;VirtualHost 10.1.2.3:80&gt;
  ServerAdmin webmaster@host.example.com
  DocumentRoot "/www/docs/host.example.com"
  ServerName host.example.com
  ErrorLog "logs/host.example.com-error_log"
  TransferLog "logs/host.example.com-access_log"
&lt;/VirtualHost&gt;
    </highlight>


    <p>Les adresses IPv6 doivent être entourées de crochets car dans le
    cas contraire, un éventuel port optionnel ne pourrait pas être
    déterminé. Voici un exemple de serveur virtuel avec adresse IPv6
    :</p>

    <highlight language="config">
&lt;VirtualHost [2001:db8::a00:20ff:fea7:ccea]:80&gt;
  ServerAdmin webmaster@host.example.com
  DocumentRoot "/www/docs/host.example.com"
  ServerName host.example.com
  ErrorLog "logs/host.example.com-error_log"
  TransferLog "logs/host.example.com-access_log"
&lt;/VirtualHost&gt;
    </highlight>

    <p>Chaque serveur virtuel doit correspondre à une adresse IP, un
    port ou un nom d'hôte spécifique ; dans le premier cas, le serveur
    doit être configuré pour recevoir les paquets IP de plusieurs
    adresses (si le serveur n'a qu'une interface réseau, on peut
    utiliser à cet effet la commande <code>ifconfig alias</code> -- si
    votre système d'exploitation le permet).</p>

    <note><title>Note</title>
    <p>L'utilisation de la directive <directive
    type="section">VirtualHost</directive> n'affecte en rien les
    adresses IP sur lesquelles Apache httpd est en écoute. Vous devez vous
    assurer que les adresses des serveurs virtuels sont bien incluses
    dans la liste des adresses précisées par la directive <directive
    module="mpm_common">Listen</directive>.</p>
    </note>
    
    <p>Tout bloc <directive
    type="section">VirtualHost</directive> doit comporter une directive
    <directive module="core">ServerName</directive>. Dans le cas
    contraire, le serveur virtuel héritera de la valeur de la directive
    <directive module="core">ServerName</directive> issue de la
    configuration du serveur principal.</p>

    <p>A l'arrivée d'une requête, le serveur tente de la
    faire prendre en compte par la section <directive
    type="section">VirtualHost</directive> qui correspond le mieux en ne
    se basant que sur la paire adresse IP/port. Les chaînes sans
    caractères génériques l'emportent sur celles qui en contiennent. Si
    aucune correspondance du point de vue de l'adresse IP/port n'est
    trouvée, c'est la configuration du serveur "principal" qui sera
    utilisée.</p>
    
    <p>Si plusieurs serveurs virtuels correspondent du point de vue de
    l'adresse IP/port, le serveur sélectionne celui qui correspond le
    mieux du point de vue du nom d'hôte de la requête. Si aucune
    correspondance du point de vue du nom d'hôte n'est trouvée, c'est le
    premier serveur virtuel dont l'adresse IP/port correspond qui sera
    utilisé. Par voie de conséquence, le premier serveur virtuel
    comportant une certaine paire adresse IP/port est le serveur virtuel
    par défaut pour cette paire adresse IP/port.</p>

    <note type="warning"><title>Sécurité</title>
    <p>Voir le document sur les <a
    href="../misc/security_tips.html">conseils à propos de sécurité</a>
    pour une description détaillée des raisons pour lesquelles la
    sécurité de votre serveur pourrait être compromise, si le répertoire
    contenant les fichiers journaux est inscriptible par tout autre
    utilisateur que celui qui démarre le serveur.</p>
    </note>
</usage>
<seealso><a href="../vhosts/">Documentation des serveurs virtuels
du serveur HTTP Apache</a></seealso>
<seealso><a href="../dns-caveats.html">Problèmes concernant le DNS et
le serveur HTTP Apache</a></seealso>
<seealso><a href="../bind.html">Définition des adresses et ports
qu'utilise le serveur HTTP Apache</a></seealso>
<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manière dont ces différentes sections se combinent
entre elles à la réception d'une requête</seealso>
</directivesynopsis>

<directivesynopsis>
<name>MergeTrailers</name>
<description>Détermine si les données supplémentaires (trailers) sont
fusionnées avec les en-têtes</description>
<syntax>MergeTrailers [on|off]</syntax>
<default>MergeTrailers off</default>
<contextlist><context>server config</context><context>virtual host</context></contextlist>
<compatibility>Disponible à partir de la version 2.4.11 du serveur HTTP
Apache</compatibility>

<usage>
    <p>Cette directive permet de contrôler la fusion des données HTTP
    supplémentaires (trailers) avec la représentation interne des
    en-têtes. Cette fusion intervient lorsque le corps de la requête a
    été entièrement reçu, bien longtemps après que la majeure partie du
    traitement des en-têtes ait une chance de pouvoir examiner ou
    modifier les en-têtes de la requête.</p>
    <p>Cette option a été introduite dans un souci de compatibilité avec
    les versions antérieures à 2.4.11, où les données supplémentaires
    étaient systématiquement fusionnées avec les en-têtes de la requête.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>QualifyRedirectURL</name>
<description>Vérifie si la variable d'environnement REDIRECT_URL est
pleinement qualifiée</description>
<syntax>QualifyRedirectURL On|Off</syntax>
<default>QualifyRedirectURL Off</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>
<override>FileInfo</override>
<compatibility>Directive supportée à partir de la version 2.4.18 du
serveur HTTP Apache. Jusqu'à la version 2.4.17, le serveur se comportait
comme si la directive QualifyRedirectURL était définie à On.</compatibility>

<usage>
    <p>Cette directive permet de s'assurer que le serveur vérifiera que
    la variable d'environnement REDIRECT_URL est bien pleinement
    qualifiée. Par défaut, cette variable contient l'URL textuellement
    demandée par le client, par exemple "/index.html". Avec
    <directive>QualifyRedirectURL ON</directive>, la même requête
    affectera à la variable REDIRECT_URL une valeur du style
    "http://www.example.com/index.html".</p>
    <p>Même si cette directive n'est pas définie, lorsqu'une requête est
    soumise avec une URL pleinement qualifiée, la variable REDIRECT_URL
    contiendra quand-même une URL pleinement qualifiée.
    </p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RegisterHttpMethod</name>
<description>Enregistrement de méthodes HTTP non standards</description>
<syntax>RegisterHttpMethod <var>méthode</var> [<var>méthode</var> [...]]</syntax>
<contextlist><context>server config</context></contextlist>
<compatibility>Disponible à partir de la version 2.4.24 du serveur HTTP Apache</compatibility>

<usage>
<p>Cette directive permet d'enregistrer des méthodes HTTP supplémentaires. Ceci
s'avérera nécessaire si l'on doit utiliser des méthodes non standards avec des
directives qui acceptent des noms de méthodes en paramètres, ou pour permettre
l'utilisation de méthodes particulières non standards en passant par un serveur
mandataire ou au sein de scripts CGI, et ceci alors que le serveur a été
configuré pour ne transmettre que des méthodes reconnues aux modules.</p>
</usage>
<seealso><directive module="core">HTTPProtocolOptions</directive></seealso>
<seealso><directive module="mod_allowmethods">AllowMethods</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>MergeSlashes</name>
<description>Fusion des slashes consécutifs dans les URLs par le serveur.
</description>
<syntax>MergeSlashes ON|OFF</syntax>
<default>MergeSlashes ON</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>
<compatibility>Disponible à partir de la version 2.4.39 du serveur HTTP Apache</compatibility>

<usage>
    <p>Par défaut, le serveur fusionne les caractères slash ('/') multiples et
    consécutifs dans la partie chemin de l'URL d'une requête.</p>

    <p>Lorsque cette partie chemin de l'URL est appliquée au système de
    fichiers, ces slashes multiples sont inutiles. Il peut être cependant
    préférable de conserver ces slashes multiples et consécutifs car ils peuvent
    avoir une signification dans le cas des URLs gérées différemment, par
    exemple par CGI ou par un serveur mandataire. Il convient alors de définir
    <directive>MergeSlashes</directive> à <em>OFF</em>. Dans ces types de
    configuration, les expressions rationnelles utilisées dans le
    fichier de configuration pour effectuer une comparaison de la partie chemin
    de l'URL ((<directive>LocationMatch</directive>,
    <directive>RewriteRule</directive>, ...) doivent en effet tenir compte de la
    présence éventuelle de slashes multiples et consécutifs.</p>
</usage>
</directivesynopsis>

</modulesynopsis>
