<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1794162 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_brotli.xml.meta">

<name>mod_brotli</name>
<description>Compression du contenu via Brotli avant sa livraison au client</description>
<status>Extension</status>
<sourcefile>mod_brotli.c</sourcefile>
<identifier>brotli_module</identifier>
<compatibility>Disponible à partir de la version 2.4.26 du serveur HTTP Apache</compatibility>

<summary>
    <p>Le module <module>mod_brotli</module> fournit le filtre en sortie
    <code>BROTLI_COMPRESS</code> qui permet de compresser un contenu avant sa
    livraison au client en utilisant la bibliothèque brotli. Ce filtre est
    implémenté en utilisant la bibliothèque Brotli que l'on peut trouver à <a
    href="https://github.com/google/brotli">https://github.com/google/brotli</a>.</p>
</summary>
<seealso><a href="../filter.html">Filters</a></seealso>

<section id="recommended"><title>Exemples de configurations</title>
    <note type="warning"><title>Compression et TLS</title>
        <p>Certaines applications web sont vulnérables à une attaque de type vol
	d'informations lorsqu'une connexion TLS transmet des données
	compressées. Pour plus d'informations, étudiez en détail la famille
	d'attaques "BREACH".</p>
    </note>
    <p>Voici une configuration simple qui compresse des types de contenus
    courants au format texte :</p>

    <example><title>Compression de certains types seulement</title>
    <highlight language="config">
AddOutputFilterByType BROTLI_COMPRESS text/html text/plain text/xml text/css text/javascript application/javascript
    </highlight>
    </example>

</section>

<section id="enable"><title>Activation de la compression</title>
    <note type="warning"><title>Compression et TLS</title>
        <p>Certaines applications web sont vulnérables à une attaque de type vol
	d'informations lorsqu'une connexion TLS transmet des données
	compressées. Pour plus d'informations, étudiez en détail la famille
	d'attaques "BREACH".</p>
    </note>

    <section id="output"><title>Compression en sortie</title>
      <p>La compression est implémentée par le <a
      href="../filter.html">filtre</a> <code>BROTLI_COMPRESS</code>. La
      directive suivante active la compression pour les documents correspondant
      au conteneur dans lequel elle est placée :</p>

      <highlight language="config">
SetOutputFilter BROTLI_COMPRESS
SetEnvIfNoCase Request_URI \.(?:gif|jpe?g|png)$ no-brotli
      </highlight>

      <p>Si vous voulez restreindre la compression à certains types MIME
      particuliers, vous pouvez utiliser la directive <directive
      module="mod_filter">AddOutputFilterByType</directive>. Dans l'exemple
      suivant, l'activation de la compression est restreinte aux fichiers html
      de la documentation d'Apache :</p>

      <highlight language="config">
&lt;Directory "/your-server-root/manual"&gt;
    AddOutputFilterByType BROTLI_COMPRESS text/html
&lt;/Directory&gt;
      </highlight>

      <note><title>Note</title>
        Le filtre <code>BROTLI_COMPRESS</code> est toujours inséré après les
	filtres RESOURCE comme PHP ou SSI. Il n'affecte jamais les sous-requêtes
	internes.
      </note>
      <note><title>Note</title>
        Définie via <directive module="mod_env">SetEnv</directive>, la variable
	d'environnement <code>no-brotli</code> permet de désactiver la
	compression brotli pour une requête particulière, et ceci même si elle
	est supportée par le client.
      </note>

    </section>

</section>

<section id="proxies"><title>Interaction avec les serveurs mandataires</title>

    <p>Le module <module>mod_brotli</module> envoie un en-tête de réponse HTTP
    <code>Vary:Accept-Encoding</code> pour indiquer aux mandataires qu'une
    réponse mise en cache ne doit être envoyée qu'aux clients qui envoient
    l'en-tête de requête <code>Accept-Encoding</code> approprié. Ceci permet
    d'éviter d'envoyer du contenu compressé à un client qui ne sera pas en
    mesure de le décompresser.</p>

    <p>Si vous utilisez des exclusions spéciales dépendant, par exemple, de
    l'en-tête <code>User-Agent</code>, vous devez faire un ajout manuel à
    l'en-tête <code>Vary</code> afin d'informer les mandataires des restrictions
    supplémentaires. Par exemple, dans une configuration typique où l'addition
    du filtre <code>BROTLI_COMPRESS</code> dépend de l'en-tête <code>User-Agent</code>,
    vous devez ajouter :</p>

    <highlight language="config">
Header append Vary User-Agent
    </highlight>

    <p>Si votre décision d'utiliser la compression ou non dépend d'autres
    informations que le contenu d'en-têtes de requêtes (par exemple la version
    HTTP), vous devez affecter la valeur <code>*</code> à l'en-tête
    <code>Vary</code>. Ceci permet d'éviter que des mandataires qui le
    supportent n'effectuent une mise en cache intégrale.</p>

    <example><title>Exemple</title>
    <highlight language="config">
Header set Vary *
    </highlight>
    </example>
</section>

<section id="precompressed"><title>Servir un contenu pré-compressé</title>

    <p>comme <module>mod_brotli</module> compresse systématiquement un contenu
    pour chaque requête le concernant, il est possible d'obtenir un gain en
    performance en pré-compressant le contenu et en disant à mod_brotli de le
    servir sans le recompresser. Pour cela, vous pouvez utiliser une
    configuration du style :</p>

    <highlight language="config">
&lt;IfModule mod_headers.c&gt;
    # Sert des fichiers CSS compressés par brotli, s'ils existent
    # et si le client supporte brotli.
    RewriteCond "%{HTTP:Accept-encoding}" "br"
    RewriteCond "%{REQUEST_FILENAME}\.br" "-s"
    RewriteRule "^(.*)\.css"              "$1\.css\.br" [QSA]

    # Sert des fichiers JS compressés par brotli, s'ils existent
    # et si le client supporte brotli.
    RewriteCond "%{HTTP:Accept-encoding}" "br"
    RewriteCond "%{REQUEST_FILENAME}\.br" "-s"
    RewriteRule "^(.*)\.js"               "$1\.js\.br" [QSA]


    # Sert des types de contenu corrects, et évite la double compression.
    RewriteRule "\.css\.gz$" "-" [T=text/css,E=no-brotli:1]
    RewriteRule "\.js\.gz$"  "-" [T=text/javascript,E=no-brotli:1]


    &lt;FilesMatch "(\.js\.br|\.css\.br)$"&gt;
      # Sert un type d'encodage correct.
      Header append Content-Encoding br

      # Force les mandataires à mettre en cache séparément les fichiers css/js
      # compressés ou non par brotli.
      Header append Vary Accept-Encoding
    &lt;/FilesMatch&gt;
&lt;/IfModule&gt;
    </highlight>

</section>

<directivesynopsis>
<name>BrotliFilterNote</name>
<description>Enregistre le taux de compression dans une note à des fins de
journalisation</description>
<syntax>BrotliFilterNote [<var>type</var>] <var>notename</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>BrotliFilterNote</directive> permet d'indiquer
    qu'une note à propos du taux de compression doit être attachée à la
    requête. L'argument <var>notename</var> permet de spécifier le nom de la
    note. Vous pouvez utiliser cette note à des fins de statistiques en ajoutant
    l'information correspondante à votre <a href="../logs.html#accesslog">access
    log</a>.</p>

    <example><title>Exemple</title>
    <highlight language="config">
BrotliFilterNote ratio

LogFormat '"%r" %b (%{ratio}n) "%{User-agent}i"' brotli
CustomLog "logs/brotli_log" brotli
    </highlight>
    </example>

    <p>Si vous souhaitez que l'information enregistrée dans vos journaux soit
    plus pertinente, vous pouvez renseigner l'argument optionnel <var>type</var>
    afin de spécifier le type de données à enregistrer dans la note à
    journaliser. L'argument <var>type</var> accepte les valeurs suivantes :</p>

    <dl>
      <dt><code>Input</code></dt>
      <dd>Enregistre dans la note le nombre d'octets contenus dans le flux
      d'entrée du filtre.</dd>

      <dt><code>Output</code></dt>
      <dd>Enregistre dans la note le nombre d'octets contenus dans le flux
      de sortie du filtre.</dd>

      <dt><code>Ratio</code></dt>
      <dd>Enregistre dans la note le taux de compression (<code>output/input *
      100</code>). Il s'agit de l'option par défaut si l'argument
      <var>type</var> est omis.</dd>
    </dl>

    <p>Vous pouvez alors configurer vos journaux de la manière suivante :</p>

    <example><title>Journalisation spécifique</title>
    <highlight language="config">
BrotliFilterNote Input instream
BrotliFilterNote Output outstream
BrotliFilterNote Ratio ratio

LogFormat '"%r" %{outstream}n/%{instream}n (%{ratio}n%%)' brotli
CustomLog "logs/brotli_log" brotli
    </highlight>
    </example>
</usage>
<seealso><module>mod_log_config</module></seealso>
</directivesynopsis>

<directivesynopsis>
<name>BrotliCompressionQuality</name>
<description>Qualité de la compression</description>
<syntax>BrotliCompressionQuality <var>value</var></syntax>
<default>BrotliCompressionQuality 5</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>BrotliCompressionQuality</directive> permet de
    spécifier la qualité de la compression (une valeur entre 0 et
    11). Les valeurs les plus hautes correspondent à une compression de
    meilleure qualité mais plus lente.
  </p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>BrotliCompressionWindow</name>
<description>Taille de la fenêtre de compression glissante brotli</description>
<syntax>BrotliCompressionWindow <var>value</var></syntax>
<default>BrotliCompressionWindow 18</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>BrotliCompressionWindow</directive> permet de
    spécifier la taille de la fenêtre de compression glissante brotli (une
    valeur comprise entre 10 et 24). Une taille de fenêtre plus grande peut
    améliorer la qualité de la compression mais consomme d'avantage de mémoire.</p>
</usage>
</directivesynopsis>

<directivesynopsis>

<name>BrotliCompressionMaxInputBlock</name>
<description>Taille maximale du bloc de données en entrée</description>
<syntax>BrotliCompressionMaxInputBlock <var>value</var></syntax>
<default>(automatic)</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>BrotliCompressionMaxInputBlock</directive> permet
    de spécifier la taille maximale du bloc de données en entrée entre 16 et 24,
    sachant que plus cette taille sera grande, plus grande sera la quantité de
    mémoire consommée.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>BrotliAlterETag</name>
<description>Comment l'en-tête de réponse ETag doit être modifié au cours de la
compression</description>
<syntax>BrotliAlterETag AddSuffix|NoChange|Remove</syntax>
<default>BrotliAlterETag AddSuffix</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>BrotliAlterETag</directive> permet d'indiquer
    comment l'en-tête ETag doit être modifié lorsqu'une réponse est compressée.</p>
    <dl>
    <dt>AddSuffix</dt>
    <dd><p>Ajoute la méthode de compression à la fin de l'en-tête ETag, ce qui
    implique que les représentations compressées et non compressées possèderont
    des en-têtes ETag uniques. C'est le comportement par défaut depuis la
    version 2.4.0 avec un autre module de compression dynamique,
    mod-deflate. Ce paramètre permet d'éviter l'envoi de messages
    "HTTP Not Modified" (304) en réponse aux requêtes conditionnelles pour des
    contenus compressés.</p></dd>
    <dt>NoChange</dt>
    <dd><p>Ne modifie pas l'en-tête ETag d'une réponse compressée. C'était le
    comportement par défaut avant la version 2.4.0 avec un autre module de
    compression dynamique, mod-deflate. Ce paramètre ne respecte pas la
    propriété HTTP/1.1 selon laquelle toutes les représentations d'une même
    ressource ont des en-têtes ETag uniques.</p></dd>
    <dt>Remove</dt>
    <dd><p>Supprime l'en-tête ETag des réponses compressées, ce qui rend
    impossibles certaines requêtes conditionnelles, mais évite les inconvénients
    des options précédentes.</p></dd>
    </dl>
</usage>
</directivesynopsis>

</modulesynopsis>
