<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1851174 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_cache.xml.meta">

<name>mod_cache</name>
<description>Filtre de mise en cache HTTP conforme à la RFC 2616</description>
<status>Extension</status>
<sourcefile>mod_cache.c</sourcefile>
<identifier>cache_module</identifier>

<summary>
    <note type="warning">Ce module doit être utilisé avec précautions
    car lorsque la directive <directive
    module="mod_cache">CacheQuickHandler</directive> est définie à sa
    valeur par défaut <strong>on</strong>, les directives <directive
    module="mod_access_compat">Allow</directive> and <directive
    module="mod_access_compat">Deny</directive> sont court-circuitées. Vous
    ne devez donc pas activer la gestion rapide de la mise en cache pour
    un contenu auquel vous souhaitez limiter l'accès en fonction du nom
    d'hôte du client, de l'adresse IP ou d'une variable
    d'environnement.</note>

    <p><module>mod_cache</module> implémente un <strong>filtre de mise
    en cache de contenu HTTP</strong> conforme à la <a
    href="http://www.ietf.org/rfc/rfc2616.txt">RFC 2616</a>, avec
    support de la mise en cache des réponses dont le contenu a été
    négocié et comportant l'en-tête Vary.</p>

    <p>La mise en cache conforme à la RFC 2616 fournit un mécanisme
    permettant de vérifier si un contenu expiré ou dépassé est encore à
    jour, et peut apporter un gain de performances significatif si le
    serveur original supporte les <strong>requêtes
    conditionnelles</strong> en prenant en compte l'en-tête de requête
    HTTP <a
    href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.26">If-None-Match</a>.
    Le contenu n'est ainsi régénéré que lorsqu'il a été modifié, et non
    lorsqu'il a expiré.</p>

    <p>En tant que filtre, <module>mod_cache</module> peut être placé
    en face d'un contenu issu de tout gestionnaire, y compris
    <strong>des fichiers à accès séquentiel</strong> (servis depuis un
    disque lent mis en
    cache sur un gros disque), la sortie d'un <strong>script
    CGI</strong> ou d'un <strong>générateur de contenu
    dynamique</strong>, ou du contenu <strong>mandaté depuis un autre
    serveur</strong>.</p>

    <p>Dans la configuration par défaut, <module>mod_cache</module>
    place le filtre de mise en cache aussi loin que possible dans la
    pile de filtres, utilisant le <strong>gestionnaire rapide</strong>
    pour court-circuiter tout traitement par requête lors de l'envoi du
    contenu au client. Dans ce mode opératoire,
    <module>mod_cache</module> peut être considéré comme un serveur
    mandataire avec cache fixé en tête du serveur web, alors qu'il
    s'exécute dans ce même serveur web.</p>

    <p>Lorsque le gestionnaire rapide est désactivé via la directive
    <directive module="mod_cache">CacheQuickHandler</directive>, il
    devient possible d'insérer le filtre <strong>CACHE</strong> à un
    point de la pile de filtres choisi par l'administrateur. Ceci permet
    de mettre en cache un contenu avant que celui-ci ne soit
    personnalisé par le filtre <module>mod_include</module>, ou
    éventuellement compressé par le filtre <module>mod_deflate</module>.</p>

    <p>Dans le mode de fonctionnement normal, <module>mod_cache</module>
    peut être contrôlé par les en-têtes <a
    href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">Cache-Control</a>
    et <a
    href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.32">Pragma</a>
    envoyés par un client dans une requête, ou par un serveur dans une
    réponse. Dans des circonstances exceptionnelles,
    <module>mod_cache</module> peut cependant être configuré pour
    outrepasser ces en-têtes et forcer un comportement spécifique au
    site, bien qu'un tel comportement sera limité à ce cache seulement,
    et n'affectera pas les opérations des autres caches qui peuvent
    s'insérer entre le client et le serveur, et ce type de configuration
    ne doit donc être utiliser qu'en cas de nécessité absolue.</p>

    <p>La RFC 2616 permet au cache de renvoyer des données périmées
    pendant que l'entrée périmée correspondante est mise à jour depuis
    le serveur original, et <module>mod_cache</module> supporte cette
    fonctionnalité lorsque la directive <directive
    module="mod_cache">CacheLock</directive> est configurée en
    conséquence. De telles réponses comportent un en-tête HTTP <a
    href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.46">Warning</a>
    contenant un code de réponse 110. La RFC 2616 permet aussi au cache
    de renvoyer des données périmées lorsque la tentative de mise à jour
    des données périmées renvoie une erreur 500 ou supérieure, et cette
    fonctionnalité est supportée par défaut par
    <module>mod_cache</module>. De telles réponses comportent un en-tête HTTP <a
    href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.46">Warning</a>
    contenant un code de réponse 111.</p>

    <p><module>mod_cache</module> requiert les services d'un ou
    plusieurs modules de gestion de stockage. La distribution Apache de base
    inclut les modules de gestion de stockage suivants :</p>
    <dl>
    <dt><module>mod_cache_disk</module></dt>

    <dd>implémente un gestionnaire de stockage sur disque. Les en-têtes
    et corps sont stockés séparément sur le disque dans une structure de
    répertoires basée sur le condensé md5 de l'URL mise en cache.
    Plusieurs réponses à contenu négocié peuvent être stockées en même
    temps, mais la mise en cache de contenus partiels n'est pas
    supportée par ce module. L'utilitaire
    <program>htcacheclean</program> permet de lister et de supprimer les
    URLs mises en cache, et de maintenir le cache en deçà de
    certaines limites de taille et de nombre d'inodes.</dd>
    <dt><module>mod_cache_socache</module></dt>
    <dd>Implémente un gestionnaire de stockage basé sur un cache d'objets
    partagés. Les en-têtes et corps sont stockés ensemble sous une seule
    clé basée sur l'URL de la réponse mise en cache. Des réponses à
    contenus multiples négociés peuvent être stockées simultanément, mais
    ce module ne supporte pas la mise en cache de contenus partiels.</dd>
    </dl>

    <p>Pour de plus amples détails, une description, et des exemples,
    reportez-vous au <a href="../caching.html">Guide de la mise en
    cache</a>.</p>
</summary>
<seealso><a href="../caching.html">Guide de la mise en
cache</a></seealso>

<section id="related"><title>Modules apparentés et directives</title>
    <related>
      <modulelist>
        <module>mod_cache_socache</module>
      </modulelist>
      <directivelist>
        <directive module="mod_cache_disk">CacheRoot</directive>
        <directive module="mod_cache_disk">CacheDirLevels</directive>
        <directive module="mod_cache_disk">CacheDirLength</directive>
        <directive module="mod_cache_disk">CacheMinFileSize</directive>
        <directive module="mod_cache_disk">CacheMaxFileSize</directive>
	<directive module="mod_cache_socache">CacheSocache</directive>
        <directive module="mod_cache_socache">CacheSocacheMaxTime</directive>
        <directive module="mod_cache_socache">CacheSocacheMinTime</directive>
        <directive module="mod_cache_socache">CacheSocacheMaxSize</directive>
        <directive module="mod_cache_socache">CacheSocacheReadSize</directive>
        <directive module="mod_cache_socache">CacheSocacheReadTime</directive>
      </directivelist>
    </related>
</section>

<section id="sampleconf"><title>Exemple de configuration</title>
    <example><title>Extrait de httpd.conf</title>
      <highlight language="config">
#
# Exemple de configuration du cache
#
LoadModule cache_module modules/mod_cache.so
&lt;IfModule mod_cache.c&gt;
    LoadModule cache_disk_module modules/mod_cache_disk.so
    &lt;IfModule mod_cache_disk.c&gt;
        CacheRoot "c:/cacheroot"
        CacheEnable disk  "/"
        CacheDirLevels 5
        CacheDirLength 3
    &lt;/IfModule&gt;
    
    # Lorsqu'on sert de mandataire, on ne met pas en cache la liste
# des mises à jour de sécurité
    CacheDisable "http://security.update.server/update-list/"
&lt;/IfModule&gt;
      </highlight>
    </example>
</section>

<section id="thunderingherd"><title>Eviter une tempête de requête</title>
  <p>Lorsqu'une entrée du cache est périmée, <module>mod_cache</module>
  soumet une requête conditionnelle au processus d'arrière-plan, qui est
  censé confirmer la validité de l'entrée du cache, ou dans la négative
  envoyer une entrée mise à jour.</p>
  <p>Un court mais non négligeable laps de temps existe entre le moment
  où l'entrée du cache est périmée, et le moment où elle est mise à
  jour. Sur un serveur fortement chargé, un certain nombre de requêtes
  peut arriver pendant ce laps de temps, et provoquer une
  <strong>tempête</strong> de requêtes susceptibles de saturer le
  processus d'arrière-plan de manière soudaine et imprédictible.</p>
  <p>Pour contenir cette tempête, on peut utiliser la directive <directive
  module="mod_cache">CacheLock</directive> afin de définir un répertoire où
  seront créés <strong>à la volée</strong> des verrous pour les URLs.  Ces
  verrous sont utilisés comme autant d'<strong>indications</strong> par les
  autres requêtes, soit pour empêcher une tentative de mise en cache (un autre
  processus est en train de récupérer l'entité), soit pour indiquer qu'une
  entrée périmée est en cours de mise à jour (pendant ce temps, c'est le contenu
  périmé qui sera renvoyé).
  </p>
  <section>
    <title>Mise en cache initiale d'une entrée</title>
    <p>Lorsqu'une entité est mise en cache pour la première fois, un
    verrou est créé pour cette entité jusqu'à ce que la réponse ait été
    entièrement mise en cache. Pendant la durée de vie du verrou, le
    cache va empêcher une seconde tentative de mise en cache de la même
    entité. Bien que cela ne suffise pas à contenir la tempête de
    requêtes, toute tentative de mettre en cache la même entité
    plusieurs fois simultanément est stoppée.
    </p>
  </section>
  <section>
    <title>Mise à jour d'une entrée périmée</title>
    <p>Lorsqu'une entrée atteint la limite de sa durée de vie, et
    devient par conséquent périmée, un verrou est créé pour cette entité
    jusqu'à ce que la réponse ait été soit confirmée comme encore
    valide, soit remplacée par le processus d'arrière-plan. Pendant la
    durée de vie du verrou, une seconde requête entrante va provoquer le
    renvoi de la donnée périmée, et la tempête de requêtes sera
    contenue.</p>
  </section>
  <section>
    <title>Verrous et en-tête Cache-Control: no-cache</title>
    <p>Les verrous ne sont utilisés <strong>qu'à titre
    indicatif</strong> pour enjoindre le cache à être plus coopératif
    avec les serveurs d'arrière-plan, et il est possible de passer outre
    si nécessaire. Si le client envoie une requête contenant un en-tête
    Cache-Control imposant un nouveau téléchargement de l'entité, tout
    verrou éventuel sera ignoré, la requête du client sera honorée
    immédiatement, et l'entrée du cache mise à jour.</p>

    <p>Comme mécanisme de sécurité supplémentaire, la durée de vie maximale des
    verrous est configurable. Lorsque cette limite est atteinte, le verrou est
    supprimé et une autre requête peut alors en créer un nouveau. Cette durée de
    vie peut être définie via la directive <directive
    module="mod_cache">CacheMaxExpire</directive>, et sa valeur par défaut est
    de 5 secondes.
    </p>
  </section>
  <section>
    <title>Exemple de configuration</title>
    <example><title>Activation du verrouillage du cache</title>
      <highlight language="config">
#
# Active le verrouillage du cache
#
&lt;IfModule mod_cache.c&gt;
    CacheLock on
    CacheLockPath "/tmp/mod_cache-lock"
    CacheLockMaxAge 5
&lt;/IfModule&gt;
      </highlight>
    </example>
  </section>
</section>

<section id="finecontrol"><title>Contrôle fin via le filtre CACHE</title>
  <p>Dans son mode de fonctionnement par défaut, le cache s'exécute sous
  la forme d'un gestionnaire rapide, court-circuitant la majorité des
  traitements du serveur et fournissant ainsi une mise en cache
  possédant les plus hautes performances disponibles.</p>

  <p>Dans ce mode, le cache <strong>s'incruste</strong> devant le
  serveur, comme si un mandataire de mise en cache indépendant RFC 2616
  était placé devant ce dernier.</p>

  <p>Bien que que ce mode offre les meilleures performances, les
  administrateurs peuvent souhaiter, dans certaines circonstances,
  effectuer des traitements sur la requête après que cette dernière ait
  été mise en cache, comme ajouter du contenu personnalisé à la page
  mise en cache, ou appliquer des restrictions d'autorisations au
  contenu. Pour y parvenir, l'administrateur sera alors souvent forcé de
  placer des serveurs mandataires inverses indépendants soit derrière,
  soit devant le serveur de mise en cache.</p>

  <p>Pour résoudre ce problème, la directive <directive
  module="mod_cache">CacheQuickHandler</directive> peut être définie à
  <strong>off</strong>, afin que le serveur traite toutes les phases
  normalement exécutées par une requête non mise en cache, y compris les
  phases <strong>d'authentification et d'autorisation</strong>.</p>

  <p>En outre, l'administrateur peut éventuellement spécifier le
  <strong>point précis dans la chaîne de filtrage</strong> où devra
  intervenir la mise en cache en ajoutant le filtre
  <strong>CACHE</strong> à la chaîne de filtrage en sortie.</p>

  <p>Par exemple, pour mettre en cache le contenu avant d'appliquer une
  compression à la réponse, placez le filtre <strong>CACHE</strong>
  avant le filtre <strong>DEFLATE</strong> comme dans l'exemple suivant
  :</p>

  <highlight language="config">
# Mise en cache du contenu avant la compression optionnelle
CacheQuickHandler off
AddOutputFilterByType CACHE;DEFLATE text/plain
  </highlight>

  <p>Une autre possibilité consiste à mettre en cache le contenu avant
  l'ajout de contenu personnalisé via <module>mod_include</module> (ou
  tout autre filtre de traitement de contenu). Dans l'exemple suivant,
  les modèles contenant des balises comprises par
  <module>mod_include</module> sont mis en cache avant d'être
  interprétés :</p>

  <highlight language="config">
# Mise en cache du contenu avant l'intervention de mod_include et
   # mod_deflate
CacheQuickHandler off
AddOutputFilterByType CACHE;INCLUDES;DEFLATE text/html
  </highlight>

  <p>Vous pouvez insérer le filtre <strong>CACHE</strong> en tout point
  de la chaîne de filtrage. Dans l'exemple suivant, le contenu est mis
  en cache après avoir été interprété par <module>mod_include</module>,
  mais avant d'être traité par <module>mod_deflate</module> :</p>

  <highlight language="config">
# Mise en cache du contenu entre les interventions de mod_include et
   # mod_deflate
CacheQuickHandler off
AddOutputFilterByType INCLUDES;CACHE;DEFLATE text/html
  </highlight>

  <note type="warning"><title>Avertissement :</title>Si pour une raison
  ou pour une autre, le point d'insertion du filtre
  <strong>CACHE</strong> dans la chaîne de filtrage est modifié, vous
  devez <strong>vider votre cache</strong> pour être sûr que les données
  servies soient à jour. En effet, <module>mod_cache</module> n'est pas
  en mesure d'effectuer cette opération à votre place.</note>

</section>

<section id="status"><title>Etat du cache et journalisation</title>
  <p>Lorsque <module>mod_cache</module> a décidé s'il devait ou non
  servir une entité depuis le cache, les raisons précises de cette
  décision sont enregistrées dans l'environnement du sous-processus
  interne à la requête sous la clé <strong>cache-status</strong>.
  Cette information peut être journalisée via la directive <directive
  module="mod_log_config">LogFormat</directive> comme suit :</p>

  <highlight language="config">
    LogFormat "%{cache-status}e ..."
  </highlight>

  <p>En fonction de la décision prise, l'information est aussi écrite
  dans l'environnement du sous-processus sous une des quatre clés
  suivantes :</p>

  <dl>
    <dt>cache-hit</dt><dd>Le contenu a été servi depuis le cache.</dd>
    <dt>cache-revalidate</dt><dd>Le contenu du cache était périmé, a été
    mis à jour avec succès, puis servi depuis le cache.</dd>
    <dt>cache-miss</dt><dd>Le contenu n'était pas dans le cache et a été
    servi directement depuis le serveur demandé.</dd>
    <dt>cache-invalidate</dt><dd>L'entité du cache est devenue invalide
    suite à une requête d'un type autre que GET ou HEAD.</dd>
  </dl>

  <p>Il est alors possible d'envisager une journalisation conditionnelle
  du traitement des requêtes par rapport au cache comme dans l'exemple
  suivant :</p>

  <highlight language="config">
CustomLog "cached-requests.log" common env=cache-hit
CustomLog "uncached-requests.log" common env=cache-miss
CustomLog "revalidated-requests.log" common env=cache-revalidate
CustomLog "invalidated-requests.log" common env=cache-invalidate
  </highlight>

  <p>Pour les concepteurs de modules, une accroche (hook) nommée
  <var>cache_status</var> est disponible et permet aux modules de
  répondre aux résultats de la vérification du cache ci-dessus de manière
  personnalisée.</p>

</section>

<directivesynopsis>
<name>CacheEnable</name>
<description>Active la mise en cache des URLs spécifiées en utilisant le
gestionnaire de stockage précisé</description>
<syntax>CacheEnable <var>type de cache</var> [<var>chaîne
URL</var>]</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>
<compatibility>Une chaîne URL telle que '/' s'appliquait à tout contenu
en mandat direct dans les versions 2.2 et antérieures.</compatibility>

<usage>
    <p>La directive <directive>CacheEnable</directive> enjoint
    <module>mod_cache</module> de mettre en cache l'URL précisée par
    <var>chaîne URL</var>, ainsi que les URLs de niveaux inférieurs. Le
    gestionnaire de stockage du cache est spécifié à l'aide de l'argument
    <var>type de cache</var>. La directive <directive>CacheEnable</directive>
    peut être placée à l'intérieur d'une section <directive type="section"
    module="core">Location</directive> ou <directive type="section"
    module="core">LocationMatch</directive> pour indiquer que le contenu
    considéré peut être mis en cache. Si <var>type de cache</var> a pour valeur
    <code>disk</code>, <module>mod_cache</module> utilisera le gestionnaire de
    stockage sur disque implémenté par
    <module>mod_cache_disk</module>. Pour que <module>mod_cache</module>
    utilise le gestionnaire de stockage basé sur le cache d'objets
    partagés implémenté par <module>mod_cache_socache</module>,
    spécifiez <code>socache</code> comme valeur du paramètre <var>type
    de cache</var>.</p>
    <p>Si les différentes directives <directive>CacheEnable</directive>
    spécifient des URLs qui se recoupent (comme dans l'exemple
    ci-dessous), tous les gestionnaires de stockage possibles seront
    lancés, jusqu'au premier d'entre eux qui traitera effectivement la
    requête.
    L'ordre dans lequel les gestionnaires de stockage sont lancés est déterminé
    par l'ordre dans lequel apparaissent les directives
    <directive>CacheEnable</directive> dans le fichier de configuration. Les
    directives <directive>CacheEnable</directive> situées à l'intérieur de
    sections <directive type="section" module="core">Location</directive> ou
    <directive type="section" module="core">LocationMatch</directive> sont
    traitées avant les directives <directive>CacheEnable</directive> définies au
    niveau global.</p>

    <p>En fonctionnement du type serveur mandataire direct, <var>chaîne
    URL</var> doit au moins débuter par un protocole pour lequel la mise
    en cache doit être activée.</p>

    <highlight language="config">
# Mise en cache de contenu (gestionnaire normal seulement)
CacheQuickHandler off
&lt;Location "/foo"&gt;
    CacheEnable disk
&lt;/Location&gt;

# Mise en cache via une expression rationnelle (gestionnaire normal seulement)
CacheQuickHandler off
&lt;LocationMatch "foo$"&gt;
    CacheEnable disk
&lt;/LocationMatch&gt;

# Mise en cache de tous les contenus, à l'exception des URLs
# mandatées en direct (gestionnaire normal ou rapide)
CacheEnable  disk  /

# Mise en cache des URLs FTP mandatées (gestionnaire normal ou rapide)
CacheEnable  disk  ftp://

# Mise en cache des contenus mandatés en direct depuis www.example.org (gestionnaire normal ou rapide)
CacheEnable  disk  http://www.example.org/
    </highlight>

    <p>Un nom d'hôte commençant par un caractère <strong>"*"</strong>
    correspondra à tout nom d'hôte se terminant par le suffixe
    considéré. Un nom d'hôte commençant par un caractère
    <strong>"."</strong> correspondra à tout nom d'hôte contenant le
    composant de nom de domaine qui suit ce caractère.</p>

    <highlight language="config">
# Correspond à www.example.org et fooexample.org
CacheEnable  disk  "http://*example.org/"
# Correspond à www.example.org, mais pas à fooexample.org
CacheEnable  disk  "http://.example.org/"
    </highlight>

    <p>Depuis la version 2.2.12, on peut définir la variable
    d'environnement <code>no-cache</code> pour une définition plus fine
    des ressources à mettre en cache.</p>

</usage>
<seealso><a href="../env.html">Les variables d'environnement dans
Apache</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>CacheDisable</name>
<description>Désactive la mise en cache des URLs
spécifiées</description>
<syntax>CacheDisable <var>chaîne-url</var> | <var>on</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>CacheDisable</directive> enjoint
    <module>mod_cache</module> de <em>ne pas</em> mettre en cache l'URL
    spécifiée par <var>chaîne URL</var>, ainsi que les URLs de niveaux
    inférieurs.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      CacheDisable "/fichiers_locaux"
      </highlight>
    </example>

    <p>Si la directive se trouve à l'intérieur d'une section <directive
    type="section" module="core">Location</directive>, le chemin doit être
    spécifié en dessous de la Location, et si le mot "on" est utilisé, la mise
    en cache sera désactivée pour l'ensemble de l'arborescence concernée par la
    section Location.</p>

    <example><title>Exemple</title>
      <highlight language="config">
&lt;Location "/foo"&gt;
    CacheDisable on
&lt;/Location&gt;
      </highlight>
    </example>

    <p>Avec les versions 2.2.12 et ultérieures, on peut définir la
    variable d'environnement <code>no-cache</code> pour une définition
    plus fine des ressources à mettre en cache.</p>
</usage>
<seealso><a href="../env.html">Les variables d'environnement dans
Apache</a></seealso>
</directivesynopsis>
<directivesynopsis>
<name>CacheMaxExpire</name>
<description>La durée maximale en secondes de mise en cache d'un
document</description>
<syntax>CacheMaxExpire <var>secondes</var></syntax>
<default>CacheMaxExpire 86400 (une journée)</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>CacheMaxExpire</directive> permet de
    spécifier le nombre maximum de secondes pendant lequel les documents
    HTTP suceptibles d'être mis en cache seront conservés sans vérifier
    leur contenu sur le serveur d'origine. Ce nombre de secondes
    correspond donc à la durée maximale pendant laquelle un document ne
    sera pas à jour. L'utilisation de cette valeur maximale est forcée,
    même si le document possède une date d'expiration.</p>

    <highlight language="config">
      CacheMaxExpire 604800
      </highlight>
    
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheMinExpire</name>
<description>La durée minimale en secondes de mise en cache d'un
document</description>
<syntax>CacheMinExpire <var>secondes</var></syntax>
<default>CacheMinExpire 0</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>CacheMinExpire</directive> permet de
    spécifier le nombre minimum de secondes pendant lequel les documents
    HTTP susceptibles d'être mis en cache seront conservés sans vérifier
    leur contenu sur le serveur d'origine. Elle n'est prise en compte
    que dans le cas où le document ne possède aucune date d'expiration
    valide.</p>

    <highlight language="config">
      CacheMinExpire 3600
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheDefaultExpire</name>
<description>La durée par défaut de mise en cache d'un document
lorsqu'aucune date d'expiration n'a été spécifiée.</description>
<syntax>CacheDefaultExpire <var>secondes</var></syntax>
<default>CacheDefaultExpire 3600 (une heure)</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>CacheDefaultExpire</directive> permet de
    spécifier un temps par défaut, en secondes, pendant lequel sera conservé
    dans le cache un document qui ne possède ni date d'expiration, ni date de
    dernière modification. La valeur de cette directive n'est <em>pas</em>
    écrasée par la valeur de la directive <directive
    module="mod_cache">CacheMaxExpire</directive>, même si cette dernière est
    utilisée.</p>

    <highlight language="config">
      CacheDefaultExpire 86400
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheIgnoreNoLastMod</name>
<description>Ignore le fait qu'une réponse ne possède pas d'en-tête Last
Modified.</description>
<syntax>CacheIgnoreNoLastMod On|Off</syntax>
<default>CacheIgnoreNoLastMod Off</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>

<usage>
    <p>Normalement, les documents qui ne possèdent pas de date de
    dernière modification ne sont pas mis en cache. Dans certaines
    circonstances, la date de dernière modification est supprimée (au
    cours des traitements liés à <module>mod_include</module> par
    exemple), ou n'existe tout simplement pas. La directive
    <directive>CacheIgnoreNoLastMod</directive> permet de spécifier si
    les documents ne possèdant pas de date de dernière modification doivent être
    mis en cache, même sans date de dernière modification.  Si le document ne
    possède ni date d'expiration, ni date de dernière modification, la valeur
    spécifiée par la directive <directive
    module="mod_cache">CacheDefaultExpire</directive> servira à générer une date
    d'expiration.
    </p>

    <highlight language="config">
      CacheIgnoreNoLastMod On
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheIgnoreCacheControl</name>
<description>Ignore les en-têtes de requête enjoignant de ne pas servir
le contenu au client depuis le cache</description>
<syntax>CacheIgnoreCacheControl On|Off</syntax>
<default>CacheIgnoreCacheControl Off</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Normalement, les requêtes contenant des en-têtes tels que
    <code>Cache-Control: no-cache</code> ou Pragma: no-cache ne sont pas 
    servies depuis le cache. La directive
    <directive>CacheIgnoreCacheControl</directive> permet de modifier ce
    comportement. Avec <directive>CacheIgnoreCacheControl
    On</directive>, le serveur tentera de servir la ressource depuis le
    cache, même si la requête contient un des en-têtes cités plus haut.
    Les ressources qui requièrent une autorisation ne seront
    <em>jamais</em> mises en cache.</p>

    <highlight language="config">
      CacheIgnoreCacheControl On
    </highlight>

    <note type="warning"><title>Avertissement :</title>
       Cette directive permet de servir des ressources depuis le cache,
       même si le client a demandé à ce qu'il n'en soit pas ainsi. Le
       contenu servi est ainsi susceptible d'être périmé.
    </note>
</usage>
<seealso><directive module="mod_cache">CacheStorePrivate</directive></seealso>
<seealso><directive module="mod_cache">CacheStoreNoStore</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>CacheIgnoreQueryString</name>
<description>Ignore la chaîne de paramètres lors de la mise en
cache</description>
<syntax>CacheIgnoreQueryString On|Off</syntax>
<default>CacheIgnoreQueryString Off</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Normalement, les requêtes comportant une chaîne de paramètres
    sont mises en cache séparément si leurs chaînes de paramètres
    diffèrent.
    En accord avec la RFC 2616/13.9, cette mise en cache n'est effectuée
    séparément que si une date d'expiration est spécifiée. La directive
    <directive>CacheIgnoreQueryString</directive> permet la mise en
    cache de requêtes même si aucune date d'expiration est spécifiée, et
    de renvoyer une réponse depuis la cache même si les chaînes de
    paramètres diffèrent. Du point de vue du cache, la requête est
    traitée comme si elle ne possèdait pas de chaîne de paramètres
    lorsque cette directive est activée.</p>

    <highlight language="config">
      CacheIgnoreQueryString On
    </highlight>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheLastModifiedFactor</name>
<description>Le facteur utilisé pour générer une date d'expiration en
fonction de la date de dernière modification.</description>
<syntax>CacheLastModifiedFactor <var>flottant</var></syntax>
<default>CacheLastModifiedFactor 0.1</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>

<usage>
    <p>Si un document ne possède pas de date d'expiration, elle peut
    être calculée en fonction de la date de dernière modification, si
    elle existe. La directive
    <directive>CacheLastModifiedFactor</directive> permet de spécifier
    un <var>facteur</var> à utiliser pour la génération de cette date
    d'expiration au sein de la formule suivante :

    <code>délai-expiration = durée-depuis-date-dernière-modification *
    <var>facteur</var>
    date-expiration = date-courante + délai-expiration</code>

    Par exemple, si la dernière modification du document date de 10
    heures, et si <var>facteur</var> a pour valeur 0.1, le délai
    d'expiration sera de 10*0.1 = 1 heure. Si l'heure courante est
    3:00pm, la date d'expiration calculée sera 3:00pm + 1 heure =
    4:00pm.

    Si le délai d'expiration est supérieur à celui spécifié par la directive
    <directive module="mod_cache">CacheMaxExpire</directive>, c'est ce dernier
    qui l'emporte.</p>

    <highlight language="config">
      CacheLastModifiedFactor 0.5
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheIgnoreHeaders</name>
<description>Ne pas stocker le(s) en-tête(s) spécifié(s) dans le cache.
</description>
<syntax>CacheIgnoreHeaders <var>en-tête</var> [<var>en-tête</var>] ...</syntax>
<default>CacheIgnoreHeaders None</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>En accord avec la RFC 2616, les en-têtes HTTP hop-by-hop ne sont
    pas stockés dans le cache. Les en-têtes HTTP suivant sont des
    en-têtes hop-by-hop, et en tant que tels, ne sont en  <em>aucun</em>
    cas stockés dans le cache, quelle que soit la définition de la
    directive <directive>CacheIgnoreHeaders</directive> :</p>

    <ul>
      <li><code>Connection</code></li>
      <li><code>Keep-Alive</code></li>
      <li><code>Proxy-Authenticate</code></li>
      <li><code>Proxy-Authorization</code></li>
      <li><code>TE</code></li>
      <li><code>Trailers</code></li>
      <li><code>Transfer-Encoding</code></li>
      <li><code>Upgrade</code></li>
    </ul>

    <p>La directive <directive>CacheIgnoreHeaders</directive> permet de
    spécifier quels en-têtes HTTP ne doivent pas être stockés dans le
    cache. Par exemple, il peut s'avérer pertinent dans certains cas de
    ne pas stocker les cookies dans le cache.</p>

    <p>La directive <directive>CacheIgnoreHeaders</directive> accepte
    une liste d'en-têtes HTTP séparés par des espaces, qui ne doivent
    pas être stockés dans le cache. Si les en-têtes hop-by-hop sont les
    seuls à ne pas devoir être stockés dans le cache (le comportement
    compatible RFC 2616), la directive
    <directive>CacheIgnoreHeaders</directive> peut être définie à
    <code>None</code>.</p>

    <example><title>Exemple 1</title>
    <highlight language="config">
      CacheIgnoreHeaders Set-Cookie
      </highlight>
    </example>

    <example><title>Exemple 2</title>
    <highlight language="config">
      CacheIgnoreHeaders None
      </highlight>
    </example>

    <note type="warning"><title>Avertissement :</title>
      Si des en-têtes nécessaires à la bonne gestion du cache, comme
      <code>Expires</code>, ne sont pas stockés suite à la définition
      d'une directive <directive>CacheIgnoreHeaders</directive>, le
      comportement de mod_cache sera imprévisible.
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheIgnoreURLSessionIdentifiers</name>
<description>Ignore les identifiants de session définis encodés dans
l'URL lors de la mise en cache
</description>
<syntax>CacheIgnoreURLSessionIdentifiers <var>identifiant</var>
[<var>identifiant</var>] ...</syntax>
<default>CacheIgnoreURLSessionIdentifiers None</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Certaines applications encodent l'identifiant de session dans
    l'URL comme dans l'exemple suivant :
    </p>
    <ul>
      <li><code>/une-application/image.gif;jsessionid=123456789</code></li>
      <li><code>/une-application/image.gif?PHPSESSIONID=12345678</code></li>
    </ul>
    <p>Ceci implique la mise en cache des ressources séparément pour
    chaque session, ce qui n'est en général pas souhaité. La directive
    <directive>CacheIgnoreURLSessionIdentifiers</directive> permet de
    définir une liste d'identifiants qui seront supprimés de la clé
    utilisée pour identifier une entité dans le cache, de façon à ce que
    les ressources ne soient pas stockées séparément pour chaque
    session.
    </p>
    <p><code>CacheIgnoreURLSessionIdentifiers None</code> vide la liste
    des identifiants ignorés. Autrement, chaque identifiant spécifié est
    ajouté à la liste.</p>

    <example><title>Exemple 1</title>
    <highlight language="config">
      CacheIgnoreURLSessionIdentifiers jsessionid
      </highlight>
    </example>

    <example><title>Exemple 2</title>
    <highlight language="config">
      CacheIgnoreURLSessionIdentifiers None
      </highlight>
    </example>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheStoreExpired</name>
<description>Tente de mettre en cache les réponses que le serveur
considère comme arrivées à expiration</description>
<syntax>CacheStoreExpired On|Off</syntax>
<default>CacheStoreExpired Off</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>

<usage>
    <p>Depuis la version 2.2.4, les réponses qui sont arrivées à
    expiration ne sont pas stockées dans le cache. La directive
    <directive>CacheStoreExpired</directive> permet de modifier ce
    comportement. Avec <directive>CacheStoreExpired</directive> On, le
    serveur tente de mettre en cache la ressource si elle est périmée.
    Les requêtes suivantes vont déclencher une requête si-modifié-depuis
    de la part du serveur d'origine, et la réponse sera renvoyée à
    partir du cache si la ressource d'arrière-plan n'a pas été modifiée.</p>

    <highlight language="config">
      CacheStoreExpired On
      </highlight>
    
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheStorePrivate</name>
<description>Tente de mettre en cache des réponses que le serveur a
marquées comme privées</description>
<syntax>CacheStorePrivate On|Off</syntax>
<default>CacheStorePrivate Off</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>

<usage>
    <p>Normalement, les réponse comportant un en-tête <code>Cache-Control:
    private</code> ne seront pas stockées dans le cache. La directive
    <directive>CacheStorePrivate</directive> permet de modifier ce comportement.
    Si <directive>CacheStorePrivate</directive> est définie à On, le serveur
    tentera de mettre la ressource en cache, même si elle
    contient des en-têtes ayant pour valeur private. Les ressources
    nécessitant une autorisation ne sont <em>jamais</em> mises en
    cache.</p>

    
    <highlight language="config">
      CacheStorePrivate On
      </highlight>
    

    <note type="warning"><title>Avertissement :</title>
       Cette directive autorise la mise en cache même si le serveur
       indique que la ressource ne doit pas être mise en cache. Elle
       n'est de ce fait appropriée que dans le cas d'un cache
       'privé'.
    </note>
</usage>
<seealso><directive module="mod_cache">CacheIgnoreCacheControl</directive></seealso>
<seealso><directive module="mod_cache">CacheStoreNoStore</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>CacheStoreNoStore</name>
<description>Tente de mettre en cache les requêtes ou réponses dont
l'entête Cache-Control: a pour valeur no-store.</description>
<syntax>CacheStoreNoStore On|Off</syntax>
<default>CacheStoreNoStore Off</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>

<usage>
    <p>Normalement, les requêtes ou réponses dont l'en-tête
    <code>Cache-Control: no-store</code> ne sont pas stockées dans le
    cache. La directive <directive>CacheStoreNoStore</directive> permet
    de modifier ce comportement. Si
    <directive>CacheStoreNoStore</directive> est définie à On, le
    serveur tente de mettre la ressource en cache même si elle contient
    des en-têtes ayant pour valeur no-store. Les ressources
    nécessitant une autorisation ne sont <em>jamais</em> mises en
    cache.</p>

    
    <highlight language="config">
      CacheStoreNoStore On
      </highlight>
    

    <note type="warning"><title>Avertissement :</title>
       Selon la RFC 2616, la valeur d'en-tête no-store est censée
       "prévenir la suppression ou la rétention par inadvertance
       d'informations sensibles (par exemple, sur des bandes de
       sauvegarde)". Autrement dit, l'activation de la directive
       <directive>CacheStoreNoCache</directive> pourrait provoquer le
       stockage d'informations sensibles dans le cache. Vous avez donc
       été prévenus.
    </note>
</usage>
<seealso><directive module="mod_cache">CacheIgnoreCacheControl</directive></seealso>
<seealso><directive module="mod_cache">CacheStorePrivate</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>CacheLock</name>
<description>Active la protection contre les tempêtes de requêtes.</description>
<syntax>CacheLock <var>on|off</var></syntax>
<default>CacheLock off</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>
<compatibility>Disponible depuis la version 2.2.15 d'Apache</compatibility>

<usage>
  <p>La directive <directive>CacheLock</directive> active la protection
  contre les tempêtes de requêtes pour l'espace d'adressage donné.</p>

  <p>La configuration minimale pour activer le verrouillage contre les
  tempêtes de requêtes dans le répertoire temp par défaut du système est
  la suivante :</p>

  <highlight language="config">
# Active le verrouillage du cache
CacheLock on
  </highlight>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheLockPath</name>
<description>Définit le répertoire des verrous.</description>
<syntax>CacheLockPath <var>répertoire</var></syntax>
<default>CacheLockPath /tmp/mod_cache-lock</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
  <p>La directive <directive>CacheLockPath</directive> permet de
  spécifier le répertoire dans lequel les verrous sont créés. Par
  défaut, c'est le répertoire temporaire du système qui est utilisé. Les
  verrous sont des fichiers vides qui n'existent que pour les URLs
  périmées en cours de mise à jour, et consomment donc bien moins de
  ressources que le traditionnel cache sur disque.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheLockMaxAge</name>
<description>Définit la durée de vie maximale d'un verrou de cache.</description>
<syntax>CacheLockMaxAge <var>entier</var></syntax>
<default>CacheLockMaxAge 5</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
  <p>La directive <directive>CacheLockMaxAge</directive> permet de
  spécifier la durée de vie maximale d'un verrou de cache.</p>

  <p>Un verrou plus ancien que cette valeur exprimée en secondes sera
  ignoré, et la prochaine requête entrante sera alors en mesure de
  recréer le verrou. Ce mécanisme permet d'éviter les mises à jour trop
  longues initiées par des clients lents.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
  <name>CacheQuickHandler</name>
  <description>Exécute le cache à partir d'un gestionnaire rapide.</description>
  <syntax>CacheQuickHandler <var>on|off</var></syntax>
  <default>CacheQuickHandler on</default>
  <contextlist><context>server config</context><context>virtual host</context>
  </contextlist>
  <compatibility>Disponible à partir de la version 2.3.3 du serveur HTTP
  Apache</compatibility>

  <usage>
    <p>La directive <directive>CacheQuickHandler</directive> permet de contrôler
    la phase au cours de laquelle la mise en cache est effectuée.</p>

    <p>Avec la configuration par défaut, le cache agit au cours de la
    phase du gestionnaire rapide. Cette phase court-circuite la majorité
    des traitements du serveur, et constitue le mode d'opération le plus
    performant pour un serveur typique. Le cache
    <strong>s'incruste</strong> devant le serveur, et la majorité des
    traitements du serveur est court-circuitée.</p>

    <p>Lorsque cette directive est définie à off, le cache agit comme un
    gestionnaire normal, et est concerné par toutes les phases de
    traitement d'une requête. Bien que ce mode soit moins performant que
    le mode par défaut, il permet d'utiliser le cache dans les cas où un
    traitement complet de la requête est nécessaire, comme par exemple
    lorsque le contenu est soumis à autorisation.</p>

    <highlight language="config">
# Exécute le cache comme un gestionnaire normal
CacheQuickHandler off
    </highlight>

    <p>Lorsque le gestionnaire rapide est désactivé, l'administrateur a
    aussi la possibilité de choisir avec précision le point de la chaîne
    de filtrage où la mise en cache sera effectuée, en utilisant le
    filtre <strong>CACHE</strong>.</p>

    <highlight language="config">
# Mise en cache du contenu avant l'intervention de mod_include et
     # mod_deflate
CacheQuickHandler off
AddOutputFilterByType CACHE;INCLUDES;DEFLATE text/html
    </highlight>

    <p>Si le filtre CACHE est spécifié plusieurs fois, c'est la dernière
    instance qui sera prise en compte.</p>

  </usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheHeader</name>
<description>Ajoute un en-tête X-Cache à la réponse.</description>
<syntax>CacheHeader <var>on|off</var></syntax>
<default>CacheHeader off</default>
<contextlist><context>server config</context>
    <context>virtual host</context>
    <context>directory</context>
    <context>.htaccess</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.9 d'Apache</compatibility>

<usage>
  <p>Lorsque la directive <directive>CacheHeader</directive> est définie à on, un
  en-tête <strong>X-Cache</strong> est ajouté à la réponse et contient
  l'état du cache pour cette dernière. Si le gestionnaire normal est
  utilisé, cette directive peut se situer dans une section
  <directive type="section" module="core">Directory</directive> ou
  <directive type="section" module="core">Location</directive>. Si c'est
  le gestionnaire rapide qui est utilisé, elle doit se situer dans un
  contexte de serveur principal ou de serveur virtuel, sinon elle sera
  ignorée.</p>

  <dl>
    <dt><strong>HIT</strong></dt><dd>Le contenu était à jour et a été
    servi depuis le cache.</dd>
    <dt><strong>REVALIDATE</strong></dt><dd>Le contenu était périmé, a
    été mis à jour, puis a été servi depuis le cache.</dd>
    <dt><strong>MISS</strong></dt><dd>Le contenu n'a pas été servi
    depuis le cache, mais directement depuis le serveur demandé.</dd>
  </dl>

  <highlight language="config">
# Active l'en-tête X-Cache
CacheHeader on
  </highlight>

  <highlight language="config">
    X-Cache: HIT from localhost
  </highlight>
  

</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheDetailHeader</name>
<description>Ajoute un en-tête X-Cache-Detail à la réponse.</description>
<syntax>CacheDetailHeader <var>on|off</var></syntax>
<default>CacheDetailHeader off</default>
<contextlist><context>server config</context>
      <context>virtual host</context>
      <context>directory</context>
      <context>.htaccess</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.9 d'Apache</compatibility>

<usage>
  <p>Lorsque la directive <directive>CacheDetailHeader</directive> est définie à
  on, un en-tête <strong>X-Cache-Detail</strong> est ajouté à la réponse et
  contient les raisons précises d'une décision d'utilisation du cache vis à vis
  de cette dernière.</p>

  <p>Ceci peut s'avérer utile au cours du développement de services
  RESTful mis en cache pour obtenir des informations supplémentaires à
  propos des décisions vis à vis du cache écrites dans les en-têtes de
  la réponse. Il est ainsi possible de vérifier si
  <code>Cache-Control</code> et d'autres en-têtes ont été correctement
  utilisés par le service et le client.</p>

  <p>Si le gestionnaire normal est utilisé, cette directive peut se situer dans
  une section <directive type="section" module="core">Directory</directive> ou
  <directive type="section" module="core">Location</directive>. Si c'est le
  gestionnaire rapide qui est utilisé, elle doit se situer dans un contexte de
  serveur principal ou de serveur virtuel, sinon elle sera ignorée.</p>

  <highlight language="config">
# Active l'en-tête X-Cache-Detail
CacheDetailHeader on
  </highlight>

  <example>
    X-Cache-Detail: "conditional cache hit: entity refreshed" from localhost<br />
  </example>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheKeyBaseURL</name>
<description>Remplace l'URL de base des clés du cache mandatées en
inverse</description>
<syntax>CacheKeyBaseURL <var>URL</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.9 d'Apache</compatibility>

<usage>
  <p>Lorsque la directive <directive>CacheKeyBaseURL</directive> est utilisée,
  l'URL spécifiée sera utilisée comme URL de base pour calculer l'URL des clés
  du cache dans la configuration du mandataire inverse. Par défaut, c'est le
  protocole/nom d'hôte/port du serveur virtuel courant qui sera utilisé pour
  construire la clé de cache. Dans le cas d'un cluster de machines, si toutes
  les entrées du cache doivent posséder la même clé, cette directive permet de
  spécifier une nouvelle URL de base.</p>

  <highlight language="config">
# Remplace l'URL de base de la clé de cache.
CacheKeyBaseURL "http://www.example.com/"
  </highlight>

  <note type="warning">Prenez garde en définissant cette directive. Si
  deux serveurs virtuels distincts possèdent accidentellement la même
  URL de base, les entrées en provenance d'un serveur virtuel seront
  servies par l'autre.</note>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheStaleOnError</name>
<description>Sert du contenu non à jour à la place de réponses 5xx.</description>
<syntax>CacheStaleOnError <var>on|off</var></syntax>
<default>CacheStaleOnError on</default>
<contextlist><context>server config</context>
    <context>virtual host</context>
    <context>directory</context>
    <context>.htaccess</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.9 d'Apache</compatibility>

<usage>
  <p>Lorsque la directive <directive>CacheStaleOnError</directive> est définie à
  on, et si des données non mises à jour sont disponibles dans le cache, ce
  dernier renverra ces données, plutôt qu'une éventuelle réponse 5xx en
  provenance du serveur d'arrière-plan. Alors que l'en-tête Cache-Control envoyé
  par les clients sera respecté, et que les clients recevront donc dans ce cas
  la réponse 5xx brute à leur requête, cette réponse 5xx renvoyée au client
  n'invalidera pas le contenu dans le cache.</p>

  <highlight language="config">
# Sert des données non mises à jour en cas d'erreur.
CacheStaleOnError on
  </highlight>

</usage>
</directivesynopsis>

</modulesynopsis>
