<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1788722 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_cache_socache.xml.meta">

<name>mod_cache_socache</name>
<description>Module de stockage à base de cache d'objets partagés
(socache) pour le filtre de mise en cache HTTP.</description>
<status>Extension</status>
<sourcefile>mod_cache_socache.c</sourcefile>
<identifier>cache_socache_module</identifier>

<summary>
    <p>Le module <module>mod_cache_socache</module> implémente un
    gestionnaire de stockage à base de cache d'objets partagés (socache)
    pour le module <module>mod_cache</module>.</p>

    <p>Les en-têtes et corps des réponses mises en cache sont rassemblés
    et stockés sous une même clé dans le cache d'objets partagés. Il est
    possible de choisir entre plusieurs <a
    href="../socache.html">implémentations</a> de caches d'objets
    partagés.</p>

    <p>Des réponses avec différents contenus négociés peuvent être
    stockées simultanément ; cependant, la mise en cache de contenus
    partiels n'est pas encore supportée par ce module.</p>

    <highlight language="config">
# Activation de la mise en cache
CacheSocache shmcb
CacheSocacheMaxSize 102400
&lt;Location "/foo"&gt;
    CacheEnable socache
&lt;/Location&gt;

# Possibilité de se rabattre sur le cache disque
CacheSocache shmcb
CacheSocacheMaxSize 102400
&lt;Location "/foo"&gt;
    CacheEnable socache
    CacheEnable disk
&lt;/Location&gt;
    </highlight>

    <note><title>Note :</title>
      <p>Le module <module>mod_cache_socache</module> requiert les
      services du module <module>mod_cache</module> qui doit donc avoir
      été préalablement chargé.</p>
    </note>
</summary>
<seealso><module>mod_cache</module></seealso>
<seealso><module>mod_cache_disk</module></seealso>
<seealso><a href="../caching.html">Guide de la mise en cache</a></seealso>

<directivesynopsis>
<name>CacheSocache</name>
<description>Implémentation du cache d'objets partagés à utiliser</description>
<syntax>CacheSocache <var>type[:args]</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>
<compatibility>Disponible à partir de la version 2.4.5 du serveur HTTP
Apache</compatibility>

<usage>
    <p>La directive <directive>CacheSocache</directive>
    définit l'implémentation du cache d'objets partagés à utiliser,
    suivie d'arguments optionnels. Il est
    possible de choisir entre plusieurs <a
    href="../socache.html">implémentations</a> de caches d'objets
    partagés.</p>

    <highlight language="config">
      CacheSocache shmcb
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheSocacheMaxTime</name>
<description>La durée maximale de stockage d'un document dans le cache
avant péremption</description>
<syntax>CacheSocacheMaxTime <var>secondes</var></syntax>
<default>CacheSocacheMaxTime 86400</default>
<contextlist><context>server config</context>
  <context>virtual host</context>
  <context>directory</context>
  <context>.htaccess</context>
</contextlist>
<compatibility>Disponible à partir de la version 2.4.5 du serveur HTTP
Apache</compatibility>

<usage>
    <p>La directive <directive>CacheSocacheMaxTime</directive>
    définit la durée de stockage maximale en secondes d'un document dans
    le cache avant péremption. Cette définition l'emporte sur la durée
    de fraîcheur définie pour le document par le protocole HTTP.</p>

    <highlight language="config">
      CacheSocacheMaxTime 86400
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheSocacheMinTime</name>
<description>La durée minimale de stockage d'un document dans le cache</description>
<syntax>CacheSocacheMinTime <var>seconds</var></syntax>
<default>CacheSocacheMinTime 600</default>
<contextlist><context>server config</context>
  <context>virtual host</context>
  <context>directory</context>
  <context>.htaccess</context>
</contextlist>
<compatibility>Disponible à partir de la version 2.4.5 du serveur HTTP
Apache</compatibility>

<usage>
    <p>La directive <directive>CacheSocacheMinTime</directive>
    définit le nombre de secondes au delà de la durée de fraîcheur de la
    réponse pendant lesquelles cette dernière devra être stockée dans le
    cache d'objets partagés. En effet, si une réponse n'est stockée que
    pour une durée égale à sa durée de fraîcheur, elle n'a pas besoin
    d'être rafraîchie.</p>

    <highlight language="config">
      CacheSocacheMinTime 600
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheSocacheMaxSize</name>
<description>La taille maximale d'une entrée pouvant être placée dans le
cache</description>
<syntax>CacheSocacheMaxSize <var>octets</var></syntax>
<default>CacheSocacheMaxSize 102400</default>
<contextlist><context>server config</context>
  <context>virtual host</context>
  <context>directory</context>
  <context>.htaccess</context>
</contextlist>
<compatibility>Disponible à partir de la version 2.4.5 du serveur HTTP
Apache</compatibility>

<usage>
    <p>La directive <directive>CacheSocacheMaxSize</directive>
    définit la taille maximale, en octets, de la somme des en-têtes et
    du corps d'un document pouvant être stocké dans le cache. Bien
    entendu, plus la taille des en-têtes sera grande, plus la taille
    maximale du corps du document s'en trouvera réduite.</p>

    <p>Le module <module>mod_cache_socache</module> ne tentera de mettre
    en cache que des réponses qui possèdent une taille de contenu
    explicite, ou dont la taille est suffisamment petite pour qu'elles
    soient écrites en une seule passe. Ceci permet au module
    <module>mod_cache_disk</module> de mettre en cache des réponses dont
    la taille est trop importante pour pouvoir être mises en cache par
    <module>mod_cache_socache</module>.</p>

    <highlight language="config">
      CacheSocacheMaxSize 102400
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheSocacheReadSize</name>
<description>La quantité minimale de données du document à lire et
mettre en cache avant envoi au client</description>
<syntax>CacheSocacheReadSize <var>octets</var></syntax>
<default>CacheSocacheReadSize 0</default>
<contextlist><context>server config</context>
    <context>virtual host</context>
    <context>directory</context>
    <context>.htaccess</context>
</contextlist>
<compatibility>Disponible à partir de la version 2.4.5 du serveur HTTP
Apache</compatibility>

<usage>
    <p>La directive <directive>CacheSocacheReadSize</directive>
    définit la quantité minimale de données, en octets, à lire depuis
    l'arrière-plan avant envoi au client. Avec la valeur par défaut 0,
    les données sont transmises au client dès leur arrivée et quelle que
    soit leur taille. Si la valeur définie est non nulle, le cache
    disque va mettre en tampon au moins la quantité de données
    correspondante avant envoi au client. Ceci peut améliorer les
    performances en cas de mise en cache de contenu en provenance d'un
    mandataire inverse lent.</p>

    <p>Cette directive n'a d'effet qu'au moment où les données sont
    stockées dans le cache, et non lorsqu'elles sont servies depuis le
    cache.</p>

    <highlight language="config">
      CacheSocacheReadSize 102400
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheSocacheReadTime</name>
<description>La durée minimale de lecture avant l'envoi des données</description>
<syntax>CacheSocacheReadTime <var>millisecondes</var></syntax>
<default>CacheSocacheReadTime 0</default>
<contextlist><context>server config</context>
  <context>virtual host</context>
  <context>directory</context>
  <context>.htaccess</context>
</contextlist>
<compatibility>Disponible à partir de la version 2.4.5 du serveur HTTP
Apache</compatibility>

<usage>
    <p>La directive <directive>CacheSocacheReadTime</directive>
    définit le temps minimal qui doit s'écouler avant de tenter
    l'envoi des données au client. Cette durée sera mise à profit pour
    lire et mettre en tampon les données avant leur envoi au client.
    Ceci peut améliorer les performances en cas de mise en cache de
    contenu en provenance d'un mandataire inverse.</p>

    <p>La valeur par défaut 0 désactive cette directive.</p>

    <p>Cette directive n'a d'effet qu'au moment où les données sont
    stockées dans le cache, et non lorsqu'elles sont servies depuis le
    cache. Il est recommandé d'utiliser cette directive en concomitance
    avec la directive <directive
    module="mod_cache_socache">CacheSocacheReadSize</directive> afin de
    s'assurer que le serveur ne mette pas les données en tampon de
    manière excessive dans le cas où les données arriveraient plus vite
    que prévu.</p>

    <highlight language="config">
      CacheSocacheReadTime 1000
    </highlight>
</usage>
</directivesynopsis>

</modulesynopsis>
