<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1873915 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_cgid.xml.meta">

<name>mod_cgid</name>
<description>Exécution des scripts CGI par l'intermédiaire d'un démon
CGI externe</description>
<status>Base</status>
<sourcefile>mod_cgid.c</sourcefile>
<identifier>cgid_module</identifier>
<compatibility>Uniquement compatible avec les MPMs Unix
threadés</compatibility>

<summary>
    <p>Exceptées les optimisations et la directive additionnelle
    <directive module="mod_cgid">ScriptSock</directive> décrite
    ci-dessous, <module>mod_cgid</module> a un comportement similaire à
    celui de <module>mod_cgi</module>. <strong>Voir le résumé de
    <module>mod_cgi</module> pour plus de détails à propos d'Apache et
    CGI.</strong></p>

    <p>Sur certains systèmes d'exploitation de type unix, le lancement
    (forking) d'un processus depuis un serveur multi-threadé est une
    opération très lourde car le nouveau processus va répliquer tous les
    threads du processus parent. Pour éviter cette dépense de ressouces
    pour chaque invocation d'un programme CGI, <module>mod_cgid</module>
    crée un démon externe qui est responsable du branchement de
    processus enfants destinés au lancement de scripts CGI. Le serveur
    principal communique avec ce démon par l'intermédiaire d'une socket
    de domaine unix.</p>

    <p>Si un MPM multi-threadé a été sélectionné lors du processus de
    compilation, c'est ce module qui est utilisé par défaut à la place
    de <module>mod_cgi</module>. Du point de vue de l'utilisateur, ce
    module est identique à <module>mod_cgi</module> quant à sa
    configuration et son utilisation. La seule différence est la
    directive additionnelle <code>ScriptSock</code> qui permet de
    définir le nom du socket à utiliser pour la communication avec le
    démon CGI.</p>
</summary>

<seealso><module>mod_cgi</module></seealso>
<seealso><a href="../suexec.html">Exécution de programmes CGI sous des
utilisateurs différents</a></seealso>

<directivesynopsis location="mod_cgi">
<name>ScriptLog</name>
</directivesynopsis>

<directivesynopsis location="mod_cgi">
<name>ScriptLogLength</name>
</directivesynopsis>

<directivesynopsis location="mod_cgi">
<name>ScriptLogBuffer</name>
</directivesynopsis>

<directivesynopsis>
<name>ScriptSock</name>
<description>Le préfixe du nom de fichier du socket à utiliser pour
communiquer avec le démon CGI</description>
<syntax>ScriptSock <var>chemin fichier</var></syntax>
<default>ScriptSock cgisock</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de définir le préfixe du nom de fichier de la
    socket à utiliser pour communiquer avec le démon CGI, préfixe auquel
    sera ajouté une extension correspondant à l'identifiant processus du
    serveur. La socket sera ouverte avec les permissions de l'utilisateur
    qui a démarré Apache (en général root). Afin de préserver la
    sécurité des communications avec les scripts CGI, il est impératif
    de n'accorder à aucun autre utilisateur la permission d'écrire dans
    le répertoire où se trouve la socket.</p>

    <p>Si <var>chemin fichier</var> n'est pas un chemin absolu, il est
    relatif au chemin défini par la directive <directive
    module="core">DefaultRuntimeDir</directive>.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      ScriptSock /var/run/cgid.sock
      </highlight>
    </example>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>CGIDScriptTimeout</name>
<description>Durée maximale d'attente de la prochaine sortie du
programme CGI</description>
<syntax>CGIDScriptTimeout <var>time</var>[s|ms]</syntax>
<default>Si non définie ou définie à 0, valeur de la directive <directive
module="core">Timeout</directive></default>
<contextlist><context>server config</context>
<context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<compatibility>Disponible à partir de la version 2.4.10 du serveur HTTP Apache ;
dans les versions précédentes, aucune durée d'attente n'était définie</compatibility>

<usage>
    <p>Cette directive permet de limiter la durée d'attente avant les prochaines données
    reçues en sortie du programme CGI. Si ce temps est dépassé, la requête et le
    programme CGI se terminent.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      CGIDScriptTimeout 20
    </highlight>
    </example>

</usage>
</directivesynopsis>

</modulesynopsis>

