<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1872258 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_dir.xml.meta">
<name>mod_dir</name>
<description>Permet la redirection des adresses se terminant par un
répertoire sans slash de fin et la mise à disposition des fichiers index
de répertoire</description>
<status>Base</status>
<sourcefile>mod_dir.c</sourcefile>
<identifier>dir_module</identifier>

<summary>
    <p>L'index d'un répertoire peut provenir de deux sources :</p>

    <ul>
      <li>Un fichier écrit par l'utilisateur, dont le nom, en général
      appelé <code>index.html</code>, peut être défini à l'aide de la
      directive <directive module="mod_dir">DirectoryIndex</directive>
      fournie par le module <module>mod_dir</module>.</li>

      <li>Un listing généré par le serveur, par l'intermédiaire du
      module <module>mod_autoindex</module>.</li>
    </ul>
    <p>Les deux fonctions sont bien distinctes, si bien que vous pouvez
    supprimer (ou remplacer) la génération automatique d'index, si vous
    le souhaitez.</p>

    <p>Une redirection "slash de fin" est effectuée lorsque le serveur
    reçoit une requête pour une URL du style
    <code>http://nom-serveur/foo/nom-rep</code> où <code>nom-rep</code>
    est le nom d'un répertoire. Comme les répertoires nécessitent un slash de
    fin, <module>mod_dir</module> effectue une redirection vers
    <code>http://nom-serveur/foo/nom-rep/</code>.</p>
</summary>

<directivesynopsis>
<name>DirectoryIndex</name>
<description>Liste des fichiers ressources à rechercher lorsque le
client envoie une requête pour un répertoire</description>
<syntax>DirectoryIndex
    disabled | <var>url locale</var> [<var>url locale</var>] ...</syntax>
<default>DirectoryIndex index.html</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Indexes</override>

<usage>
    <p>La directive <directive>DirectoryIndex</directive> permet de
    définir une liste de fichiers ressources à rechercher lorsqu'un
    client envoie une requête pour l'index d'un répertoire, en ajoutant
    un '/' à la fin du nom de ce dernier. <var>url locale</var> est
    l'URL (codée avec caractères '%') d'un document du serveur, relative
    au répertoire faisant l'objet de la requête ; il s'agit en général
    du nom d'un fichier situé dans le répertoire. Si plusieurs URLs sont
    fournies, le serveur renverra la première d'entre elles qui
    correspond à une ressource existante. Si aucune ressource ne
    correspond à la liste des URLs spécifiées, et si l'option
    <code>Indexes</code> est définie, le serveur générera son propre
    listing du répertoire.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      DirectoryIndex index.html
      </highlight>
    </example>

    <p>Avec cette configuration, une requête pour l'URL
    <code>http://example.com/docs/</code> renverrait au client la
    ressource <code>http://example.com/docs/index.html</code> si elle
    existe, ou provoquerait la génération du listing du répertoire si la
    ressource n'existe pas.</p>

    <p>Notez qu'il n'est pas nécessaire que les documents soient
    relatifs au répertoire ;</p>

    <highlight language="config">
      DirectoryIndex index.html index.txt  /cgi-bin/index.pl
    </highlight>

    <p>provoquerait l'exécution du script CGI
    <code>/cgi-bin/index.pl</code> si aucun des fichiers
    <code>index.html</code> ou <code>index.txt</code> n'existe dans le
    répertoire considéré.</p>

    <p>La spécification du seul argument "disabled" empêche
    <module>mod_dir</module> de rechercher un index. Un argument
    "disabled" sera interprété de manière littérale si d'autres
    arguments sont présents avant ou après lui, même s'ils sont
    eux-mêmes des arguments "disabled".</p>

    <p><strong>Note:</strong> Positionner plusieurs directives <directive>DirectoryIndex</directive>
    au coeur du <a href="../sections.html"><em>même context</em></a> complète la liste des ressources et ne l'écrase pas :
    </p>
    <highlight language="config">
# Exemple A: Positionner index.html en page d'index, puis ajouter index.php.
&lt;Directory "/foo"&gt;
    DirectoryIndex index.html
    DirectoryIndex index.php
&lt;/Directory&gt;

# Exemple B: La même chose que l'exemple A, mais réalisé au moyen d'une seule directive.
&lt;Directory "/foo"&gt;
    DirectoryIndex index.html index.php
&lt;/Directory&gt;

# Exemple C: Pour remplacer la liste des ressources, il faut d'abord la vider :
# Ici, seul index.php restera référencé comme ressource d'index.
&lt;Directory "/foo"&gt;
    DirectoryIndex index.html
    DirectoryIndex disabled
    DirectoryIndex index.php
&lt;/Directory&gt;
    </highlight>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>DirectoryIndexRedirect</name>
<description>Définit une redirection externe pour les index de
répertoires.
</description>
<syntax>DirectoryIndexRedirect on | off | permanent | temp | seeother |
<var>3xx-code</var>
</syntax>
<default>DirectoryIndexRedirect off</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Indexes</override>
<compatibility>Disponible depuis la version 2.3.14</compatibility>

<usage>
    <p>Par défaut, c'est la page définie par la directive
    <directive>DirectoryIndex</directive> qui est sélectionnée et
    renvoyée de manière transparente au client. La directive
    <directive>DirectoryIndexRedirect</directive> permet de rediriger le
    client via une redirection de type 3xx.</p>

    <p>Les arguments acceptés sont :</p>
    <ul>
     <li><code>on</code> : envoie une redirection 302 vers l'index choisi.</li>
     <li><code>off</code> : n'envoie aucune redirection. Il s'agit du comportement historique de mod_dir.</li>
     <li><code>permanent</code> : envoie une redirection 301 (permanent) vers l'index choisi.</li>
     <li><code>temp</code> : ceci est équivalent à <code>on</code></li>
     <li><code>seeother</code> : envoie une redirection 303 (également appelée "See Other") vers l'index choisi.</li>
     <li><var>3xx-code</var> : envoie une redirection accompagnée du code 3xx choisi.</li>
    </ul>



    <example><title>Exemple</title>
    <highlight language="config">
      DirectoryIndexRedirect on
      </highlight>
    </example>

    <p>Une requête pour <code>http://example.com/docs/</code> se
    solderait par une redirection temporaire vers
    <code>http://example.com/docs/index.html</code> si cette ressource
    existe.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>DirectorySlash</name>
<description>Activation/Désactivation de la redirection "slash de
fin"</description>
<syntax>DirectorySlash On|Off</syntax>
<default>DirectorySlash On</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Indexes</override>

<usage>
    <p>La directive <directive>DirectorySlash</directive> permet de
    déterminer si <module>mod_dir</module> doit corriger ou non les URLs
    pointant vers un répertoire.</p>

    <p>En général, si un utilisateur envoie une requête pour une
    ressource sans slash de fin, cette ressource représentant un
    répertoire, <module>mod_dir</module> le redirige vers la même
    ressource, mais <em>en ajoutant</em> un slash de fin, et ceci pour
    plusieurs bonnes raisons :</p>

    <ul>
    <li>La requête de l'utilisateur contiendra finalement l'URL
    canonique de la ressource</li>
    <li><module>mod_autoindex</module> fonctionnera correctement. Comme
    il n'indique pas le chemin dans le lien, le chemin de l'URL serait
    incorrect.</li>
    <li>La directive <directive
    module="mod_dir">DirectoryIndex</directive> n'est évaluée
    <em>que</em> pour les répertoires se terminant par un slash.</li>
    <li>Les références à des URLs relatives dans les pages html
    fonctionneront alors correctement.</li>
    </ul>

    <p>Si vous ne souhaitez pas voir ces effets, <em>et</em> si
    les raisons évoquées ci-dessus ne s'appliquent pas à vous, vous
    pouvez désactiver la redirection comme indiqué ci-dessous.
    Gardez cependant à l'esprit que ceci peut avoir des répercutions en
    matière de sécurité.</p>

    <highlight language="config">
# voir l'avertissement de sécurité ci-dessous !
&lt;Location "/some/path"&gt;
    DirectorySlash Off
    SetHandler some-handler
&lt;/Location&gt;
    </highlight>

    <note type="warning"><title>Avertissement de sécurité</title>
    <p>La désactivation de la redirection "slash de fin" peut entraîner
    la divulgation d'informations. Considérons la situation où
    <module>mod_autoindex</module> est actif (<code>Options
    +Indexes</code>), où la directive <directive module="mod_dir"
    >DirectoryIndex</directive> a pour valeur une ressource valide (par
    exemple <code>index.html</code>), et où aucun gestionnaire
    particulier n'a été défini pour cette URL. Dans ce cas, une requête
    avec slash de fin afficherait le contenu du fichier
    <code>index.html</code> ; <strong>par contre, une requête sans slash
    de fin afficherait un listing du contenu du
    répertoire</strong>.</p>
    </note>
    <p>Notez aussi que certains navigateurs peuvent modifier par erreur
    des requêtes POST en requêtes GET lors d'une redirection, les
    données POST étant alors perdues.</p>
</usage>
</directivesynopsis>
<directivesynopsis>
<name>FallbackResource</name>
<description>Définit une URL par défaut pour les requêtes qui ne ciblent
aucun fichier</description>
<syntax>FallbackResource disabled | <var>url-locale</var></syntax>
<default>disabled - httpd renvoie un code d'erreur 404 (Not Found)</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Indexes</override>
<compatibility>L'argument <code>disabled</code> est disponible à partir
de la version 2.4.4 du serveur HTTP Apache.</compatibility>
<usage>
    <p>Cette directive permet de définir un traitement pour toute URL
    qui ne correspond à aucune ressource de votre système de fichiers,
    et qui provoquerait sans cela l'envoi d'un code d'erreur HTTP 404
    (Not Found).
    Par exemple</p>
    <highlight language="config">
        FallbackResource /not-404.php
    </highlight>
    <p>fait en sorte que les requêtes ne correspondant à aucun fichier
    soient traitées par <code>non-404.php</code>, sans affecter les
    requêtes pour des fichiers existants.</p>
    <p>Il est souvent souhaitable qu'un seul fichier ou ressource traite
    toutes les requêtes à destination d'un répertoire
    particulier, sauf pour les requêtes qui correspondent à un fichier
    ou script existant. On y fait souvent référence sous le terme
    'contrôleur frontal'.</p>
    <p>Dans les versions plus anciennes de httpd, cet effet nécessitait
    en général <module>mod_rewrite</module>, et l'utilisation des tests
    conditionnels <code>-f</code> et <code>-d</code> pour vérifier
    l'existence des fichiers et répertoires. Maintenant, une seule ligne
    de configuration est nécessaire.</p>
    <highlight language="config">
        FallbackResource /index.php
    </highlight>
    <p>Les fichiers existants comme des images, des fichiers css, etc...
    seront traités normalement.</p>
    <p>L'argument <code>disabled</code> permet de désactiver cette
    fonctionnalité dans le cas où l'héritage d'un répertoire parent
    n'est pas souhaité.</p>
    <p>Pour un URI intermédiaire tel que
    <em>http://example.com/blog/</em>, cet URI intermédiaire doit être
    spécifié en tant que <var>url-locale</var> :</p>
    <highlight language="config">
&lt;Directory "/web/example.com/htdocs/blog"&gt;
    FallbackResource /blog/index.php
&lt;/Directory&gt;
&lt;Directory "/web/example.com/htdocs/blog/images"&gt;
    FallbackResource disabled
&lt;/Directory&gt;
    </highlight>
    <p>Un gestionnaire de ressource par défaut (dans l'exemple ci-dessus
    <code>/blog/index.php</code>) peut accéder à l'URL de la requête originale
    via la variable de serveur <code>REQUEST_URI</code>. Pour accéder à cette
    variable en PHP, par exemple, utilisez <code>$_SERVER['REQUEST_URI']</code>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>DirectoryCheckHandler</name>
<description>Définit la réponse de ce module lorsqu'un autre
gestionnaire est utilisé</description>
<syntax>DirectoryCheckHandler On|Off</syntax>
<default>DirectoryCheckHandler Off</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Indexes</override>
<compatibility>Disponible depuis la version 2.4.8 du serveur HTTP
Apache. Les versions antérieures à 2.4 se comportaient implicitement
comme si "DirectoryCheckHandler ON" avait été spécifié.</compatibility>
<usage>
    <p>La directive <directive>DirectoryCheckHandler</directive> permet
    de faire en sorte que <module>mod_dir</module> recherche un index
    de répertoire ou ajoute des slashes de fin lorsqu'un autre
    gestionnaire à été défini pour l'URL considérée. Les gestionnaires
    peuvent être définis à via des directives telles que
    <directive module="core">SetHandler</directive> ou par d'autres
    modules tels que <module>mod_rewrite</module> au cours des
    substitutions de niveau répertoire.</p>

    <p>Dans les versions antérieures à 2.4, ce module ne modifiait pas son
    comportement si un autre gestionnaire avait été défini pour l'URL
    considérée. Ceci permettait de servir des index de répertoires même si une
    directive <directive>SetHandler</directive> avait été définie pour un
    répertoire entier, mais pouvait aussi être à l'origine de conflits avec
    d'autres modules comme <module>mod_rewrite</module>.</p> 
</usage>
</directivesynopsis>

</modulesynopsis>
