<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1874169 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->


<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_ldap.xml.meta">

<name>mod_ldap</name>
<description>Conservation des connexions LDAP et services de mise en
cache du résultat à destination des autres modules LDAP</description>
<status>Extension</status>
<sourcefile>util_ldap.c</sourcefile>
<identifier>ldap_module</identifier>

<summary>
    <p>Ce module a été conçu dans le but d'améliorer les performances
    des sites web s'appuyant sur des connexions en arrière-plan vers des
    serveurs LDAP. Il ajoute aux fonctions fournies par les
    bibliothèques standards LDAP la conservation des connexions LDAP
    ainsi qu'un cache LDAP partagé en mémoire.</p>

    <p>Pour activer ce module, le support LDAP doit être compilé dans
    apr-util. Pour ce faire, on ajoute l'option <code>--with-ldap</code>
    au script <program>configure</program> lorsqu'on construit
    Apache.</p>

    <p>Le support SSL/TLS est conditionné par le kit de développement
    LDAP qui a été lié à <glossary>APR</glossary>. Au moment où ces
    lignes sont écrites, APR-util supporte <a
    href="http://www.openldap.org/">OpenLDAP SDK</a> (version 2.x ou
    supérieure), <a
    href="http://developer.novell.com/ndk/cldap.htm">Novell LDAP
    SDK</a>, <a href="https://wiki.mozilla.org/LDAP_C_SDK">
    Mozilla LDAP SDK</a>, le SDK LDAP Solaris natif (basé sur Mozilla)
    ou le SDK LDAP Microsoft natif. Voir le site web <a
    href="http://apr.apache.org">APR</a> pour plus de détails.</p>

</summary>

<section id="exampleconfig"><title>Exemple de configuration</title>
    <p>Ce qui suit est un exemple de configuration qui utilise
    <module>mod_ldap</module> pour améliorer les performances de
    l'authentification HTTP de base fournie par
    <module>mod_authnz_ldap</module>.</p>

    <highlight language="config">
# Active la conservation des connexions LDAP et le cache partagé en
# mémoire. Active le gestionnaire de statut du cache LDAP.
# Nécessite le chargement de mod_ldap et de mod_authnz_ldap.
# Remplacez "votre-domaine.example.com" par le nom de votre
# domaine.

LDAPSharedCacheSize 500000
LDAPCacheEntries 1024
LDAPCacheTTL 600
LDAPOpCacheEntries 1024
LDAPOpCacheTTL 600

&lt;Location "/ldap-status"&gt;
    SetHandler ldap-status
    
    Require host yourdomain.example.com
    
    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    AuthLDAPURL "ldap://127.0.0.1/dc=example,dc=com?uid?one"
    Require valid-user
&lt;/Location&gt;
    </highlight>
</section>

<section id="pool"><title>Conservation des connexions LDAP</title>

    <p>Les connexions LDAP sont conservées de requête en requête. Ceci
    permet de rester connecté et identifié au serveur LDAP, ce dernier
    étant ainsi prêt pour la prochaine requête, sans avoir à se
    déconnecter, reconnecter et réidentifier. Le gain en performances
    est similaire à celui des connexions persistantes (keepalives)
    HTTP.</p>

    <p>Sur un serveur très sollicité, il est possible que de nombreuses
    requêtes tentent d'accéder simultanément à la même connexion au
    serveur LDAP. Lorsqu'une connexion LDAP est utilisée, Apache en crée
    une deuxième en parallèle à la première, ce qui permet d'éviter que
    le système de conservation des connexions ne devienne un goulot
    d'étranglement.</p>

    <p>Il n'est pas nécessaire d'activer explicitement la conservation
    des connexions dans la configuration d'Apache. Tout module utilisant
    le module ldap pour accéder aux services LDAP partagera le jeu de
    connexions.</p>

    <p>Les connexions LDAP peuvent garder la trace des données
    d'identification du client ldap utilisées pour l'identification
    auprès du serveur LDAP. Ces données peuvent être fournies aux
    serveurs LDAP qui ne permettent pas les connexions anonymes au cours
    lors des tentatives de sauts vers des serveurs alternatifs. Pour
    contrôler cette fonctionnalité, voir les directives <directive
    module="mod_ldap">LDAPReferrals</directive> et <directive
    module="mod_ldap">LDAPReferralHopLimit</directive>. Cette
    fonctionnalité est activée par défaut.</p>
</section>

<section id="cache"><title>Cache LDAP</title>

    <p>Pour améliorer les performances, <module>mod_ldap</module> met en
    oeuvre une stratégie de mise en cache agressive visant à minimiser
    le nombre de fois que le serveur LDAP doit être contacté. La mise en
    cache peut facilement doubler et même tripler le débit d'Apache
    lorsqu'il sert des pages protégées par mod_authnz_ldap. De plus, le
    serveur LDAP verra lui-même sa charge sensiblement diminuée.</p>

    <p><module>mod_ldap</module> supporte deux types de mise en cache
    LDAP : un <em>cache recherche/identification</em> durant la phase
    de recherche/identification et deux <em>caches d'opérations</em>
    durant la phase de comparaison. Chaque URL LDAP utilisée par le
    serveur a son propre jeu d'instances dans ces trois caches.</p>

    <section id="search-bind"><title>Le cache
    recherche/identification</title>
      <p>Les processus de recherche et d'identification sont les
      opérations LDAP les plus consommatrices en temps, en particulier
      si l'annuaire est de grande taille. Le cache de
      recherche/identification met en cache toutes les recherches qui
      ont abouti à une identification positive. Les résultats négatifs
      (c'est à dire les recherches sans succès, ou les recherches qui
      n'ont pas abouti à une identification positive) ne sont pas mis en
      cache. La raison de cette décision réside dans le fait que les
      connexions avec des données d'identification invalides ne
      représentent qu'un faible pourcentage du nombre total de
      connexions, et ainsi, le fait de ne pas mettre en cache les
      données d'identification invalides réduira d'autant la taille du
      cache.</p>

      <p><module>mod_ldap</module> met en cache le nom d'utilisateur, le
      DN extrait, le mot de passe utilisé pour l'identification, ainsi
      que l'heure de l'identification. Chaque fois qu'une nouvelle
      connexion est initialisée avec le même nom d'utilisateur,
      <module>mod_ldap</module> compare le mot de passe de la nouvelle
      connexion avec le mot de passe enregistré dans le cache. Si les
      mots de passe correspondent, et si l'entrée du cache n'est pas
      trop ancienne, <module>mod_ldap</module> court-circuite la phase
      de recherche/identification.</p>

      <p>Le cache de recherche/identification est contrôlé par les
      directives <directive
      module="mod_ldap">LDAPCacheEntries</directive> et <directive
      module="mod_ldap">LDAPCacheTTL</directive>.</p>
    </section>

    <section id="opcaches"><title>Les caches d'opérations</title>
      <p>Au cours des opérations de comparaison d'attributs et de noms
      distinctifs (DN), <module>mod_ldap</module> utilise deux caches
      d'opérations pour mettre en cache les opérations de comparaison.
      Le premier cache de comparaison sert à mettre en cache les
      résultats de comparaisons effectuées pour vérifier l'appartenance
      à un groupe LDAP. Le second cache de comparaison sert à mettre en
      cache les résultats de comparaisons entre DNs.</p>

      <p>Notez que, lorsque l'appartenance à un groupe est vérifiée,
      toute comparaison de sous-groupes est mise en cache afin
      d'accélérer les comparaisons de sous-groupes ultérieures.</p>

      <p>Le comportement de ces deux caches est contrôlé par les
      directives <directive
      module="mod_ldap">LDAPOpCacheEntries</directive> et <directive
      module="mod_ldap">LDAPOpCacheTTL</directive>.</p>
    </section>

    <section id="monitoring"><title>Superviser le cache</title>
      <p><module>mod_ldap</module> possède un gestionnaire de contenu
      qui permet aux administrateurs de superviser les performances du
      cache. Le nom du gestionnaire de contenu est
      <code>ldap-status</code>, et on peut utiliser les directives
      suivantes pour accéder aux informations du cache de
      <module>mod_ldap</module> :</p>

      <highlight language="config">
&lt;Location "/server/cache-info"&gt;
    SetHandler ldap-status
&lt;/Location&gt;
      </highlight>

      <p>En se connectant à l'URL
      <code>http://nom-serveur/infos-cache</code>, l'administrateur peut
      obtenir un rapport sur le statut de chaque cache qu'utilise
      <module>mod_ldap</module>. Notez que si Apache ne supporte pas la
      mémoire partagée, chaque instance de <program>httpd</program>
      possèdera son propre cache, et chaque fois que l'URL sera
      rechargée, un résultat différent pourra être affiché, en fonction
      de l'instance de <program>httpd</program> qui traitera la
      requête.</p>
    </section>
</section>

<section id="usingssltls"><title>Utiliser SSL/TLS</title>

    <p>La possibilité de créer des connexions SSL et TLS avec un serveur
    LDAP est définie par les directives <directive module="mod_ldap">
    LDAPTrustedGlobalCert</directive>, <directive module="mod_ldap">
    LDAPTrustedClientCert</directive> et <directive module="mod_ldap">
    LDAPTrustedMode</directive>. Ces directives permettent de spécifier
    l'autorité de certification (CA), les certificats clients éventuels,
    ainsi que le type de chiffrement à utiliser pour la connexion (none,
    SSL ou TLS/STARTTLS).</p>

    <highlight language="config">
# Etablissement d'une connexion SSL LDAP sur le port 636.
# Nécessite le chargement de mod_ldap et mod_authnz_ldap.
# Remplacez "votre-domaine.example.com" par le nom de votre
# domaine.

LDAPTrustedGlobalCert CA_DER "/certs/certfile.der"

&lt;Location "/ldap-status"&gt;
    SetHandler ldap-status
    
    Require host yourdomain.example.com
    
    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    AuthLDAPURL "ldaps://127.0.0.1/dc=example,dc=com?uid?one"
    Require valid-user
&lt;/Location&gt;
    </highlight>

    <highlight language="config">
# Etablissement d'une connexion TLS LDAP sur le port 389.
# Nécessite le chargement de mod_ldap et mod_authnz_ldap.
# Remplacez "votre-domaine.example.com" par le nom de votre
# domaine.

LDAPTrustedGlobalCert CA_DER "/certs/certfile.der"

&lt;Location "/ldap-status"&gt;
    SetHandler ldap-status
    
    Require host yourdomain.example.com
    
    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    AuthLDAPURL "ldap://127.0.0.1/dc=example,dc=com?uid?one" TLS
    Require valid-user
&lt;/Location&gt;
    </highlight>

</section>

<section id="settingcerts"><title>Certificats SSL/TLS</title>

    <p>Les différents SDKs LDAP disposent de nombreuses méthodes pour
    définir et gérer les certificats des clients et des autorités de
    certification (CA).</p>

    <p>Si vous avez l'intention d'utiliser SSL ou TLS, lisez cette
    section ATTENTIVEMENT de façon à bien comprendre les différences de
    configurations entre les différents SDKs LDAP supportés.</p>

    <section id="settingcerts-netscape"><title>SDK Netscape/Mozilla/iPlanet</title>
        <p>Les certificat de CA sont enregistrés dans un fichier nommé
	cert7.db. Le SDK ne dialoguera avec aucun serveur LDAP dont le
	certificat n'a pas été signé par une CA spécifiée dans ce
	fichier. Si des certificats clients sont requis, un fichier
	key3.db ainsi qu'un mot de passe optionnels peuvent être
	spécifiés. On peut aussi spécifier le fichier secmod si
	nécessaire. Ces fichiers sont du même format que celui utilisé
	par les navigateurs web Netscape Communicator ou Mozilla. Le
	moyen le plus simple pour obtenir ces fichiers consiste à les
	extraire de l'installation de votre navigateur.</p>

        <p>Les certificats clients sont spécifiés pour chaque connexion
	en utilisant la directive LDAPTrustedClientCert et en se
	référant au certificat "nickname". On peut éventuellement
	spécifier un mot de passe pour déverrouiller la clé privée du
	certificat.</p>

        <p>Le SDK supporte seulement SSL. Toute tentative d'utilisation
	de STARTTLS engendrera une erreur lors des tentatives de
	contacter le serveur LDAP pendant l'exécution.</p>

        <highlight language="config">
# Spécifie un fichier de certificats de CA Netscape
LDAPTrustedGlobalCert CA_CERT7_DB "/certs/cert7.db"
# Spécifie un fichier key3db optionnel pour le support des
# certificats clients
LDAPTrustedGlobalCert CERT_KEY3_DB "/certs/key3.db"
# Spécifie le fichier secmod si nécessaire
LDAPTrustedGlobalCert CA_SECMOD "/certs/secmod"
&lt;Location "/ldap-status"&gt;
    SetHandler ldap-status

    Require host yourdomain.example.com

    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    LDAPTrustedClientCert CERT_NICKNAME &lt;nickname&gt; [password]
    AuthLDAPURL "ldaps://127.0.0.1/dc=example,dc=com?uid?one"
    Require valid-user
&lt;/Location&gt;
        </highlight>

    </section>

    <section id="settingcerts-novell"><title>SDK Novell</title>

        <p>Un ou plusieurs certificats de CA doivent être spécifiés pour
	que le SDK Novell fonctionne correctement. Ces certificats
	peuvent être spécifiés sous forme de fichiers au format binaire
	DER ou codés en Base64 (PEM).</p>

        <p>Note: Les certificats clients sont spécifiés globalement
	plutôt qu'à chaque connexion, et doivent être spécifiés à l'aide
	de la directive LDAPTrustedGlobalCert comme ci-dessous. Définir
	des certificats clients via la directive LDAPTrustedClientCert
	engendrera une erreur qui sera journalisée, au moment de la
	tentative de connexion avec le serveur LDAP.</p>

        <p>Le SDK supporte SSL et STARTTLS, le choix étant défini par le
	paramètre de la directive LDAPTrustedMode. Si une URL de type
	ldaps:// est spécifiée, le mode SSL est forcé, et l'emporte sur
	cette directive.</p>

        <highlight language="config">
# Spécifie deux fichiers contenant des certificats de CA
LDAPTrustedGlobalCert CA_DER "/certs/cacert1.der"
LDAPTrustedGlobalCert CA_BASE64 "/certs/cacert2.pem"
# Spécifie un fichier contenant des certificats clients
# ainsi qu'une clé
LDAPTrustedGlobalCert CERT_BASE64 "/certs/cert1.pem"
LDAPTrustedGlobalCert KEY_BASE64 "/certs/key1.pem" [password]
# N'utilisez pas cette directive, sous peine de provoquer
# une erreur
#LDAPTrustedClientCert CERT_BASE64 "/certs/cert1.pem"
        </highlight>

    </section>

    <section id="settingcerts-openldap"><title>SDK OpenLDAP</title>

        <p>Un ou plusieurs certificats de CA doivent être spécifiés pour
	que le SDK OpenLDAP fonctionne correctement. Ces certificats
	peuvent être spécifiés sous forme de fichiers au format binaire
	DER ou codés en Base64 (PEM).</p>

        <p>Les certificats clients sont spécifiés pour chaque connexion
	à l'aide de la directive LDAPTrustedClientCert.</p>

        <p>La documentation du SDK prétend que SSL et STARTTLS sont
	supportés ; cependant, STARTTLS semble ne pas fonctionner avec
	toutes les versions du SDK. Le mode SSL/TLS peut être défini en
	utilisant le paramètre de la directive LDAPTrustedMode. Si une
	URL de type
	ldaps:// est spécifiée, le mode SSL est forcé. La documentation
	OpenLDAP indique que le support SSL (ldaps://) tend à être
	remplacé par TLS, bien que le mode SSL fonctionne toujours.</p>

        <highlight language="config">
# Spécifie deux fichiers contenant des certificats de CA
LDAPTrustedGlobalCert CA_DER "/certs/cacert1.der"
LDAPTrustedGlobalCert CA_BASE64 "/certs/cacert2.pem"
&lt;Location /ldap-status&gt;
    SetHandler ldap-status
    
    Require host yourdomain.example.com
    
    LDAPTrustedClientCert CERT_BASE64 "/certs/cert1.pem"
    LDAPTrustedClientCert KEY_BASE64 "/certs/key1.pem"
    # CA certs respecified due to per-directory client certs
    LDAPTrustedClientCert CA_DER "/certs/cacert1.der"
    LDAPTrustedClientCert CA_BASE64 "/certs/cacert2.pem"
    Satisfy any
    AuthType Basic
    AuthName "LDAP Protected"
    AuthBasicProvider ldap
    AuthLDAPURL "ldaps://127.0.0.1/dc=example,dc=com?uid?one"
    Require valid-user
&lt;/Location&gt;
        </highlight>

    </section>

    <section id="settingcerts-solaris"><title>SDK Solaris</title>

        <p>SSL/TLS pour les bibliothèques LDAP propres à Solaris n'est
	pas encore supporté. Si nécessaire, installez et utilisez plutôt
	les bibliothèques OpenLDAP.</p>

    </section>

    <section id="settingcerts-microsoft"><title>SDK Microsoft</title>

        <p>La configuration des certificats SSL/TLS pour les
	bibliothèques LDAP propres à Microsoft s'effectue à l'intérieur
	du registre système, et aucune directive de configuration n'est
	requise.</p>

        <p>SSL et TLS sont tous deux supportés en utilisant des URLs de
	type ldaps://, ou en définissant la directive LDAPTrustedMode à
	cet effet.</p>

        <p>Note: L'état du support des certificats clients n'est pas
	encore connu pour ce SDK.</p>

    </section>

</section>

<directivesynopsis>
<name>LDAPSharedCacheSize</name>
<description>Taille en octets du cache en mémoire partagée</description>
<syntax>LDAPSharedCacheSize <var>octets</var></syntax>
<default>LDAPSharedCacheSize 500000</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de spécifier le nombre d'octets à allouer
    pour le cache en mémoire partagée. La valeur par
    défaut est 500kb.
    Si elle est définie à 0, le cache en mémoire partagée ne sera pas
    utilisé et chaque processus HTTPD va créer son propre cache.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPSharedCacheFile</name>
<description>Définit le fichier du cache en mémoire
partagée</description>
<syntax>LDAPSharedCacheFile <var>chemin/fichier</var></syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de spécifier le chemin du
    fichier du cache en mémoire partagée. Si elle n'est pas définie, la
    mémoire partagée anonyme sera utilisée si la plate-forme la
    supporte.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPCacheEntries</name>
<description>Nombre maximum d'entrées dans le cache LDAP
primaire</description>
<syntax>LDAPCacheEntries <var>nombre</var></syntax>
<default>LDAPCacheEntries 1024</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de spécifier la taille maximale du cache
    LDAP primaire. Ce cache contient les résultats de
    recherche/identification positifs. Définissez-la à 0 pour désactiver
    la mise en cache des résultats de recherche/identification positifs.
    La taille par défaut est de 1024 recherches en cache.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPCacheTTL</name>
<description>Durée pendant laquelle les entrées du cache restent
valides.</description>
<syntax>LDAPCacheTTL <var>secondes</var></syntax>
<default>LDAPCacheTTL 600</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de spécifier la durée (en secondes)
    pendant laquelle une entrée du cache de recherche/identification
    reste valide. La valeur par défaut est de 600 secondes (10
    minutes).</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPOpCacheEntries</name>
<description>Nombre d'entrées utilisées pour mettre en cache les
opérations de comparaison LDAP</description>
<syntax>LDAPOpCacheEntries <var>nombre</var></syntax>
<default>LDAPOpCacheEntries 1024</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de spécifier le nombre d'entrées que
    <module>mod_ldap</module> va utiliser pour mettre en cache les
    opérations de comparaison LDAP. La valeur par défaut est de 1024
    entrées. Si elle est définie à 0, la mise en cache des opérations de
    comparaison LDAP est désactivée.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPOpCacheTTL</name>
<description>Durée pendant laquelle les entrées du cache d'opérations
restent valides</description>
<syntax>LDAPOpCacheTTL <var>secondes</var></syntax>
<default>LDAPOpCacheTTL 600</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de spécifier la durée (en secondes)
    pendant laquelle les entrées du cache d'opérations restent valides.
    La valeur par défaut est de 600 secondes.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPReferralHopLimit</name>
<description>Le nombre maximum de redirections vers des serveurs
alternatifs (referrals) avant l'abandon de la requête
LDAP.</description>
<syntax>LDAPReferralHopLimit <var>nombre</var></syntax>
<default>Dépend du SDK, en général entre 5 et 10</default>
<contextlist><context>directory</context><context>.htaccess</context></contextlist>
<override>AuthConfig</override>

<usage>
    <p>Si elle est activée par la directive <directive>LDAPReferrals</directive>,
    cette directive permet de définir le nombre maximum de sauts vers
    des serveurs alternatifs (referrals) avant l'abandon de la requête
    LDAP.</p>

<note type="warning">
<p>L'ajustement de ce paramètre n'est pas commun à tous les SDKs LDAP.</p>
</note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPReferrals</name>
<description>Active la redirection vers des serveurs alternatifs au
cours des requêtes vers le serveur LDAP.</description>
<syntax>LDAPReferrals <var>On|Off|default</var></syntax>
<default>LDAPReferrals On</default>
<contextlist><context>directory</context><context>.htaccess</context></contextlist>
<override>AuthConfig</override>
<compatibility>Le paramètre <var>default</var> est disponible depuis la
version 2.4.7 du serveur HTTP Apache.</compatibility>

<usage>
    <p>Certains serveurs LDAP partagent leur annuaire en plusieurs
    domaines et utilisent le système des redirections (referrals) pour
    aiguiller un client lorsque les limites d'un domaine doivent être
    franchies. Ce processus est similaire à une redirection HTTP. Les
    bibliothèques client LDAP ne respectent pas forcément ces
    redirections par défaut. Cette directive permet de configurer
    explicitement les redirections LDAP dans le SDK sous-jacent.</p>

    <p>La directive <directive>LDAPReferrals</directive> accepte les
    valeurs suivantes :</p>

    <dl>
     <dt>"on"</dt>
     <dd> <p>Avec la valeur "on", la prise en compte des redirections
     LDAP par le SDK sous-jacent est activée, la directive
     <directive>LDAPReferralHopLimit</directive> permet de surcharger la
     "hop limit" du SDK, et un "LDAP rebind callback" est enregistré.</p></dd>
     <dt>"off"</dt>
     <dd> <p>Avec la valeur "off", la prise en compte des redirections
     LDAP par le SDK sous-jacent est complètement désactivée.</p></dd>
     <dt>"default"</dt>
     <dd> <p>Avec la valeur "default", la prise en compte des redirections
     LDAP par le SDK sous-jacent n'est pas modifiée, la directive
     <directive>LDAPReferralHopLimit</directive> ne permet pas de surcharger la
     "hop limit" du SDK, et aucun "LDAP rebind callback" n'est enregistré.</p></dd>
    </dl>
    
    <p>La directive <directive>LDAPReferralHopLimit</directive> travaille en
    conjonction avec cette directive pour limiter le nombre de
    redirections à suivre pour achever le traitement de la requête LDAP.
    Lorsque le processus de redirection est activé par la valeur "On",
    les données d'authentification du client sont transmises via un
    "rebind callback" à tout serveur LDAP qui en fait la demande.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPRetryDelay</name>
<description>Définit le temps d'attente avant un autre essai de connexion au
serveur LDAP.</description>
<syntax>LDAPRetryDelay <var>secondes</var></syntax>
<default>LDAPRetryDelay 0</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Si la directive <directive>LDAPRetryDelay</directive> est définie
    à une valeur différente de 0, le serveur attendra pendant la durée
    spécifiée pour envoyer à nouveau sa requête LDAP. Une valeur de 0
    implique une absence de délai pour les essais successifs.</p>

    <p>Il est possible d'effectuer une autre tentative de connexion en
    cas d'erreurs LDAP du type délai dépassé ou connexion refusée. </p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPRetries</name>
<description>Définit le nombre maximum de tentatives de connexions au
serveur LDAP.</description>
<syntax>LDAPRetries <var>nombre d'essais</var></syntax>
<default>LDAPRetries 3</default>
<contextlist><context>server config</context></contextlist>
<usage>
    <p>Suite à des échecs de connexion au serveur LDAP, le serveur
    tentera de se connecter autant de fois qu'indiqué par la directive
    <directive>LDAPRetries</directive>. Si cette directive est définie à
    0, le serveur ne tentera pas d'autre connexion après un échec.</p>
    <p>Il est possible d'effectuer une autre tentative de connexion en
    cas d'erreurs LDAP du type délai dépassé ou connexion refusée. </p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPTrustedGlobalCert</name>
<description>Définit le nom de fichier ou la base de données contenant
les Autorités de Certification de confiance globales ou les certificats
clients globaux</description>
<syntax>LDAPTrustedGlobalCert <var>type</var>
<var>chemin/nom-fichier</var> <var>[mot de passe]</var></syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de spécifier le chemin et le nom du
    fichier contenant les certificats des CA de confiance et/ou les
    certificats clients du système global que <module>mod_ldap</module>
    utilisera pour établir une connexion SSL ou TLS avec un serveur
    LDAP. Notez que toute information relative aux certificats spécifiée
    en utilisant cette directive s'applique globalement à l'ensemble de
    l'installation du serveur. Certains SDK LDAP (en particulier Novell)
    nécessitent la définition globale de tous les certificats clients en
    utilisant cette directive. La plupart des autres SDK nécessitent la
    définition des certificats clients dans une section Directory ou
    Location en utilisant la directive LDAPTrustedClientCert. Si vous ne
    définissez pas ces directives correctement, une erreur sera générée
    lors des tentatives de contact avec un serveur LDAP, ou la connexion
    échouera silencieusement (Voir plus haut le guide des certificats
    SSL/TLS pour plus de détails). Le paramètre type spécifie le type de
    certificat en cours de définition, en fonction du SDK LDAP utilisé.
    Les types supportés sont :</p>
    <ul>
      <li>CA_DER - certificat de CA codé en binaire DER</li>
      <li>CA_BASE64 - certificat de CA codé en PEM</li>
      <li>CA_CERT7_DB - fichier de base de données des certificats de CA
      de Netscape cert7.db</li>
      <li>CA_SECMOD - fichier de base de données secmod de Netscape</li>
      <li>CERT_DER - certificat client codé en binaire DER</li>
      <li>CERT_BASE64 - certificat client codé en PEM</li>
      <li>CERT_KEY3_DB - fichier de base de données des certificats
      clients de Netscape key3.db</li>
      <li>CERT_NICKNAME - certificat client "nickname" (SDK Netscape)</li>
      <li>CERT_PFX - certificat client codé en PKCS#12 (SDK Novell)</li>
      <li>KEY_DER - clé privée codée en binaire DER</li>
      <li>KEY_BASE64 - clé privée codée en PEM</li>
      <li>KEY_PFX - clé privée codée en PKCS#12 (SDK Novell)</li>
    </ul>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPTrustedClientCert</name>
<description>Définit le nom de fichier contenant un certificat client ou
un alias renvoyant vers un certificat client spécifique à une connexion.
Tous les SDK LDAP ne supportent pas les certificats clients par
connexion.</description>
<syntax>LDAPTrustedClientCert <var>type</var>
<var>chemin/nom-fichier/alias</var> <var>[mot de passe]</var></syntax>
<contextlist><context>server config</context><context>virtual
host</context><context>directory</context><context>.htaccess</context></contextlist>

<usage>
    <p>Cette directive permet de spécifier le chemin et le nom de
    fichier ou l'alias d'un certificat client par connexion utilisé lors
    de l'établissement d'une connexion SSL ou TLS avec un serveur LDAP.
    Les sections directory ou location peuvent posséder leurs propres
    configurations de certificats clients. Certains SDK LDAP (en
    particulier Novell) ne supportent pas les certificats clients par
    connexion, et renvoient une erreur lors de la connexion au serveur
    LDAP si vous tenter d'utiliser cette directive (Utilisez à la place
    la directive LDAPTrustedGlobalCert pour les certificats clients sous
    Novell - Voir plus haut le guide des certificats SSL/TLS pour plus
    de détails). Le paramètre type spécifie le type du certificat en
    cours de définition, en fonction du SDK LDAP utilisé. Les types
    supportés sont :</p>
    <ul>
      <li>CA_DER - certificat de CA codé en binaire DER</li>
      <li>CA_BASE64 - certificat de CA codé en PEM</li>
      <li>CERT_DER - certificat client codé en binaire DER</li>
      <li>CERT_BASE64 - certificat client codé en PEM</li>
      <li>CERT_NICKNAME - certificat client "nickname" (SDK Netscape)</li>
      <li>KEY_DER - clé privée codée en binaire DER</li>
      <li>KEY_BASE64 - clé privée codée en PEM</li>
    </ul>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPTrustedMode</name>
<description>Spécifie le mode (SSL ou TLS) à utiliser lors de la
connexion à un serveur LDAP.</description>
<syntax>LDAPTrustedMode <var>type</var></syntax>
<contextlist><context>server config</context><context>virtual
host</context></contextlist>

<usage>
    <p>Les modes suivants sont supportés :</p>
    <ul>
      <li>NONE - aucun chiffrement</li>
      <li>SSL - chiffrement ldaps:// sur le port par défaut 636</li>
      <li>TLS - chiffrement STARTTLS sur le port par défaut 389</li>
    </ul>

    <p>Les modes ci-dessus ne sont pas supportés par tous les SDK LDAP.
    Un message d'erreur sera généré à l'exécution si un mode n'est pas
    supporté, et la connexion au serveur LDAP échouera.
    </p>

    <p>Si une URL de type ldaps:// est spécifiée, le mode est forcé à
    SSL et la définition de LDAPTrustedMode est ignorée.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPConnectionTimeout</name>
<description>Spécifie le délai d'attente en secondes de la socket de
connexion</description>
<syntax>LDAPConnectionTimeout <var>secondes</var></syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive configure l'option LDAP_OPT_NETWORK_TIMEOUT (ou
    LDAP_OPT_CONNECT_TIMEOUT) dans la bibliothèque client LDAP
    sous-jacente, si elle est disponible. Cette valeur représente la
    durée pendant laquelle la bibliothèque client LDAP va attendre que
    le processus de connexion TCP au serveur LDAP soit achevé.</p>

    <p>Si la connexion n'a pas réussi avant ce délai, une erreur sera
    renvoyée, ou la bibliothèque client LDAP tentera de se connecter à
    un second serveur LDAP, s'il en a été défini un (via une liste de
    noms d'hôtes séparés par des espaces dans la directive <directive
    module="mod_authnz_ldap">AuthLDAPURL</directive>).</p>

    <p>La valeur par défaut est 10 secondes, si la bibliothèque client
    LDAP liée avec le serveur supporte l'option
    LDAP_OPT_NETWORK_TIMEOUT.</p>

    <note>LDAPConnectionTimeout n'est disponible que si la bibliothèque client
    LDAP liée avec le serveur supporte l'option
    LDAP_OPT_NETWORK_TIMEOUT (ou LDAP_OPT_CONNECT_TIMEOUT), et le
    comportement final est entièrement dicté par la bibliothèque client
    LDAP.
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPTimeout</name>
<description>Spécifie le délai d'attente pour les opérations de
recherche et d'identification LDAP en secondes</description>
<syntax>LDAPTimeout <var>secondes</var></syntax>
<default>LDAPTimeout 60</default>
<contextlist><context>server config</context></contextlist>
<compatibility>Disponible à partir de la version 2.3.5 du serveur HTTP
Apache</compatibility>

<usage>
    <p>Cette directive permet de spécifier le délai d'attente pour les
    opérations de recherche et d'identification, ainsi que l'option
    LDAP_OPT_TIMEOUT dans la bibliothèque LDAP client sous-jacente,
    lorsqu'elle est disponible.</p>

    <p>Lorsque le délai est atteint, httpd va refaire un essai dans le
    cas où une connexion existante a été silencieusement fermée par un
    pare-feu. Les performances seront cependant bien meilleures si le
    pare-feu est configuré pour envoyer des paquets TCP RST au lieu de
    rejeter silencieusement les paquets.</p>

    <note>
    <p>Les délais pour les opérations de comparaison LDAP nécessitent un
    SDK avec LDAP_OPT_TIMEOUT, comme OpenLDAP &gt;= 2.4.4.</p>
    </note>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPVerifyServerCert</name>
<description>Force la vérification du certificat du
serveur</description>
<syntax>LDAPVerifyServerCert <var>On|Off</var></syntax>
<default>LDAPVerifyServerCert On</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de spécifier s'il faut forcer la
    vérification d'un certificat de serveur lors de l'établissement
    d'une connexion SSL avec un serveur LDAP.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPConnectionPoolTTL</name>
<description>Désactive les connexions d'arrière-plan qui sont restées
inactives trop longtemps au sein du jeu de connexions.</description>
<syntax>LDAPConnectionPoolTTL <var>n</var></syntax>
<default>LDAPConnectionPoolTTL -1</default>
<contextlist><context>server config</context><context>virtual host</context></contextlist>
<compatibility>Disponible à partir de la version 2.3.12 du serveur HTTP
Apache</compatibility>

<usage>
    <p>Cette directive permet de spécifier la durée maximale, en
    secondes, pendant laquelle une connexion LDAP du jeu de connexions
    peut demeurer inactive, mais rester quand-même disponible pour une
    utilisation éventuelle. Le jeu de connexions est nettoyé au fur et à
    mesure des besoins, de manière non asynchrone.</p>

    <p>Si cette directive est définie à 0, les connexions ne sont jamais
    sauvegardées dans le jeu de connexions d'arrière-plan. Avec la
    valeur par défaut -1, ou toute autre valeur négative, les connexions
    peuvent être réutilisées sans limite de durée.</p>

    <p>Dans le but d'améliorer les performances, le temps de référence
    qu'utilise cette directive correspond au moment où la connexion LDAP
    est enregistrée ou remise dans le jeu de connexions, et non au
    moment du dernier échange réussi avec le serveur LDAP.</p>

    <p>La version 2.4.10 a introduit de nouvelles mesures permettant
    d'éviter une augmentation excessive du temps de référence due à des
    correspondances positives dans le cache ou des requêtes lentes. A
    cet effet, le temps de référence n'est pas réactualisé si aucune
    connexion LDAP d'arrière-plan n'est requise ; d'autre part, le temps
    de référence se base sur le moment où la requête HTTP est reçue, et
    non sur le moment où la requête a été traitée.</p>

    <note><p>Cette durée de vie s'exprime par défaut en secondes, mais
    il est possible d'utiliser d'autres unités en ajoutant un suffixe :
    millisecondes (ms), minutes (min), ou heures (h).
    </p></note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LDAPLibraryDebug</name>
<description>Active le débogage dans le SDK LDAP</description>
<syntax>LDAPLibraryDebug <var>7</var></syntax>
<default>disabled</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Active les options de débogage LDAP spécifiques au SDK, qui
    entraînent en général une journalisation d'informations verbeuses du
    SDK LDAP dans le journal principal des erreurs d'Apache. Les
    messages de traces en provenance du SDK LDAP fournissent des
    informations très détaillées qui peuvent s'avérer utiles lors du
    débogage des problèmes de connexion avec des serveurs LDAP
    d'arrière-plan.</p>

    <p>Cette option n'est configurable que lorsque le serveur HTTP
    Apache est lié avec un SDK LDAP qui implémente
    <code>LDAP_OPT_DEBUG</code> ou <code>LDAP_OPT_DEBUG_LEVEL</code>,
    comme OpenLDAP (une valeur de 7 est verbeuse) ou Tivoli Directory
    Server (une valeur de 65535 est verbeuse).</p>

    <note type="warning">
    <p>Les informations journalisées peuvent contenir des données
    d'authentification en clair utilisées ou validées lors de
    l'authentification LDAP ; vous devez donc prendre soin de protéger
    et de purger le journal des erreurs lorsque cette directive est
    utilisée.</p>
    </note>

</usage>
</directivesynopsis>

</modulesynopsis>
