<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1855818 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_log_config.xml.meta">

<name>mod_log_config</name>
<description>Journalisation des requêtes envoyées au
serveur</description>
<status>Base</status>
<sourcefile>mod_log_config.c</sourcefile>
<identifier>log_config_module</identifier>

<summary>
    <p>Ce module apporte une grande souplesse dans la journalisation des
    requêtes des clients. Les journaux sont écrits sous un format
    personnalisable, et peuvent être enregistrés directement dans un
    fichier, ou redirigés vers un programme externe. La journalisation
    conditionnelle est supportée, si bien que des requêtes individuelles
    peuvent être incluses ou exclues des journaux en fonction de leur
    caractéristiques.</p>

    <p>Ce module fournit trois directives : <directive
    module="mod_log_config">TransferLog</directive> crée un fichier
    journal, <directive module="mod_log_config">LogFormat</directive>
    définit un format personnalisé, et <directive module="mod_log_config"
    >CustomLog</directive> définit un fichier journal et un format en
    une seule étape. Pour journaliser les requêtes dans plusieurs
    fichiers, vous pouvez utiliser plusieurs fois les directives
    <directive>TransferLog</directive> et
    <directive>CustomLog</directive> dans chaque serveur.</p>
</summary>
<seealso><a href="../logs.html">Les fichiers journaux
d'Apache</a></seealso>

<section id="formats"><title>Formats de journaux personnalisés</title>

    <p>L'argument format des directives <directive
    module="mod_log_config">LogFormat</directive> et <directive
    module="mod_log_config">CustomLog</directive> est une chaîne de
    caractères. Cette chaîne définit le format de la journalisation des
    requêtes dans le fichier journal. Elle peut contenir des caractères
    littéraux qui seront reproduits dans le fichier journal, et les
    caractères de contrôle de style C "\n" et "\t" représentant
    respectivement une nouvelle ligne et une tabulation. Les guillemets
    et les anti-slashes littéraux doivent être échappés à l'aide
    d'anti-slashes.</p>

    <p>Les caractéristiques de la requête en elle-même sont journalisées
    en insérant des directives "<code>%</code>" dans la chaîne de
    format, celles-ci étant remplacées dans le fichier journal par
    certaines valeurs comme suit :</p>

    <table border="1" style="zebra">
    <columnspec><column width=".2"/><column width=".8"/></columnspec>
    <tr><th>Chaîne&nbsp;de&nbsp;format</th>
        <th>Description</th></tr>

    <tr><td><code>%%</code></td>
        <td>Le signe "pourcentage"</td></tr>

    <tr><td><code>%a</code></td>
        <td>L'adresse IP distante (voir le module
	<module>mod_remoteip</module>).</td></tr>

    <tr><td><code>%{c}a</code></td>
        <td>Adresse IP distante de la connexion(voir le module
	<module>mod_remoteip</module>)</td></tr>

    <tr><td><code>%A</code></td>
        <td>L'adresse IP locale</td></tr>

    <tr><td><code>%B</code></td>
        <td>La taille de la réponse en octets, en excluant les en-têtes
	HTTP.</td></tr>

    <tr><td><code>%b</code></td>
        <td>La taille de la réponse en octets, en excluant les en-têtes
	HTTP. Au format CLF , c'est à dire un '<code>-</code>' à la
	place d'un 0 lorsqu'aucun octet n'est renvoyé.</td></tr>

    <tr><td><code>%{<var>NOMVAR</var>}C</code></td>
        <td>Le contenu du cookie <var>NOMVAR</var> dans la requête
	envoyée au serveur. Seuls les cookies version 0 sont pleinement
	supportés.</td></tr>

    <tr><td><code>%D</code></td>
        <td>Le temps mis à servir la requête, en
	microsecondes.</td></tr>

    <tr><td><code>%{<var>NOMVAR</var>}e</code></td>
        <td>Le contenu de la variable d'environnement
	<var>NOMVAR</var></td></tr>

    <tr><td><code>%f</code></td>
        <td>Nom de fichier</td></tr>

    <tr><td><code>%h</code></td>
        <td>Serveur distant. Contiendra l'adresse IP si la directive
	<directive module="core">HostnameLookups</directive> est définie
	à <code>Off</code>, ce qui est sa valeur par défaut. Si cette
	adresse IP n'est enregistrée que pour certains serveurs, vous
	avez probablement défini des directives de contrôle d'accès qui
	mentionnent ces derniers par leurs noms. Voir la <a
        href="mod_authz_host.html#reqhost">documentation de Require
	host</a>.</td></tr>

    <tr><td><code>%{c}h</code></td>
	<td>Semblable à <code>%h</code>, mais exploite toujours le nom d'hôte de
	la connection TCP sous-jacente, en ignorant toute modification réalisée
	sur le nom d'hôte distant par des modules tels que
	<module>mod_remoteip</module>.</td></tr>	

    <tr><td><code>%H</code></td>
        <td>Le protocole de la requête</td></tr>

    <tr><td><code>%{<var>NOMVAR</var>}i</code></td>
        <td>Le contenu des lignes d'en-tête
	<code><var>NOMVAR</var>:</code> dans la requête envoyée au
	serveur. Ces en-têtes sont ajoutés par d'autres modules (par
	exemple <module>mod_headers</module>). Si vous êtes intéressé
	par ce qu'était l'en-tête de la requête avant d'être modifié
	par la plupart des modules, utilisez
	<module>mod_setenvif</module> pour copier l'en-tête dans une
	variable d'environnement interne et journaliser sa valeur via
	le champ <code>%{<var>VARNAME</var>}e</code> décrit plus haut.

        </td></tr>

    <tr><td><code>%k</code></td>
        <td>Nombre de requêtes persistantes en cours pour cette
	connexion. Interessant si la directive <directive
	module="core">KeepAlive</directive> est utilisée ; par exemple,
	'1' signifie la première requête après la requête initiale, '2'
	la seconde, etc... ; autrement, il s'agit toujours de 0
	(indiquant la requête initiale).</td></tr>

    <tr><td><code>%l</code></td>
        <td>Le nom de connexion distant (en provenance d'identd, si
	disponible). Affiche un tiret, sauf si
	<module>mod_ident</module> est présent et si <directive
        module="mod_ident">IdentityCheck</directive> est à
	<code>On</code>.</td></tr>

    <tr><td><code>%L</code></td>
        <td>L'identifiant du message de journalisation de la requête
	dans le journal des erreurs (ou '-' si aucun message n'a
	été enregistré dans le journal des erreurs pour cette requête)</td></tr>

    <tr><td><code>%m</code></td>
        <td>La méthode de la requête</td></tr>

    <tr><td><code>%{<var>NOMVAR</var>}n</code></td>
        <td>Le contenu de la note <var>NOMVAR</var> en provenance d'un
	autre module.</td></tr>

    <tr><td><code>%{<var>NOMVAR</var>}o</code></td>
        <td>Le contenu de la ligne d'en-tête
	<code><var>NOMVAR</var>:</code> de la réponse.</td></tr>

    <tr><td><code>%p</code></td>
        <td>Le port canonique du serveur servant la requête</td></tr>

    <tr><td><code>%{<var>format</var>}p</code></td>
        <td>Le port canonique du serveur servant la requête ou le
	véritable port du serveur ou le véritable port du client. les
	formats valides sont <code>canonical</code>, <code>local</code>,
	ou <code>remote</code>.
        </td></tr>

    <tr><td><code>%P</code></td>
        <td>Le numéro de processus du processus enfant qui a servi la
	requête.</td></tr>

    <tr><td><code>%{<var>format</var>}P</code></td>
        <td>Le numéro de processus ou le numéro de thread du processus
	enfant qui a servi la requête. Les formats valides sont
	<code>pid</code>, <code>tid</code>, et <code>hextid</code>.
	<code>hextid</code> nécessite APR version 1.2.0 ou supérieure.
        </td></tr>

    <tr><td><code>%q</code></td>
        <td>La chaîne d'arguments (préfixée par un <code>?</code> si une
	chaîne d'arguments existe, sinon une chaîne vide)</td></tr>

    <tr><td><code>%r</code></td>
        <td>La première ligne de la requête</td></tr>

    <tr><td><code>%R</code></td>
        <td>Le gestionnaire qui génère la réponse (s'il y en a un).</td></tr>

    <tr><td><code>%s</code></td>
        <td>Statut. Pour les requêtes redirigées en interne, il s'agit
	du statut de la requête *originale* --- <code>%&gt;s</code> pour
	la dernière.</td></tr>

    <tr><td><code>%t</code></td>
        <td>Date à laquelle la requête a été reçue (au format anglais
	standard)</td></tr>

    <tr><td><code>%{<var>format</var>}t</code></td>
        <td>La date, sous la forme spécifiée par format, qui devrait
	être au format étendu <code>strftime(3)</code> (éventuellement
	localisé). Si le format commence par <code>begin:</code> (valeur
	par défaut), la date est extraite au début du traitement de la
	requête ; s'il commence par <code>end:</code>, la date
	correspond au moment où l'entrée du journal est inscrite, par
	conséquent vers la fin du traitement de la requête. Hormis les
	formats supportés par <code>strftime(3)</code>, les formats
	suivants sont aussi disponibles :
        <table>
        <tr><td><code>sec</code></td><td>nombre de secondes depuis Epoch</td></tr>
        <tr><td><code>msec</code></td><td>nombre de millisecondes depuis  Epoch</td></tr>
        <tr><td><code>usec</code></td><td>nombre de microsecondes depuis Epoch</td></tr>
        <tr><td><code>msec_frac</code></td><td>fraction de milliseconde</td></tr>
        <tr><td><code>usec_frac</code></td><td>fraction de microseconde</td></tr>
        </table>
        Ces symboles ne peuvent pas être combinés entre eux ou avec un
	formatage <code>strftime(3)</code> dans la même chaîne de
	format. Par contre, vous pouvez utiliser plusieurs symboles
	<code>%{<var>format</var>}t</code>.</td></tr>

    <tr><td><code>%T</code></td>
        <td>Le temps mis pour servir la requête, en secondes.</td></tr>

    <tr><td><code>%{<var>UNIT</var>}T</code></td>
        <td>Le temps mis pour traiter la requête dans une unité définie
	par <code>UNIT</code>. Les valeurs d'unité valides sont
	<code>ms</code> pour millisecondes, <code>us</code> pour
	microsecondes et <code>s</code> pour secondes. Si
	<code>UNIT</code> est omis, la valeur de l'unité par défaut est
	la seconde ; spécifier la valeur d'unité <code>us</code> revient
	à utiliser le format <code>%D</code>. La possibilité de
	spécifier une valeur d'unité avec le format <code>%T</code> est
	disponible depuis la version 2.4.13 du serveur HTTP Apache.</td></tr>	

    <tr><td><code>%u</code></td>
        <td>L'utilisateur distant (en provenance d'auth ; peut être faux
	si le statut de retour (<code>%s</code>) est 401).</td></tr>

    <tr><td><code>%U</code></td>
        <td>Le chemin de la requête, à l'exclusion de toute chaîne
	d'arguments.</td></tr>

    <tr><td><code>%v</code></td>
        <td>Le nom canonique du serveur qui a servi la requête, défini
	par la directive <directive
	module="core">ServerName</directive>.</td></tr>

    <tr><td><code>%V</code></td>
        <td>La nom du serveur en tenant compte de la définition de la
	directive <directive module="core"
        >UseCanonicalName</directive>.</td></tr>

    <tr><td><code>%X</code></td>
        <td>Statut de la connexion lorsque la réponse a été renvoyée
	:

        <table>
        <columnspec><column width=".2"/><column width=".6"/></columnspec>
        <tr><td><code>X</code> =</td>
            <td>connexion abandonnée avant l'envoi de la réponse.</td></tr>
        <tr><td><code>+</code> =</td>
            <td>la connexion peut rester ouverte après l'envoi de la
	    réponse.</td></tr>
        <tr><td><code>-</code> = </td>
            <td>la connexion sera fermée après l'envoi de la
	    réponse.</td></tr>
        </table>

        </td></tr>

    <tr><td><code>%I</code></td>
        <td>Le nombre d'octets reçus, en comptant la requête et les
	en-têtes, ne peut être nul. Nécessite l'activation de
	<module>mod_logio</module>.</td></tr>

    <tr><td><code>%O</code></td>
        <td>Nombre d'octets envoyés, y compris les en-têtes. Peut être
	nul dans les rares cas où une requête est avortée avant que la
	réponse ne soit envoyée. Nécessite l'activation de
	<module>mod_logio</module>.</td></tr>

    <tr><td><code>%S</code></td>
        <td>Nombre d'octets transmis (en émission et réception), y
	compris corps et en-têtes de requête. Ce nombre ne peut pas être
	nul, et il correspond à la combinaison des formats %I et %O.
	<module>mod_logio</module> doit être chargé pour pouvoir
	utiliser ce format.</td></tr>
	
    <tr><td><code>%{<var>VARNAME</var>}^ti</code></td>
        <td>Le contenu de <code><var>VARNAME</var>:</code> dans les
	paramètres de la requête envoyée au serveur.</td></tr>

    <tr><td><code>%{<var>VARNAME</var>}^to</code></td>
        <td>Le contenu de <code><var>VARNAME</var>:</code> dans les
	paramètres de la réponse envoyée par le serveur.</td></tr>

    </table>

    <section id="modifiers"><title>Modificateurs</title>

      <p>Il est possible de restreindre l'enregistrement de certains
      éléments
      en fonction du code de statut de la réponse, en insérant une liste
      de codes de statut séparés par des virgules immédiatement après le
      caractère "%". Par exemple, <code>"%400,501{User-agent}i"</code>
      n'enregistrera l'en-tête <code>User-agent</code> que dans le cas
      d'une erreur 400 ou 501. Avec les autres codes de statut, c'est la
      chaîne littérale <code>"-"</code> qui sera enregistrée. La liste
      de codes peut être précédée d'un "<code>!</code>" pour inverser la
      condition : <code>"%!200,304,302{Referer}i"</code> enregistre
      l'en-tête <code>Referer</code> pour toutes les requêtes qui
      <em>ne</em> renvoient <em>pas</em> un des trois codes spécifiés.</p>

      <p>Les modificateurs "&lt;" et "&gt;" peuvent être utilisés pour
      les requêtes qui ont été redirigées en interne afin de choisir si
      c'est respectivement la requête originale ou finale qui doit être
      consultée. Par défaut, les directives <code>%s, %U, %T, %D,</code>
      et <code>%r</code> consultent la requête originale, alors que
      toutes les autres consultent la requête finale. Ainsi, par
      exemple, on peut utiliser <code>%&gt;s</code> pour enregistrer le
      statut final de la requête, et <code>%&lt;u</code> pour
      enregistrer l'utilisateur authentifié à l'origine pour une requête
      redirigée en interne vers une ressource sans authentification.</p>

    </section>

    <section id="format-notes"><title>Quelques Notes</title>

      <p>Pour des raisons de sécurité, à partir de la version 2.0.46,
      les caractères non imprimables et autres caractères spéciaux dans
      les directives <code>%r</code>, <code>%i</code> et <code>%o</code>
      doivent être échappés à l'aide des séquences
      <code>\x<var>hh</var></code>,
      où <var>hh</var> est le code hexadécimal du caractère spécial.
      Comme exceptions à cette règle, les caractères <code>"</code> et
      <code>\</code> doivent être échappés par un anti-slash, et tous
      les "blancs" doivent être écrits selon leur notation de style C
      (<code>\n</code>, <code>\t</code>, etc...). Avant la version
      2.0.46, aucun échappement n'était effectué sur ces chaînes, et il
      fallait être très prudent lors de l'exploitation des journaux
      bruts.</p>

      <p>A la différence de la version 1.3, depuis httpd 2.0, les chaînes
      de format <code>%b</code> et <code>%B</code> ne représentent pas
      le nombre d'octets envoyés au client, mais simplement la taille en
      octets de la réponse HTTP (les deux étant différents, par exemple,
      si la connexion est abandonnée, ou si SSL est utilisé). Le format
      <code>%O</code> fourni par <module>mod_logio</module>,
      enregistrera le nombre réel d'octets envoyés sur le réseau.</p>

      <p>Note : <module>mod_cache</module> est implémenté en tant que
      gestionnaire basique et non en tant que gestionnaire standard.
      C'est pourquoi la chaîne de format <code>%R</code> ne renverra pas
      d'information à propos du gestionnaire lorsqu'une mise en cache de
      contenu entre en jeu.</p>

    </section>

    <section id="examples"><title>Exemples</title>

      <p>Quelques chaînes de format couramment utilisées :</p>

      <dl>
        <dt>Format de journal courant (CLF)</dt>
        <dd><code>"%h %l %u %t \"%r\" %&gt;s %b"</code></dd>

        <dt>Format de journal courant avec un serveur virtuel</dt>
        <dd><code>"%v %h %l %u %t \"%r\" %&gt;s %b"</code></dd>

        <dt>Format de journal NCSA étandu/combiné</dt>
        <dd><code>"%h %l %u %t \"%r\" %&gt;s %b \"%{Referer}i\"
        \"%{User-agent}i\""</code></dd>

        <dt>Format de journal de la page qui contient le lien vers la
	page concernée (Referer)</dt>
        <dd><code>"%{Referer}i -&gt; %U"</code></dd>

        <dt>Format de journal de l'agent (Navigateur)</dt>
        <dd><code>"%{User-agent}i"</code></dd>
      </dl>

      <p>Vous pouvez utiliser plusieurs fois la directive
      <code>%{format}t</code> pour construire un format de temps
      utilisant les symboles de format étendus tels que
      <code>msec_frac</code> :</p>
      <dl>
<dt>Format de temps prenant en compte les milisecondes</dt>
<dd><code>"%{%d/%b/%Y %T}t.%{msec_frac}t %{%z}t"</code></dd>

      </dl>

    </section>
</section>

<section id="security"><title>Considérations concernant la
sécurité</title>
    <p>Voir le document <a
    href="../misc/security_tips.html#serverroot">conseils à matière de
    sécurité</a> pour plus de détails sur les raisons pour lesquelles
    votre sécurité pourrait être compromise, si le répertoire où sont
    stockés les fichiers journaux sont inscriptibles par tout autre
    utilisateur que celui qui démarre le serveur.</p>
</section>

<directivesynopsis>
<name>BufferedLogs</name>
<description>Enregistre les entrées du journal dans un tampon en mémoire
avant de les écrire sur disque</description>
<syntax>BufferedLogs On|Off</syntax>
<default>BufferedLogs Off</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Lorsque la directive <directive>BufferedLogs</directive> est à
    "on", <module>mod_log_config</module> stocke de nombreuses entrées
    du journal en mémoire, et les écrit d'un seul bloc sur disque,
    plutôt que de les écrire après chaque requête. Sur certains
    systèmes, ceci peut améliorer l'efficacité des accès disque, et par
    conséquent les performances. La directive ne peut être définie
    qu'une seule fois pour l'ensemble du serveur ; elle ne peut pas être
    définie au niveau d'un serveur virtuel.</p>

    <note>Cette directive doit être utilisée avec
    précautions car un crash peut provoquer la perte de données de
    journalisation.</note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CookieLog</name>
<description>Définit le nom du fichier pour la journalisation des
cookies</description>
<syntax>CookieLog <var>nom-fichier</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>
<compatibility>Cette directive est obsolète.</compatibility>

<usage>
    <p>La directive <directive>CookieLog</directive> permet de définir
    le nom du fichier pour la journalisation des cookies. Le nom du
    fichier est relatif au répertoire défini par la directive <directive
    module="core">ServerRoot</directive>. Cette directive n'est présente
    qu'à des fins de compatibilité avec with <code>mod_cookies</code>,
    et est obsolète.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CustomLog</name>
<description>Définit le nom et le format du fichier
journal</description>
<syntax>CustomLog  <var>fichier</var>|<var>pipe</var>
<var>format</var>|<var>alias</var>
[env=[!]<var>variable-environnement</var>|
expr=<var>expression</var>]</syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>CustomLog</directive> permet de contrôler
    la journalisation des requêtes destinées au serveur. Un format de
    journal est spécifié, et la journalisation peut s'effectuer de
    manière conditionnelle en fonction des caractéristiques de la
    requête en utilisant des variables d'environnement.</p>

    <p>Le premier argument, qui spécifie l'emplacement où les journaux
    seront écrits, accepte deux types de valeurs :</p>

    <dl>
      <dt><var>fichier</var></dt>
      <dd>Un nom de fichier, relatif au répertoire défini par la
      directive <directive module="core">ServerRoot</directive>.</dd>

      <dt><var>pipe</var></dt>
      <dd>Le caractère pipe "<code>|</code>", suivi du chemin vers un
      programme qui recevra les informations de la journalisation sur
      son entrée standard. Voir les notes à propos de la <a
      href="../logs.html#piped">journalisation redirigée</a> pour plus
      d'informations.

      <note type="warning"><title>Sécurité :</title>
      <p>Si les journaux sont redirigés vers un programme, ce dernier
      s'exécutera sous l'utilisateur qui a démarré
      <program>httpd</program>. Ce sera l'utilisateur root si le serveur
      a été démarré par root ; vérifiez que le programme est
      sécurisé.</p>
      </note>
      <note type="warning"><title>Note</title>
        <p>Lors de la spécification d'un chemin de fichier sur les
	plate-formes non-Unix, il faut prendre soin de ne pas oublier
	que seuls les slashes directs doivent être utilisés, même si la
	plate-forme autorise l'emploi d'anti-slashes. D'une manière
	générale, c'est une bonne idée que de n'utiliser que des slashes
	directs dans les fichiers de configuration.</p>
      </note></dd>
    </dl>

    <p>Le second argument permet de définir ce qui va être écrit dans le
    fichier journal. Il peut contenir soit un <var>alias</var> prédéfini
    par une directive <directive
    module="mod_log_config">LogFormat</directive>, soit une chaîne de
    <var>format</var> explicite comme décrit dans la section <a
    href="#formats">formats de journaux</a>.</p>

    <p>Par exemple, les deux blocs de directives suivants produisent le
    même effet :</p>

    <highlight language="config">
# Journal personnalisé avec alias de format
LogFormat "%h %l %u %t \"%r\" %&gt;s %b" common
CustomLog "logs/access_log" common

# Journal personnalisé avec chaîne de format explicite
CustomLog "logs/access_log" "%h %l %u %t \"%r\" %&gt;s %b"
    </highlight>

    <p>Le troisième argument est optionnel et permet de contrôler si une
    requête doit être ou non journalisée. Dans le cas d'une clause
    '<code>env=!<var>nom</var></code>', la condition peut être la
    présence ou l'absence d'une variable particulière dans
    l'<a href="../env.html">environnement du serveur</a>. Dans le cas
    d'une clause 'expr=<var>expression</var>', la condition consiste
    en une <a href="../expr.html">expression</a> booléenne
    quelconque. Si la condition n'est pas vérifiée, la requête ne sera
    pas journalisée. D'éventuelles références à des en-têtes HTTP dans
    l'expression rationnelle n'entraîneront pas l'ajout des noms
    d'en-tête correspondants à l'en-tête Vary.</p>

    <p>Les variables d'environnement peuvent être définies au niveau de
    chaque requête en utilisant les modules
    <module>mod_setenvif</module> et/ou <module>mod_rewrite</module>.
    Par exemple, si vous voulez enregistrer les requêtes pour toutes les
    images GIF sur votre serveur dans un fichier journal séparé, et pas
    dans votre journal principal, vous pouvez utiliser :</p>

    <highlight language="config">
SetEnvIf Request_URI \.gif$ gif-image
CustomLog "gif-requests.log" common env=gif-image
CustomLog "nongif-requests.log" common env=!gif-image
    </highlight>

    <p>Ou, pour reproduire le comportement de l'ancienne directive
    RefererIgnore, vous pouvez utiliser :</p>

    <highlight language="config">
SetEnvIf Referer example\.com localreferer
CustomLog "referer.log" referer env=!localreferer
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LogFormat</name>
<description>Décrit un format utilisable dans un fichier
journal</description>
<syntax>LogFormat <var>format</var>|<var>alias</var>
[<var>alias</var>]</syntax>
<default>LogFormat "%h %l %u %t \"%r\" %>s %b"</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive permet de spécifier le format du fichier journal
    des accès.</p>

    <p>La directive <directive>LogFormat</directive> se présente sous
    deux formes. Sous la première forme, qui ne possède qu'un seul
    argument, la directive définit le format qui sera utilisé dans les
    journaux spécifiés par les directives
    <directive>TransferLog</directive> ultérieures. L'argument unique
    peut contenir un <var>format</var> explicite comme décrit dans la
    section <a href="#formats">formats de journaux personnalisés</a>
    ci-dessus. Il peut aussi contenir un <var>alias</var> faisant
    référence à un format de journal prédéfini par une directive
    <directive>LogFormat</directive> comme décrit plus loin.</p>

    <p>Sous sa seconde forme, la directive
    <directive>LogFormat</directive> associe un <var>format</var>
    explicite à un <var>alias</var>. Cet <var>alias</var> peut
    ensuite s'utiliser dans les directives
    <directive>LogFormat</directive> ou <directive
    module="mod_log_config">CustomLog</directive> ultérieures, ce qui
    évite d'avoir à répéter l'ensemble de la chaîne de format. Une
    directive <directive>LogFormat</directive> qui définit un alias
    <strong>ne fait rien d'autre</strong> -- c'est à dire qu'<em>elle ne
    fait que</em> définir l'alias, elle n'applique pas le format et n'en
    fait pas le format par défaut. Par conséquent, elle n'affecte pas
    les directives <directive
    module="mod_log_config">TransferLog</directive> ultérieures. En
    outre, la directive <directive>LogFormat</directive> ne peut pas
    utiliser un alias pour en définir un autre. Notez que l'alias ne
    doit pas contenir de caractère pourcent (<code>%</code>).</p>

    <example><title>Exemple</title>
    <highlight language="config">
      LogFormat "%v %h %l %u %t \"%r\" %&gt;s %b" serveur_virtuel_commun
      </highlight>
    </example>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>TransferLog</name>
<description>Spécifie l'emplacement d'un fichier journal</description>
<syntax>TransferLog <var>fichier</var>|<var>pipe</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive possède exactement les mêmes arguments et produit
    les mêmes effets que la directive <directive
    module="mod_log_config">CustomLog</directive>, à l'exception qu'elle
    ne permet pas de spécifier un format de journal explicite ou la
    journalisation conditionnelle des requêtes. En l'occurrence, le
    format de journal est déterminé par la dernière définition d'une
    directive <directive module="mod_log_config">LogFormat</directive>
    qui ne définit pas d'alias. Si aucun format particulier n'a été
    spécifié, c'est le Common Log Format qui sera utilisé.</p>

    <example><title>Exemple</title>
      <highlight language="config">
LogFormat "%h %l %u %t \"%r\" %&gt;s %b \"%{Referer}i\" \"%{User-agent}i\""
TransferLog logs/access_log
      </highlight>
    </example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>GlobalLog</name>
<description>Définit le nom et le format du fichier journal</description>
<syntax>GlobalLog<var>file</var>|<var>pipe</var>
<var>format</var>|<var>nickname</var>
[env=[!]<var>environment-variable</var>|
expr=<var>expression</var>]</syntax>
<contextlist><context>server config</context>
</contextlist>
<compatibility>Disponible à partir de la version 2.4.19 du serveur HTTP Apache</compatibility>

<usage>

    <p>La directive <directive>GlobalLog</directive> permet de spécifier un
    journal partagé entre le serveur principal et tous les serveurs virtuels
    définis.</p>

    <p>Elle est identique à la directive <directive>CustomLog</directive> à ces
    différences près : </p>
    <ul>
       <li>Elle n'est pas valide dans un contexte de serveur virtuel.</li>
       <li>A la différence d'une directive <directive>CustomLog</directive>
       définie globalement, elle est prise en compte par les serveurs virtuels
       qui définissent leur propre directive <directive>CustomLog</directive>.</li>
    </ul>
</usage>
</directivesynopsis>

</modulesynopsis>
