<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- English Revision: 1875858 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -->

<modulesynopsis metafile="mod_md.xml.meta">
    
    <name>mod_md</name>
    <description>Gestion des domaines au sein des serveurs virtuels et obtention
    de certificats via le protocole ACME
    </description>
    <status>Experimental</status>
    <sourcefile>mod_md.c</sourcefile>
    <identifier>md_module</identifier>
    <compatibility>Disponible à partir de la version 2.4.30 du serveur HTTP
    Apache</compatibility>
    <summary>
        <p>
	Ce module permet de gérer les propriétés courantes des domaines pour un
	ou plusieurs serveurs virtuels. Il fournit deux fonctionnalités
	principales : la première permet la supervision et le renouvellement des
	certificats https: via le protocole ACME (<a
	href="https://tools.ietf.org/html/rfc8555">RFC 8555</a>). Le module
	effectue le renouvellement des certificats avant leur expiration
	afin d'éviter une interruption des services internet. Il est possible de
	monitorer l'état de tous les certificats gérés par mod_md et de configurer
	le serveur de façon à ce qu'il envoie des notifications de
	renouvellement, d'expiration ou d'erreur personnalisées.
	</p><p>
	La seconde fonctionnalité principale fournit une implémentation
	alternative de l'agrafage OCSP, et ceci aussi bien pour les certificats
	gérés par mod_md que pour les certificats que vous gérez vous-même.
	Composant nécessaire pour tout site https, l'agrafage OCSP influence la
	vitesse de chargement des pages et suivant la configuration, la
	disponibilité de ces dernières. Vous trouverez plus de détails dans la section
	agrafage ci-dessous.
        </p><p>
        L'autorité ACME par défaut pour la gestion des certificats est <a
	href="https://letsencrypt.org/">Let's Encrypt</a>, mais il est possible
	de configurer une autre CA si cette dernière supporte le protocole.
        </p>
        
        <p>Exemple de configuration simple :</p>
        
        <note><title>TLS dans un contexte de serveur virtuel</title>
        <highlight language="config">
MDomain example.org

&lt;VirtualHost *:443&gt;
    ServerName example.org
    DocumentRoot htdocs/a

    SSLEngine on
    # aucun certificat spécifié
&lt;/VirtualHost&gt;
        </highlight>
        <p>
            Au démarrage, un serveur ainsi configuré contactera <a
	    href="https://letsencrypt.org/">Let's Encrypt</a> pour demander un
	    certificat pour le domaine considéré. Si Let's Encrypt peut vérifier
	    le propriétaire du domaine, le module obtiendra le certificat et sa
	    chaîne de certification, le stockera dans son système de fichiers
	    (voir la directive <directive
	    module="mod_md">MDStoreDir</directive>) et le proposera au prochain
	    redémarrage à <module>mod_ssl</module>.
        </p><p>
            Ce processus se déroule pendant l'exécution du serveur. Tous les
	    autres serveurs virtuels continueront à fonctionner normalement,
	    mais tant que le certificat ne sera pas disponible, toute requête
	    pour le domaine considéré génèrera une réponse du type '503 Service
	    Unavailable'. 
        </p>
        </note>

        <note><title>Prérequis</title>
        <p>
            Pour pouvoir être utilisé, ce module nécessite le chargement
	    préalable du module <module>mod_watchdog</module>.
        </p><p>
            Pour que Let's Encrypt puisse signer et renouveler votre certificat,
	    votre serveur doit être accessible depuis l'internet public sur le port 80
	    (http:) et/ou 443 (https:), à moins que votre serveur soit configuré
	    pour utiliser les vérifications DNS - pour plus de détails, voir
	    "certificats génériques".
        </p><p>
            Le module choisit une des méthodes proposées par Let's Encrypt. En
	    général, LE propose des méthodes de vérification sur les ports ou le
	    DNS et Apache choisit une des méthodes disponibles.    
        </p><p>
            Pour déterminer quelles méthodes sont disponibles, le module
	    consulte les ports sur lesquels écoute Apache httpd. Si le port 80 en
	    fait partie, le module supposera que la vérification http: nommée
	    http-01 est disponible. Si le port 443 en fait aussi partie, la
	    vérification https: nommée tls-alpn-01 sera ajoutée à la liste des
	    méthodes disponibles. Enfin, si la directive <directive
	    module="mod_md">MDChallengeDns01</directive> est définie, la méthode
	    de vérification dns-01 sera aussi ajoutée. 
        </p><p>
            Si votre configuration est plus complexe, deux méthodes permettent
	    d'orienter ce choix. En premier lieu, voyez du côté de la directive
	    <directive module="mod_md">MDPortMap</directive> si le serveur se
	    trouve derrière un redirecteur de port comme un pare-feu. En second
	    lieu, vous pouvez court-circuiter entièrement le processus de choix
	    du module en définissant directement la directive <directive
	    module="mod_md">MDCAChallenges</directive>.  
        </p>
        </note>

        <note><title>Vérifications https:</title>
        <p>
            Pour la vérification de domaine via le protocole TLS, le nom de la
	    méthode correspondante est "tls-alpn-01". Le serveur Apache doit
	    alors être en écoute sur le port 443 (voir la directive <directive
	    module="mod_md">MDPortMap</directive> si vous redirigez ce port vers
	    un autre).
        </p><p>
            Let's Encrypt ouvrira alors une connexion TLS avec Apache en
	    utilisant l'indicateur spécial "acme-tls/1" (cette portion
	    indication de TLS se nomme ALPN, d'où le nom de la méthode de
	    vérification. ALPN est aussi utilisé par les navigateurs pour ouvrir
	    une connexion HTTP/2.
        </p><p>
            Si vous ne souhaitez cependant qu'aucun de vos sites ne soit
	    accessible sur le port 80, vous pouvez laiser ce dernier ouvert et
	    rediriger toutes les requêtes vers vos sites en https:. Pour
	    ce faire, utilisez la directive <directive
	    module="mod_md">MDRequireHttps</directive> décrite plus loin. Votre
	    serveur pourra alors continuer à répondre au requêtes en http: en
	    provenance de Let's Encrypt.
	    Comme dans le cas du protocole HTTP/2, vous pouvez configurer ceci
	    de la manière suivante :
        </p>
	<highlight language="config">
Protocols h2 http/1.1 acme-tls/1
        </highlight>
        <p>
            La méthode de vérification "tls-alpn-01" sera alors disponible.
	</p>
        </note>
	<note><title>Certificats génériques</title>
        <p>
            Les certificats génériques sont supportés à partir de la version 2.x
	    de mod_md, mais leur obtention n'est pas triviale. Let's Encrypt
	    impose pour ces derniers la vérification "dns-01".
	    Aucune autre n'est considérée comme suffisamment efficace.
        </p><p>
	    Apache ne peut cependant pas implémenter cette vérification de
	    lui-même . Comme son nom l'indique, "dns-01" vous demande de
	    présenter certains enregistrement DNS spécifiques à votre domaine
	    qui doivent contenir certaines données de vérification. Vous devez
	    donc être en mesure d'éditer et modifier les enregistrements DNS de
	    votre domaine.
        </p><p>
            Si c'est le cas, vous pouvez procéder via mod_md. Supposons que vous
	    disposiez pour cela du script /usr/bin/acme-setup-dns ; vous
	    configurez alors Apache comme suit :
        </p>
        <highlight language="config">
MDChallengeDns01 /usr/bin/acme-setup-dns
        </highlight>
        <p>
            Apache fera alors appel à ce script lorsqu'il aura besoin de
	    définir ou détruire un enregistrement DNS de vérification pour le
	    domaine considéré.
        </p><p>
            Supposons ainsi que vous souhaitiez obtenir un certificat pour
	    *.mydomain.com ;  mod_md va appeler :
        </p>
        <highlight language="config">
/usr/bin/acme-setup-dns setup mydomain.com challenge-data
# ceci nécessite de supprimer tout enregistrement DNS TXT pour
# _acme-challenge.mydomain.com et d'en créer un nouveau dont le contenu sera
# "challenge-data"
        </highlight>
        <p>
            il appellera ensuite :
        </p>
        <highlight language="config">
/usr/bin/acme-setup-dns teardown mydomain.com
# ceci nécessite de supprimer tout enregistrement DNS TXT pour
# _acme-challenge.mydomain.com
        </highlight>
        </note>

        <note><title>Monitoring</title>
            <p>Apache possède un module de monitoring standard :
	    <module>mod_status</module>. mod_md y ajoute une section et facilite
	    le monitoring de votre domaine.
            </p><p>
                Vous pouvez alors visualiser tous vos domaines gérés par ordre
		alphabétique, les noms de domaine qu'ils contiennent, un état
		global, les date d'expiration ainsi que des paramètres
		spécifiques. Ces derniers comprennent la périodicité de
		renouvellement que vous avez sélectionnée (ou la valeur par
		défaut), la CA (autorité de certification) utilisée, etc...
            </p><p>
                La colonne "Renewal" montre des rapports d'activité ou d'erreur
		à propos des renouvellements de certificats, ce qui devrait
		faciliter la vie des utilisateurs qui souhaitent savoir si tout
		fonctionne correctement ou si des problèmes se produisent.
            </p><p>
                Si un des domaines gérés provoque une erreur, elle apparaîtra
		aussi ici, ce qui vous permettra de visualiser les éventuels
		problèmes sans devoir vous plonger dans les journaux du serveur.
            </p><p>
                Il existe aussi un nouveau gestionnaire, "md-status", qui peut
		vous fournir les informations à propos des domaines gérés à
		partir de "server-status" et au format JSON. Vous pouvez le
		configurer comme suit sur votre serveur :
            </p>
            <highlight language="config">
&lt;Location "/md-status">
  SetHandler md-status
&lt;/Location>
            </highlight>
            <p>
                Comme pour "server-status", vous devez
		ajouter les autorisations nécessaires. 
            </p><p>
                Si vous ne souhaitez recevoir l'état JSON que pour un domaine
		spécifique, ajoutez le simplement à votre URL d'état :
            </p>
            <highlight language="config">
> curl https://&lt;yourhost>/md-status/another-domain.org
{
  "name": "another-domain.org",
  "domains": [
    "another-domain.org",
    "www.another-domain.org"
  ],
  ...
            </highlight>
            <p>
                Cet état JSON montre aussi un journal des renouvellements de
		certificats :
            </p>
            <highlight language="config">
{
"when": "Wed, 19 Jun 2019 14:45:58 GMT",
"type": "progress", "detail": "The certificate for the managed domain has been renewed successfully and can be used. A graceful server restart now is recommended."
},{
"when": "Wed, 19 Jun 2019 14:45:58 GMT",
"type": "progress", "detail": "Retrieving certificate chain for test-901-003-1560955549.org"
},{
"when": "Wed, 19 Jun 2019 14:45:58 GMT",
"type": "progress", "detail": "Waiting for finalized order to become valid"
},{
"when": "Wed, 19 Jun 2019 14:45:50 GMT",
"type": "progress", "detail": "Submitting CSR to CA for test-901-003-1560955549.org"
},
...
            </highlight>
            <p>
                Vous trouverez aussi ces informations dans le fichier "job.json"
		dans votre répertoire de test et, s'il est activé, dans le
		répertoire des domaines. Vous pourrez ainsi les consulter à tout
		moment. 
            </p><p>
                Enfin, la directive <directive
		module="mod_md">MDCertificateStatus</directive> donne accès au
		informations à propos du certificat spécifié au format JSON.
            </p>
        </note>

	<note><title>Agrafage</title>
            <p>
                Si vous voulez commencer par tester l'agrafage pour un seul
		domaine géré, utilisez cette configuration :
            </p>
            <highlight language="config">
&lt;MDomain mydomain.net>
  MDStapling on
&lt;/MDomain>            
            </highlight>
            <p>
		et utilisez 'server-status' et/ou <directive
		module="mod_md">MDMessageCmd</directive> pour voir comment tout
		cela fonctionne. Vous pourrez alors vérifier si l'information
		d'agrafage est présente, sa durée de validité, son origine et à
		quel moment elle sera rafraîchie.
            </p><p>
                Si tout fonctionne comme vous le souhaitez, vous pouvez définir
		cette configuration pour tous les certificats ou seulement vos
		certificats gérés.
            </p><p>
                De nombreux sites utilisent l'implémentation d'agrafage
		existante de mod_ssl depuis des années. Les implémentations par
		mod-ssl et mod_md présentent deux différences principales :
            </p>
            <ol>
                <li>Lecture des informations à la demande ou de manière planifiée
		: mod_ssl extrait les informations d'agrafage lorsque le besoin
		s'en fait sentir, par exemple lors d'une nouvelle connexion. mod_md
		quant à lui, extrait ces informations au démarrage du serveur et
		lorsqu'elles ont atteint les deux tiers de leur durée de vie.</li>
                <li>Conservation des informations en mémoire ou de manière
		persistante : mod_ssl <em>peut</em> conserver ces informations
		de manière persistante, mais la plupart des configurations
		exemples utilisent un cache en mémoire. mod_md quant à lui,
		stocke systématiquement les informations dans le système de
		fichiers.</li>
            </ol>
            <p>
                Si par malchance vous redémarrez votre serveur alors que le
		service OCSP de votre CA est en panne, les utilisateurs ne
		pourront plus atteindre vos sites. Sans persistance des
		informations, votre serveur n'est plus en mesure de fournir au
		client les données nécessaires, et le navigateur client ne peut
		pas les obtenir lui-même car le service OCSP ne répond pas. 
            </p><p>
                Avec l'implémentation de mod_md, l'information d'agrafage est
		stockée de manière persistante, et elle peut donc être réchargée
		au démarrage du serveur et être ainsi disponible pour les
		connexions entrantes. Un jour ou deux avant expiration des
		informations, mod_md va les renouveler, ce qui permet de faire
		face à un temps d'indisponibilité du service OCSP assez long.
            </p><p>
                Pour conserver une compatibilité ascendante, l'implémentation de
		mod_ssl n'a pas pu être modifiée en profondeur. Par exemple,
		mod_ssl est incapable d'ajouter une dépendance à mod_watchdog
		sans rendre inutilisables de nombreuses configurations
		existantes qui ne chargent pas ce module.
            </p>
        </note>
	
    </summary>
    
    <directivesynopsis>
        <name>MDomain</name>
        <description>Définit une liste de noms de domaines qui appartiennent à
	un groupe.</description>
        <syntax>MDomain <var>dns-name</var> [ <var>other-dns-name</var>... ] [auto|manual]</syntax>
        <contextlist>
            <context>server config</context>
        </contextlist>
        
        <usage>
            <p>
                Tous les domaines de la liste seront gérés par
		mod_md comme un seul domaine géré (Managed Domain - MD).
		mod_md ne demandera qu'un seul certificat qui
		sera valide pour tous ces noms de domaine. Cette directive
		s'utilise au niveau de la configuration globale (voir plus loin
		les autres directives MD). Si un domaine nécessite une
		configuration particulière, utilisez la directive <directive
		module="mod_md" type="section">MDomainSet</directive>.
            </p><p>
		Deux définitions supplémentaires sont nécessaires pour un
		domaine géré : une adresse Email de contact (via <directive
		module="mod_md">MDContactEmail</directive> ou <directive
		module="core">ServerAdmin</directive>) et <directive
		module="mod_md">MDCertificateAgreement</directive>.  L'adresse
		électronique du <directive module="core">ServerAdmin</directive>
		permet de s'enregistrer auprès de l'autorité de certification
		(par défaut Let's Encrypt). L'autorité de certification
		l'utilisera pour vous informer à propos du statut de vos
		certificats ou d'éventuelles modifications de ses services.
            </p><p>
                La seconde définition, <directive
		module="mod_md">MDCertificateAgreement</directive> doit avoir
		pour valeur "accepted". Vous confirmez ainsi que vous acceptez
		les conditions d'utilisation du CA.
            </p>
            <example><title>Exemple</title>
                <highlight language="config">
MDContactEmail admin@example.org
MDCertificateAgreement accepted
MDomain example.org www.example.org

&lt;VirtualHost *:443&gt;
    ServerName example.org
    DocumentRoot htdocs/root

    SSLEngine on
&lt;/VirtualHost&gt;

&lt;VirtualHost *:443&gt;
    ServerName www.example.org
    DocumentRoot htdocs/www

    SSLEngine on
&lt;/VirtualHost&gt;
                </highlight>
            </example>
            <p>
                En plus de la liste des domaines gérés, cette directive accepte
		un paramètre supplémentaire qui peut prendre pour valeur
		'manual' ou 'auto'. Ce paramètre permet de définir si un domaine
		sera géré sous le nom spécifié dans la liste seul ('manual'),
		ou si tous les noms du serveur virtuel correspondant seront
		gérés ('auto'). C'est d'ailleurs cette dernière valeur qui
		est la valeur par défaut.
            </p>
            <example><title>Exemple</title>
                <highlight language="config">
MDomain example.org

&lt;VirtualHost *:443&gt;
    ServerName example.org
    ServerAlias www.example.org
    DocumentRoot htdocs/root

    SSLEngine on
&lt;/VirtualHost&gt;

MDomain example2.org auto

&lt;VirtualHost *:443&gt;
    ServerName example2.org
    ServerAlias www.example2.org
    ...
&lt;/VirtualHost&gt;
                </highlight>
            </example>
	    <p> Dans cet exemple, le domaine 'www.example.org' est
	    automatiquement ajouté à la liste MD 'example.org'. De manière
	    similaire, le domaine 'www.example2.org' sera automatiquement ajouté
	    à la liste MD 'example2.org' pour laquelle 'auto' est explicitement
	    spécifié.  Chaque fois que vous ajouterez des noms à ces serveurs
	    virtuels via ServerAlias, ils seront ajoutés à la liste MD
	    correspondante.
            </p><p>
                Si vous préférez déclarer explicitement tous les noms de
		domaines, utilisez le mode 'manual'. Une erreur sera enregistrée
		dans le journal si les noms ne correspondent pas à ceux
		attendus.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis type="section" idtype="section">
        <name>MDomainSet</name>
        <description>Conteneur de directives à appliquer à un ou plusieurs
	domaines gérés.</description>
        <syntax>&lt;MDomainSet <var>dns-name</var> [ <var>other-dns-name</var>... ]&gt;...&lt;/MDomainSet&gt;</syntax>
        <contextlist>
            <context>server config</context>
        </contextlist>
        
        <usage>
            <p>
		Cette directive est équivalente à la directive <directive
		module="mod_md">MDomain</directive> avec la possibilité
		supplémentaire d'ajouter des paramètres seulement pour le
		domaine géré considéré. En fait, vous pouvez aussi utiliser
		"&lt;MDomain ..>" à titre de raccourci.
            </p>
            <p>
                Cette directive permet de configurer un domaine géré en
		spécifiant un autre CA, ou d'autres paramètres de renouvellement
		des certificats, etc...
            </p>
            <example><title>Exemple</title>
                <highlight language="config">
&lt;MDomain sandbox.example.org&gt;
    MDCertificateAuthority   https://someotherca.com/ACME
&lt;/MDomain&gt;
                </highlight>
            </example>
        <p>
            Cette configuration est souvent utilisée pour définir des paramètres
	    https: spécifiques à votre domaine.
        </p>
            <example><title>Exemple</title>
                <highlight language="config">
&lt;MDomain example.org&gt;
    MDRequireHttps temporary
&lt;/MDomain&gt;
                </highlight>
            </example>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDCertificateAgreement</name>
        <description>Acceptation des conditions d'utilisation de l'autorité de
	certification.</description>
        <syntax>MDCertificateAgreement accepted</syntax>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
	    <p>Lorsque vous utilisez mod_md pour obtenir un certificat, vous
	    devenez un client de l'autorité de certification (par exemple Let's
	    Encrypt).  Cela signifie que vous devez lire et approuver leurs
	    conditions d'utilisation, et donc que vous avez compris ce qu'ils
	    ont à offrir, ce qu'ils ne fournissent pas, et ce que vous devez
	    vous-même fournir.  mod_md ne peut pas de lui-même procéder à cet
	    agrément à votre place.  </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDCertificateAuthority</name>
        <description>L'URL du service ACME de l'autorité de certification.</description>
        <syntax>MDCertificateAuthority <var>url</var></syntax>
        <default>MDCertificateAuthority https://acme-v02.api.letsencrypt.org/directory</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
                L'URL à laquelle l'autorité de certication offre son service
		ACME.
            </p><p>
                Let's Encrypt propose actuellement quatre URLs pour accéder à ce
		service. Deux pour la version précédente du protocole ACME,
		communément appelé ACMEv1, et deux pour la version de la RFC
		8555 nommée ACMEv2.
            </p><p>
                Chaque version possède deux modes de fonctionnement : un mode
		production et un mode test. Le mode test est identique au mode
		production, à la différence près que le certificat ne sera pas
		reconnu par les navigateurs. Il est aussi beaucoup plus souple
		quant aux limitations en performances. Il permet de tester de
		manière répétée le service sans pour autant bloquer votre
		serveur.
            </p>
            <example><title>Configuration pour le mode test de Let's Encrypt</title>
                <highlight language="config">
MDCertificateAuthority https://acme-staging-v02.api.letsencrypt.org/directory
                </highlight>
            </example>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDCertificateProtocol</name>
        <description>Le protocole à utiliser avec l'autorité de certification.</description>
        <syntax>MDCertificateProtocol <var>protocol</var></syntax>
        <default>MDCertificateProtocol ACME</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>Cette directive permet de spécifier le protocole à utiliser.
	    Pour l'heure, seul le protocole <code>ACME</code> est supporté.</p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDDriveMode</name>
        <description>Ancien nom de MDRenewMode.</description>
        <syntax>MDDriveMode always|auto|manual</syntax>
        <default>MDDriveMode auto</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
             <p>Cette directive est l'ancien nom de la directive <directive
	     module="mod_md">MDRenewMode</directive>, et n'est encore supportée
	     qu'à titre de compatibilité ascendante.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDRenewMode</name>
        <description>Contrôle le renouvellement des certificats.</description>
        <syntax>MDRenewMode always|auto|manual</syntax>
        <default>MDRenewMode auto</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
		En mode "auto" (mode par défaut), le module va agir de la
		manière la plus opportune pour chaque domaine géré. Si un
		domaine ne possède pas de certificat, le module en demandera un
		à l'autorité de certification. 
            </p>
            <p>
		Si par contre vous avez défini un domaine géré qui n'est utilisé
		par aucun serveur virtuel, le module n'effectuera aucune demande
		de renouvellement. De même, pour les domaines gérés avec des
		fichiers de certificats statiques (voir <directive
		module="mod_md">MDCertificateFile</directive>), le module
		supposera que vous avez votre propre source et n'effectuera
		aucune demande de renouvellement.
            </p>
            <p>
                Avec le mode "always", le module renouvellera les certificats
		des modules gérés, même s'il ne sont pas utilisés ou
		possèdent un fichier de certificats statique.
            </p>
            <p>
                A l'opposé, avec le mode "manual", mod_md n'effectuera aucune
		demande automatique de renouvellement pour aucun domaine géré.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDHttpProxy</name>
        <description>Spécifie un serveur mandataire pour les connexions
	sortantes.</description>
        <syntax>MDHttpProxy <var>url</var></syntax>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
	    <p>Cette directive permet de spécifier un serveur http mandataire
	    pour se connecter à l'autorité de certification spécifiée via
	    <directive module="mod_md">MDCertificateAuthority</directive>. Vous
	    devez la définir si votre serveur web ne peut atteindre internet que
	    via un serveur mandataire.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDMember</name>
        <description>Nom d'hôte additionnel pour le domaine géré.</description>
        <syntax>MDMember <var>hostname</var></syntax>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
	    Plutôt que de lister tous les noms DNS sur la même ligne, vous
	    pouvez utiliser la directive <directive>MDMember</directive> pour
	    ajouter des noms d'hôte à un domaine géré.
            </p>
            <example><title>Exemple</title>
                <highlight language="config">
&lt;MDomain example.org&gt;
    MDMember www.example.org
    MDMember mail.example.org
&lt;/MDomain&gt;
                </highlight>
            </example>
            <p>
               Si vous utilisez cette directive au niveau de la configuration
	       globale, en dehors de tout serveur virtuel correspondant à un
	       domaine géré, vous ne pouvez spécifier qu'une valeur, 'auto' ou
	       'manual' comme mode par défaut pour tous les autres domaines
	       gérés. Voir la directive <directive
	       module="mod_md">MDomain</directive> pour une description de ces
	       valeurs.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDMembers</name>
        <description>Définit si les alias de noms de domaines sont
	automatiquement ajoutés.</description>
        <syntax>MDMembers auto|manual</syntax>
        <default>MDMembers auto</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>Cette directive permet de définir si les valeurs de <directive
	    module="core">ServerName</directive> et <directive
	    module="core">ServerAlias</directive> sont automatiquement ajoutées
	    en tant que membres d'un domaine géré.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDMustStaple</name>
        <description>Définit si les nouveaux certificats doivent avoir le
	drapeau OCSP Must Staple activé.</description>
        <syntax>MDMustStaple on|off</syntax>
        <default>MDMustStaple off</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>Cette directive permet de définir si les nouveaux certificats
	    doivent avoir le drapeau OCSP Must Staple activé ou non. Si un
	    certificat possède ce drapeau, le serveur devra envoyer une réponse
	    avec agrafage OCSP à chaque client. Ceci ne fonctionne que si vous
	    configurez <module>mod_ssl</module> pour générer cette agrafe (voir la
	    directive <directive module="mod_ssl">SSLUseStapling</directive> et
	    ses directives dérivées).
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDNotifyCmd</name>
        <description>Lance un programme lorsqu'un domaine géré est opérationnel.</description>
        <syntax>MDNotifyCmd <var>path</var> [ <var>args</var> ]</syntax>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>Cette directive permet de définir un programme à lancer lorsqu'un
	    domaine géré a obtenu ou renouvelé son certificat. Ce
	    programme reçoit le nom de domaine géré concerné comme
	    argument additionnel (après les paramètres spécifiés ici). Il doit
	    renvoyer un code d'état de 0 s'il s'est exécuté avec
	    succès.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDPortMap</name>
        <description>Mappage des ports externes avec les ports internes pour
	vérifier à qui appartient le domaine.</description>
        <syntax>MDPortMap <var>map1</var> [ <var>map2</var> ]</syntax>
        <default>MDPortMap http:80 https:443</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
                Le protocole ACME propose deux méthodes pour vérifier à qui
		appartient le domaine via HTTP : la première utilise les URLs en
		"http:" (port 80) et la deuxième les URLs en "https:" (port
		443). Si votre serveur n'est accessible sur aucun
		de ces ports, ACME ne pourra fonctionner que si vous configurez
		votre serveur DNS de manière adéquate (voir la directive <directive
		module="mod_md">MDChallengeDns01</directive>).
            </p><p>
                Sur la plupart des serveurs publics, "http:" arrive sur le
		port 80 et "https:" sur le port 443. Ce module vérifie les ports
		sur lesquels votre serveur Apache est en écoute et suppose
		qu'ils sont disponibles. Autrement dit, si votre serveur n'est
		pas en écoute sur le port 80, le module suppose que les requêtes
		en "http:" en provenance d'internet ne seront pas traitées.
            </p><p>
		Ce raisonnement est légitime, mais il peut s'avérer faux.
		Par exemple, même si votre serveur est effectivement en écoute
		sur le port 80, votre pare-feu peut bloquer ce dernier. "http:"
		ne sera alors disponible que sur votre intranet. Dans ce cas, le
		module va supposer de manière erronée que Let's Encrypt peut
		effectuer des vérifications en "http:" avec votre serveur. Ces
		dernières échouerons car elles auront été rejetées par votre
		pare-feu.
            </p>
            <example><title>Exemple</title>
                <highlight language="config">
MDPortMap http:- https:8433
                </highlight>
            </example>
            <p>
                L'exemple précédent montre comment spécifier que les requêtes en
		"http:" en provenance d'internet n'arriveront jamais. En outre,
		il indique que les requêtes en "https:" arriveront sur le port
		8433.
            </p><p>
		Cette définition peut s'avérer nécessaire si vous faites de la
		redirection de port ; votre serveur peut ainsi être accessible
		depuis l' Internet sur le port 443, alors que le port local
		utilisé par httpd sera différent. Par exemple, votre serveur
		peut n'être en écoute que sur les ports 8443 et 8000, mais
		accessible depuis internet sur les ports 443 et 80.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDPrivateKeys</name>
        <description>Définit le type et la taille des clés privées générées.</description>
        <syntax>MDPrivateKeys <var>type</var> [ <var>params</var>... ]</syntax>
        <default>MDPrivateKeys RSA 2048</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
                Cette directive permet de définir les paramètres de construction
		des clés privées pour les domaines gérés. Seule la valeur 'RSA'
		est à l'heure actuelle supportée pour le paramètre
		<var>type</var>, et le paramètre <var>params</var> spécifie la
		nombre de bits utilisés pour la clé.
            </p><p>
                La recommandation actuelle (en 2017) est de 2048 bits au minimum,
		et une valeur inférieure ne sera pas acceptée. Des valeurs
		supérieures offriront une plus grande sécurité mais seront plus
		gourmandes en ressources, et augmenteront donc la charge de
		votre serveur, ce qui pourra (ou non) être gênant pour vous.
            </p><p>
                D'autres types de clés seront supportés dans le futur.
            </p>
            <example><title>Exemple</title>
                <highlight language="config">
MDPrivateKeys RSA 3072
                </highlight>
            </example>
            <p>
                Notez que cette directive n'aura d'effet que sur les nouvelles
		clés. Toute clé préexistante ne sera pas affectée. En outre,
		seules les clés privées générées pour les certificats sont
		concernées, les clés de comptes ACME n'étant pas affectées.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDRenewWindow</name>
        <description>Définit le moment auquel un certificat doit être renouvelé.</description>
        <syntax>MDRenewWindow <var>duration</var></syntax>
        <default>MDRenewWindow 33%</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
            Lorsqu'un certificat arrive à expiration, mod_md va
	    tenter d'en obtenir un nouveau signé.
            </p><p>
            Normalement, les certificats ont une validité de 90 jours, et
	    mod_md les renouvelle lorsqu'il leur reste 33% de
	    durée de vie (soit 30 jours pour une durée de vie de 90 jours). Si
	    cela ne correspond pas à ce que vous souhaitez, vous pouvez
	    spécifier une autre valeur comme dans les exemples suivants :
            </p>
            <example><title>Exemple</title>
                <highlight language="config">
# 21 jours avant expiration
MDRenewWindow 21d 
# 30 secondes (peut-être un peu juste !)
MDRenewWindow 30s
# lorsqu'il reste 10% de durée de vie au certificat
MDRenewWindow 10%
                </highlight>
            </example>
	    <p>En mode pilotage automatique, le module va vérifier le statut des
	    domaines gérés au moins toutes les 12 heures pour voir s'il y a
	    quelque chose à faire. En cas d'erreur, par exemple lorsque le CA
	    est inaccessible, il va dans un premier temps réessayer après
	    quelques secondes. Si l'erreur persiste, il va réduire son
	    intervalle de vérification de 12 à 1 heure.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDRequireHttps</name>
        <description>Redirige le trafic http: vers https: pour les domaines
	gérés.</description>
        <syntax>MDRequireHttps off|temporary|permanent</syntax>
        <default>MDRequireHttps off</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>Cette directive facilite la migration de vos domaines gérés de
	    http: vers https:. Dans l'exemple suivant,
            </p>
            <example><title>Exemple</title>
                <highlight language="config">
MDRequireHttps temporary                
                </highlight>
            </example>
            <p>vous indiquez que vous désirez que pour l'instant, tout le trafic via des URLs en
	    http: doit être redirigé vers des URLs en https:. Cette directive
	    est sans risque et vous pouvez la désactiver à tout moment.
            </p><p>
                <strong>Ce qui suit par contre, a des conséquences : </strong>si
		vous souhaitez que les clients <strong>n'utilisent plus</strong>
		d'URLs en http:, spécifiez :
            </p>
            <example><title>Permanent (pour au moins 6 mois !)</title>
                <highlight language="config">
MDRequireHttps permanent                
                </highlight>
            </example>
            <p>Cette directive a deux effets :
            </p>
            <ol>
                <li>Toutes les requêtes pour une ressource en <code>http:</code>
		sont redirigées vers la même requête en remplaçant le protocole
		<code>http:</code> par <code>https:</code> et en renvoyant le code
		d'état <code>301</code>. Ce dernier indique aux clients que
		cette modification est permanente et qu'ils doivent mettre à
		jour leurs liens en conséquence.
                </li>
		<li>Toutes les réponses aux requêtes en <code>https:</code>
		comporteront l'en-tête <code>Strict-Transport-Security</code>
		avec une durée de vie de six mois. Cela indique au navigateur
		qu'il ne devra <strong>jamais</strong> utiliser
		<code>http:</code> (pendant six mois) lorsqu'il formulera une
		requête pour le domaine concerné.  Avec cette information, les
		navigateurs refuseront de contacter votre site en mode non
		chiffré. Ceci interdit à des middlewares malicieux de dégrader
		les connexions et d'écouter/manipuler le trafic. C'est une bonne
		chose, mais cette configuration ne peut pas être désactivée
		aussi simplement que la configuration temporaire ci-dessus.
                </li>
            </ol>
            <p>Vous pouvez obtenir le même résultat de manière simple avec
	    <module>mod_alias</module> et une configuration basée sur la
	    directive <directive module="mod_alias">Redirect</directive>. Si
	    vous le faites vous-même, assurez-vous d'exclure les chemins
	    /.well-known/* de votre redirection, sinon mod_md
	    aura des difficultés pour signer les nouveaux certificats.
            </p>
            <p>Si vous effectuez cette configuration au niveau global, elle
	    s'appliquera à tous les domaines gérés. Si vous souhaitez qu'elle ne
	    s'applique qu'à un domaine spécifique, utilisez :
            </p>
            <example><title>Exemple</title>
                <highlight language="config">
&lt;MDomain xxx.yyy&gt;
  MDRequireHttps temporary
&lt;/MDomain&gt;
                </highlight>
            </example>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDStoreDir</name>
	<description>Chemin dans le système de fichiers local du répertoire où
	seront stockées les données à propos des domaines gérés.</description>
        <syntax>MDStoreDir <var>path</var></syntax>
        <default>MDStoreDir md</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
                Cette directive permet de définir le répertoire dans le système
		de fichiers local où seront stockées les données à propos des
		domaines gérés. Il s'agit d'un chemin absolu ou relatif à la
		racine du serveur. Par défaut, le répertoire "md" sera créé à la
		racine de votre serveur.
            </p><p>
		Si vous souhaitez changer de répertoire et si ce dernier
		contient déjà des données, copiez tout d'abord les données vers
		le nouveau répertoire, puis modifier la configuration et
		redémarrez le serveur. Si vous commencez par modifier la
		configuration et redémarrer le serveur sans copier les données,
		ce dernier croira que les certificats sont absents et il tentera
		d'en obtenir de nouveaux.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDCAChallenges</name>
        <description>Type de négociation ACME utilisée pour prouver l'appartenance
	du domaine.</description>
        <syntax>MDCAChallenges <var>name</var> [ <var>name</var> ... ]</syntax>
        <default>MDCAChallenges tls-alpn-01 http-01 dns-01</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
		Cette directive permet de définir les types de négociation
		utilisés (par ordre de préférences) pour prouver l'appartenance
		du domaine. Les types de négociation supportés par le module
		sont 'tls-alpn-01', 'dns-01' et 'http-01'. Le module parcourt
		toute la configuration du serveur pour déterminer quelles
		méthodes peuvent être utilisées.
            </p><p>
		Si par exemple le serveur est en écoute sur le port 80, c'est la
		méthode 'http-01' qui sera disponible. Pour 'dns-01', une
		commande <directive module="mod_md">MDChallengeDns01</directive>
		définie sera requise. La méthode 'tls-alpn-01' est décrite
		ci-dessus dans 'https: Challenges'.
            </p><p>
                Cette sélection automatique fonctionne pour la plupart des
		configurations. Mais comme Apache est un serveur très puissant
		avec de nombreuses options de configuration, certains cas
		pourront poser des problèmes. Par exemple, il peut être en
		écoute sur plusieurs adresses IP, certaines étant accessibles en
		https: et d'autres non.
            </p><p>
		Si vous définissez <directive>MDCAChallenges</directive>
		directement, la sélection automatique est désactivée. A la
		place, le module va utiliser la liste de méthodes de négociation
		spécifiée pour dialoguer avec le serveur ACME (un type de
		négociation doit aussi être proposé par le serveur). Ces
		méthodes de négociation sont examinées dans l'ordre selon lequel
		elles sont spécifiées.
             </p>

        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDBaseServer</name>
        <description>Définit si le serveur global peut être géré ou seulement
	les serveurs virtuels.</description>
        <syntax>MDBaseServer on|off</syntax>
        <default>MDBaseServer off</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
            Cette directive permet de définir si le serveur global, autrement
	    dit la partie du serveur située en dehors de tout serveur virtuel,
	    doit être géré par mod_md ou non. Par défaut il ne
	    le sera pas car cela provoquerait des effets de bord
	    générateurs de confusion. Il est donc recommandé de
	    définir des serveurs virtuels pour tous les domaines gérés, et
	    d'exclure des domaines gérés le serveur global (serveur par défaut).
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDCertificateFile</name>
        <description>Définit un fichier de certificat statique pour le domaine géré.</description>
        <syntax>MDCertificateFile <var>path-to-pem-file</var></syntax>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
                Cette directive s'utilise dans une section <directive
		module="mod_md">MDomainSet</directive> et permet de spécifier le
		nom du fichier qui contiendra le certificat pour le
		domaine géré. La clé correspondante est spécifiée via la
		directive <directive
		module="mod_md">MDCertificateKeyFile</directive>.
            </p>
            <example><title>Exemple</title>
                <highlight language="config">
&lt;MDomain mydomain.com>
  MDCertificateFile /etc/ssl/my.cert
  MDCertificateKeyFile /etc/ssl/my.key
&lt;/MDomain>
                </highlight>
            </example>

            <p>
                Cette directive est équivalente à la directive <directive
		module="mod_ssl">SSLCertificateFile</directive> de mod_ssl. Elle
		s'utilise dans de nombreuses applications. 
            </p><p>
                Une première application est la migration de la gestion des
		certificats d'un domaine existant depuis le mode statique via des
		fichiers vers le mode automatique via Let's Encrypt. A cet
		effet, vous définissez tout d'abord la section <directive
		module="mod_md">MDomainSet</directive> dans laquelle vous
		spécifiez les fichiers, puis supprimez la directive <directive
		module="mod_ssl">SSLCertificateFile</directive> de la
		configuration de vos serveurs virtuels. 
            </p><p>
		Avec cette configuration, votre serveur fonctionnera comme
		avant, avec probablement moins de lignes répétitives. Vous
		pouvez alors ajouter la directive <directive
		module="mod_md">MDRenewMode</directive> avec pour valeur
		"always", et le module obtiendra un nouveau cerificat avant que
		celui du fichier considéré n'arrive à expiration. Une fois le
		certificat renouvelé, vous pouvez supprimer la directive
		<directive>MDCertificateFile</directive> et
		recharger la configuration.
            </p><p>
                Une autre application est le renouvellement de vos certificats
		Let's Encrypt avec d'autres clients ACME comme l'excellent <a
		href="https://certbot.eff.org">certbot</a>. A cet effet, faites
		pointer vos domaines gérés vers les fichiers de certbot et ils
		travaillerons alors ensemble.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDCertificateKeyFile</name>
        <description>Définit une clé privée statique pour le certificat
	statique.</description>
        <syntax>MDCertificateKeyFile <var>path-to-file</var></syntax>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
                Cette directive s'utilise dans une section <directive
		module="mod_md">MDomainSet</directive> et permet de spécifier le
		nom du fichier contenant la clé privée pour le domaine géré. Le
		certificat correspondant est spécifié via la directive
		<directive module="mod_md">MDCertificateFile</directive>.
            </p><p>
                Cette directive est équivalente à la directive <directive
		module="mod_ssl">SSLCertificateKeyFile</directive> de mod_ssl.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDCertificateStatus</name>
        <description>Extrait les informations publiques du certificat au format
	JSON.</description>
        <syntax>MDCertificateStatus on|off</syntax>
        <default>MDCertificateStatus on</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
		Lorsque cette directive est à "on", vous disposez d'une
		ressource pour les domaines gérés à
		https://domain/.httpd/certificate-status qui renvoie un
		document au format JSON contenant une liste de propriétés
		concernant les clés, le certificat courant et, s'il est
		disponible, le certificat renouvelé.
            </p>
            <example><title>Exemple</title>
                <highlight language="config">
{
  "valid-until": "Thu, 29 Aug 2019 16:06:35 GMT",
  "valid-from": "Fri, 31 May 2019 16:06:35 GMT",
  "serial": "03039C464D454EDE79FCD2CAE859F668F269",
  "sha256-fingerprint": "1ff3bfd2c7c199489ed04df6e29a9b4ea6c015fe8a1b0ce3deb88afc751e352d"
  "renewal" : { ...renewed cert information... }
}                
                </highlight>
            </example>
        </usage>
    </directivesynopsis>


    <directivesynopsis>
        <name>MDChallengeDns01</name>
        <description></description>
        <syntax>MDChallengeDns01 <var>path-to-command</var></syntax>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
		Cette directive permet de définir le programme à appeler
		lorsque la vérification "dns-01" doit être générée/détruite. Le
		programme prend respectivement comme arguments "setup" ou
		"teardown" suivi du nom de domaine. Pour "setup", le programme
		prend comme argument supplémentaire les données de vérification
		"dns-01".
            </p><p>
                Tant que la méthode de vérification "http:" ou "https:" est
		valable, vous n'avez pas besoin de définir cette directive.
		Cependant, Let's Encrypt n'accepte que "dns-01" comme méthode de
		vérification valide pour les certificats génériques. Si vous
		avez besoin d'un tel certificat, vous devez alors définir cette
		directive.
            </p><p>
                Reportez vous à la section sur les certificats génériques pour
		plus de détails.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDMessageCmd</name>
        <description>Gère les évènements pour les domaines gérés</description>
        <syntax>MDMessageCmd <var>path-to-cmd</var> <var>optional-args</var></syntax>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
		Cette directive permet de définir la commande à appeler
		lorsqu'un des évènements "renewed", "installed", "expiring" ou
		"errored" se produit pour un domaine géré. La commande sera
		probablement invoquée pour d'autres évènements dans le futur et
		ignorera les évènements pour lesquels elle n'aura pas été
		préparée.
            </p><p>
                Il s'agit d'une version plus souple de la directive
		<directive module="mod_md">MDNotifyCmd</directive>.
            </p>
            <example><title>Exemple</title>
	        <highlight language="config">
MDMessageCmd /etc/apache/md-message
		</highlight>

# sera invoquée sous la forme "/etc/apache/md-message renewed mydomain.com"
# lorsqu'un nouveau certificat sera disponible pour le domaine mydomain.com
            </example>
            <p>
		Le programme ne doit pas être bloquant car le module attend
		qu'il se termine. Un code de retour autre que 0 doit indiquer
		une erreur d'exécution. 
            </p><p>
                "errored" n'est pas l'évènement à surveiller en priorité car le
		renouvellement du certificat est censé se produire suffisammant
		tôt pour éviter toute interruption de service. Cet évènement est
		signalé au plus une fois par heure.
            </p><p>
                L'évènement "expiring", quant à lui, doit être pris au sérieux.
		Il se produit lorsque la valeur de <directive
		module="mod_md">MDWarnWindow</directive> est atteinte. Par
		défaut, cette valeur correspond à 10% de la durée de vie du
		certificat, donc actuellement pour Let's Encrypt, 9 jours avant
		expiration du certificat. Le message d'avertissement est répété
		au plus une fois par jour.
            </p><p>
                'renewed' indique qu'un nouveau certificat a été obtenu et
		se trouve dans la zone intermédiaire du magasin MD. Il sera
		activé au prochain restart/reload du serveur.
            </p><p>
		'installed' indique qu'un nouveau certificat a été transféré
		depuis la zone intermédiaire vers la zone des domaines du
		magasin MD. Cet évènement se produit lors d'un restart/reload du
		serveur. A la différence des autres commandes,
		<directive>MDMessageCmd</directive> s'exécute avec les
		permissions de root (sur les systèmes *nix) et a donc accès aux
		fichiers de certificats (et aux clés). Les certificats
		nécessaires à d'autres applications ou possédant des formats
		différents peuvent être traités suite à cet évènement.		
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDWarnWindow</name>
        <description>Définit la fenêtre de temps pendant laquelle vous serez
	informé de l'expiration prochaine d'un certificat.</description>
        <syntax>MDWarnWindow duration</syntax>
        <default>MDWarnWindow 10%</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
                Voir la directive <directive
		module="mod_md">MDRenewWindow</directive> pour une description
		de la méthode à employer pour spécifier cette durée.
            </p><p>
                Le module inspecte la durée de vie restante des certificats et
		invoque <directive module="mod_md">MDMessageCmd</directive>
		lorsqu'une de ces durées devient inférieure à la fenêtre de
		temps spécifiée. Si l'on conserve la valeur par défaut, cette
		durée correspond à 9 jours pour les certificats de Let's
		Encrypt.
            </p><p>
                Cette directive s'applique aussi aux domaines gérés via des
		fichiers de certificats statiques (voir la directive <directive
		module="mod_md">MDCertificateFile</directive>).
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDServerStatus</name>
        <description>Définit si les informations à propos des domaines gérés
	sont ajoutés ou non à server-status.</description>
        <syntax>MDServerStatus on|off</syntax>
        <default>MDServerStatus on</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
                Le gestionnaire d'Apache "server-status" vous permet de
		configurer une ressource pour monitorer le fonctionnement du
		serveur. Cette ressource inclut maintenant une section indiquant
		tous les domaines gérés avec leur nom DNS, l'état de
		renouvellement du certificat, la durée de vie de ce dernier,
		ainsi que d'autres propriétés fondamentales.
            </p><p>
                Cette directive permet d'activer/désactiver cette ressource.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDCertificateMonitor</name>
        <description>L'URL d'un moniteur d'enregistrement de certificat.</description>
        <syntax>MDCertificateMonitor name url</syntax>
        <default>MDCertificateMonitor crt.sh https://crt.sh?q=</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
                Cette directive impacte l'interface utilisateur HTML 'server-status' et
		n'a rien à voir avec le fonctionnement de mod_md proprement dit.
		Elle permet de définir le lien qui s'affiche sur cette interface
		pour accéder facilement à un moniteur de certificat. L'empreinte
		SHA256 du certificat doit être ajoutée à l'URL spécifié.
            </p><p>
                Les moniteurs de certificat donnent accès aux enregistrements de
		la Certificate Transparency (CT) afin de tracer l'utilisation
		des certificats pour les domaines. Vous pourrez au moins
		vérifier si Let's Encrypt (ou tout autre CA que vous aurez
		défini) a bien inscrit votre certificat dans les enregistrements
		de CT.
            </p><p>
                Avertissement : La mise à jour des enregistrements des
		certificats et leur prise en compte par les moniteurs peut
		prendre un certain temps. Ce dernier varie en fonction des
		enregistreurs et des moniteurs. Un nouveau certificat ne sera
		donc pas connu immédiatement.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDStapling</name>
        <description>Active l'agrafage pour un ou plusieurs domaines.</description>
        <syntax>MDStapling on|off</syntax>
        <default>MDStapling off</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
	<compatibility>Disponible à partir de la version 2.4.42 du serveur HTTP
	Apache</compatibility>
        <usage>
            <p>
		<module>mod_md</module> permet l'obtention des informations
		d'agrafage OCSP.  Cette fonctionnalité est une alternative à
		celle fournie par <module>mod_ssl</module>. Elle est désactivée
		par défaut à des fins de compatibilité ascendante.
            </p><p>
                La fonctionnalité peut être activée pour tous les certificats du
		serveur ou pour un <directive module="mod_md">MDomain</directive> seulement, ce qui aura pour effet
		de remplacer toute configuration d'agrafage au niveau de
		<module>mod_ssl</module> pour ce(s) domaine(s). Lorsqu'elle est désactivée,
		l'agrafage de <module>mod_ssl</module> se chargera du travail (s'il a été
		lui-même activé, bien entendu). Ceci permet de basculer de
		manière graduée d'une implémentation à l'autre.
            </p><p>
		L'agrafage fonctionne aussi pour les domaines non gérés par
		<module>mod_md</module> (voir à ce sujet la directive <directive
		module="mod_md">MDStapleOthers</directive>). En fait, l'agrafage
		OCSP peut très bien être utilisé en l'absence de tout certificat
		géré via le protocole ACME.
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDStapleOthers</name>
        <description>Active l'agrafage pour les certificats non gérés par
	mod_md.</description>
        <syntax>MDStapleOthers on|off</syntax>
        <default>MDStapleOthers on</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
	<compatibility>Disponible à partir de la version 2.4.42 du serveur HTTP
	Apache</compatibility>
        <usage>
            <p>
		Cette directive n'a d'effet que si <directive
		module="mod_md">MDStapling</directive> est activée.  Elle permet
		de contrôler si <module>mod_md</module> doit aussi fournir les
		informations d'agrafage pour les certificats qu'il ne gère pas
		directement (autrement dit pour les certificats non renouvelés
		via le protocole ACME).
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDStaplingKeepResponse</name>
        <description>Contrôle la durée au bout de laquelle les anciennes
	réponses doivent être supprimées.</description>
        <syntax>MDStaplingKeepResponse <var>duration</var></syntax>
        <default>MDStaplingKeepResponse 7d</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
	<compatibility>Disponible à partir de la version 2.4.42 du serveur HTTP
	Apache</compatibility>
        <usage>
            <p>
                Cette directive permet de spécifier la durée au bout de laquelle
		les données OCSP utilisées pour l'agrafage doivent être
		supprimées du magasin. Par défaut, ces informations sont
		supprimées lors d'un restart/reload du serveur si elles ont plus
		de sept jours. Ceci permet de limiter la taille du magasin
		lorsque les certificats sont renouvelés et/ou reconfigurés
		fréquemment.
            </p><p>
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDStaplingRenewWindow</name>
        <description>Contrôle l'ancienneté des réponses OCSP au dela de laquelle
	ces dernières seront renouvelées.</description>
        <syntax>MDStaplingRenewWindow <var>duration</var></syntax>
        <default>MDStaplingRenewWindow 33%</default>
        <contextlist>
            <context>server config</context>
        </contextlist>
	<compatibility>Disponible à partir de la version 2.4.42 du serveur HTTP
	Apache</compatibility>
        <usage>
            <p>
		Si la durée de validité d'un réponse OCSP passe en dessous de
		<var>duration</var>, <module>mod_md</module> va tenter de la
		renouveler.
            </p><p>
                La CA à l'origine du certificat fournit aussi en général le
		service de réponse OCSP et détermine la durée de validité de sa
		réponse signée à propos de la validité du certificat. Plus
		longtemps une réponse sera valide, plus longtemps elle pourra
		être mise en cache, ce qui arrange tout le monde en matière de
		performances. Plus courte sera la validité d'une réponse, plus
		vite seront envoyées des révocations de certificats aux clients.
		Il est donc important de prendre en compte la qualité de
		service.
            </p><p>
                En ajustant la durée de validité des réponses vous-même, vous
		pouvez contrôler une partie du processus. Si vous spécifiez une
		durée de vie importante (autrement dit si vous spécifiez un
		petit pourcentage de validité avant que l'information n'expire),
		vous assurer un temps de mise en cache maximal, mais une
		interruption du service OCSP (par exemple un arrêt pour
		maintenance) aura plus de chance de vous affecter. Si vous
		spécifiez un pourcentage de temps avant expiration plus
		important, les mises à jour seront plus fréquentes, ce qui va
		augmenter la charge de l'infrastructure de serveurs du CA et
		nécessiter d'avantage de coordination entre les processus
		enfants de votre propre serveur.
            </p><p>
                La valeur par défaut choisie est de 33%, ce qui signifie que la
		demande de renouvellement interviendra lorsque la durée de vie
		de la réponse OCSP passera en dessous de 33%. Pour une CA qui
		fournit des réponses OCSP avec une durée de vie de 3 jours, cela
		implique 2 jours de mise en cache et 1 jour pour les tentatives
		de renouvellement. Pour affecter votre domaine, une interruption
		de service devra donc avoir une durée supérieure à 1 jour.
            </p><p>
                Vous pouvez aussi définir de manière absolue la durée de vie
		restante, par exemple `2d` pour 2 jours. 
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDCertificateCheck</name>
        <description></description>
        <syntax>MDCertificateCheck <var>name</var> <var>url</var></syntax>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <compatibility>Disponible à partir de la version 2.4.42 du serveur HTTP
	Apache</compatibility>
        <usage>
            <p>
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDActivationDelay</name>
        <description></description>
        <syntax>MDActivationDelay <var>duration</var></syntax>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <compatibility>Disponible à partir de la version 2.4.42 du serveur HTTP
	Apache</compatibility>
        <usage>
            <p>
            </p>
        </usage>
    </directivesynopsis>

    <directivesynopsis>
        <name>MDContactEmail</name>
        <description></description>
        <syntax>MDContactEmail <var>address</var></syntax>
        <contextlist>
            <context>server config</context>
        </contextlist>
        <usage>
            <p>
                Lors de votre inscription, vous devez fournir une url de contact
		pour le protocole ACME. Actuellement, Let's Encrypt exige une
		adresse Email qu'il utilisera pour vous informer des
		renouvellements de certificats ou de toute modification des
		conditions d'utilisation. Pour obtenir cette adresse, <module>mod_md</module>
		utilise l'email spécifiée par la directive <directive>MDContactEmail</directive> dans
		votre configuration de httpd ; veillez par conséquent à bien
		spécifier une adresse correcte à ce niveau. Si la directive
		<directive>MDContactEmail</directive> n'est pas définie, <module>mod_md</module> utilisera l'email
		spécifiée via la directive <directive
		module="core">ServerAdmin</directive>.
            </p>
        </usage>
    </directivesynopsis>

</modulesynopsis>
