<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1852273 -->
<!-- French translation : Lucien GENTIS -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_proxy_express.xml.meta">

<name>mod_proxy_express</name>
<description>Extension à <module>mod_proxy</module> pour le mandatement
dynamique inverse de masse</description>
<status>Extension</status>
<sourcefile>mod_proxy_express.c</sourcefile>
<identifier>proxy_express_module</identifier>
<compatibility>Disponible à partir de la version 2.3.13 du serveur HTTP Apache</compatibility>

<summary>
    <p>Ce module crée dynamiquement en masse des mandataires inverses en
    faisant correspondre l'en-tête <code>Host:</code> de la requête HTTP à un nom de
    serveur et une URL d'arrière-plan stockés dans un fichier DBM. Il
    est ainsi plus aisé d'utiliser un grand nombre de
    mandataires inverses sans avoir à modifier la configuration. Il est
    loin de posséder autant de fonctionnalités que
    <module>mod_proxy_balancer</module> qui propose aussi la croissance
    dynamique, mais il est conçu pour gérer un nombre beaucoup plus important
    de serveurs d'arrière-plan. Il convient parfaitement pour créer un
    commutateur HTTP frontal et pour les architectures Microservices.</p>

    <p>Pour pouvoir être utilisé, ce module nécessite le chargement de
    <module>mod_proxy</module>.</p>

    <note type="warning"><title>Avertissement</title>
      <p>N'activez le mandatement que si vous avez <a
      href="mod_proxy.html#access">sécurisé votre serveur</a>. Les
      serveurs mandataires ouverts sont dangereux pour votre réseau, et
      dans une plus large mesure pour Internet.</p>
    </note>

<note><title>Limitations</title>
  <ul>
    <li>Ce module n'est pas conçu pour remplacer les fonctionnalités dynamiques
    de <module>mod_proxy_balancer</module>. Par contre, il peut constituer une
    alternative légère et rapide à <module>mod_rewrite</module> lorsque ce
    dernier utilise la directive <directive
    module="mod_rewrite">RewriteMap</directive> et le drapeau <code>[P]</code>
    pour le mandatement inverse à partir d'une table de correspondances.
    </li>
    <li>Il ne supporte pas les mises en correspondance basées sur les
    expressions rationnelles ou les modèles.
    </li>
    <li>Il émule :
      <highlight language="config">
&lt;VirtualHost *:80&gt;
   ServerName front.end.server
   ProxyPass "/" "back.end.server:port"
   ProxyPassReverse "/" "back.end.server:port"
&lt;/VirtualHost&gt;
      </highlight>
      En d'autres termes, l'URL dans son ensemble est ajoutée à l'URL
      d'arrière-plan correspondante, tout ceci dans le but de
      proposer un commutateur mandataire inverse simple mais rapide.
    </li>
  </ul>
</note>

</summary>
<seealso><module>mod_proxy</module></seealso>
<seealso><directive module="mod_proxy">BalancerMember</directive></seealso>
<seealso><directive module="mod_proxy">BalancerGrowth</directive></seealso>
<seealso><directive module="mod_proxy">BalancerPersist</directive></seealso>
<seealso><directive module="mod_proxy">BalancerInherit</directive></seealso>

<directivesynopsis>
<name>ProxyExpressEnable</name>
<description>Active la fonctionnalité du module.</description>
<syntax>ProxyExpressEnable on|off</syntax>
<default>ProxyExpressEnable off</default>
<contextlist><context>server config</context><context>virtual host</context>
  </contextlist>

<usage>
  <p>La directive <directive>ProxyExpressEnable</directive> permet
  d'activer/désactiver le module.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyExpressDBMFile</name>
<description>Chemin du fichier DBM.</description>
<syntax>ProxyExpressDBMFile <var>pathname</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
  </contextlist>

<usage>
  <p>La directive <directive>ProxyExpressDBMFile</directive> permet de
  définir le chemin du fichier DBM de correspondance Express. Ce fichier
  permet de faire correspondre le nom de serveur extrait de l'en-tête
  <code>Host:</code> de la requête entrante avec une URL d'arrière-plan.</p>

    <note><title>Note</title>
      <p>Ce fichier est élaboré à partir d'un fichier texte à l'aide de
      l'utilitaire <code><a
      href="../programs/httxt2dbm.html">httxt2dbm</a></code>.</p>

      <example><title>Fichier de correspondances ProxyExpress</title>
        ##<br />
        ##express-map.txt:<br />
        ##<br />
        <br />
        www1.example.com   http://192.168.211.2:8080<br />
        www2.example.com   http://192.168.211.12:8088<br />
        www3.example.com   http://192.168.212.10<br />
      </example>

      <example><title>Création du fichier DBM</title>
        httxt2dbm -i express-map.txt -o emap<br />
      </example>

      <example><title>Configuration</title>
      <highlight language="config">
ProxyExpressEnable on
ProxyExpressDBMFile emap
      </highlight>
      </example>        
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyExpressDBMType</name>
<description>Type de fichier DBM.</description>
<syntax>ProxyExpressDBMType <var>type</var></syntax>
<default>ProxyExpressDBMType default</default>
<contextlist><context>server config</context><context>virtual host</context>
  </contextlist>

<usage>
  <p>La directive <directive>ProxyExpressDBMType</directive> permet de
  définir le type de fichier DBM requis par le module. La valeur par
  défaut correspond au type DBM par défaut du fichier créé par
  l'utilitaire <code><a
  href="../programs/httxt2dbm.html">httxt2dbm</a></code>.</p>
  <p>Les valeurs possibles sont (mais toutes ne seront pas disponibles à
  l'exécution) :</p>
<table border="1" style="zebra">
    <columnspec><column width=".3"/><column width=".7"/></columnspec>

    <tr><th>Value</th><th>Description</th></tr>
    <tr><td><code>db</code></td><td>Fichiers Berkeley DB</td></tr>
    <tr><td><code>gdbm</code></td><td>Fichiers GDBM</td></tr>
    <tr><td><code>ndbm</code></td><td>Fichiers NDBM</td></tr>
    <tr><td><code>sdbm</code></td><td>Fichiers SDBM (toujours disponible)</td></tr>
    <tr><td><code>default</code></td><td>type DBM par défaut</td></tr>
    </table>

</usage>
</directivesynopsis>

</modulesynopsis>
