<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1838314 -->
<!-- French translation : Lucien GENTIS -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_proxy_ftp.xml.meta">

<name>mod_proxy_ftp</name>
<description>Module fournissant le support FTP à
<module>mod_proxy</module></description>
<status>Extension</status>
<sourcefile>mod_proxy_ftp.c</sourcefile>
<identifier>proxy_ftp_module</identifier>

<summary>
    <p>Pour pouvoir fonctionner, ce module <em>requiert</em> le
    chargement de <module>mod_proxy</module>. Il fournit le support du
    mandatement des sites FTP. Notez que le support FTP est
    actuellement limité à la méthode GET.</p>

    <p>Ainsi, pour pouvoir traiter les requêtes FTP mandatées,
    <module>mod_proxy</module>, et <module>mod_proxy_ftp</module>
    doivent être chargés dans le serveur.</p>

    <note type="warning"><title>Avertissement</title>
      <p>N'activez pas la fonctionnalité de mandataire avant d'avoir <a
      href="mod_proxy.html#access">sécurisé votre serveur</a>. Les
      serveurs mandataires ouverts sont dangereux non seulement pour
      votre réseau, mais aussi pour l'Internet au sens large.</p>
    </note>
</summary>
<seealso><module>mod_proxy</module></seealso>

    <section id="mimetypes"><title>Pourquoi les fichiers du type
    <var>xxx</var> ne sont-ils pas téléchargeables par FTP ?</title>
      <p>Ce type particulier de fichier n'est probablement pas défini en
      temps que <code>application/octet-stream</code> dans le fichier
      de configuration mime.types de votre mandataire. La ligne suivante
      peut y remédier :</p>

      <example>
<pre>application/octet-stream   bin dms lha lzh exe class tgz taz</pre>
      </example>
    <p>Vous pouvez aussi utiliser la directive <directive
    module="core">ForceType</directive> pour définir par défaut tous les types
    de fichiers en tant que fichiers binaires :</p>
      <example>
<highlight language="config">
	ForceType application/octet-stream
</highlight>
      </example>
    </section> <!-- /mimetypes -->

    <section id="type"><title>Comment puis-je forcer le téléchargement
    FTP en mode ASCII du fichier <var>xxx</var> ?</title>
      <p>Dans les rares siruations où vous devez télécharger un fichier
      spécifique en utilisant la méthode de transfert FTP
      <code>ASCII</code> (alors que le mode transfert par défaut est
      <code>binary</code>), vous pouvez modifier le mode de transfert de
      <module>mod_proxy</module> en suffixant la requête avec
      <code>;type=a</code> pour forcer un transfert en mode ASCII (les
      listings de répertoires FTP sont cependant quant à eux transmis en
      mode ASCII).</p>
    </section> <!-- /type -->

    <section id="ftpnonget"><title>Comment puis-je effectuer un
    chargement FTP ?</title>
    <p>Actuellement, seule la méthode GET est supportée pour FTP dans
    <module>mod_proxy</module>. Vous pouvez par contre utiliser le chargement HTTP (POST
    or PUT) via un mandataire Apache.</p>
    </section>

    <section id="percent2fhck"><title>Comment puis-je accéder par FTP à
    des fichiers situés en dehors de mon répertoire home ?</title>
      <p>Un URI FTP est considéré comme relatif au répertoire home de
      l'utilisateur connecté. Hélas, vous ne pouvez pas utiliser /../
      pour atteindre des répertoires de niveau supérieur, car les points
      sont interprétés par le navigateur et ne sont donc pas vraiment
      envoyés au serveur FTP. Pour traiter ce problème, une méthode
      nommée <dfn>Squid %2f hack</dfn> a été implémentée dans le
      mandataire FTP Apache ; cette solution est aussi utilisée par
      d'autres serveurs mandataires courants comme le <a
      href="http://www.squid-cache.org/">Cache mandataire Squid</a>. En
      préfixant par <code>/%2f</code> le chemin de votre requête, vous
      pouvez faire en sorte que le mandataire modifie le répertoire FTP
      racine en <code>/</code> (au lieu du répertoire home). Par
      exemple, pour extraire le fichier <code>/etc/motd</code>, vous
      pourriez utiliser l'URL :</p>

      <example>
        ftp://<var>utilisateur</var>@<var>serveur</var>/%2f/etc/motd
      </example>
    </section> <!-- /percent2fhck -->

    <section id="ftppass"><title>Comment puis-je dissimuler le mot de
    passe FTP apparaissant en clair dans la ligne d'URL de mon
    navigateur ?</title>
      <p>Apache utilise différentes stratégies pour effectuer une
      connexion à un serveur FTP à l'aide d'un nom d'utilisateur et d'un
      mot de passe. En l'absence de nom d'utilisateur et de mot de passe
      dans l'URL, Apache tente une connexion anonyme auprès du serveur
      FTP comme suit :</p>

      <example>
        utilisateur : anonymous<br />
        mot de passe : apache-proxy@
      </example>

      <p>Ceci fonctionne avec tous les serveurs FTP courants configurés
      pour accepter les connexions anonymes.</p>

      <p>Pour une connexion personnalisée avec un nom d'utilisateur
      spécifique, vous pouvez intégrer ce dernier dans l'URL comme suit
      :</p>

      <example>
        ftp://<var>nom-utilisateur</var>@<var>serveur</var>/mon-fichier
      </example>

      <p>Si le serveur FTP demande un mot de passe pour ce nom
      d'utilisateur (ce qu'il est censé faire), Apache va renvoyer au
      client une réponse <code>401</code> (Autorisation requise), ce qui
      fera afficher au navigateur une boîte de dialogue utilisateur/mot
      de passe. Une fois le mot de passe saisi, la connexion est tentée
      à nouveau, et si elle réussit, la ressource demandée est
      présentée. L'avantage de cette procédure réside dans le fait que
      votre navigateur n'affiche pas le mot de passe en clair, ce qu'il
      aurait fait si vous aviez utilisé l'URL :</p>

      <example>
        ftp://<var>nom-utilisateur</var>:<var>mot-de-passe</var
	>@<var>serveur</var>/mon-fichier
      </example>

      <note><title>Note</title>
        <p>Le mot de passe transmis de cette manière n'est pas chiffré
	lorsqu'il est envoyé. Il transite entre votre navigateur et le
	serveur mandataire Apache sous la forme d'une chaîne de texte en
	clair codée en base64, et entre le mandataire Apache et le
	serveur FTP en texte pur. Vous devez par conséquent réfléchir à
	deux fois avant d'accéder à votre serveur FTP via HTTP (et d'une
	manière générale avant d'accéder à vos fichiers personnels via
	FTP !) sur des canaux non sécurisés, car des oreilles
	indiscrètes pourraient intercepter votre mot de passe au cours
	de son transfert.</p>
      </note>
    </section> <!-- /ftppass -->

    <section id="wildcard"><title>Pourquoi reçois-je un listing de
    fichiers alors que j'ai demandé le téléchargement d'un fichier
    ?</title>
      <p>Apache examine l'URL de la requête afin de permettre la
      navigation dans les répertoires d'un serveur FTP ainsi que le
      téléchargement de fichiers. Si elle ressemble à un répertoire, ou
      contient des caractères génériques ("*?[{~"), alors Apache
      considère que c'est un listing qui est demandé, et non un
      téléchargement.</p>
      <p>Vous pouvez désactiver le traitement spécial des noms contenant
      des caractères génériques. Voir à cet effet la directive
      <directive module="mod_proxy_ftp">ProxyFtpListOnWildcard</directive>.
      </p>
    </section> <!-- /wildcard -->

<directivesynopsis>
<name>ProxyFtpListOnWildcard</name>
<description>Les caractères génériques dans les noms de fichiers
demandés doivent-ils déclencher l'affichage d'un listing ?</description>
<syntax>ProxyFtpListOnWildcard on|off</syntax>
<default>ProxyFtpListOnWildcard on</default>
<contextlist><context>server config</context><context>virtual host</context>
  <context>directory</context></contextlist>
<compatibility>Disponible depuis la version 2.3.3 du serveur HTTP Apache</compatibility>

<usage>
  <p>La directive <directive>ProxyFtpListOnWildcard</directive> permet
  de déterminer si les caractères génériques ("*?[{~") que contiennent
  les noms de fichiers demandés provoquent l'affichage d'un listing de
  fichiers par <module>mod_proxy_ftp</module> au lieu de télécharger un
  fichier. Il s'agit de leur comportement par défaut (valeur on).</p>
  <p>Définissez cette directive à "off" pour permettre le téléchargement de
  fichiers même si leur nom contient des caractères génériques.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyFtpEscapeWildcards</name>
<description>Les caractères génériques dans les noms de fichiers
doivent-ils être échappés lorsqu'ils sont envoyés au serveur FTP ?</description>
<syntax>ProxyFtpEscapeWildcards on|off</syntax>
<default>ProxyFtpEscapeWildcards on</default>
<contextlist><context>server config</context><context>virtual host</context>
  <context>directory</context></contextlist>
<compatibility>Disponible depuis la version 2.3.3 du serveur HTTP Apache</compatibility>

<usage>
  <p>La directive <directive>ProxyFtpEscapeWildcards</directive> permet
  de déterminer si les caractères génériques ("*?[{~") que contiennent
  les noms de fichiers demandés doivent être échappés pas un slash
  inversé avant d'être envoyés au serveur FTP. Il s'agit du comportement
  par défaut ; cependant, de nombreux serveurs FTP n'ont aucune
  connaissance de la notion d'échappement, et tentent de servir le
  fichier demandé sous sa forme littérale, en incluant les slashes
  inversés dans son nom.</p>
    <p>Définissez cette directive à "off" pour permettre le
    téléchargement de fichiers dont les noms contiennent des caractères
    génériques depuis des serveurs FTP qui ne connaissent pas
    l'échappement des caractères génériques.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ProxyFtpDirCharset</name>
<description>Définit le jeu de caractères des listings FTP
mandatés</description>
<syntax>ProxyFtpDirCharset <var>character_set</var></syntax>
<default>ProxyFtpDirCharset ISO-8859-1</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context></contextlist>
<compatibility>Disponible à partir de la version 2.2.7 du serveur HTTP Apache. Déplacé
depuis <module>mod_proxy</module> à partir de la version 2.3.5</compatibility>

<usage>
    <p>La directive <directive>ProxyFtpDirCharset</directive> permet de
    définir le jeu de caractères à utiliser pour les listings FTP en
    HTML générés par <module>mod_proxy_ftp</module>.</p>
</usage>
</directivesynopsis>

</modulesynopsis>
