<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- English Revision: 1825769 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_proxy_uwsgi.xml.meta">

<name>mod_proxy_uwsgi</name>
<description>Module de passerelle UWSGI pour <module>mod_proxy</module></description>
<status>Extension</status>
<sourcefile>mod_proxy_uwsgi.c</sourcefile>
<identifier>proxy_uwsgi_module</identifier>

<summary>
    <p>Pour pouvoir fonctionner, ce module requiert le chargement préalable de
    <module>mod_proxy</module>. Il fournit le support du <a
    >href="http://uwsgi-docs.readthedocs.io/en/latest/index.html">protocole
    UWSGI</a>.</p>

    <p>Pour être en mesure de gérer le protocole UWSGI, le serveur doit donc
    pouvoir disposer des modules <module>mod_proxy</module> et
    <module>mod_proxy_uwsgi</module>.</p>

    <note type="warning"><title>Avertissement</title>
      <p>N'activez le mandatement que si vous avez <a
      href="mod_proxy.html#access">sécurisé votre serveur</a>. Les serveurs
      mandataires ouverts sont dangereux pour votre réseau, mais aussi pour
      Internet en général.</p>
    </note>
</summary>

<seealso><module>mod_proxy</module></seealso>
<seealso><module>mod_proxy_balancer</module></seealso>

<section id="examples"><title>Exemples</title>
    <p>Il est rappelé que vous devez charger les modules
    <module>mod_proxy</module> et <module>mod_proxy_uwsgi</module> pour que les
    exemples suivants fonctionnent.</p>

    <example><title>Passerelle simple</title>
    <highlight language="config">
ProxyPass "/uwsgi-bin/" "uwsgi://localhost:4000/"
      </highlight>
    </example>

    <p>La passerelle à répartition de charge nécessite
    <module>mod_proxy_balancer</module> et au moins un module implémentant un
    algorithme de répartition de charge comme
    <module>mod_lbmethod_byrequests</module>, en plus des modules de mandatement
    listés ci-dessus. Par défaut, c'est <module>mod_lbmethod_byrequests</module>
    qui sera utilisé, et c'est donc ce dernier qui sera utilisé dans l'exemple
    suivant :</p>

    <example><title>Passerelle à répartition de charge</title>
    <highlight language="config">
ProxyPass "/uwsgi-bin/" "balancer://somecluster/"
&lt;Proxy balancer://somecluster&gt;
    BalancerMember uwsgi://localhost:4000
    BalancerMember uwsgi://localhost:4001
&lt;/Proxy&gt;
    </highlight>
    </example>
</section>

</modulesynopsis>
