<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1808698 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_proxy_wstunnel.xml.meta">

<name>mod_proxy_wstunnel</name>
<description>Module pour <module>mod_proxy</module> supportant les
websockets</description>
<status>Extension</status>
<sourcefile>mod_proxy_wstunnel.c</sourcefile>
<identifier>proxy_wstunnel_module</identifier>
<compatibility>Disponible à partir de la version 2.4.5 du serveur HTTP
Apache</compatibility>

<summary>
    <p>Pour utiliser ce module, <module>mod_proxy</module> doit être
    chargé. Il fournit le support du tunnelling pour les connexions
    websocket vers un serveur websockets d'arrière-plan. La connexion
    est automatiquement promue en connexion websocket :</p>

    <example><title>Réponse HTTP</title>
        <highlight language="config">
Upgrade: WebSocket
Connection: Upgrade
        </highlight>
    </example>	

<p>Le mandatement des requêtes vers un serveur websockets comme
<code>echo.websocket.org</code> peut être configuré via la directive <directive
type="ProxyPass" module="mod_proxy">ProxyPass</directive> :</p>
    <highlight language="config">
ProxyPass "/ws2/"  "ws://echo.websocket.org/"
ProxyPass "/wss2/" "wss://echo.websocket.org/"
    </highlight>
    
<p>La répartition de charge entre plusieurs serveurs d'arrière-plan peut être
configurée via le module <module>mod_proxy_balancer</module>.</p>

<p>En fait, ce module permet d'accepter d'autres protocoles ; vous pouvez à cet
effet utiliser le paramètre <code>upgrade</code> de la directive <directive
type="ProxyPass" module="mod_proxy">ProxyPass</directive>. La valeur NONE
signifie que vous court-circuitez la consultation de l'en-tête, mais que vous
autorisez quand-même WebSocket. La valeur ANY signifie que <code>Upgrade</code>
va lire les en-têtes de la requête et les utilisera dans l'en-tête
<code>Upgrade</code> de la réponse.</p>
</summary>

<seealso><module>mod_proxy</module></seealso>
</modulesynopsis>
