<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1835168 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<!--<modulesynopsis> is the root tag and must surround all other tags.
The sequence of tags is important and must be followed in order for
the document to validate. -->

<modulesynopsis metafile="mod_ratelimit.xml.meta">
<name>mod_ratelimit</name>
<description>Limitation de la bande passante pour les clients</description>
<status>Extension</status>
<sourcefile>mod_ratelimit.c</sourcefile>
<identifier>ratelimit_module</identifier>
<compatibility>
    <code>rate-initial-burst</code> est disponible à partir de la version 2.4.24
    du serveur HTTP Apache. La limitation de bande passante pour les contenus
    mandatés ne fonctionne pas correctement jusqu'à la version 2.4.33.
</compatibility>

<summary>

<p>Ce module fournit un filtre <code>RATE_LIMIT</code> pour limiter la
bande passante des clients. Cette contrainte s'applique à chaque réponse HTTP au
moment où elle est envoyée au client ; elle n'affecte pas les autres échanges
entre le client et le serveur. La variable d'environnement
<code>rate-limit</code> permet de spécifier, en kb/s, le débit de la
connexion à simuler.</p>

<p>Optionnellement, il est possible, via la variable d'environnement
<code>rate-initial-burst</code>, de définir une quantité de données en
kOctets à transmettre à pleine vitesse avant de limiter la bande passante à la
valeur voulue.</p>

<example><title>Exemple de configuration</title>
<highlight language="config">
&lt;Location "/downloads"&gt;
    SetOutputFilter RATE_LIMIT
    SetEnv rate-limit 400
    SetEnv rate-initial-burst 512
&lt;/Location&gt;
</highlight>

<note type="warning">
Si la valeur affectée à <code>rate-limit</code> dépasse la valeur maximale à
affecter à un entier, la limitation de bande passante sera désactivée. Si la
valeur affectée à <code>rate-limit-burst</code> dépasse la valeur maximale à
affecter à un entier, la transmission du burst initial sans limitation de bande
passante sera désactivée.
</note>

</example>

</summary>

</modulesynopsis>

