<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1864783 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_session.xml.meta">

<name>mod_session</name>
<description>Support des sessions</description>
<status>Extension</status>
<sourcefile>mod_session.c</sourcefile>
<identifier>session_module</identifier>
<compatibility>Disponible depuis la version 2.3 d'Apache</compatibility>

<summary>
    <note type="warning"><title>Avertissement</title>
      <p>Le module session fait usage des cookies HTTP, et peut &agrave; ce
      titre &ecirc;tre victime d'attaques de type Cross Site Scripting, ou
      divulguer des informations &agrave; caract&egrave;re priv&eacute; aux clients. Veuillez
      vous assurer que les risques ainsi encourus ont &eacute;t&eacute; pris en compte
      avant d'activer le support des sessions sur votre serveur.</p>
    </note>

    <p>Ce module fournit le support d'une interface de session pour
    chaque utilisateur au niveau du serveur global. Les sessions
    permettent de transmettre diverses informations  : l'utilisateur
    est-il connect&eacute; ou non, ou toute autre information qui doit &ecirc;tre
    conserv&eacute;e d'une requ&ecirc;te &agrave; l'autre.</p>

    <p>Les sessions peuvent &ecirc;tre stock&eacute;es sur le serveur, ou au niveau
    du navigateur. Les sessions peuvent &eacute;galement &ecirc;tre chiffr&eacute;es pour une
    s&eacute;curit&eacute; accrue. Ces fonctionnalit&eacute;s sont r&eacute;parties entre diff&eacute;rents
    modules compl&eacute;mentaires de <module>mod_session</module> :
    <module>mod_session_crypto</module>,
    <module>mod_session_cookie</module> et
    <module>mod_session_dbd</module>. Chargez les modules appropri&eacute;s
    en fonction des besoins du serveur (soit statiquement &agrave; la
    compilation, soit dynamiquement via la directive <directive
    module="mod_so">LoadModule</directive>).</p>

    <p>Les sessions peuvent &ecirc;tre manipul&eacute;es par d'autres modules qui
    d&eacute;pendent de la session, ou la session peut &ecirc;tre lue et &eacute;crite dans
    des variables d'environnement et des en-t&ecirc;tes HTTP, selon les
    besoins.</p>

</summary>
<seealso><module>mod_session_cookie</module></seealso>
<seealso><module>mod_session_crypto</module></seealso>
<seealso><module>mod_session_dbd</module></seealso>

    <section id="whatisasession"><title>Qu'est-ce qu'une session ?</title>
      <p>Au coeur de l'interface de session se trouve une table de
      paires cl&eacute;/valeur qui sont accessibles d'une requ&ecirc;te du navigateur
      &agrave; l'autre. Les valeurs de cl&eacute;s peuvent se voir affecter toute cha&icirc;ne
      de caract&egrave;res valide, en fonction des besoins de l'application qui
      fait usage de la session.</p>

      <p>Une "session" est une cha&icirc;ne
      <strong>application/x-www-form-urlencoded</strong> qui contient la
      paire cl&eacute;/valeur d&eacute;finie par la <a
      href="http://www.w3.org/TR/html4/">sp&eacute;cification HTML</a>.</p>

      <p>Selon les souhaits de l'administrateur, la session peut &ecirc;tre
      chiffr&eacute;e et cod&eacute;e en base64 avant d'&ecirc;tre soumise au dispositif de
      stockage.</p>

    </section>
    <section id="whocanuseasession"><title>Qui peut utiliser une session
    ?</title>
      <p>L'interface de session a &eacute;t&eacute; con&ccedil;ue &agrave; l'origine pour &ecirc;tre
      utilis&eacute;e par d'autres modules du serveur comme
      <module>mod_auth_form</module> ; les applications &agrave; base de
      programmes CGI peuvent cependant se voir accorder l'acc&egrave;s au
      contenu d'une session via la variable d'environnement
      HTTP_SESSION. Il est possible de modifier et/ou de mettre &agrave; jour
      une session en ins&eacute;rant un en-t&ecirc;te de r&eacute;ponse HTTP contenant les
      nouveaux param&egrave;tres de session.</p>

    </section>
    <section id="serversession"><title>Stockage des sessions sur le
    serveur</title>
      <p>Apache peut &ecirc;tre configur&eacute; pour stocker les sessions
      utilisateurs sur un serveur particulier ou un groupe de serveurs.
      Cette fonctionnalit&eacute; est similaire aux sessions disponibles sur
      les serveurs d'applications courants.</p>

      <p>Selon la configuration, les sessions sont suivies &agrave;
      partir d'un identifiant de session stock&eacute; dans un cookie, ou
      extraites de la cha&icirc;ne de param&egrave;tres de l'URL, comme dans les
      requ&ecirc;tes GET courantes.</p>

      <p>Comme le contenu de la session est stock&eacute; exclusivement sur le
      serveur, il est n&eacute;cessaire de pr&eacute;server la confidentialit&eacute; de ce
      contenu. Ceci a des implications en mati&egrave;re de performance et de
      consommation de ressources lorsqu'un grand nombre de sessions est
      stock&eacute;, ou lorsqu'un grand nombre de serveurs doivent se partager
      les sessions entre eux.</p>

      <p>Le module <module>mod_session_dbd</module> permet de stocker
      les sessions utilisateurs dans une base de donn&eacute;es SQL via le
      module <module>mod_dbd</module>.</p>

    </section> <!-- /serversession -->

    <section id="browsersession"><title>Stockage des sessions au niveau
    du navigateur</title>
      <p>Dans les environnements &agrave; haut trafic o&ugrave; le stockage d'une
      session sur un serveur consomme trop
      de ressources, il est possible de stocker le contenu de la session
      dans un cookie au niveau du navigateur client.</p>

      <p>Ceci a pour avantage de ne n&eacute;cessiter qu'une quantit&eacute; minimale de
      ressources sur le serveur pour suivre les sessions, et &eacute;vite &agrave;
      plusieurs serveurs parmi une for&ecirc;t de serveurs de devoir partager
      les informations de session.</p>

      <p>Le contenu de la session est cependant pr&eacute;sent&eacute; au client, avec
      pour cons&eacute;quence un risque de perte de confidentialit&eacute;. Le module
      <module>mod_session_crypto</module> peut &ecirc;tre configur&eacute; pour
      chiffrer le contenu de la session avant qu'elle soit stock&eacute;e au
      niveau du client.</p>

      <p>Le module <module>mod_session_cookie</module> permet de stocker
      les sessions au niveau du navigateur dans un cookie HTTP.</p>

    </section> <!-- /browsersession -->

    <section id="basicexamples"><title>Exemples simples</title>

      <p>La cr&eacute;ation d'une session consiste simplement &agrave; ouvrir la
      session, et &agrave; d&eacute;cider de l'endroit o&ugrave; elle doit &ecirc;tre stock&eacute;e. Dans
      l'exemple suivant, la session sera stock&eacute;e au niveau du
      navigateur, dans un cookie nomm&eacute; <code>session</code>.</p>

      <example><title>Session stock&eacute;e au niveau du navigateur</title>
        <highlight language="config">
Session On
SessionCookieName session path=/
        </highlight>
      </example>

      <p>Une session est inutile s'il n'est pas possible d'y lire
      ou d'y &eacute;crire. L'exemple suivant montre comment des valeurs
      peuvent &ecirc;tre inject&eacute;es dans une session &agrave; l'aide d'un en-t&ecirc;te de
      r&eacute;ponse HTTP pr&eacute;d&eacute;termin&eacute; nomm&eacute;
      <code>X-Replace-Session</code>.</p>

      <example><title>Ecriture dans une session</title>
        <highlight language="config">
Session On
SessionCookieName session path=/
SessionHeader X-Replace-Session
        </highlight>
      </example>

      <p>L'en-t&ecirc;te doit contenir des paires cl&eacute;/valeur sous le m&ecirc;me
      format que celui de la cha&icirc;ne d'argument d'une URL, comme dans
      l'exemple suivant. Donner pour valeur &agrave; une cl&eacute; la cha&icirc;ne vide a
      pour effet de supprimer la cl&eacute; de la session.</p>

      <example><title>Script CGI pour &eacute;crire dans une session</title>
        <highlight language="sh">
#!/bin/bash
echo "Content-Type: text/plain"
echo "X-Replace-Session: key1=foo&amp;key2=&amp;key3=bar"
echo
env
        </highlight>
      </example>

      <p>Selon la configuration, les informations de la session peuvent
      &ecirc;tre extraites de la variable d'environnement HTTP_SESSION. Par
      d&eacute;faut la session est priv&eacute;e, et cette fonctionnalit&eacute; doit donc
      &ecirc;tre explicitement activ&eacute;e via la directive <directive
      module="mod_session">SessionEnv</directive>.</p>

      <example><title>Lecture depuis une session</title>
        <highlight language="config">
Session On
SessionEnv On
SessionCookieName session path=/
SessionHeader X-Replace-Session
        </highlight>
      </example>

      <p>Une fois la lecture effectu&eacute;e, la variable CGI
      <code>HTTP_SESSION</code> doit contenir la valeur
      <code>cl&eacute;1=foo&amp;cl&eacute;3=bar</code>.</p>

    </section>
    <section id="sessionprivacy"><title>Confidentialit&eacute; des
    sessions</title>

      <p>En utilisant la fonctionnalit&eacute; de votre navigateur "Afficher
      les cookies", vous pouvez voir une r&eacute;pr&eacute;sentation de la session
      sous forme de texte en clair. Ceci peut poser probl&egrave;me si le
      contenu de la session doit &ecirc;tre dissimul&eacute; &agrave; l'utilisateur final,
      ou si un tiers acc&egrave;de sans autorisation aux informations de
      session.</p>

      <p>&Agrave; ce titre, le contenu de la session peut &ecirc;tre chiffr&eacute; &agrave; l'aide
      du module <module>mod_session_crypto</module> avant d'&ecirc;tre stock&eacute;
      au niveau du navigateur.</p>

      <example><title>Session chiffr&eacute;e avant stockage au niveau du
      navigateur</title>
        <highlight language="config">
Session On
SessionCryptoPassphrase secret
SessionCookieName session path=/
        </highlight>
      </example>

      <p>La session sera automatiquement d&eacute;chiffr&eacute;e &agrave; la lecture, et
      rechiffr&eacute;e par Apache lors de la sauvegarde, si bien que
      l'application sous-jacente qui utilise la session n'a pas &agrave; se
      pr&eacute;occuper de savoir si un chiffrement a &eacute;t&eacute; mis en oeuvre ou
      non.</p>

      <p>Les sessions stock&eacute;es sur le serveur plut&ocirc;t qu'au niveau du
      navigateur peuvent aussi &ecirc;tre chiffr&eacute;es, pr&eacute;servant par l&agrave;-m&ecirc;me la
      confidentialit&eacute; lorsque des informations sensibles sont partag&eacute;es
      entre les serveurs web d'une for&ecirc;t de serveurs &agrave; l'aide du module
      <module>mod_session_dbd</module>.</p>

    </section>
    <section id="cookieprivacy"><title>Confidentialit&eacute; du cookie</title>

      <p>Le m&eacute;canisme de cookie HTTP offre aussi des fonctionnalit&eacute;s
      quant &agrave; la confidentialit&eacute;, comme la possibilit&eacute; de
      restreindre le transport du cookie aux pages prot&eacute;g&eacute;es par SSL
      seulement, ou l'interdiction pour les scripts java qui
      s'ex&eacute;cutent au niveau du navigateur d'obtenir l'acc&egrave;s au contenu
      du cookie.</p>

      <note type="warning"><title>Avertissement</title>
      <p>Certaines fonctionnalit&eacute;s de confidentialit&eacute; du cookie HTTP ne
      sont pas standardis&eacute;es, ou ne sont pas toujours impl&eacute;ment&eacute;es au
      niveau du navigateur. Les modules de session vous permettent de
      d&eacute;finir les param&egrave;tres du cookie, mais il n'est pas garanti que la
      confidentialit&eacute; sera respect&eacute;e par le navigateur. Si la s&eacute;curit&eacute;
      est la principale pr&eacute;occupation, chiffrez le contenu de la session
      avec le module <module>mod_session_crypto</module>, ou stockez la
      session sur le serveur avec le module
      <module>mod_session_dbd</module>.</p>
      </note>

      <p>Les param&egrave;tres standards du cookie peuvent &ecirc;tre sp&eacute;cifi&eacute;s apr&egrave;s
      le nom du cookie comme dans l'exemple suivant :</p>

      <example><title>D&eacute;finition des param&egrave;tres du cookie</title>
        <highlight language="config">
Session On
SessionCryptoPassphrase secret
SessionCookieName session path=/private;domain=example.com;httponly;secure;
        </highlight>
      </example>

      <p>Dans les cas o&ugrave; le serveur Apache sert de frontal pour des
      serveurs d'arri&egrave;re-plan, il est possible de supprimer les cookies
      de session des en-t&ecirc;tes HTTP entrants &agrave; l'aide de la directive
      <directive
      module="mod_session_cookie">SessionCookieRemove</directive>. Ceci
      permet d'emp&ecirc;cher les serveurs d'arri&egrave;re-plan d'acc&eacute;der au contenu
      des cookies de session.
      </p>

    </section>
    <section id="authentication"><title>Support des sessions pour
    l'authentification</title>

      <p>Comme il est possible de le faire avec de nombreux serveurs
      d'applications, les modules d'authentification peuvent utiliser
      une session pour stocker le nom d'utilisateur et le mot de passe
      apr&egrave;s connexion. Le module <module>mod_auth_form</module> par
      exemple, sauvegarde les nom de connexion et mot de passe de
      l'utilisateur dans une session.</p>

      <example><title>Authentification &agrave; base de formulaire</title>
        <highlight language="config">
Session On
SessionCryptoPassphrase secret
SessionCookieName session path=/
AuthFormProvider file
AuthUserFile "conf/passwd"
AuthType form
AuthName "realm"
#...
        </highlight>
      </example>

      <p>Pour la documentation et des exemples complets, voir le module
      <module>mod_auth_form</module>.</p>

    </section>

    <section id="integration"><title>Int&eacute;gration des sessions avec les
    applications externes</title>

      <p>Pour que les sessions soient utiles, leur contenu doit &ecirc;tre
      accessible aux applications externes, et ces derni&egrave;res doivent
      elles-m&ecirc;mes &ecirc;tre capables d'&eacute;crire une session.</p>

      <p>L'exemple type est une application qui modifie le mot de passe
      d'un utilisateur d&eacute;fini par <module>mod_auth_form</module>. Cette
      application doit pouvoir extraire les nom d'utilisateur et mot de
      passe courants de la session, effectuer les modifications
      demand&eacute;es, puis &eacute;crire le nouveau mot de passe dans la session,
      afin que la transition vers le nouveau mot de passe soit
      transparente.</p>

      <p>Un autre exemple met en jeu une application qui enregistre un
      nouvel utilisateur pour la premi&egrave;re fois. Une fois
      l'enregistrement termin&eacute;, le nom d'utilisateur et le mot de passe
      sont &eacute;crits dans la session, fournissant l&agrave; aussi une transition
      transparente.</p>

      <dl>
      <dt>Modules Apache</dt>
      <dd>Selon les besoins, les modules du serveur peuvent utiliser
      l'API <strong>mod_session.h</strong> pour lire et &eacute;crire dans les
      sessions. Les modules tels que <module>mod_auth_form</module>
      utilisent ce m&eacute;canisme.
      </dd>

      <dt>Programmes CGI et langages de script</dt>
      <dd>Les applications qui s'ex&eacute;cutent au sein du serveur web
      peuvent &eacute;ventuellement extraire la valeur de la session de la
      variable d'environnement <strong>HTTP_SESSION</strong>. La session
      doit &ecirc;tre cod&eacute;e sous la forme d'une cha&icirc;ne
      <strong>application/x-www-form-urlencoded</strong> selon les
      pr&eacute;conisations de la <a
      href="http://www.w3.org/TR/html4/">specification HTML</a>. Cette
      variable d'environnement est d&eacute;finie via la directive <directive
      module="mod_session">SessionEnv</directive>. Un script peut &eacute;crire
      dans la session en renvoyant un en-t&ecirc;te de r&eacute;ponse
      <strong>application/x-www-form-urlencoded</strong> dont le nom est
      d&eacute;fini via la directive <directive
      module="mod_session">SessionHeader</directive>. Dans les deux cas,
      tout chiffrement ou d&eacute;chiffrement, ainsi que la lecture ou
      l'&eacute;criture de ou vers la session &agrave; partir du m&eacute;canisme de stockage
      choisi sont g&eacute;r&eacute;s par le module <module>mod_session</module> et la
      configuration correspondante.
      </dd>

      <dt>Applications situ&eacute;es derri&egrave;re <module>mod_proxy</module></dt>
      <dd>Si la directive <directive
      module="mod_session">SessionHeader</directive> est utilis&eacute;e pour
      d&eacute;finir un en-t&ecirc;te de requ&ecirc;te HTTP, la session cod&eacute;e sous la forme
      d'une cha&icirc;ne <strong>application/x-www-form-urlencoded</strong>
      sera accessible pour l'application. Si ce m&ecirc;me en-t&ecirc;te est fourni
      dans la r&eacute;ponse, sa valeur sera utilis&eacute;e pour remplacer la
      session. Comme pr&eacute;c&eacute;demment, tout chiffrement ou d&eacute;chiffrement,
      ainsi que la lecture ou
      l'&eacute;criture de ou vers la session &agrave; partir du m&eacute;canisme de stockage
      choisi sont g&eacute;r&eacute;s par le module <module>mod_session</module> et la
      configuration correspondante.</dd>

      <dt>Applications ind&eacute;pendantes</dt>
      <dd>Les applications peuvent choisir de manipuler la session en
      s'affranchissant du contr&ocirc;le du serveur HTTP Apache. Dans ce cas,
      c'est l'application qui doit prendre en charge la lecture de la
      session depuis le m&eacute;canisme de stockage choisi, son d&eacute;chiffrement,
      sa mise &agrave; jour, son chiffrement et sa r&eacute;&eacute;criture vers le m&eacute;canisme
      de stockage choisi de mani&egrave;re appropri&eacute;e.</dd>
      </dl>

    </section>

<directivesynopsis>
<name>Session</name>
<description>Ouvre une session pour le contexte courant</description>
<syntax>Session On|Off</syntax>
<default>Session Off</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>La directive <directive>Session</directive> permet d'ouvrir une
    session pour le contexte ou conteneur courant. Les directives
    suivantes permettent de d&eacute;finir o&ugrave; la session sera stock&eacute;e et
    comment sera assur&eacute;e la confidentialit&eacute;.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionMaxAge</name>
<description>D&eacute;finit une dur&eacute;e de vie maximale pour la session en
secondes</description>
<syntax>SessionMaxAge <var>dur&eacute;e de vie maximale</var></syntax>
<default>SessionMaxAge 0</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>La directive <directive>SessionMaxAge</directive> permet de
    d&eacute;finir la dur&eacute;e maximale pendant laquelle une session restera
    valide. Lorsqu'une session est sauvegard&eacute;e, cette dur&eacute;e est
    r&eacute;initialis&eacute;e et la session peut continuer d'exister. Si la dur&eacute;e
    d'une session d&eacute;passe cette limite sans qu'une requ&ecirc;te au serveur ne
    vienne la rafra&icirc;chir, la session va passer hors d&eacute;lai et sera
    supprim&eacute;e. Lorsqu'une session est utilis&eacute;e pour stocker les
    informations de connexion d'un utilisateur, ceci aura pour effet de
    le d&eacute;connecter automatiquement apr&egrave;s le d&eacute;lai sp&eacute;cifi&eacute;.</p>

    <p>Donner &agrave; cette directive la valeur 0 emp&ecirc;che l'expiration de la
    session.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionEnv</name>
<description>D&eacute;finit si le contenu de la session doit &ecirc;tre enregistr&eacute;
dans la variable d'environnement <var>HTTP_SESSION</var></description>
<syntax>SessionEnv On|Off</syntax>
<default>SessionEnv Off</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Lorsque la directive <directive>SessionEnv</directive> est
    d&eacute;finie &agrave; <var>On</var>, le contenu de la session est enregistr&eacute;
    dans une variable d'environnement CGI nomm&eacute;e
    <var>HTTP_SESSION</var>.</p>

    <p>La cha&icirc;ne est &eacute;crite sous le m&ecirc;me format que celui de la cha&icirc;ne
    d'arguments d'une URL, comme dans l'exemple suivant :</p>

    <example>
      <code>cl&eacute;1=foo&amp;cl&eacute;3=bar</code>
    </example>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionHeader</name>
<description>Importation des mises &agrave; jour de session depuis l'en-t&ecirc;te de
r&eacute;ponse HTTP sp&eacute;cifi&eacute;</description>
<syntax>SessionHeader <var>en-t&ecirc;te</var></syntax>
<default>none</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>La directive <directive>SessionHeader</directive> permet de
    d&eacute;finir le nom d'un en-t&ecirc;te de r&eacute;ponse HTTP qui, s'il est pr&eacute;sent,
    sera lu et son contenu &eacute;crit dans la session courante.</p>

    <p>Le contenu de l'en-t&ecirc;te doit se pr&eacute;senter sous le m&ecirc;me format que
    celui de la cha&icirc;ne d'arguments d'une URL, comme dans l'exemple
    suivant :</p>

    <example>
      <code>cl&eacute;1=foo&amp;cl&eacute;2=&amp;cl&eacute;3=bar</code>
    </example>

    <p>Si une cl&eacute; a pour valeur la cha&icirc;ne vide, elle sera supprim&eacute;e de
    la session.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionInclude</name>
<description>D&eacute;finit les pr&eacute;fixes d'URL pour lesquels une session est
valide</description>
<syntax>SessionInclude <var>chemin</var></syntax>
<default>toutes URLs</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>La directive <directive>SessionInclude</directive> permet de
    d&eacute;finir les pr&eacute;fixes d'URL sp&eacute;cifiques pour lesquels une session
    sera valide. Ceci peut am&eacute;liorer l'efficacit&eacute; d'un site web, en
    ciblant de mani&egrave;re plus pr&eacute;cise l'espace d'URL pour lequel une
    session devra &ecirc;tre maintenue. Par d&eacute;faut, toutes les URLs du
    contexte ou du conteneur courant sont incluses dans la session.</p>

    <note type="warning"><title>Avertissement</title>
    <p>Cette directive a un comportement similaire &agrave; celui de l'attribut
    <var>chemin</var> des cookies HTTP, mais ne doit pas &ecirc;tre confondue
    avec cet attribut. En effet, cette directive ne d&eacute;finit pas
    l'attribut <var>chemin</var>, qui doit &ecirc;tre configur&eacute; s&eacute;par&eacute;ment.</p></note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionExclude</name>
<description>D&eacute;finit les pr&eacute;fixes d'URLs pour lesquels une session sera
ignor&eacute;e</description>
<syntax>SessionExclude <var>chemin</var></syntax>
<default>none</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>SessionExclude</directive> permet de
    d&eacute;finir les pr&eacute;fixes d'URLs pour lesquels la session sera
    d&eacute;sactiv&eacute;e. Ceci peut am&eacute;liorer l'efficacit&eacute; d'un site web, en
    ciblant de mani&egrave;re plus pr&eacute;cise l'espace d'URL pour lequel une
    session devra &ecirc;tre maintenue. Par d&eacute;faut, toutes les URLs du
    contexte ou du conteneur courant sont incluses dans la session. La
    directive <directive module="mod_session">SessionExclude</directive>
    l'emporte sur la directive <directive
    module="mod_session">SessionInclude</directive>.</p>

    <note type="warning"><title>Avertissement</title>
    <p>Cette directive a un comportement similaire &agrave; celui de l'attribut
    <var>chemin</var> des cookies HTTP, mais ne doit pas &ecirc;tre confondue
    avec cet attribut. En effet, cette directive ne d&eacute;finit pas
    l'attribut <var>chemin</var>, qui doit &ecirc;tre configur&eacute;
    s&eacute;par&eacute;ment.</p></note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionExpiryUpdateInterval</name>
<description>Définit le nombre de secondes dont la durée d'expiration d'une
session peut changer sans que cette session soit mise à jour</description>
<syntax>SessionExpiryUpdateInterval <var>interval</var></syntax>
<default>SessionExpiryUpdateInterval 0 (mise à jour systématique)</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>
<compatibility>Disponible à partir de la version 2.4.41 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive>SessionExpiryUpdateInterval</directive>
    permet d'éviter le coût de l'écriture d'une session pour chaque
    requête en n'effectuant cette mise à jour que lorsque la date
    d'expiration a changé. Ceci permet d'améliorer les performances d'un
    site web ou de réduire la charge d'une base de données lorsqu'on
    utilise <module>mod_session_dbd</module>. La session est
    systématiquement mise à jour si les données stockées dans la session
    ont été modifiées ou si la durée d'expiration a été modifiée d'une
    durée supérieure à l'intervalle spécifié.</p>

    <p>Définir l'intervalle à 0 désactive cette directive, et
    l'expiration de la session sera alors rafraîchie pour chaque requête.</p>

    <p>Cette directive n'a d'effet que si on l'utilise en combinaison
    avec la directive <directive
    module="mod_session">SessionMaxAge</directive> qui active
    l'expiration des sessions. Les sessions sans date d'expiration ne
    sont écrites que lorsque les données qu'elles renferment ont été
    modifiées.</p>

    <note type="warning"><title>Avertissement</title>
    <p>Comme l'expiration de la session n'est pas systématiquement
    rafraîchie à chaque requête, une session peut arriver à expiration
    plus tôt d'un nombre de secondes spécifié dans le paramètre
    <var>interval</var>. Définir un petit intervalle est en général
    assez sur, mais en revenche n'a qu'un effet minime sur la prise en
    compte des durées d'expiration.</p></note>
</usage>
</directivesynopsis>

</modulesynopsis>
